<?php

namespace App\Http\Controllers\Administracion;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AccesoriosModel;
use Log;
use DB;
class AccesoriosController extends Controller
{
    public function index(){
        return view("administracion.accesorios.index");
    }

    
    public function accesorio_lista(){
        try {
            $lista_accesorios = AccesoriosModel::where('estado_del',0)->get();
            return response()->json([
                "status"=>'success',
                "response"=>$lista_accesorios
            ]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>'error',
                "response"=>"Error al consultar accesorios"
            ]);
        }
    }

    public function accesorio_guardar(Request $request){
        $transaction=DB::transaction(function() use ($request){
            try {
                if(empty($request->idedit)){
                    //buscar si existe en bd
                    $accesorio_existe=AccesoriosModel::where('descripcion',$request->descripcion)->where('estado_del',0)->first();
                    if($accesorio_existe==null){
                        $accesorio=new AccesoriosModel();
                        $accesorio->descripcion=$request['descripcion'];
                        $accesorio->user_registra=auth()->user()->id;
                        $accesorio->save();
                    }else{
                        return response()->json(['status'=>'error',
                        'response'=>'Accesorio ya se encuentra registrado con este nombre']);
                    }
                   
                }else{ //actualizacion
                    $existeaccesorio=AccesoriosModel::where('descripcion',$request->descripcion)->where('id','!=',decrypt($request->idedit))->where('estado_del',0)->first();
                    if($existeaccesorio!=null){
                        return response()->json(['status'=>'error',
                        'response'=>'Accesorio ya se encuentra registrado con este nombre']);
                    }
                    $accesorio=AccesoriosModel::find(decrypt($request->idedit));
                    $accesorio->descripcion=$request['descripcion'];
                    $accesorio->user_actualiza=auth()->user()->id;
                    $accesorio->save();
                }
                
                return response()->json(['status'=>'success',
                                        'response'=>'Accesorio registrado con éxito']);
            }catch(\Throwable $th){
                Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
                DB::rollback();
                return response()->json(['status'=>'error','response'=>'Inconvenientes al registrar accesorio, intente nuevamente']);
            }
        });
        return $transaction;
    }

    public function accesorio_editar($id){
        try {
            $id=decrypt($id);
            $accesorio=AccesoriosModel::find($id);
            return response()->json([
                "status"=>'success',
                "response"=>$accesorio
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"error",
                "response"=>"Error al consultar los datos del accesorio"
            ]);
        }
    }

    public function accesorio_eliminar($id){
        try {
            $id=decrypt($id);
            $accesorio=AccesoriosModel::find($id);
            $accesorio->estado_del=1;
            $accesorio->user_elimina=auth()->user()->id;
            $accesorio->fecha_elimina=date('Y-m-d H:i:s');
            $accesorio->save();
            return response()->json([
                "status"=>'success',
                "response"=>'Accesorio eliminado con éxito'
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"error",
                "response"=>"Error al eliminar accesorio"
            ]);
        }
    }
}
