<?php

namespace App\Http\Controllers\Administracion;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Configuracion\MenuModel;
use App\Models\Configuracion\MenuOpcionModel;
use App\Models\Configuracion\UsuarioOpcionModel;
use Log;

class GestionMenuController extends Controller
{
    
    public function menu_index(){
        
        $lista_menu = MenuModel::with("menu_opcion")->orderBy('orden','asc')->get();
        return view("administracion.gestion_menu", compact("lista_menu"));

    }

    public function menu_get_tabla(){

        try {
            
            $lista_menu = MenuModel::with("menu_opcion")->orderBy('orden','asc')->get();
            return view("administracion.menu_tabla", compact("lista_menu"));

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage()." => en la linea => ".$th->getLine());
            return response()->json([
                "status"=>"danger",
                "response"=>"No se pudo obtener los datos"
            ]);
        }

    }

    public function menu_edit($idmenu){

        try {

            $menu = MenuModel::find(decrypt($idmenu));
            
            return response()->json([
                "status"=>"success",
                "response"=>$menu
            ]);
    
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage()." => en la linea => ".$th->getLine());
            return response()->json([
                "status"=>"danger",
                "response"=>"No se pudo obtener el registro"
            ]);
        }

    }

    public function menu_store(Request $request){

        try {

            if(empty($request->idmenu)){ #guardar
                $menu = new MenuModel();
            }else{ #actualizar
                $menu = MenuModel::find(decrypt($request->idmenu));
            }
            
            $menu->detalle = $request->detalle;
            $menu->icono = $request->icono;
            $menu->orden = $request->orden;
            $menu->save();
    
            return response()->json([
                "status"=>"success",
                "response"=>"Registro guardado correctamente"
            ]);
    
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage()." => en la linea => ".$th->getLine());
            return response()->json([
                "status"=>"danger",
                "response"=>"No se pudo guardar el registro"
            ]);
        }

    }

    public function menu_delete($idmenu){
        try {

            $menu = MenuModel::find(decrypt($idmenu));
            #buscamos las menu_opciones
            MenuOpcionModel::where("menu_id", $menu->id)->delete();
            $menu->delete();
            
            return response()->json([
                "status"=>"success",
                "response"=>"Menu eliminado correctamente"
            ]);
    
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage()." => en la linea => ".$th->getLine());
            return response()->json([
                "status"=>"danger",
                "response"=>"No se pudo obtener el registro"
            ]);
        }
    }

    // OPCIONES PARA LA ADMNISTRACION DE OPCIONES
    
    public function opcion_store(Request $request){

        try {

            if(empty($request->idmenu_opcion)){ #guardar
                $opcion = new MenuOpcionModel();
            }else{ #actualizar
                $opcion = MenuOpcionModel::find(decrypt($request->idmenu_opcion));
            }
            
            $opcion->detalle = $request->detalle;
            $opcion->ruta = $request->ruta;
            $opcion->icono = $request->icono;
            $opcion->orden = $request->orden;
            $opcion->menu_id = decrypt($request->menu_id);
            $opcion->save();
    
            return response()->json([
                "status"=>"success",
                "response"=>"Registro guardado correctamente"
            ]);
    
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage()." => en la linea => ".$th->getLine());
            return response()->json([
                "status"=>"danger",
                "response"=>"No se pudo guardar el registro"
            ]);
        }

    }

    public function opcion_edit($idopcion){

        try {

            $menu = MenuOpcionModel::with("menu")->where("id",decrypt($idopcion))->first();
            
            return response()->json([
                "status"=>"success",
                "response"=>$menu
            ]);
    
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage()." => en la linea => ".$th->getLine());
            return response()->json([
                "status"=>"danger",
                "response"=>"No se pudo obtener el registro"
            ]);
        }

    }

    public function opcion_delete($idopcion){
        try {

            $opcion = MenuOpcionModel::find(decrypt($idopcion));
            $opcion->delete();

            return response()->json([
                "status"=>"success",
                "response"=>"Registro eliminado correctamente"
            ]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage()." => en la linea => ".$th->getLine());
            return response()->json([
                "status"=>"danger",
                "response"=>"No se pudo obtener el registro"
            ]);
        }
    }

    //RUTAS PARA AGREGAR OPCIONES A UN USUARIO

    public function usuario_opciones($usuario_id){
        try {
            // $usuario_id=decrypt($usuario_id);
            $lista_menu = MenuModel::with(["menu_opcion" => function($query) use ($usuario_id){
                    $query->with(["usuario_opcion" => function($subquery) use($usuario_id) {
                        $subquery->where("user_id", decrypt($usuario_id));
                    }]);
                }])
                ->orderBy('orden','asc')
                ->get();
            return view("administracion.registrousuario_menu_tabla", compact("lista_menu", "usuario_id"));
    
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage()." => en la linea => ".$th->getLine());
            return response()->json([
                "status"=>"danger",
                "response"=>"No se pudo obtener el registro"
            ]);
        }
    }

    public function asignar_quitar($menu_opcion_id, $usuario_id){

        try {
            $menu_opcion_id = decrypt($menu_opcion_id);
            $usuario_id = decrypt($usuario_id);
            
            $us_op = UsuarioOpcionModel::where("menu_opcion_id", $menu_opcion_id)
                ->where("user_id", $usuario_id)
                ->first();

            if(empty($us_op)){ //opcion no asignada (la agregamos)
                $us_ob = new UsuarioOpcionModel();
                $us_ob->menu_opcion_id = $menu_opcion_id;
                $us_ob->user_id = $usuario_id;
                $us_ob->save();
            }else{ //opcion asignada (la quitamos)
                $us_op->delete();
            }

            return response()->json([
                "status"=>"success",
                "response"=>"Registro actualizado"
            ]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage()." => en la linea => ".$th->getLine());
            return response()->json([
                "status"=>"danger",
                "response"=>"No se pudo actualizar el registro"
            ]);
        }

    }

}
