<?php

namespace App\Http\Controllers\Administracion;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Log;
use DB;
use App\Models\Parametrizacion\LocalModel;

class LocalesController extends Controller
{
    public function index(){
        return view("administracion.locales.index");
    }

    
    public function local_lista(){
        try {
            $lista_locales = LocalModel::where('estado_del',0)->get();
            return response()->json([
                "status"=>'success',
                "response"=>$lista_locales
            ]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>'error',
                "response"=>"Error al consultar locales"
            ]);
        }
    }

    public function local_guardar(Request $request){
        $transaction=DB::transaction(function() use ($request){
            try {
                if(empty($request->idedit)){
                    //buscar si existe en bd
                    $local_existe=LocalModel::where('descripcion',$request->descripcion)->where('estado_del',0)->first();
                    if($local_existe==null){
                        $local=new LocalModel();
                        $local->descripcion=$request['descripcion'];
                        $local->direccion=$request['direccion'];
                        $local->user_registra=auth()->user()->id;
                        $local->save();
                    }else{
                        return response()->json(['status'=>'error',
                        'response'=>'Local ya se encuentra registrado con este nombre']);
                    }
                   
                }else{ //actualizacion
                    $existelocal=LocalModel::where('descripcion',$request->descripcion)->where('id','!=',decrypt($request->idedit))->where('estado_del',0)->first();
                    if($existelocal!=null){
                        return response()->json(['status'=>'error',
                        'response'=>'Local ya se encuentra registrado con este nombre']);
                    }
                    $local=LocalModel::find(decrypt($request->idedit));
                    $local->descripcion=$request['descripcion'];
                    $local->direccion=$request['direccion'];
                    $local->user_actualiza=auth()->user()->id;
                    $local->save();
                }
                
                return response()->json(['status'=>'success',
                                        'response'=>'Local registrado con éxito']);
            }catch(\Throwable $th){
                Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
                DB::rollback();
                return response()->json(['status'=>'error','response'=>'Inconvenientes al registrar local, intente nuevamente']);
            }
        });
        return $transaction;
    }

    public function local_editar($id){
        try {
            $id=decrypt($id);
            $local=LocalModel::find($id);
            return response()->json([
                "status"=>'success',
                "response"=>$local
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"error",
                "response"=>"Error al consultar los datos del local"
            ]);
        }
    }

    public function local_eliminar($id){
        try {
            $id=decrypt($id);
            $local=LocalModel::find($id);
            $local->estado_del=1;
            $local->user_elimina=auth()->user()->id;
            $local->fecha_elimina=date('Y-m-d H:i:s');
            $local->save();
            return response()->json([
                "status"=>'success',
                "response"=>'Local eliminado con éxito'
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"error",
                "response"=>"Error al eliminar local"
            ]);
        }
    }

    public function cambiar_local($idlocal){
        try {
            $idlocal=decrypt($idlocal);
            $local=LocalModel::where('id',$idlocal)->where('estado_del',0)->first();
            session(['id_local' => encrypt($local['id'])]);
            session(['descripcion_local' => $local['descripcion'].'-'.$local['direccion']]);
            return response()->json(['status'=>'success','response'=>'Exito']);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
                DB::rollback();
                return response()->json(['status'=>'error','response'=>'Inconvenientes, intente nuevamente']);
        }
    }

}
