<?php

namespace App\Http\Controllers\Administracion;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Parametrizacion\ParametrosModel;
use Log;
use DB;
class ParametrosController extends Controller
{
    public function index(){
        return view("administracion.parametros.index");
    }

    
    public function parametros_lista(){
        try {
            $lista_parametros = ParametrosModel::where('estado_del',0)->get();
            return response()->json([
                "status"=>'success',
                "response"=>$lista_parametros
            ]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>'error',
                "response"=>"Error al consultar parametros"
            ]);
        }
    }

    public function parametros_guardar(Request $request){
        $transaction=DB::transaction(function() use ($request){
            try {
                if(empty($request->idedit)){
                    $parametros=new ParametrosModel();
                    $parametros->descripcion=$request['descripcion'];
                    $parametros->valor=$request['valor'];
                    $parametros->codigo=$request['codigo'];
                    $parametros->user_registra=auth()->user()->id;
                    $parametros->save();
                }else{ //actualizacion
                    $parametros=ParametrosModel::find(decrypt($request->idedit));
                    $parametros->descripcion=$request['descripcion'];
                    $parametros->valor=$request['valor'];
                    $parametros->codigo=$request['codigo'];
                    $parametros->user_actualiza=auth()->user()->id;
                    $parametros->save();
                }
                
                return response()->json(['status'=>'success',
                                        'response'=>'Parametro registrado con éxito']);
            }catch(\Throwable $th){
                Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
                DB::rollback();
                return response()->json(['status'=>'error','response'=>'Inconvenientes al registrar parametros, intente nuevamente']);
            }
        });
        return $transaction;
    }

    public function parametros_editar($id){
        try {
            $id=decrypt($id);
            $parametros=ParametrosModel::find($id);
            return response()->json([
                "status"=>'success',
                "response"=>$parametros
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"error",
                "response"=>"Error al consultar los datos del parametro"
            ]);
        }
    }

    public function parametros_eliminar($id){
        try {
            $id=decrypt($id);
            $parametros=ParametrosModel::find($id);
            $parametros->estado_del=1;
            $parametros->user_elimina=auth()->user()->id;
            $parametros->fecha_elimina=date('Y-m-d H:i:s');
            $parametros->save();
            return response()->json([
                "status"=>'success',
                "response"=>'parametros eliminado con éxito'
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"error",
                "response"=>"Error al eliminar parametros"
            ]);
        }
    }
}
