<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate();

        $request->session()->regenerate();
        if(auth()->user()['tipo']!='AD'){
            if(sizeof(auth()->user()['localesusuario'])>1){
                return redirect('/local');
            }else{
                $idlocal=encrypt(auth()->user()['localesusuario'][0]['idlocal']);
                $descripcion=auth()->user()['localesusuario'][0]['local']['descripcion'].'-'.auth()->user()['localesusuario'][0]['local']['direccion'];
                session(['id_local' => $idlocal]);
                session(['descripcion_local' => $descripcion]);
                return redirect('/');
            }
        }
        return redirect('/');
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }
}
