<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Log;
use GuzzleHttp\Client;
use DB;
use App\Models\User;
use DateTime;
use Mail;
use App\Models\Parametrizacion\Usuario\TipoUsuarioModel;
use App\Models\Parametrizacion\Usuario\Usuario_tipousuarioModel;
use App\Models\Parametrizacion\UsuarioLocalModel;
use App\Models\Parametrizacion\LocalModel;

use Hash;
use Auth;

use Illuminate\Support\Facades\Validator;
class RegistroUsuarioController extends Controller
{
    private $conexion = null;

    public function __construct(){
        try {
            $this->conexion = new Client([
                'base_uri' => env('SERVICE_URL'),
                'verify' => false,
            ]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
        }
    }


    private function correo_existe($correo){
        $usuario=User::where('email',$correo)->where('estado_del',0)->first();
        if($usuario!=null){
            return true;
        }else{
            return false;
        }
    }

    public function cambiarclave(Request $request){
        try  {
            $usuario= auth()->User();
            if (Hash::check($request['claveact'], $usuario->password))
            {
                if($request['nuevaclaveact']==$request['confirmarclaveact']){
                   
                        if (Hash::check($request['nuevaclaveact'], $usuario->password))
                        {
                            return response()->json(['status'=>'failed','response'=>'La nueva clave no puede ser igual a la anterior']);
                        }else{
                            $usuario->password=bcrypt($request['nuevaclaveact']);
                            $usuario->save();
                            return response()->json(['status'=>'success','response'=>'Cambio de clave exitoso']);
                        }
                }else{
                    return response()->json(['status'=>'failed','response'=>'Las claves no coinciden']);
                } 
            }else{
                return response()->json(['status'=>'failed','response'=>'Las clave actual no es la correcta']);
            }
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
            return response()->json(['status'=>'failed','response'=>'Inconvenientes al actualizar clave']);
        }
    }

    //NUEVAS FUNCIONES PARA REGISTRO DE USUARIO
    public function usuario_index(){
      
        
        //obtener los locales
        $locales = DB::table("local as l")
        ->where("l.estado_del", 0)
        ->select(
            "l.id","l.descripcion", "l.estado_del", "l.direccion"
        )->get();
        $locales=json_decode($locales,true);
        return view("administracion.registrousuario")->with(['locales'=>$locales]);
    }

    public function usuario_lista(){
        try {
            $lista_usuarios = User::with([
                'localesusuario' => function($query) {
                    $query->select('id', 'idusuario', 'idlocal', 'estado_del')
                        ->where('estado_del', 0); // Filtra solo los registros con estado_del = 0
                },
                'usuariotipousuario' => function($query) {
                    $query->select('id', 'idusuario', 'idtipousuario', 'estado')
                        ->where('estado', 0); // Filtra solo los registros con estado = 0
                }
            ])
            ->select('id', 'name', 'email', 'celular', 'identificacion','estado_user')
            ->where('estado_del',0)
            ->where('estado_user',0)
            ->get();
            return response()->json([
                "error"=>false,
                "response"=>$lista_usuarios
            ]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "error"=>true,
                "response"=>"Error al consultar los usuarios"
            ]);
        }

    }

    public function usuario_store(Request $request){
        $transaction=DB::transaction(function() use ($request){
            try {
                //validar los campos que sean obligatorios
                $validator_cedula = Validator::make($request->all(), [
                    'cedula' => 'required|numeric|digits_between:10,13',
                ]);
                if ($validator_cedula->fails()) {
                    return response()->json(['status'=>'error',
                                            'response'=>'Identificación no cumple con las reglas de validación']);
                }

                $validator_direccion = Validator::make($request->all(), [
                    'nombres' => 'required',
                ]);
                if ($validator_direccion->fails()) {
                    return response()->json(['status'=>'error',
                                            'response'=>'Nombres es un campo obligatorio']);
                }

                $validator_correo= Validator::make($request->all(), [
                    'correo' => 'required|email',
                ]);
                if ($validator_correo->fails()) {
                    return response()->json(['status'=>'error',
                                            'response'=>'El correo es obligatorio y debe cumplir con la estructura correcta']);
                }

                //validar si el correo no esta registrado
                if(empty($request->idedit)){
                    $exist_correo=$this->correo_existe($request->correo);
                    if($exist_correo){
                        DB::rollback();
                        return response()->json(['status'=>'error',
                                                'response'=>'Correo ya se encuentra registrado en nuestro sistema']);
                    }
                }

                //registrar el nuevo usuario
                $usuario_sistema=null;
                if(empty($request->idedit)){
                    //buscar si existe en bd
                    $usuario_sistema=User::where('identificacion',substr($request->cedula, 0, 10))->first();
                    if($usuario_sistema==null){
                        $usuario=new User();
                        $usuario->identificacion=substr($request->cedula, 0, 10);
                        $usuario->password=bcrypt($usuario->identificacion);
                        $usuario->celular=$request->celular;
                    }else{

                        $tipousuario=tipousuario($usuario_sistema->id);
                        if($tipousuario!=''){
                            return response()->json(['status'=>'error',
                            'response'=>'Usuario ya se encuentra registrado en nuestro sistema']);
                        }

                        $usuario_sistema->password=bcrypt($usuario_sistema->identificacion);
                        $usuario_sistema->email=strtolower($request->correo);

                    }
                   
                }else{ //actualizacion
                    //verificar si no esta creado el correo
                    $existeemail=User::where('email',$request->correo)->where('id','!=',decrypt($request->idedit))->where('estado_del',0)->first();
                    if($existeemail!=null){
                        return response()->json(['status'=>'error',
                        'response'=>'Correo ya se encuentra registrado en nuestro sistema']);
                    }
                    $usuario=User::find(decrypt($request->idedit));
                    $usuario->identificacion=substr($request->cedula, 0, 10);
                    $usuario->celular=$request->celular;
                    $usuario->name=$request->nombres;


                }
                if($usuario_sistema==null){
                    if($usuario->email==null){
                        $usuario->name=$request->nombres;
                        $usuario->email=strtolower($request->correo);
                    }else{
                        $usuario->email=strtolower($request->correo);
                    }
              
                }else{
                    $usuario=$usuario_sistema;
                }
                $usuario->save();

                //crear el tipo de usuario 
                if(empty($request->idedit)){
                    if(isset($request['rol'])){
                        $tipouser=TipoUsuarioModel::where('codigo',$request['rol'])->first();
                        $usuario_tipo=new Usuario_tipousuarioModel();
                        $usuario_tipo->idusuario=$usuario['id'];
                        $usuario_tipo->idtipousuario=$tipouser['id'];
                        $usuario_tipo->save();
                    }
                }else{
                    if(isset($request['rol'])){
                        $tipouser=TipoUsuarioModel::where('codigo',$request['rol'])->first();
                        $buscar_tipo_user=Usuario_tipousuarioModel::where('estado',0)->where('idusuario',$usuario['id'])->first();
                        if($buscar_tipo_user==null){
                            $usuario_tipo=new Usuario_tipousuarioModel();
                            $usuario_tipo->idusuario=$usuario['id'];
                            $usuario_tipo->idtipousuario=$tipouser['id'];
                            $usuario_tipo->save();
                        }else{
                            $buscar_tipo_user->idtipousuario=$tipouser['id'];
                            $buscar_tipo_user->save();
                        }
                    }
                }

                if($request['rol']=='AD'){
                    $usuario_local_ad=UsuarioLocalModel::where('idusuario',$usuario['id'])
                    ->where('estado_del',0)->update(['estado_del'=>1]); 

                }else{
                    //Registrar el usuario al local
                    if( $request['local']!=null ){
                        $usuario_local=UsuarioLocalModel::where('idusuario',$usuario['id'])
                        ->whereNotIn('idlocal',$request['local'])
                        ->where('estado_del',0)->update(['estado_del'=>1]);
                        
                        foreach ($request['local'] as $key => $value) {
                            $buscar_usuario_local=UsuarioLocalModel::where('idusuario',$usuario['id'])->where('idlocal',$value)->first();
                            if($buscar_usuario_local==null){
                                $usuario_local_new=new UsuarioLocalModel();
                                $usuario_local_new->idlocal=$value;
                                $usuario_local_new->idusuario=$usuario['id'];
                                $usuario_local_new->save();
                            }else{
                                $buscar_usuario_local->estado_del=0;
                                $buscar_usuario_local->save();
                            }

                        }
                    }else{
                        return response()->json(['status'=>'error',
                                'response'=>'Seleccione un local']);
                    }
                }
                
                return response()->json(['status'=>'success',
                                        'response'=>'Usuario registrado con éxito']);
            }catch(\Throwable $th){
                Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
                DB::rollback();
                return response()->json(['status'=>'error','response'=>'Inconvenientes al registrar usuario, intente nuevamente']);
            }
        });
        return $transaction;

    }

    public function usuario_edit($usuario_id){
        try {
            $usuario_id=decrypt($usuario_id);
            $usuario = User::where('id', $usuario_id)
            ->with([
                'localesusuario' => function($query) {
                    $query->select('id', 'idusuario', 'idlocal', 'estado_del')
                        ->where('estado_del', 0); // Filtra solo los registros con estado_del = 0
                },
                'usuariotipousuario' => function($query) {
                    $query->select('id', 'idusuario', 'idtipousuario', 'estado')
                        ->where('estado', 0); // Filtra solo los registros con estado = 0
                }
            ])
            ->select('id', 'name', 'email', 'celular', 'identificacion')
            ->first();
            return response()->json([
                "status"=>'success',
                "response"=>$usuario
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"error",
                "response"=>"Error al consultar los datos del usuario"
            ]);
        }
    }

    public function usuario_bloquear_desbloquear($usuario_id, $estado=0){
        try {
            $usuario_id=decrypt($usuario_id);
            $usuario = User::find($usuario_id);
            if($estado==0){
                $usuario->estado_user = 1; #bloqueado
            }else{
                $usuario->estado_user = 0; #desbloqueado
            }
            $usuario->save();

            return response()->json([
                "status"=>"success",
                "response"=>"Usuario actualizado"
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"failed",
                "response"=>"Error al consultar los datos del usuario"
            ]);
        }
    }


    public function resetearclave($id){
        try {
            $id=decrypt($id);
            if(tipousuario(auth()->user()->id)=='AD'){
                $usuario=User::where('id',$id)->first();
                if($usuario==null){
                    return response()->json([
                        "status"=>'failed',
                        "response"=>"Usuario no existe"
                    ]);
                }
                $usuario->password=bcrypt($usuario->identificacion);
                $usuario->save();
                return response()->json([
                    "status"=>'success',
                    "response"=>"Clave actualizada al número de cédula"
                ]);
            }else{ 
                return response()->json([
                    "status"=>'failed',
                    "response"=>"Acceso no permitido"
                ]);
            }
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"failed",
                "response"=>"Error al consultar los datos del usuario"
            ]);
        }
 

    }

    function iniciarSesion($id){
        // if(Auth::user()->rol_id==1){
            // $id=decrypt($id);
            Auth::loginUsingId($id, true);
            return redirect('/');
        // }
    }

    public function login_local(Request $request){
       
        try {
            $idlocal=decrypt($request['local']);
            $local=LocalModel::where('id',$idlocal)->where('estado_del',0)->first();
            session(['id_local' => $request['local']]);
            session(['descripcion_local' => $local['descripcion'].'-'.$local['direccion']]);
            return redirect('/');
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return redirect('/local');
        }
    }

}
