<?php

namespace App\Http\Controllers\Gestiones;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ClienteModel;
use DB;
use Log;
use Illuminate\Support\Facades\Auth;
use Mail;
class ClienteController extends Controller
{
    public function store_cliente(Request $request){
        $transaction=DB::transaction(function() use ($request){
            try {
                //buscar si existe
                $buscar_cliente=ClienteModel::whereRaw('LEFT(identificacion,10)=?',substr($request['cedula_clientes'],0,10))->where('estado_del',0)->first();
                $identificacion=0;
                if($buscar_cliente==null){
                    $cliente= new ClienteModel();
                    $cliente->nombres=$request['nombres_clientes'];
                    $cliente->identificacion=$request['cedula_clientes'];
                    $cliente->celular=$request['celular_clientes'];
                    $cliente->correo = strtolower($request['correo_clientes']);
                    $cliente->direccion=$request['direccion_clientes'];
                    if(auth()->user()['tipo']=='AD'){
                        $cliente->idlocal=0;
                    }else{
                        $cliente->idlocal=decrypt(session('id_local'));
                    }
                    $cliente->user_registra=auth()->user()->id;
                    $cliente->save();
                    $identificacion=$cliente->identificacion;
                }else{
                    $buscar_cliente->nombres=$request['nombres_clientes'];
                    $buscar_cliente->celular=$request['celular_clientes'];
                    $buscar_cliente->correo = strtolower($request['correo_clientes']);
                    $buscar_cliente->direccion=$request['direccion_clientes'];
                    if(auth()->user()['tipo']=='AD'){
                        $buscar_cliente->idlocal=0;
                    }else{
                        $buscar_cliente->idlocal=decrypt(session('id_local'));
                    }
                    $buscar_cliente->user_actualiza=auth()->user()->id;
                    $buscar_cliente->save();
                    $identificacion=$buscar_cliente->identificacion;

                }
                return response()->json(['status'=>'success','response'=>'Cliente registrado','identificacion'=>$identificacion]);
       
            }catch(\Throwable $th){
                Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
                DB::rollback();
                return response()->json(['status'=>'error','response'=>'Inconvenientes al registrar cliente, intente nuevamente2']);
            }
        });
        return $transaction;
    }

    public function search_cliente($cedula){
        $buscar_cliente=ClienteModel::whereRaw('LEFT(identificacion,10)=?',substr($cedula,0,10))->where('estado_del',0)->first();
        if($buscar_cliente==null){
            return response()->json(['status'=>'warning','response'=>'Cliente no se encuentra registrado']);

        }
        return response()->json(['status'=>'success','response'=>$buscar_cliente]);

    }


    public function index(){
        $email="leonardosabando@gmail.com";
        Mail::raw('Hola, se te ha asignado una nueva orden. Por favor revisa el sistema.', function ($message) use ($email) {
            $message->to($email)
                    ->subject('Asignación de orden');
        });
        return view("administracion.clientes.index");
    }

    
    public function cliente_lista(){
        try {
            $lista_cliente = ClienteModel::where('estado_del',0)->get();
            return response()->json([
                "status"=>'success',
                "response"=>$lista_cliente
            ]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>'error',
                "response"=>"Error al consultar clientes"
            ]);
        }
    }

    public function cliente_editar($id){
        try {
            $id=decrypt($id);
            $cliente=ClienteModel::find($id);
            return response()->json([
                "status"=>'success',
                "response"=>$cliente
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"error",
                "response"=>"Error al consultar los datos del cliente"
            ]);
        }
    }

    public function cliente_eliminar($id){
        try {
            $id=decrypt($id);
            $cliente=ClienteModel::find($id);
            $cliente->estado_del=1;
            $cliente->user_elimina=auth()->user()->id;
            $cliente->fecha_elimina=date('Y-m-d H:i:s');
            $cliente->save();
            return response()->json([
                "status"=>'success',
                "response"=>'Cliente eliminado con éxito'
            ]);

        }catch(\Throwable $th){
            Log::error(__CLASS__." => ".__FUNCTION__." => Mensaje => ".$th->getMessage());
            return response()->json([
                "status"=>"error",
                "response"=>"Error al eliminar cliente"
            ]);
        }
    }
}
