<?php

namespace App\Http\Controllers\Gestiones;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AccesoriosModel;
use App\Models\OrdenModel;
use App\Models\OrdenAccesoriosModel;
use App\Models\OrdenImagenesModel;
use App\Models\OrdenIncidenciasModel;
use App\Models\OrdenAtencionModel;
use App\Models\AuditoriaOrdenAtencionModel;
use App\Models\Parametrizacion\ParametrosModel;
use Carbon\carbon;
use DB;
use PDF;
use Log;
use Mail;
use Illuminate\Support\Facades\Auth;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Crypt;
class OrdenController extends Controller
{

    public function index_orden(){
            if(auth()->user()['tipo']=='AD'){
                $locales = DB::table("local as l")
                ->where("l.estado_del", 0)
                ->select(
                    "l.id","l.descripcion", "l.estado_del", "l.direccion"
                )->get();
                $locales=json_decode($locales,true);
                $accesorios=AccesoriosModel::where('estado_del',0)->get();
                return view("gestiones.ordenes.index")->with(['locales'=>$locales,'accesorios'=>$accesorios]);
            }else{
                $accesorios=AccesoriosModel::where('estado_del',0)->get();
                return view('gestiones.ordenes.index')->with(['accesorios'=>$accesorios]);
            }
    }

    public function generar_orden(Request $request){
        $transaction=DB::transaction(function() use ($request){
            try {
                $idcliente=decrypt($request['idcliente_encrypt']);
                $orden=new OrdenModel();
                $orden->idcliente=$idcliente;
                $orden->fecha=date('Y-m-d H:i:s');
                $orden->estado_orden='I';
                $orden->modelo=$request['modelo'];
                $orden->imei=$request['imei'];
                $orden->estado_celular=$request['estado'];
                $orden->estado_encendido=$request['estado_encendido'];
                $orden->fecha_recibe=date('Y-m-d');
                $orden->hora_recibe=date('H:i:s');
                $orden->tipo_orden=$request['tipo_orden'];
                $orden->tipo_garantia=$request['tipo_garantia'];
                $orden->observacion_inicio=$request['observacion'];
                $orden->observacion_para_tecnico=$request['observacion_tecnico'];
                $orden->user_registra=auth()->user()->id;
               
                if(auth()->user()['tipo']!='AD'){
                    $idlocal=decrypt(session('id_local'));
                    $orden->idlocal=$idlocal;
                }else{
                    $idlocal=decrypt($request['local']);
                    $orden->idlocal=$idlocal;
                }

                if(isset($request['notiene_clave'])){
                    $orden->tiene_clave='N';
                }else{
                    $orden->pin=$request['pin'];
                    $orden->patron=$request['canvasImage'];
                }
                $secuencia=ParametrosModel::where('codigo','SO')->where('estado_del',0)->first();
                if($secuencia==null){
                    return response()->json(['status'=>'error','response'=>'No está registrada la secuencia en parametros generales.']);
                }
                $secuencia->valor=($secuencia->valor)+1;
                $secuencia->save();
                $orden->codigo = str_pad($secuencia['valor'], 6, '0', STR_PAD_LEFT);
                $orden->save();
                if($request['accesorios']!=null){
                    foreach ($request['accesorios'] as $key => $value) {
                        if($value!='Ninguno'){
                            $orden_accesorios=new OrdenAccesoriosModel();
                            $orden_accesorios->idorden=$orden->id;
                            $orden_accesorios->idaccesorios=$value;
                            $orden_accesorios->save();
                        }
             
                    }
                }else{
                    return response()->json(['status'=>'error','response'=>'Por favor seleccione accesorios.']);

                }
                
                $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
                $qrCode= QrCode::format('png')->size(200)->generate($protocol.$_SERVER['HTTP_HOST'].'/orden/imagi/'.encrypt($orden['id']).'/'.base64_encode('I'));
                $imageData = base64_encode($qrCode);

                $result['img']=$imageData;
                $result['codigo']=$orden->codigo;
                $result['url']='/orden/imagi/'.encrypt($orden['id']).'/'.base64_encode('I');
                $result['id_encrypt']=encrypt($orden['id']);
                try {
                    $pdf=$this->orden_reporte_pdf($orden['id']);
                } catch (\Throwable $th) {
                    $pdf=null;
                }
                if($orden['cliente']['correo']!=null){
                    $email=$orden['cliente']['correo'];
                    $data['orden']=$orden;
                    $data['tipo']='C';
                    //$email='leonardosabando@gmail.com';
                    try {
                        Mail::send('gestiones.ordenes.email_ingreso', ['data'=>$data], function ($message) use ($email,$orden,$pdf) {
                            $message->to($email)
                            ->subject('Orden generada')
                            ->attachData($pdf->output(), 'Orden'.$orden['codigo'].'.pdf', [
                                'mime' => 'application/pdf',
                                  ]);
                        });
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                    } 
                }
                $correos_administradores=ParametrosModel::where('codigo','CAI')->where('estado_del',0)->get();
                foreach ($correos_administradores as $key => $value) {
                    try {
                        $email=$value['valor'];
                        $data['orden']=$orden;
                        $data['tipo']='A';
                        //$email='leonardosabando@gmail.com';
                        Mail::send('gestiones.ordenes.email_ingreso', ['data'=>$data], function ($message) use ($email,$orden,$pdf) {
                            $message->to($email)->subject('Orden generada')
                            ->attachData($pdf->output(), 'Orden'.$orden['codigo'].'.pdf', [
                                'mime' => 'application/pdf',
                            ]);
                        });
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                    } 
                }

                return response()->json(['status'=>'success','response'=>'Orden registrada con éxito','result'=>$result]);
            }catch(\Throwable $th){
                Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
                DB::rollback();
                return response()->json(['status'=>'error','response'=>'Inconvenientes al registrar, intente nuevamente']);
            }
        });
        return $transaction;
    }

    public function cargar_imagen($idorden,$nivel){
        // try {
            $idorden=decrypt($idorden);
            $nivel=base64_decode($nivel);
            $orden = DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->whereIn('o.estado_orden', ['I','A','T'])
            ->where('o.id', $idorden)
            ->join('clientes as c', 'c.id', '=', 'o.idcliente') 
            ->join('local as l', 'l.id', '=', 'o.idlocal') 
            ->select(
                "o.id as idorden",
                "o.estado_orden", 
                "o.codigo", 
                "c.identificacion",
                "c.nombres",
                "l.descripcion as local"
            )->first();
            $orden=(array) $orden;
            if($orden!=null){
                if($nivel=='I'){
                    if($orden['estado_orden'] != 'I'){
                        $mensaje = 'No se puede subir imagen desde este enlace porque se encuentra delegada a un técnico o no existe'; 
                        return view('error_message')->with(['response'=>$mensaje,'ruta'=>'/','status'=>'warning']);
                    }

                }
                if($nivel=='A'){
                    if($orden['estado_orden'] != 'A'){
                        $mensaje = 'No se puede subir imagen desde este enlace porque se encuentra asignada a un técnico'; 
                        return view('error_message')->with(['response'=>$mensaje,'ruta'=>'/','status'=>'warning']);
                    }
                }
                if($nivel=='T'){
                    if($orden['estado_orden'] != 'T'){
                        $mensaje = 'No se puede subir imagen desde este enlace'; 
                        return view('error_message')->with(['response'=>$mensaje,'ruta'=>'/','status'=>'warning']);
                    }
                }
                $accesorios=OrdenAccesoriosModel::with('accesorios')->where('idorden',$idorden)->get();
                $imagenes=OrdenImagenesModel::where('estado_del',0)->where('idorden',$idorden)->where('nivel_orden',$nivel)->get();
                return view('gestiones.ordenes.imagen_qr')->with(['data'=>$orden,'accesorios'=>$accesorios,'images'=>$imagenes]);
            }else{
                $mensaje = 'No se puede subir imagen desde este enlace'; 
                return view('error_message')->with(['response'=>$mensaje,'ruta'=>'/','status'=>'warning']);
            }
        // } catch (\Throwable $th) {
        //     Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
        //     // DB::rollback();
        //     // return response()->json(['status'=>'error','response'=>'Inconvenientes al registrar cliente, intente nuevamente']);
        // }
    }

    public function guardar_imagen(Request $request) {
        if ($request->hasFile('imagen')) {
            $archivos = $request->file('imagen'); // Obtener todas las imágenes
            $catalogo_extensiones = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];
            
            $idorden = decrypt($request['id_orden']);
            $estado_orden = decrypt($request['estado_orden']);
            $orden = OrdenModel::where('id', $idorden)->first();
            
            if ($orden && $orden['estado_orden'] == $estado_orden) {
                foreach ($archivos as $archivo) {
                    $extension = strtolower($archivo->getClientOriginalExtension());
                    
                    if (!in_array($extension, $catalogo_extensiones)) {
                        return back()->with(['mensaje' => 'Por favor suba imágenes en un formato válido.', 'status' => 'error']);
                    }
                    
                    // Crear el registro para la imagen
                    $orden_imagen = new OrdenImagenesModel();
                    $orden_imagen->idorden = $idorden;
                    $orden_imagen->nivel_orden = $estado_orden;
                    $orden_imagen->descripcion = $request['descripcion'];
                    $orden_imagen->save();
                    
                    // Asignar nombre y guardar archivo
                    $nombre_imagen = 'Img_' . $orden_imagen->id . '.' . '.webp';
                    // $nombre = uniqid('vehiculo_') . '.webp';
                    $orden_imagen->ruta = $nombre_imagen;
                    $orden_imagen->save();
                    $path = $archivo->getPathname();
                    $image = new \Imagick($path);
                    if (function_exists('exif_read_data')) {
                        $exif = @exif_read_data($path);
                        if (!empty($exif['Orientation'])) {
                            switch ($exif['Orientation']) {
                                case 3:
                                    $image->rotateImage(new \ImagickPixel(), 180);
                                    break;
                                case 6:
                                    $image->rotateImage(new \ImagickPixel(), 90);
                                    break;
                                case 8:
                                    $image->rotateImage(new \ImagickPixel(), -90);
                                    break;
                            }
                        }
                    }

                    $image->setImageFormat('webp');
                    $width = $image->getImageWidth();
                    if ($width > 800) {
                        $image->resizeImage(800, 0, \Imagick::FILTER_LANCZOS, 1);
                    }
                    $image->setImageCompressionQuality(30);
                    $image->stripImage(); 
                    \Storage::disk('imagenes_movil')->put($nombre_imagen, $image->getImageBlob());

                    $image->clear();
                    $image->destroy();
    
                    // \Storage::disk('imagenes_movil')->put($nombre_imagen, \File::get($archivo));
                }
                
                return back()->with(['mensaje' => 'Imágenes registradas correctamente', 'status' => 'success']);
            }
            
            return back();
        }
    
        return back()->with(['mensaje' => 'No se subieron archivos.', 'status' => 'error']);
    }
    

    public function index_orden_ingresadas(){
        if(auth()->user()['tipo']=='AD'){
            $locales = DB::table("local as l")
            ->where("l.estado_del", 0)
            ->select(
                "l.id","l.descripcion", "l.estado_del", "l.direccion"
            )->get();
            $locales=json_decode($locales,true);
            $accesorios=AccesoriosModel::where('estado_del',0)->get();
            return view("gestiones.ordenes.ingresadas")->with(['locales'=>$locales]);
        }else{
            return view('gestiones.ordenes.ingresadas');
        }
    }

    public function lista_ingresadas($id='T'){
        if(auth()->user()['tipo']=='AD'){
            if($id=='T'){
                $ordenes = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", '!=', 'F')
                ->where("o.entregado", 0)
                ->join('clientes as c', 'c.id', '=', 'o.idcliente') 
                ->join('local as l', 'l.id', '=', 'o.idlocal') 
                ->leftJoin('ordenes_incidencias as oi', 'oi.idorden', '=', 'o.id') // Left join con la tabla de incidencias
                ->select(
                    "o.codigo",
                    "o.id", 
                    "o.fecha_recibe", 
                    "o.hora_recibe", 
                    "o.estado_orden",
                    "o.confirmar",
                    "o.status_confirmado",
                    "c.identificacion",
                    "c.nombres",
                    "l.descripcion as local", 
                    "l.direccion as dir_local",
                    DB::raw('IF(COUNT(oi.idorden) > 0, 1, 0) as incidencia') // Agregamos un COUNT para las incidencias
                )
                ->groupBy("o.id", "o.codigo", "o.fecha_recibe", "o.hora_recibe", "o.estado_orden", "c.identificacion", "c.nombres", "l.descripcion", "l.direccion", "o.confirmar", "o.status_confirmado") // Agrupamos por las columnas de orden
                ->get();
            
            $ordenes->map(function($orden) {
                $orden->id_encrypt = encrypt($orden->id);  
                // Si la orden tiene status_confirmado = 1
                if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                    if (isset($orden->confirmar)) {
                        if ($orden->confirmar == 'N') {
                            $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                        } elseif ($orden->confirmar == 'S') {
                            $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                    } else {
                        $orden->status_confirmado_ad = '';
                    }
                } else {
                    $orden->status_confirmado_ad = '';
                }
                return $orden;
            });
            
            $ordenes = json_decode($ordenes, true);

            return response()->json(['status' => 'success', 'response' => $ordenes, 'isadmin' => 'S']);
            }else{
                $id=decrypt($id);
                $ordenes = DB::table('ordenes as o')
                    ->join('clientes as c', 'c.id', '=', 'o.idcliente')
                    ->join('local as l', 'l.id', '=', 'o.idlocal')
                    ->leftJoin('ordenes_incidencias as oi', 'oi.idorden', '=', 'o.id')
                    ->where('o.estado_del', 0)
                    ->where('o.estado_orden', '!=', 'F')
                    ->where('o.entregado', 0)
                    ->where('o.idlocal', $id)
                    ->select(
                        'o.codigo',
                        'o.id',
                        'o.fecha_recibe',
                        'o.hora_recibe',
                        'o.estado_orden',
                        'o.confirmar',
                        'o.status_confirmado',
                        'c.identificacion',
                        'c.nombres',
                        DB::raw('l.descripcion as local'),
                        DB::raw('l.direccion as dir_local'),
                        DB::raw('IF(COUNT(oi.idorden) > 0, 1, 0) as incidencia')
                    )
                    ->groupBy(
                        'o.codigo',
                        'o.id',
                        'o.fecha_recibe',
                        'o.hora_recibe',
                        'o.estado_orden',
                        'c.identificacion',
                        'c.nombres',
                        'l.descripcion',
                        'l.direccion',
                        'o.confirmar',
                        'o.status_confirmado',
                    )
                    ->get();

                $ordenes->map(function ($orden) {
                    $orden->id_encrypt = encrypt($orden->id);
                    $orden->incidencia = (int) $orden->incidencia;
                     // Si la orden tiene status_confirmado = 1
                    if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                        if (isset($orden->confirmar)) {
                            if ($orden->confirmar == 'N') {
                                $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                            } elseif ($orden->confirmar == 'S') {
                                $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                    } else {
                        $orden->status_confirmado_ad = '';
                    }
                    return $orden;
                });

                $ordenes=json_decode($ordenes,true);
                return response()->json(['status'=>'success','response'=>$ordenes,'isadmin'=>'S']);

            }
        }else{
            $ordenes = DB::table('ordenes as o')
            ->join('clientes as c', 'c.id', '=', 'o.idcliente')
            ->join('local as l', 'l.id', '=', 'o.idlocal')
            ->leftJoin('ordenes_incidencias as oi', 'oi.idorden', '=', 'o.id')
            ->where('o.estado_del', 0)
            ->where('o.estado_orden', '!=', 'F')
            ->where('o.entregado', 0)
            ->where('o.idlocal', decrypt(session('id_local')))
            ->select(
                'o.codigo',
                'o.id',
                'o.fecha_recibe',
                'o.hora_recibe',
                'o.estado_orden',
                'c.identificacion',
                'c.nombres',
                DB::raw('l.descripcion as local'),
                DB::raw('IF(COUNT(oi.idorden) > 0, 1, 0) as incidencia')
            )
            ->groupBy(
                'o.codigo',
                'o.id',
                'o.fecha_recibe',
                'o.hora_recibe',
                'o.estado_orden',
                'c.identificacion',
                'c.nombres',
                'l.descripcion'
            )
            ->get()
            ->map(function ($orden) {
                $orden->id_encrypt = encrypt($orden->id);
                $orden->incidencia = (int) $orden->incidencia;
                return $orden;
            });


            $ordenes=json_decode($ordenes,true);
            return response()->json(['status'=>'success','response'=>$ordenes,'isadmin'=>'N']);
        }

    }

    public function detalle_orden($id){
        try {
            $id=decrypt($id);
            $orden = DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where('o.id',$id)
            ->join('clientes as c', 'c.id', '=', 'o.idcliente') 
            ->join('local as l', 'l.id', '=', 'o.idlocal') 
            ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
            ->leftJoin('users as ua', 'ua.id', '=', 'o.user_asigna') 
            ->select("o.codigo",
                "o.id",
                "o.fecha_recibe",
                "o.hora_recibe", 
                "o.estado_orden",
                "c.identificacion",
                "c.nombres",
                "c.direccion",
                "c.celular",
                "c.correo",
                "o.tipo_orden as tipo_orden",
                "o.modelo as modelo",
                "o.imei as imei",
                "o.estado_celular as estado_celular",
                "o.estado_encendido as estado_encendido",
                "o.pin",
                "o.patron",
                "o.observacion_inicio",
                "o.observacion_para_tecnico",
                "o.tiene_clave",
                "o.tipo_garantia",
                "o.idlocal",
                "o.fecha_asigna",
                "u.name as tecnico",
                "o.fecha_anula",
                "o.observacion_anulacion",
                "o.observacion_confirma",
                "o.fecha_confirma",
                "o.user_confirma",
                "o.status_confirmado",
                "o.confirmar",
                "o.observacion_entrega",
                "o.entregado",
                "o.fecha_entrega"
            )->first();
            $orden->idlocal_encrypt = encrypt($orden->idlocal);  // Encriptar el id usando el accesor
            $orden->id_encrypt = encrypt($orden->id);  // Encriptar el id usando el accesor
                
            $accesorios=OrdenAccesoriosModel::with('accesorios')->where('idorden',$id)->get();
            //Imagenes de ingreso
            $imagenes=OrdenImagenesModel::where('estado_del',0)->where('idorden',$id)->where('nivel_orden','I')->get();
            //Imagenes del técnico
            $imagenes_tecnico=OrdenImagenesModel::where('estado_del',0)->where('idorden',$id)->where('nivel_orden','A')->get();
           //Imagenes de entrega
            $imagenes_entrega=OrdenImagenesModel::where('estado_del',0)->where('idorden',$id)->where('nivel_orden','T')->get();
            return response()->json(['status'=>'success','response'=>$orden,'accesorios'=>$accesorios,'imagenes'=>$imagenes,'imagenes_tecnico'=>$imagenes_tecnico,'imagenes_entrega'=>$imagenes_entrega]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'failed','response'=>'Inconvenientes al obtener detalle, intente nuevamente']);
        }
            
    }

    public function qr_imagen($id,$nivel='I'){
        try {
            $nivel=base64_encode($nivel);
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
            $qrCode= QrCode::format('png')->size(200)->generate($protocol.$_SERVER['HTTP_HOST'].'/orden/imagi/'.$id.'/'.$nivel);
            $imageData = base64_encode($qrCode);
            $result['img']=$imageData;
            $result['url']='/orden/imagi/'.$id.'/'.$nivel;
            return response()->json(['status'=>'success','response'=>$result]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes al obtener qr, intente nuevamente']);
        }
    }

    public function lista_tecnicos($idlocal){
        try {
            $idlocal=decrypt($idlocal);
            $tecnicos = DB::table("usuario_local as ul")
            ->where("ul.estado_del", 0)
            ->join('users as u', 'ul.idusuario', '=', 'u.id')
            ->join('usuario_tipousuario as ut', 'ut.idusuario', '=', 'u.id')
            ->join('tipo_usuario as tu', 'tu.id', '=', 'ut.idtipousuario')
            ->where('tu.codigo', 'TE')  // Filtro por tipo de usuario TE
            ->where('ul.idlocal', $idlocal)
            ->where('u.estado_user', 0)
            ->select("u.identificacion", "u.name",'u.id')
            ->get();
            $tecnicos->map(function($tecnicos) {
                $tecnicos->id_encrypt = encrypt($tecnicos->id);  // Encriptar el id usando el accesor
                return $tecnicos;
            });
            $tecnicos=json_decode($tecnicos,true);
            return response()->json(['status'=>'success','response'=>$tecnicos]);
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes al obtener lista de técnicos, intente nuevamente']);
        }
    }

    public function asignar_tecnico(Request $request){
        try {
            $idtecnico=decrypt($request['tecnicos']);
            $idorden=decrypt($request['idorden_encrypt']);
            $orden=OrdenModel::where('estado_del',0)->where('id',$idorden)->first();
            
            if($orden['estado_orden']=='A'){
                return response()->json(['status'=>'error','response'=>'Orden ya se encuentra asignada']);
            }
            if($orden['estado_orden']=='F'){
                return response()->json(['status'=>'error','response'=>'Orden ya se encuentra finalizada']);
            }
            $orden->user_asigna=auth()->user()->id;
            $orden->fecha_asigna=date('Y-m-d H:i:s');
            $orden->idusuario_tecnico=$idtecnico;
            $orden->estado_orden='A';
            $orden->save();

            if($orden['tecnico']['email']!=null){
                $email=$orden['tecnico']['email'];
                $data['orden']=$orden;
                $data['tipo']='T';
                //$email='leonardosabando@gmail.com';
                try {
                    Mail::send('gestiones.ordenes.email_ingreso', ['data'=>$data], function ($message) use ($email) {
                        $message->to($email)->subject('Asignación de orden');
                    });
                } catch (\Throwable $th) {
                    Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                } 
            }
            $correos_administradores=ParametrosModel::where('codigo','CAI')->where('estado_del',0)->get();
            foreach ($correos_administradores as $key => $value) {
                try {
                    $email=$value['valor'];
                    $data['orden']=$orden;
                    $data['tipo']='AT';
                    //$email='leonardosabando@gmail.com';
                    Mail::send('gestiones.ordenes.email_ingreso', ['data'=>$data], function ($message) use ($email) {
                        $message->to($email)->subject('Asignación de orden');
                    });
                } catch (\Throwable $th) {
                    Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                } 
            }
            return response()->json(['status'=>'success','response'=>'Orden asignada con éxito']);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes al asignar técnico, intente nuevamente']);
        }
    }

    public function orden_reporte($id){
        // try{
            $id=decrypt($id);
            $orden=OrdenModel::where('estado_del',0)->where('id',$id)->first();
            $fecha=date('Y-m-d');
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp"); //IDIOMA ESPAÑOL
            $fecha= date('Y-m-j',strtotime($fecha));
            $fecha = strftime("%d de %B de %Y", strtotime($fecha));
            $data=[];
            $notas=ParametrosModel::where('codigo','NOD')->where('estado_del',0)->get();
            $aceptaciones=ParametrosModel::where('codigo','ACPT')->where('estado_del',0)->get();
            $pdf = PDF::loadView('gestiones.ordenes.reporte',['data'=>$orden,'notas'=>$notas,'aceptacion'=>$aceptaciones]);
            $pdf->setPaper("A4", "portrait");
            return $pdf->stream('Orden_'.$orden['codigo']);
        // } catch (\Throwable $th) {
        //     Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
        //     return view('error_message')->with(['response'=>'Inconvenientes generar reporte, intente nuevamente','ruta'=>'/','status'=>'warning']);
        // }
    }

    public function orden_reporte_pdf($id){
            $orden=OrdenModel::where('estado_del',0)->where('id',$id)->first();
            $fecha=date('Y-m-d');
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp"); //IDIOMA ESPAÑOL
            $fecha= date('Y-m-j',strtotime($fecha));
            $fecha = strftime("%d de %B de %Y", strtotime($fecha));
            $data=[];
            $notas=ParametrosModel::where('codigo','NOD')->where('estado_del',0)->get();
            $aceptaciones=ParametrosModel::where('codigo','ACPT')->where('estado_del',0)->get();
            $pdf = PDF::loadView('gestiones.ordenes.reporte',['data'=>$orden,'notas'=>$notas,'aceptacion'=>$aceptaciones]);
            $pdf->setPaper("A4", "portrait");
            return $pdf;
    }

    public function descargar_orden_reporte($id){
        try{
            $id=decrypt($id);
            $orden=OrdenModel::where('estado_del',0)->where('id',$id)->first();
            $fecha=date('Y-m-d');
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp"); //IDIOMA ESPAÑOL
            $fecha= date('Y-m-j',strtotime($fecha));
            $fecha = strftime("%d de %B de %Y", strtotime($fecha));
            $data=[];
            $notas=ParametrosModel::where('codigo','NOD')->where('estado_del',0)->get();
            $aceptaciones=ParametrosModel::where('codigo','ACPT')->where('estado_del',0)->get();
            $pdf = PDF::loadView('gestiones.ordenes.reporte',['data'=>$orden,'notas'=>$notas,'aceptacion'=>$aceptaciones]);
            $pdf->setPaper("A4", "portrait");
            return $pdf->download('Orden_'.$orden['codigo'].'.pdf');
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return view('error_message')->with(['response'=>'Inconvenientes generar reporte, intente nuevamente','ruta'=>'/','status'=>'warning']);

        }
    }

    public function index_asignadas(){
        if(auth()->user()['tipo']=='AD'){
            $locales = DB::table("local as l")
            ->where("l.estado_del", 0)
            ->select(
                "l.id","l.descripcion", "l.estado_del", "l.direccion"
            )->get();
            $locales=json_decode($locales,true);
            return view("gestiones.ordenes.orden_tecnicos.asignadas")->with(['locales'=>$locales]);
        }else{
            $accesorios=AccesoriosModel::where('estado_del',0)->get();
            return view('gestiones.ordenes.orden_tecnicos.asignadas');
        }
    }

    public function lista_asignadas($id='T',$estado='A'){
        if(auth()->user()['tipo']=='AD'){
            
            if($id=='T'){
                $ordenes = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", $estado)
                ->join('clientes as c', 'c.id', '=', 'o.idcliente') 
                ->join('local as l', 'l.id', '=', 'o.idlocal') 
                ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
                ->select("o.status_confirmado","o.confirmar","o.codigo","u.name as tecnico",
                    "o.id","o.fecha_recibe","o.fecha_asigna","o.fecha","o.hora_recibe", "o.estado_orden","c.identificacion","c.nombres","l.descripcion as local","l.direccion as dir_local"
                )->get();
                $ordenes->map(function($orden) {
                    $orden->id_encrypt = encrypt($orden->id);  // Encriptar el id usando el accesor
                     // Si la orden tiene status_confirmado = 1
                    if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                        if (isset($orden->confirmar)) {
                            if ($orden->confirmar == 'N') {
                                $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                            } elseif ($orden->confirmar == 'S') {
                                $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                    } else {
                        $orden->status_confirmado_ad = '';
                    }
                    return $orden;
                });
                $ordenes=json_decode($ordenes,true);
                return response()->json(['status'=>'success','response'=>$ordenes,'isadmin'=>'S']);
            }else{
                $id=decrypt($id);
                $ordenes = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden",$estado)
                ->where('o.idlocal',$id)
                ->join('clientes as c', 'c.id', '=', 'o.idcliente') 
                ->join('local as l', 'l.id', '=', 'o.idlocal') 
                ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
                ->select( "o.status_confirmado","o.confirmar","o.codigo","u.name as tecnico",
                    "o.id","o.fecha_recibe","o.fecha_asigna","o.hora_recibe", "o.estado_orden","c.identificacion","c.nombres","l.descripcion as local","l.direccion as dir_local"
                )->get();
                $ordenes->map(function($orden) {
                    $orden->id_encrypt = encrypt($orden->id);  // Encriptar el id usando el accesor
                     // Si la orden tiene status_confirmado = 1
                    if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                        if (isset($orden->confirmar)) {
                            if ($orden->confirmar == 'N') {
                                $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                            } elseif ($orden->confirmar == 'S') {
                                $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                    } else {
                        $orden->status_confirmado_ad = '';
                    }
                    
                    return $orden;
                });
                $ordenes=json_decode($ordenes,true);
                return response()->json(['status'=>'success','response'=>$ordenes,'isadmin'=>'S']);

            }
        }else{
            $ordenes = DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.estado_orden",$estado)
            ->where('o.idlocal', decrypt(session('id_local')))
            ->where('o.idusuario_tecnico',auth()->user()->id)
            ->join('clientes as c', 'c.id', '=', 'o.idcliente') 
            ->join('local as l', 'l.id', '=', 'o.idlocal')
            ->select(
                "o.codigo",
                "o.id",
                "o.fecha_recibe",
                "o.hora_recibe",
                "o.status_confirmado",
                "o.confirmar",
                "o.estado_orden",
                "c.identificacion",
                "c.nombres",
                "l.descripcion as local",
                "o.fecha_asigna"
            )
            ->get();
            $ordenes->map(function($orden) {
                $orden->id_encrypt = encrypt($orden->id);  // Encriptar el id usando el accesor
                 // Si la orden tiene status_confirmado = 1
                    if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                        if (isset($orden->confirmar)) {
                            if ($orden->confirmar == 'N') {
                                $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                            } elseif ($orden->confirmar == 'S') {
                                $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                    } else {
                        $orden->status_confirmado_ad = '';
                    }
                return $orden;
            });
            $ordenes=json_decode($ordenes,true);
            return response()->json(['status'=>'success','response'=>$ordenes,'isadmin'=>'N']);
        }

    }

    public function detalle_asignada($id){
        try {
            $id=decrypt($id);
            $orden = DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where('o.id',$id)
            ->join('clientes as c', 'c.id', '=', 'o.idcliente') 
            ->join('local as l', 'l.id', '=', 'o.idlocal') 
            ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
            ->leftJoin('users as ua', 'ua.id', '=', 'o.user_asigna') 
            ->select("o.codigo",
                "o.id",
                "o.fecha_recibe",
                "o.hora_recibe", 
                "o.estado_orden",
                "c.identificacion",
                "c.nombres",
                "c.direccion",
                "c.celular",
                "c.correo",
                "o.tipo_orden as tipo_orden",
                "o.modelo as modelo",
                "o.imei as imei",
                "o.estado_celular as estado_celular",
                "o.estado_encendido as estado_encendido",
                "o.pin",
                "o.patron",
                "o.observacion_inicio",
                "o.observacion_para_tecnico",
                "o.tiene_clave",
                "o.tipo_garantia",
                "o.idlocal",
                "o.fecha_asigna",
                "u.name as tecnico",
                "ua.name as usuario_asigna"
            )->first();
            $orden->idlocal_encrypt = encrypt($orden->idlocal);  // Encriptar el id usando el accesor
            $orden->id_encrypt = encrypt($orden->id);  // Encriptar el id usando el accesor
                
            $accesorios=OrdenAccesoriosModel::with('accesorios')->where('idorden',$id)->get();
            $imagenes=OrdenImagenesModel::where('estado_del',0)->where('idorden',$id)->where('nivel_orden','I')->get();

            return response()->json(['status'=>'success','response'=>$orden,'accesorios'=>$accesorios,'imagenes'=>$imagenes]);

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'failed','response'=>'Inconvenientes al obtener detalle, intente nuevamente']);
        }
            
    }


    public function lista_incidencias($idorden){
        try {
            $idorden=decrypt($idorden);
            $incidencias = DB::table("ordenes_incidencias as oi")
            ->where("oi.estado_del", 0)
            ->join('users as u', 'oi.user_registra', '=', 'u.id')
            ->where('oi.estado_del', 0)
            ->where('oi.idorden', $idorden)
            ->select("oi.created_at as fecha", "u.name as usuario",'oi.descripcion','oi.id','oi.correo_usuario','oi.correo_cliente')
            ->get();
            $incidencias->map(function($incidencias) {
                $incidencias->id_encrypt = encrypt($incidencias->id);  // Encriptar el id usando el accesor
                return $incidencias;
            });
            $incidencias=json_decode($incidencias,true);
            return response()->json(['status'=>'success','response'=>$incidencias]);
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes al obtener lista de incidencias, intente nuevamente']);
        }
    }

    public function reportar_incidencia(Request $request){
        try {
           
            $incidencia=new OrdenIncidenciasModel();
            $incidencia->user_registra=auth()->user()->id;
            $incidencia->idorden=decrypt($request['idordenincidencia_encrypt']);
            $incidencia->descripcion=$request['descripcion_incidencia'];
            $orden=OrdenModel::with('cliente','userregistra','tecnico')->where('id',$incidencia->idorden)->first();
            if(isset($request['correo_cliente'])){
                $incidencia->correo_cliente='S'; 
                if($orden['cliente']['correo']!=null){
                    $email=$orden['cliente']['correo'];
                    $data['orden']=$orden;
                    $data['tipo']='C';
                    $data['descripcion']=$request['descripcion_incidencia'];
                    //$email='leonardosabando@gmail.com';
                    try {
                        Mail::send('gestiones.ordenes.orden_tecnicos.email', ['data'=>$data], function ($message) use ($email) {
                            $message->to($email)->subject('Incidencia');
                        });
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                    } 
                }
            }


            $correos_administradores=ParametrosModel::where('codigo','CAI')->where('estado_del',0)->get();
            $empleados = DB::table("usuario_local as ul")
            ->where("ul.estado_del", 0)
            ->join('users as u', 'ul.idusuario', '=', 'u.id')
            ->join('usuario_tipousuario as ut', 'ut.idusuario', '=', 'u.id')
            ->join('tipo_usuario as tu', 'tu.id', '=', 'ut.idtipousuario')
            ->where('tu.codigo', 'ES')  // Filtro por tipo de usuario TE
            ->where('ul.idlocal', $orden['idlocal'])
            ->where('u.estado_user',0)
            ->select("u.identificacion", "u.name", "u.email")  // Asegúrate de incluir el correo
            ->get();
            
            // Obtener los correos de los empleados
            $correos_empleados = $empleados->pluck('email')->toArray();
            foreach ($correos_administradores as $key => $value) {
                try {
                    $email = $value['valor'];
                    $data['orden'] = $orden;
                    $data['tipo'] = 'A';
                    $data['descripcion'] = $request['descripcion_incidencia'];
            
                    Mail::send('gestiones.ordenes.orden_tecnicos.email', ['data' => $data], function ($message) use ($email, $correos_empleados) {
                        $message->to($email)->subject('Incidencia');
            
                        // Agregar empleados en CC o BCC
                        if (!empty($correos_empleados)) {
                            $message->cc($correos_empleados);
                        }
                    });
            
                } catch (\Throwable $th) {
                    Log::error(__CLASS__ . " => " . __FUNCTION__ . " => Error=>" . $th->getMessage());
                }
            }
            if(isset($request['correo_tecnico'])){
                $incidencia->correo_tecnico='S'; 
                if($orden['tecnico']['email']!=null){
                    $email=$orden['tecnico']['email'];
                    $data['orden']=$orden;
                    $data['tipo']='T';
                    $data['descripcion']=$request['descripcion_incidencia'];
                    //$email='leonardosabando@gmail.com';
                    try {
                        Mail::send('gestiones.ordenes.orden_tecnicos.email', ['data'=>$data], function ($message) use ($email) {
                            $message->to($email)->subject('Incidencia');
                        });
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                    } 
                }
            }

            $incidencia->save();
           
          
            return response()->json(['status'=>'success','response'=>'Incidencia registrada y notificada con éxito','idorden'=>$request['idordenincidencia_encrypt']]);
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes al registrar, intente nuevamente']);
        }
    }

    public function index_incidencias(){
        if(auth()->user()['tipo']=='AD'){
            $locales = DB::table("local as l")
            ->where("l.estado_del", 0)
            ->select(
                "l.id","l.descripcion", "l.estado_del", "l.direccion"
            )->get();
            $locales=json_decode($locales,true);
            return view("gestiones.ordenes.incidencias")->with(['locales'=>$locales]);
        }else{
            return view("gestiones.ordenes.incidencias");
        }
    }
    public function lista_incidencias_pendientes($id){
            if(auth()->user()['tipo']=='AD'){
                if($id=='T'){
                    $ordenes = DB::table("ordenes as o")
                        ->where("o.estado_del", 0)
                        ->where("o.estado_orden", 'A')
                        ->join('clientes as c', 'c.id', '=', 'o.idcliente')
                        ->join('local as l', 'l.id', '=', 'o.idlocal')
                        ->join('ordenes_incidencias as oi', 'o.id', '=', 'oi.idorden')  // Asegúrate de que el campo de relación sea correcto
                        ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
                        ->where("oi.estado_del", 0)
                        ->select(
                            "o.codigo",
                            "u.name as tecnico",
                            "o.id",
                            "o.fecha_recibe",
                            "o.fecha_asigna",
                            "o.hora_recibe",
                            "o.status_confirmado",
                            "o.confirmar",
                            "o.estado_orden",
                            "c.identificacion",
                            "c.nombres",
                            "l.descripcion as local",
                            "l.direccion as dir_local"
                        )
                        ->groupBy("o.status_confirmado","o.confirmar","o.id", "o.codigo", "u.name", "o.fecha_recibe", "o.fecha_asigna", "o.hora_recibe", "o.estado_orden", "c.identificacion", "c.nombres", "l.descripcion", "l.direccion")
                        ->get();
                    $ordenes->map(function($orden) {
                        $orden->id_encrypt = encrypt($orden->id);  // Encriptar el id usando el accesor
                        if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                            if (isset($orden->confirmar)) {
                                if ($orden->confirmar == 'N') {
                                    $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                                } elseif ($orden->confirmar == 'S') {
                                    $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                                } else {
                                    $orden->status_confirmado_ad = '';
                                }
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                        return $orden;
                    });
                    $ordenes=json_decode($ordenes,true);
                    return response()->json(['status'=>'success','response'=>$ordenes,'isadmin'=>'S']);
                }else{
                    $id=decrypt($id);
                    $ordenes = DB::table("ordenes as o")
                    ->where("o.estado_del", 0)
                    ->where("o.estado_orden",'A')
                    ->where('o.idlocal',$id)
                    ->join('clientes as c', 'c.id', '=', 'o.idcliente') 
                    ->join('local as l', 'l.id', '=', 'o.idlocal') 
                    ->join('ordenes_incidencias as oi', 'o.id', '=', 'oi.idorden')  // Asegúrate de que el campo de relación sea correcto
                    ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
                    ->where("oi.estado_del", 0)
                    ->select("o.status_confirmado","o.confirmar","o.codigo","u.name as tecnico","o.id","o.fecha_recibe","o.fecha_asigna","o.hora_recibe", "o.estado_orden","c.identificacion","c.nombres","l.descripcion as local","l.direccion as dir_local"
                    )->groupBy("o.status_confirmado","o.confirmar","o.id", "o.codigo", "u.name", "o.fecha_recibe", "o.fecha_asigna", "o.hora_recibe", "o.estado_orden", "c.identificacion", "c.nombres", "l.descripcion", "l.direccion")
                    
                     ->get();
                    $ordenes->map(function($orden) {
                        $orden->id_encrypt = encrypt($orden->id);  // Encriptar el id usando el accesor
                        if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                            if (isset($orden->confirmar)) {
                                if ($orden->confirmar == 'N') {
                                    $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                                } elseif ($orden->confirmar == 'S') {
                                    $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                                } else {
                                    $orden->status_confirmado_ad = '';
                                }
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                        return $orden;
                    });
                    $ordenes=json_decode($ordenes,true);
                    return response()->json(['status'=>'success','response'=>$ordenes,'isadmin'=>'S']);
                }
            }else{
                $ordenes = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden",'A')
                ->where('o.idlocal', decrypt(session('id_local')))
                ->join('clientes as c', 'c.id', '=', 'o.idcliente') 
                ->join('local as l', 'l.id', '=', 'o.idlocal') 
                ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
                ->join('ordenes_incidencias as oi', 'o.id', '=', 'oi.idorden')  // Asegúrate de que el campo de relación sea correcto
                ->where("oi.estado_del", 0)
                ->groupBy("o.confirmar","o.status_confirmado","o.id", "o.codigo", "u.name", "o.fecha_recibe", "o.fecha_asigna", "o.hora_recibe", "o.estado_orden", "c.identificacion", "c.nombres", "l.descripcion", "l.direccion")
                ->select("o.confirmar","o.status_confirmado","o.codigo","u.name as tecnico","o.id","o.fecha_recibe","o.fecha_asigna","o.hora_recibe", "o.estado_orden","c.identificacion","c.nombres","l.descripcion as local","l.direccion as dir_local")->get();
                $ordenes->map(function($orden) {
                    $orden->id_encrypt = encrypt($orden->id);  // Encriptar el id usando el accesor
                    if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                            if (isset($orden->confirmar)) {
                                if ($orden->confirmar == 'N') {
                                    $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                                } elseif ($orden->confirmar == 'S') {
                                    $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                                } else {
                                    $orden->status_confirmado_ad = '';
                                }
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                    } else {
                        $orden->status_confirmado_ad = '';
                    }
                    return $orden;
                });
                $ordenes=json_decode($ordenes,true);
                return response()->json(['status'=>'success','response'=>$ordenes,'isadmin'=>'N']);
            }
    }

    public function store_atencion(Request $request){
        $transaction=DB::transaction(function() use ($request){
            try {
                $idorden=decrypt($request['idordenatender_encrypt']);
                $orden_atencion=new OrdenAtencionModel();
                $orden_atencion->observacion_diagnostico=$request['observacion_tecnico_atender'];
                $orden_atencion->costo_local=$request['costo_local'];
                $orden_atencion->costo_tecnico=$request['costo_tecnico'];
                $orden_atencion->costo_total=$request['costo_total'];
                $orden_atencion->dias=$request['dia_atender'];
                $orden_atencion->horas=$request['horas_atender'];
                $orden_atencion->minutos=$request['minutos_atender'];
                $orden_atencion->user_atiende=auth()->user()->id;
                $orden_atencion->fecha_atiende=date('Y-m-d H:i:s');
                $orden_atencion->idorden=$idorden;
                $orden=OrdenModel::where('estado_del',0)->where('id',$idorden)->first();
                if($orden==null){
                    return response()->json(['status'=>'error','response'=>'No se puede atender la orden, recargue la página.']);
                }
                $orden_atencion->tipo_orden=$orden->tipo_orden;
                $orden_atencion->save();
                $orden->estado_orden='T';
                $orden->save();
                if($orden['cliente']['correo']!=null){
                    $email=$orden['cliente']['correo'];
                    $data1['tipo']='C';
                    $data1['atencion']=$orden_atencion;
                    $data1['orden']=$orden;
                    //$email='leonardosabando@gmail.com';
                    try {
                        Mail::send('gestiones.ordenes.orden_tecnicos.email_aceptacion', ['data'=>$data1], function ($message) use ($email) {
                            $message->to($email)->subject('Atención');
                        });
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                    } 
                }
                $correos_administradores=ParametrosModel::where('codigo','CAI')->where('estado_del',0)->get();
                $empleados = DB::table("usuario_local as ul")
                ->where("ul.estado_del", 0)
                ->join('users as u', 'ul.idusuario', '=', 'u.id')
                ->join('usuario_tipousuario as ut', 'ut.idusuario', '=', 'u.id')
                ->join('tipo_usuario as tu', 'tu.id', '=', 'ut.idtipousuario')
                ->where('tu.codigo', 'ES')  // Filtro por tipo de usuario TE
                ->where('ul.idlocal', $orden['idlocal'])
                ->where('u.estado_user',0)
                ->select("u.identificacion", "u.name", "u.email")  // Asegúrate de incluir el correo
                ->get();

                    // Obtener los correos de los empleados
                $correos_empleados = $empleados->pluck('email')->toArray();
                foreach ($correos_administradores as $key => $value) {
                    try {
                        $email=$value['valor'];
                        $data['atencion']=$orden_atencion;
                        $data['orden']=$orden;
                        $data['tipo']='A';
                
                        Mail::send('gestiones.ordenes.orden_tecnicos.email_aceptacion', ['data'=>$data], function ($message) use ($email, $correos_empleados) {
                            $message->to($email)->subject('Atención');
                
                            // Agregar empleados en CC o BCC
                            if (!empty($correos_empleados)) {
                                $message->cc($correos_empleados);
                            }
                        });
                
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__ . " => " . __FUNCTION__ . " => Error=>" . $th->getMessage());
                    }
                }
                // foreach ($correos_administradores as $key => $value) {
                //     try {
                //         $email=$value['valor'];
                //         $data['atencion']=$orden_atencion;
                //         $data['orden']=$orden;
                //         $data['tipo']='A';
                //         //$email='leonardosabando@gmail.com';
                //         Mail::send('gestiones.ordenes.orden_tecnicos.email_aceptacion', ['data'=>$data], function ($message) use ($email) {
                //             $message->to($email)->subject('Atención');
                //         });
                //     } catch (\Throwable $th) {
                //         Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                //     } 
                // }
                // if($orden['userregistra']['email']!=null){
                //     $dataU['tipo']='U';
                //     $dataU['atencion']=$orden_atencion;
                //     $dataU['orden']=$orden;
                //     $email=$orden['userregistra']['email'];
                //     //$email='leonardosabando@gmail.com';

                //     try {
                //         Mail::send('gestiones.ordenes.orden_tecnicos.email_aceptacion', ['data'=>$dataU], function ($message) use ($email) {
                //             $message->to($email)->subject('Atención');
                //         });
                //     } catch (\Throwable $th) {
                //         Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                //     } 
                // }
                return response()->json(['status'=>'success','response'=>'Orden atendida con éxito.']);

            } catch (\Throwable $th) {
                Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
                DB::rollback();
                return response()->json(['status'=>'error','response'=>'Inconvenientes al registrar atención']);

            }
        });
        return $transaction;
    }

    public function detalle_atencion($id,$tipo='T'){
        try{
            $id=decrypt($id);
            if($tipo=='T'){
                $orden_atencion=OrdenAtencionModel::with('useratiende')->where('idorden',$id)->where('estado_del',0)
                ->select('id','estado_del','idorden','fecha_atiende','costo_total','tipo_orden','observacion_diagnostico','dias','horas','minutos','user_atiende')->get();
                
            }else{
                $orden_atencion=OrdenAtencionModel::with('useratiende')->where('idorden',$id)->where('tipo_orden',$tipo)->where('estado_del',0)
                ->select('id','estado_del','idorden','costo_total','user_atiende','costo_local','costo_tecnico','observacion_diagnostico')->first();
            }
            //Imagenes de entrega
            $imagenes_entrega=OrdenImagenesModel::where('estado_del',0)->where('idorden',$id)->where('nivel_orden','T')->count();
            
            return response()->json(['status'=>'success','response'=>$orden_atencion,'img_entrega'=>$imagenes_entrega]);
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes intente nuevamente']);

        }
    }

    public function confirmar_orden(Request $request){
        try {
            $id=decrypt($request['idordenconfirmar_encrypt']);
            $orden=OrdenModel::where('id',$id)->first();
            if($orden!=null){
                if($orden['estado_orden']!='T'){
                    return response()->json(['status'=>'error','response'=>'Orden no se encuentra en estado atendida para confirmar reparación']);
                }
                if($orden['tipo_orden']!='d'){
                     return response()->json(['status'=>'error','response'=>'Orden no es tipo diagnóstico, no se puede confirmar reparación']);

                }
                $respuesta='S';

                if(isset($request['confirmar'])){
                    if($request['confirmar']=='N'){
                        $respuesta='N';
                    }
                }

                if(isset($request['respuesta'])){
                    $respuesta=$request['respuesta'];
                  
                }
               if($respuesta=='S'){
                    $orden->confirmar='S';
                    $orden->tipo_orden='r';
                    $orden->estado_orden='A';
               }else{
                    $orden->confirmar='N';
                    $orden->tipo_orden='d';
                    $orden->estado_orden='T';
               }
                
                $user = Auth::user();
                if($user){
                    $orden->user_confirma=auth()->user()->id;
                }
                $orden->fecha_confirma=date('Y-m-d H:i:s');
              
                if(isset($request['descripcion_confirmar'])){
                    $observacion=$request['descripcion_confirmar'];
                    $orden->observacion_confirma=$observacion;
                }
                $orden->status_confirmado=1;
                $orden->save();
                //enviar correo que se confirmo la orden para reparación
                if($orden['tecnico']['email']!=null){
                    $email=$orden['tecnico']['email'];
                    $data['orden']=$orden;
                    $data['tipo']='T';
                    //$email='leonardosabando@gmail.com';
                    try {
                        Mail::send('gestiones.ordenes.email_confirmacion', ['data'=>$data], function ($message) use ($email) {
                            $message->to($email)->subject('Asignación de orden');
                        });
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                    } 
                }

                $correos_administradores=ParametrosModel::where('codigo','CAI')->where('estado_del',0)->get();
                $empleados = DB::table("usuario_local as ul")
                ->where("ul.estado_del", 0)
                ->join('users as u', 'ul.idusuario', '=', 'u.id')
                ->join('usuario_tipousuario as ut', 'ut.idusuario', '=', 'u.id')
                ->join('tipo_usuario as tu', 'tu.id', '=', 'ut.idtipousuario')
                ->where('tu.codigo', 'ES')  // Filtro por tipo de usuario TE
                ->where('ul.idlocal', $orden['idlocal'])
                ->where('u.estado_user',0)
                ->select("u.identificacion", "u.name", "u.email")  // Asegúrate de incluir el correo
                ->get();

                    // Obtener los correos de los empleados
                $correos_empleados = $empleados->pluck('email')->toArray();
                foreach ($correos_administradores as $key => $value) {
                    try {
                        $email = $value['valor'];
                        $data['orden'] = $orden;
                        $data['tipo']='A';
                        $data['descripcion'] = $request['descripcion_incidencia'];
                
                        Mail::send('gestiones.ordenes.email_confirmacion', ['data'=>$data], function ($message) use ($email, $correos_empleados) {
                            $message->to($email)->subject('Confirmación cliente');
                            // Agregar empleados en CC o BCC
                            if (!empty($correos_empleados)) {
                                $message->cc($correos_empleados);
                            }
                        });
                
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__ . " => " . __FUNCTION__ . " => Error=>" . $th->getMessage());
                    }
                }
                // foreach ($correos_administradores as $key => $value) {
                //     try {
                //         $email=$value['valor'];
                //         $data['orden']=$orden;
                //         $data['tipo']='AT';
                //         //$email='leonardosabando@gmail.com';
                //         Mail::send('gestiones.ordenes.email_confirmacion', ['data'=>$data], function ($message) use ($email) {
                //             $message->to($email)->subject('Asignación de orden');
                //         });
                //     } catch (\Throwable $th) {
                //         Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                //     } 
                // }

                if($orden['cliente']['correo']!=null){
                    $email=$orden['cliente']['correo'];
                    $data['orden']=$orden;
                    $data['tipo']='C';
                    //$email='leonardosabando@gmail.com';
                    try {
                        Mail::send('gestiones.ordenes.email_confirmacion', ['data'=>$data], function ($message) use ($email) {
                            $message->to($email)->subject('Confirmación de orden');
                        });
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                    } 
                }
                if($respuesta=='S'){
                    return response()->json(['status'=>'success','response'=>'Orden confirmada para reparación','id'=>$request['idordenconfirmar_encrypt']]);
                }else{
                    return response()->json(['status'=>'success','response'=>'Orden no será reparada','id'=>$request['idordenconfirmar_encrypt']]);
                }

            }else{
                return response()->json(['status'=>'error','response'=>'Orden no disponible']);
            }

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes al confirmar orden']);

        }
    }


    public function anular_orden(Request $request){
        try {
            $id=decrypt($request['idordenanular_encrypt']);
            $orden=OrdenModel::where('id',$id)->first();
            if($orden!=null){
                if($orden['estado_orden']!='A'){
                    return response()->json(['status'=>'error','response'=>'Orden no se encuentra en estado asignada para anular']);
                }
                $orden->user_anula=auth()->user()->id;
                $orden->fecha_anula=date('Y-m-d H:i:s');
                $orden->observacion_anulacion=$request['descripcion_anular'];
                $orden->estado_orden='D';
                $orden->save();

                $correos_administradores=ParametrosModel::where('codigo','CAI')->where('estado_del',0)->get();
                $empleados = DB::table("usuario_local as ul")
                ->where("ul.estado_del", 0)
                ->join('users as u', 'ul.idusuario', '=', 'u.id')
                ->join('usuario_tipousuario as ut', 'ut.idusuario', '=', 'u.id')
                ->join('tipo_usuario as tu', 'tu.id', '=', 'ut.idtipousuario')
                ->where('tu.codigo', 'ES')  // Filtro por tipo de usuario TE
                ->where('ul.idlocal', $orden['idlocal'])
                ->where('u.estado_user',0)
                ->select("u.identificacion", "u.name", "u.email")  // Asegúrate de incluir el correo
                ->get();

                    // Obtener los correos de los empleados
                $correos_empleados = $empleados->pluck('email')->toArray();
                foreach ($correos_administradores as $key => $value) {
                    try {
                        $email=$value['valor'];
                        $data['orden']=$orden;
                        $data['tipo']='AT';
                        //$email='leonardosabando@gmail.com';
                        Mail::send('gestiones.ordenes.email_anula', ['data'=>$data], function ($message) use ($email,$correos_empleados) {
                            $message->to($email)->subject('Anulación de orden');
                            // Agregar empleados en CC o BCC
                            if (!empty($correos_empleados)) {
                                $message->cc($correos_empleados);
                            }
                        });
                
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__ . " => " . __FUNCTION__ . " => Error=>" . $th->getMessage());
                    }
                }
                // foreach ($correos_administradores as $key => $value) {
                //     try {
                //         $email=$value['valor'];
                //         $data['orden']=$orden;
                //         $data['tipo']='AT';
                //         //$email='leonardosabando@gmail.com';
                //         Mail::send('gestiones.ordenes.email_anula', ['data'=>$data], function ($message) use ($email) {
                //             $message->to($email)->subject('Anulación de orden');
                //         });
                //     } catch (\Throwable $th) {
                //         Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                //     } 
                // }

                // if($orden['userasigna']['email']!=null){
                //     $email=$orden['userasigna']['email'];
                //     $data['orden']=$orden;
                //     $data['tipo']='U';
                //     //$email='leonardosabando@gmail.com';
                //     try {
                //         Mail::send('gestiones.ordenes.email_anula', ['data'=>$data], function ($message) use ($email) {
                //             $message->to($email)->subject('Anulación de orden');
                //         });
                //     } catch (\Throwable $th) {
                //         Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                //     } 
                // }
                return response()->json(['status'=>'success','response'=>'Orden anulada con éxito']);

            }else{
                return response()->json(['status'=>'error','response'=>'Orden no disponible']);
            }

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes al anular orden']);

        }
    }

    public function entregar_orden(Request $request){
        try {
            $id=decrypt($request['idorden_entregar_encrypt']);
            $orden=OrdenModel::where('id',$id)->first();
            if($orden!=null){
                if($orden['estado_orden']!='T' && $orden['estado_orden']!='D' ){
                    return response()->json(['status'=>'error','response'=>'Orden no se encuentra en estado de atención o anulada.']);
                }
                if($orden['estado_orden']=='T'){
                    //verificar si es reparacion
                    if($orden['tipo_orden']=='r'){
                        //Imagenes de entrega
                        $imagenes_entrega=OrdenImagenesModel::where('estado_del',0)->where('idorden',$id)->where('nivel_orden','T')->count();
                        if($imagenes_entrega<=0){
                            return response()->json(['status'=>'error','response'=>'Debe cargar las imagenes de entrega.']);

                        }
                    }
                    
                }
                $orden->user_entrega=auth()->user()->id;
                $orden->fecha_entrega=date('Y-m-d H:i:s');
                $orden->observacion_entrega=$request['observacion_entrega'];
                $orden->transferencia = $request['trasferencia'];
                $orden->efectivo = $request['efectivo'];
                $orden->tarjeta_credito = $request['tarjeta_credito'];
                $orden->payphone = $request['payphone'];
                if($orden->estado_orden!='D'){
                    $orden->estado_orden='F';
                }
                $orden->entregado=1;
                $orden->save();

                $correos_administradores=ParametrosModel::where('codigo','CAI')->where('estado_del',0)->get();
                foreach ($correos_administradores as $key => $value) {
                    try {
                        $email=$value['valor'];
                        $data['orden']=$orden;
                        $data['tipo']='A';
                        //$email='leonardosabando@gmail.com';
                        Mail::send('gestiones.ordenes.email_entrega', ['data'=>$data], function ($message) use ($email) {
                            $message->to($email)->subject('Orden entregada');
                        });
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                    } 
                }

                if($orden['cliente']['correo']!=null){
                    $email=$orden['cliente']['correo'];
                    $data['orden']=$orden;
                    $data['tipo']='C';
                    try {
                        Mail::send('gestiones.ordenes.email_entrega', ['data'=>$data], function ($message) use ($email) {
                           $message->to($email)->subject('Orden entregada');
                        });
                    } catch (\Throwable $th) {
                        Log::error(__CLASS__." => ".__FUNCTION__." =>  Error=>".$th->getMessage());
                    } 
                }

                return response()->json(['status'=>'success','response'=>'Orden entregada con éxito']);

            }else{
                return response()->json(['status'=>'error','response'=>'Orden no disponible']);
            }

        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes al entregar orden']);

        }
    }

    public function confirmar_orden_link($id){
        try {
            $id=decrypt($id);
            $orden=OrdenModel::where('id',$id)->where('estado_del',0)->first();
            if($orden!=null){
                if($orden['status_confirmado']==1){
                    return view('mensaje_confirmar')->with(['status'=>'success','mensaje'=>'Orden confirmada por el cliente']);
                }
                if($orden['estado_orden']!='T'){
                    return view('mensaje_confirmar')->with(['status'=>'success','mensaje'=>'Orden no se encuentra disponible']);
                }
                $diagnostico=OrdenAtencionModel::with('useratiende')->where('idorden',$id)->where('estado_del',0)->where('tipo_orden','d')
                ->select('id','estado_del','idorden','fecha_atiende','costo_total','tipo_orden','observacion_diagnostico','dias','horas','minutos','user_atiende')->first();
                $imagenes=OrdenImagenesModel::where('estado_del',0)->where('idorden',$id)->where('nivel_orden','A')->get();
                return view('link_confirmar')->with(['orden'=>$orden,'diagnostico'=>$diagnostico,'imagenes'=>$imagenes]);
            }else{
                return view('mensaje_confirmar')->with(['status'=>'success','mensaje'=>'Orden no se encuentra disponible']);

            }
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function index_buscar(){
        if(auth()->user()['tipo']=='AD'){
            $locales = DB::table("local as l")
            ->where("l.estado_del", 0)
            ->select(
                "l.id","l.descripcion", "l.estado_del", "l.direccion"
            )->get();
            $locales=json_decode($locales,true);
            return view("gestiones.ordenes.index_buscar")->with(['locales'=>$locales]);
        }else{
            $accesorios=AccesoriosModel::where('estado_del',0)->get();
            return view('gestiones.ordenes.index_buscar');
        }
    }

    public function filtro_buscar(Request $request){
           
                $estado=null;
                $condicion_estado='!=';
                $condicion_local='!=';
                if($request['estado']!=1){
                    $estado=$request['estado'];
                    $condicion_estado='=';
                }
                $isadmin='N';
                if(auth()->user()['tipo']=='AD'){
                    if($request['local']!='T'){
                        $idlocal=decrypt($request['local']);
                        $condicion_local='=';
                    }else{
                         $condicion_local='!=';
                         $idlocal=null;
                    }
                    $isadmin='S';
                }else{
                    $idlocal=decrypt(session('id_local'));
                    $condicion_local='=';
                }
                if ($request['filtro'] == 'O') {
                    $ordenes = DB::table("ordenes as o")
                    ->where("o.estado_del", 0)
                    ->where("o.estado_orden", $condicion_estado, $estado)
                    ->where('o.idlocal', $condicion_local, $idlocal)
                    ->join('clientes as c', 'c.id', '=', 'o.idcliente')
                    ->join('local as l', 'l.id', '=', 'o.idlocal')
                    ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
                    ->leftJoin('ordenes_incidencias as oi', 'oi.idorden', '=', 'o.id') // Agregamos el LEFT JOIN con la tabla de incidencias
                    ->where("o.codigo", "like", "%" . $request['codigo'] . "%");
                
                // Filtrar por rango de fechas si el checkbox de filtro de fecha está activado
                if (!empty($request['filtro_fecha']) && !empty($request['fecha_desde']) && !empty($request['fecha_hasta'])) {
                    $ordenes->whereBetween("o.fecha_recibe", [$request['fecha_desde'], $request['fecha_hasta']]);
                }
                
                $ordenes = $ordenes->select([
                        "o.codigo",
                        "u.name as tecnico",
                        "o.id",
                        "o.fecha_recibe",
                        "o.fecha_asigna",
                        "o.hora_recibe",
                        "o.estado_orden",
                        "c.identificacion",
                        "o.status_confirmado",
                        "o.confirmar",
                        "c.nombres",
                        "l.descripcion as local",
                        "l.direccion as dir_local",
                        DB::raw('IF(COUNT(oi.idorden) > 0, 1, 0) as incidencia') // Campo incidencia con COUNT
                    ])
                    ->groupBy(
                        "o.id", "o.codigo", "u.name", "o.fecha_recibe",
                        "o.fecha_asigna", "o.hora_recibe", "o.estado_orden",
                        "c.identificacion", "c.nombres", "l.descripcion", "l.direccion", "o.status_confirmado", "o.confirmar"
                    )
                    ->get()
                    ->map(function ($orden) {
                        $orden->id_encrypt = encrypt($orden->id);
                            if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                                    if (isset($orden->confirmar)) {
                                        if ($orden->confirmar == 'N') {
                                            $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                                        } elseif ($orden->confirmar == 'S') {
                                            $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                                        } else {
                                            $orden->status_confirmado_ad = '';
                                        }
                                    } else {
                                        $orden->status_confirmado_ad = '';
                                    }
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        return $orden;
                    });
                
                $ordenes = json_decode($ordenes, true);
                
                return response()->json(['status' => 'success', 'response' => $ordenes, 'isadmin' => 'S']);
                
                    return response()->json(['status' => 'success', 'response' => $ordenes, 'isadmin' => $isadmin]);
                } if ($request['filtro'] == 'C') {
                    $ordenes = DB::table("ordenes as o")
                    ->where("o.estado_del", 0)
                    ->where("o.estado_orden", $condicion_estado, $estado)
                    ->where('o.idlocal',$condicion_local, $idlocal)
                    ->join('clientes as c', 'c.id', '=', 'o.idcliente')
                    ->join('local as l', 'l.id', '=', 'o.idlocal')
                    ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
                    ->leftJoin('ordenes_incidencias as oi', 'oi.idorden', '=', 'o.id')
                    ->where(function ($query) use ($request) {
                        if (!empty($request['cedula_nombres'])) {
                            $query->where("c.identificacion", "like", "%" . $request['cedula_nombres'] . "%")
                                  ->orWhere("c.nombres", "like", "%" . $request['cedula_nombres'] . "%");
                        }
                    });
            
                    // Filtrar por rango de fechas si el checkbox de filtro de fecha está activado
                    if (!empty($request['filtro_fecha']) && !empty($request['fecha_desde']) && !empty($request['fecha_hasta'])) {
                        $ordenes->whereBetween("o.fecha_recibe", [$request['fecha_desde'], $request['fecha_hasta']]);
                    }
                
                    $ordenes = $ordenes->select([
                            "o.codigo",
                            "u.name as tecnico",
                            "o.id",
                            "o.fecha_recibe",
                            "o.fecha_asigna",
                            "o.hora_recibe",
                            "o.estado_orden",
                            "c.identificacion",
                            "c.nombres",
                            "l.descripcion as local",
                            "l.direccion as dir_local",
                            "o.status_confirmado",
                            "o.confirmar",
                            DB::raw('IF(COUNT(oi.idorden) > 0, 1, 0) as incidencia') // Campo incidencia con COUNT
                        ])
                        ->groupBy(
                            "o.id", "o.codigo", "u.name", "o.fecha_recibe",
                            "o.fecha_asigna", "o.hora_recibe", "o.estado_orden",
                            "c.identificacion", "c.nombres", "l.descripcion", "l.direccion", "o.status_confirmado", "o.confirmar"
                        )
                        ->get()
                        ->map(function ($orden) {
                            $orden->id_encrypt = encrypt($orden->id);
                            if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                                    if (isset($orden->confirmar)) {
                                        if ($orden->confirmar == 'N') {
                                            $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                                        } elseif ($orden->confirmar == 'S') {
                                            $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                                        } else {
                                            $orden->status_confirmado_ad = '';
                                        }
                                    } else {
                                        $orden->status_confirmado_ad = '';
                                    }
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                            return $orden;
                        });
                
                    $ordenes = json_decode($ordenes, true);
                    return response()->json(['status' => 'success', 'response' => $ordenes, 'isadmin' => $isadmin]);
                    
                    
                }else {
                    $ordenes = DB::table("ordenes as o")
                        ->where("o.estado_del", 0)
                        ->where("o.estado_orden", $condicion_estado, $estado)
                        ->where('o.idlocal',$condicion_local, $idlocal)
                        ->join('clientes as c', 'c.id', '=', 'o.idcliente')
                        ->join('local as l', 'l.id', '=', 'o.idlocal')
                        ->leftJoin('ordenes_incidencias as oi', 'oi.idorden', '=', 'o.id')
                        ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico');
                
                    // Filtrar por rango de fechas si el checkbox de filtro de fecha está activado
                    if (!empty($request['filtro_fecha']) && !empty($request['fecha_desde']) && !empty($request['fecha_hasta'])) {
                        $ordenes->whereBetween("o.fecha_recibe", [$request['fecha_desde'], $request['fecha_hasta']]);
                    }
                
                    $ordenes = $ordenes->select([
                            "o.codigo",
                            "u.name as tecnico",
                            "o.id",
                            "o.fecha_recibe",
                            "o.fecha_asigna",
                            "o.hora_recibe",
                            "o.estado_orden",
                            "c.identificacion",
                            "o.status_confirmado",
                            "o.confirmar",
                            "c.nombres",
                            "l.descripcion as local",
                            "l.direccion as dir_local",
                            DB::raw('IF(COUNT(oi.idorden) > 0, 1, 0) as incidencia') // Campo incidencia con COUNT
                        ])
                        ->groupBy(
                            "o.id", "o.codigo", "u.name", "o.fecha_recibe",
                            "o.fecha_asigna", "o.hora_recibe", "o.estado_orden",
                            "c.identificacion", "c.nombres", "l.descripcion", "l.direccion"
                        )
                        ->get()
                        ->map(function ($orden) {
                            $orden->id_encrypt = encrypt($orden->id);
                            if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                                    if (isset($orden->confirmar)) {
                                        if ($orden->confirmar == 'N') {
                                            $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                                        } elseif ($orden->confirmar == 'S') {
                                            $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                                        } else {
                                            $orden->status_confirmado_ad = '';
                                        }
                                    } else {
                                        $orden->status_confirmado_ad = '';
                                    }
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                            return $orden;
                        });
                
                    $ordenes = json_decode($ordenes, true);
                    return response()->json(['status' => 'success', 'response' => $ordenes, 'isadmin' => $isadmin]);
                }
            
    }

    public function generar_orden_pdf($id){
        try{
            $id=decrypt($id);
            $orden=OrdenModel::where('estado_del',0)->where('id',$id)->first();
            $fecha=date('Y-m-d');
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp"); //IDIOMA ESPAÑOL
            $fecha= date('Y-m-j',strtotime($fecha));
            $fecha = strftime("%d de %B de %Y", strtotime($fecha));
            $data=[];
            $notas=ParametrosModel::where('codigo','NOD')->where('estado_del',0)->get();
            $aceptaciones=ParametrosModel::where('codigo','ACPT')->where('estado_del',0)->get();
            $pdf = PDF::loadView('gestiones.ordenes.reporte',['data'=>$orden,'notas'=>$notas,'aceptacion'=>$aceptaciones]);
            $pdf->setPaper("A4", "portrait");
            return $pdf;
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return false;
        }
    }


    public function index_cambio_valores(){
        $locales = DB::table("local as l")
        ->where("l.estado_del", 0)
        ->select(
            "l.id","l.descripcion", "l.estado_del", "l.direccion"
        )->get();
        $locales=json_decode($locales,true);
        return view('gestiones.ordenes.index_cambio_valores')->with(['locales'=>$locales]);
    }

    public function buscar_entregadas(Request $request){
        $estado=null;
        $condicion_estado='!=';
        $condicion_local='!=';
        if($request['estado']!=1){
            $estado=$request['estado'];
            $condicion_estado='=';
        }
        if($request['local']!='T'){
            $idlocal=decrypt($request['local']);
            $condicion_local='=';
        }else{
                $condicion_local='!=';
                $idlocal=null;
        }
  
        if ($request['filtro'] == 'O') {
            $ordenes = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", 'F')
                ->where("o.tipo_orden", 'r')
                ->where('o.idlocal', $condicion_local, $idlocal)
                ->where("o.codigo", "like", "%" . $request['codigo'] . "%")
                ->join("clientes as c", "c.id", "=", "o.idcliente")
                ->join("local as l", "l.id", "=", "o.idlocal")
                ->leftJoin("users as u", "u.id", "=", "o.idusuario_tecnico")
                ->leftJoin("ordenes_atencion as oa", function ($join) {
                    $join->on("oa.idorden", "=", "o.id")
                        ->whereColumn("oa.tipo_orden", "=", "o.tipo_orden"); // Se compara con la tabla principal
                });
        
            // Aplicar filtro por fecha solo si 'filtro_fecha' está presente
            if (!empty($request['filtro_fecha'])) {
                $ordenes->whereBetween("o.fecha_recibe", [$request["fecha_desde"], $request["fecha_hasta"]]);
            }
        
            $ordenes = $ordenes->select([
                    "o.codigo",
                    "u.name as tecnico",
                    "o.id",
                    "o.entregado",
                    "o.fecha",
                    "o.fecha_entrega",
                    "o.estado_orden",
                    "o.modelo",
                    "o.tipo_garantia",
                    "o.tipo_orden",
                    "o.observacion_inicio",
                    "c.identificacion",
                    "c.nombres",
                    "l.descripcion as local",
                    "l.direccion as dir_local",
                    "oa.costo_total",
                    "oa.costo_local as material",
                    "oa.costo_tecnico",
                    "o.transferencia",
                    "o.efectivo",
                    "o.tarjeta_credito",
                    "o.observacion_entrega",
                    "oa.observacion_diagnostico",
                    "o.observacion_anulacion",
                    "o.imei",
                    "o.status_confirmado",
                    "o.confirmar",
                ])
                ->get();
        
            $ordenes = $ordenes->map(function ($orden) {
                $orden->id = Crypt::encrypt($orden->id); // Cifra el id
                if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                        if (isset($orden->confirmar)) {
                            if ($orden->confirmar == 'N') {
                                $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                            } elseif ($orden->confirmar == 'S') {
                                $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                } else {
                    $orden->status_confirmado_ad = '';
                }
                return $orden;
            });
        
            $ordenes = json_decode($ordenes, true);
            return response()->json(['status' => 'success', 'response' => $ordenes]);
        } 
        
        else if ($request['filtro'] == 'C') {
            $ordenes = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", 'F')
                ->where("o.tipo_orden", 'r')
                ->where('o.idlocal', $condicion_local, $idlocal)
                ->join("clientes as c", "c.id", "=", "o.idcliente")
                ->join("local as l", "l.id", "=", "o.idlocal")
                ->leftJoin("users as u", "u.id", "=", "o.idusuario_tecnico")
                ->leftJoin("ordenes_atencion as oa", function ($join) {
                    $join->on("oa.idorden", "=", "o.id")
                        ->whereColumn("oa.tipo_orden", "=", "o.tipo_orden"); // Se compara con la tabla principal
                });
        
            // Aplicar filtro por fecha solo si 'filtro_fecha' está presente
            if (!empty($request['filtro_fecha'])) {
                $ordenes->whereBetween("o.fecha_recibe", [$request["fecha_desde"], $request["fecha_hasta"]]);
            }
        
            // Filtro por cedula o nombres
            $ordenes->where(function ($query) use ($request) {
                if (!empty($request['cedula_nombres'])) {
                    $query->where("c.identificacion", "like", "%" . $request['cedula_nombres'] . "%")
                        ->orWhere("c.nombres", "like", "%" . $request['cedula_nombres'] . "%");
                }
            });
        
            $ordenes = $ordenes->select([
                    "o.codigo",
                    "u.name as tecnico",
                    "o.id",
                    "o.entregado",
                    "o.fecha",
                    "o.fecha_entrega",
                    "o.estado_orden",
                    "o.modelo",
                    "o.tipo_garantia",
                    "o.tipo_orden",
                    "o.observacion_inicio",
                    "c.identificacion",
                    "c.nombres",
                    "l.descripcion as local",
                    "l.direccion as dir_local",
                    "oa.costo_total",
                    "oa.costo_local as material",
                    "oa.costo_tecnico",
                    "o.transferencia",
                    "o.efectivo",
                    "o.tarjeta_credito",
                    "o.observacion_entrega",
                    "oa.observacion_diagnostico",
                    "o.observacion_anulacion",
                    "o.imei",
                    "o.status_confirmado",
                    "o.confirmar",
                ])
                ->get();
        
            $ordenes = $ordenes->map(function ($orden) {
                $orden->id = Crypt::encrypt($orden->id); // Cifra el id
                if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                        if (isset($orden->confirmar)) {
                            if ($orden->confirmar == 'N') {
                                $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                            } elseif ($orden->confirmar == 'S') {
                                $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                } else {
                    $orden->status_confirmado_ad = '';
                }
                return $orden;
            });
        
            $ordenes = json_decode($ordenes, true);
            return response()->json(['status' => 'success', 'response' => $ordenes]);
        }
        
        else {
            $ordenes = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", 'F')
                ->where("o.tipo_orden", 'r')
                ->where('o.idlocal', $condicion_local, $idlocal)
                ->join("clientes as c", "c.id", "=", "o.idcliente")
                ->join("local as l", "l.id", "=", "o.idlocal")
                ->leftJoin("users as u", "u.id", "=", "o.idusuario_tecnico")
                ->leftJoin("ordenes_atencion as oa", function ($join) {
                    $join->on("oa.idorden", "=", "o.id")
                        ->whereColumn("oa.tipo_orden", "=", "o.tipo_orden"); // Se compara con la tabla principal
                });
        
            // Aplicar filtro por fecha solo si 'filtro_fecha' está presente
            if (!empty($request['filtro_fecha'])) {
                $ordenes->whereBetween("o.fecha_recibe", [$request["fecha_desde"], $request["fecha_hasta"]]);
            }
        
            $ordenes = $ordenes->select([
                    "o.codigo",
                    "u.name as tecnico",
                    "o.id",
                    "o.entregado",
                    "o.fecha",
                    "o.fecha_entrega",
                    "o.estado_orden",
                    "o.modelo",
                    "o.tipo_garantia",
                    "o.tipo_orden",
                    "o.observacion_inicio",
                    "c.identificacion",
                    "c.nombres",
                    "l.descripcion as local",
                    "l.direccion as dir_local",
                    "oa.costo_total",
                    "oa.costo_local as material",
                    "oa.costo_tecnico",
                    "o.transferencia",
                    "o.efectivo",
                    "o.tarjeta_credito",
                    "o.observacion_entrega",
                    "oa.observacion_diagnostico",
                    "o.observacion_anulacion",
                    "o.imei",
                    "o.status_confirmado",
                    "o.confirmar",
                ])
                ->get();
        
            $ordenes = $ordenes->map(function ($orden) {
                $orden->id = Crypt::encrypt($orden->id); // Cifra el id
                if (isset($orden->status_confirmado) && $orden->status_confirmado == 1) {
                        if (isset($orden->confirmar)) {
                            if ($orden->confirmar == 'N') {
                                $orden->status_confirmado_ad = '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
                            } elseif ($orden->confirmar == 'S') {
                                $orden->status_confirmado_ad = '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
                            } else {
                                $orden->status_confirmado_ad = '';
                            }
                        } else {
                            $orden->status_confirmado_ad = '';
                        }
                } else {
                    $orden->status_confirmado_ad = '';
                }
                return $orden;
            });
        
            $ordenes = json_decode($ordenes, true);
            return response()->json(['status' => 'success', 'response' => $ordenes]);
        }
        
    }

    public function detalle_costos($id){
        try {
            $id=decrypt($id);
            $orden=OrdenAtencionModel::where('estado_del',0)
            ->where('idorden',$id)->where('tipo_orden','r')
            ->select('id','estado_del','costo_total','costo_tecnico','costo_local')
            ->first();
            return response()->json(['status' => 'success', 'response' => $orden]);
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());

            return response()->json(['status' => 'error', 'response' => 'No se puede obtener información']);

        }
    }

    public function actualizar_costos(Request $request){
        $transaction=DB::transaction(function() use ($request){
            try {
                $idordenatencion=decrypt($request['idordenajuste_encrypt']);
                $orden_atencion=OrdenAtencionModel::where('estado_del',0)->where('id',$idordenatencion)->first();
                if($orden_atencion==null){
                    return response()->json(['status' => 'error', 'response' => 'No se puede actualizar información']);
                }
                $costo_total_bd=$orden_atencion['costo_total'];
                $costo_total_request=$request->reparacion+$request->repuesto;

                if($costo_total_bd<$costo_total_request){
                    return response()->json(['status' => 'error', 'response' => 'La suma de reparación y repuesto no puede ser mayor al costo total.']);
                }
                //verificar para el primer registro
                $buscar_audit=AuditoriaOrdenAtencionModel::where('idordenatencion',$orden_atencion['id'])->first();

                if($buscar_audit==null){
                    $auditoria_buscar=new AuditoriaOrdenAtencionModel();
                    $auditoria_buscar->costo_tecnico=$orden_atencion->costo_tecnico;
                    $auditoria_buscar->costo_local=$orden_atencion->costo_local;
                    $auditoria_buscar->idordenatencion=$idordenatencion;
                    $auditoria_buscar->observacion='Valores iniciales.';
                    $auditoria_buscar->user_registra=auth()->user()->id;
                    $auditoria_buscar->save();
                }
                $auditoria=new AuditoriaOrdenAtencionModel();
                $auditoria->costo_tecnico=$request->reparacion;
                $auditoria->costo_local=$request->repuesto;
                $auditoria->observacion=$request->observacion_ajuste;
                $auditoria->user_registra=auth()->user()->id;
                $auditoria->idordenatencion=$idordenatencion;

                $auditoria->save();

                $orden_atencion->costo_tecnico=$request->reparacion;
                $orden_atencion->costo_local=$request->repuesto;
                $orden_atencion->save();

                $result['costo_local']=$orden_atencion['costo_local'];
                $result['costo_tecnico']=$orden_atencion['costo_tecnico'];
                $result['costo_total']=$orden_atencion['costo_total'];
                $result['codigo']=$orden_atencion['orden']['codigo'];

                return response()->json(['status' => 'success', 'response' => 'Actualización realizada con éxito','result'=>$result]);

            } catch (\Throwable $th) {
                DB::rollback();
                Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
                return response()->json(['status' => 'error', 'response' => 'No se puede actualizar información']);

            }
        });
        return $transaction;
    }

    public function ordenes_status($estado){
       try{
         // Selecciona solo la fecha relevante según el estado

        $ordenes = DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.estado_orden", $estado)
            ->select(
                "o.id",
                "o.codigo",
                "o.tipo_orden",
                DB::raw("CASE WHEN o.tipo_orden = 'd' THEN 'Diagnóstico' ELSE 'Reparación' END as tipo_orden_texto")
            )
            ->get();
        return response()->json(['status' => 'success', 'response' => $ordenes]);
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status' => 'error', 'response' => 'No se puede actualizar información']);

        }
    }

    public function detalle_orden_index($id){
        $id=base64_decode($id);
        return view('gestiones.ordenes.detalle_orden')->with(['idorden'=>$id]);
    }

    public function filtro_grafico_detalle(Request $request){
            $estado=$request['estado'];
            $fechaInicio = $request['fecha_desde']; // Cambia esto por la fecha de inicio deseada
            $fechaFin = $request['fecha_hasta']; // Cambia esto por la fecha de fin deseada
            $fechaInicio = Carbon::parse($fechaInicio)->startOfDay(); // 00:00:00
            $fechaFin = Carbon::parse($fechaFin)->endOfDay(); // 23:59:59
            $condicion_local='!=';
            $idlocal=null;
            if($request['local']!='T'){
                $idlocal=decrypt($request['local']);
                $condicion_local='=';
            }
            
            // $ordenes_total = DB::table("ordenes as o")
            //     ->where("o.estado_del", 0)
            //     ->whereBetween("o.fecha", [$fechaInicio, $fechaFin])
            //     ->where('o.idlocal',$condicion_local,$idlocal)
            //     ->count();

                 $ordenes = DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.estado_orden", $estado)
            ->whereBetween("o.fecha", [$fechaInicio, $fechaFin])
                ->where('o.idlocal',$condicion_local,$idlocal)
            ->select(
                "o.id",
                "o.codigo",
                "o.tipo_orden",
                DB::raw("CASE WHEN o.tipo_orden = 'd' THEN 'Diagnóstico' ELSE 'Reparación' END as tipo_orden_texto")
            )
            ->get();
        return response()->json(['status' => 'success', 'response' => $ordenes]);

    }

}
