<?php

namespace App\Http\Controllers\Gestiones;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Carbon\carbon;
use PDF;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Symfony\Component\HttpFoundation\StreamedResponse;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Borders;
use App\Models\User;
use App\Models\OrdenModel;
use Log;
class ReportesController extends Controller
{
    public function index_graficos(){
        $locales = DB::table("local as l")
        ->where("l.estado_del", 0)
        ->select(
            "l.id","l.descripcion", "l.estado_del", "l.direccion"
        )->get();
        $locales=json_decode($locales,true);
        return view('reportes.index_dashboard')->with(['locales'=>$locales]);
    }
    public function filtro_grafico(Request $request){

            $fechaInicio = $request['fecha_desde']; // Cambia esto por la fecha de inicio deseada
            $fechaFin = $request['fecha_hasta']; // Cambia esto por la fecha de fin deseada
            $fechaInicio = Carbon::parse($fechaInicio)->startOfDay(); // 00:00:00
            $fechaFin = Carbon::parse($fechaFin)->endOfDay(); // 23:59:59
            $condicion_local='!=';
            $idlocal=null;
            if($request['local']!='T'){
                $idlocal=decrypt($request['local']);
                $condicion_local='=';
            }
            
            $ordenes_total = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->whereBetween("o.fecha", [$fechaInicio, $fechaFin])
                ->where('o.idlocal',$condicion_local,$idlocal)
                ->count();
            
            $ordenes_sinasignar = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", 'I')
                ->whereBetween("o.fecha", [$fechaInicio, $fechaFin])
                ->where('o.idlocal',$condicion_local,$idlocal)
                ->count();
            
            $ordenes_asignadas = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", 'A')
                ->whereBetween("o.fecha", [$fechaInicio, $fechaFin])
                ->where('o.idlocal',$condicion_local,$idlocal)
                ->count();
            
            $ordenes_atendidas = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", 'T')
                ->whereBetween("o.fecha", [$fechaInicio, $fechaFin])
                ->where('o.idlocal',$condicion_local,$idlocal)
                ->count();
            
            $ordenes_entregadas = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", 'F')
                ->whereBetween("o.fecha", [$fechaInicio, $fechaFin])
                ->where('o.idlocal',$condicion_local,$idlocal)
                ->count();
            
            $ordenes_anuladas = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.estado_orden", 'D')
                ->whereBetween("o.fecha", [$fechaInicio, $fechaFin])
                ->where('o.idlocal',$condicion_local,$idlocal)
                ->count();

            $clientes = DB::table("clientes as c")
            ->where("c.estado_del",0)
            ->whereBetween("c.created_at", [$fechaInicio, $fechaFin])
            ->where('c.idlocal',$condicion_local,$idlocal)
            ->count();

            $costo_total = DB::table("ordenes_atencion as oa")
            ->join("ordenes as o", "oa.idorden", "=", "o.id") // Unir con la tabla ordenes
            ->where("oa.tipo_orden", "r") // Filtrar por tipo_orden 'r'
            ->where("o.estado_orden", "F") // Filtrar por estado_orden 'F'
            ->whereBetween("o.fecha_recibe", [$fechaInicio, $fechaFin])
            ->where('o.idlocal',$condicion_local,$idlocal)
            ->sum("oa.costo_total"); // Sumar el costo total del mes

            $costo_repuesto = DB::table("ordenes_atencion as oa")
            ->join("ordenes as o", "oa.idorden", "=", "o.id") // Unir con la tabla ordenes
            ->where("oa.tipo_orden", "r") // Filtrar por tipo_orden 'r'
            ->where("o.estado_orden", "F") // Filtrar por estado_orden 'F'
            ->whereBetween("o.fecha_recibe", [$fechaInicio, $fechaFin])
            ->where('o.idlocal',$condicion_local,$idlocal)
            ->sum("oa.costo_local"); // Sumar el costo total del mes

            $costo_tecnico = DB::table("ordenes_atencion as oa")
            ->join("ordenes as o", "oa.idorden", "=", "o.id") // Unir con la tabla ordenes
            ->where("oa.tipo_orden", "r") // Filtrar por tipo_orden 'r'
            ->where("o.estado_orden", "F") // Filtrar por estado_orden 'F'
            ->whereBetween("o.fecha_recibe", [$fechaInicio, $fechaFin])
            ->where('o.idlocal',$condicion_local,$idlocal)
            ->sum("oa.costo_tecnico"); // Sumar el costo total del mes

            $ganancia=$costo_total-$costo_repuesto-$costo_tecnico;
            
            $data=['total'=>$ordenes_total,
                'sinasignar'=>$ordenes_sinasignar,
                'asignadas'=>$ordenes_asignadas,
                'atendidas'=>$ordenes_atendidas,
                'entregadas'=>$ordenes_entregadas,
                'anuladas'=>$ordenes_anuladas,
                'clientes'=>$clientes,
                'costo_total'=>$costo_total,
                'costo_repuesto'=>$costo_repuesto,
                'costo_tecnico'=>$costo_tecnico,
                'ganancia'=>number_format($ganancia,2)
            ];
            return response()->json(['error'=>false,'response'=>$data]);
    }

    public function index_reporte_fecha(){
        $locales = DB::table("local as l")
        ->where("l.estado_del", 0)
        ->select(
            "l.id","l.descripcion", "l.estado_del", "l.direccion"
        )->get();
        $locales=json_decode($locales,true);
        return view("reportes.porfecha")->with(['locales'=>$locales]);
    }

    public function filtro_buscar(Request $request){
           
        try {
            $estado=null;
                $condicion_estado='!=';
                $condicion_local='!=';
                if($request['estado']!=1){
                    $estado=$request['estado'];
                    $condicion_estado='=';
                }
                $isadmin='N';
                if(auth()->user()['tipo']=='AD'){
                    if($request['local']!='T'){
                        $idlocal=decrypt($request['local']);
                        $condicion_local='=';
                    }else{
                         $condicion_local='!=';
                         $idlocal=null;
                    }
                    $isadmin='S';
                }else{
                    $idlocal=decrypt(session('id_local'));
                    $condicion_local='=';
                }
                if ($request['filtro'] == 'O') {
                    $ordenes = DB::table("ordenes as o")
                        ->where("o.estado_del", 0)
                        ->where("o.estado_orden", $condicion_estado, $estado)
                        ->where('o.idlocal',$condicion_local, $idlocal)
                        ->join('clientes as c', 'c.id', '=', 'o.idcliente')
                        ->join('local as l', 'l.id', '=', 'o.idlocal')
                        ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
                        ->where("o.codigo", "like", "%" . $request['codigo'] . "%");
                
                    // Filtrar por rango de fechas si el checkbox de filtro de fecha está activado
                    if (!empty($request['filtro_fecha']) && !empty($request['fecha_desde']) && !empty($request['fecha_hasta'])) {
                        $ordenes->whereBetween("o.fecha_recibe", [$request['fecha_desde'], $request['fecha_hasta']]);
                    }
                
                    $ordenes = $ordenes->select([
                            "o.codigo",
                            "u.name as tecnico",
                            "o.id",
                            "o.fecha_recibe",
                            "o.fecha_asigna",
                            "o.hora_recibe",
                            "o.estado_orden",
                            "c.identificacion",
                            "c.nombres",
                            "l.descripcion as local",
                            "l.direccion as dir_local"
                        ])
                        ->groupBy(
                            "o.id", "o.codigo", "u.name", "o.fecha_recibe",
                            "o.fecha_asigna", "o.hora_recibe", "o.estado_orden",
                            "c.identificacion", "c.nombres", "l.descripcion", "l.direccion"
                        )
                        ->get()
                        ->map(function ($orden) {
                            $orden->id_encrypt = encrypt($orden->id);
                            return $orden;
                        });
                
                    $ordenes = json_decode($ordenes, true);
                    return response()->json(['status' => 'success', 'response' => $ordenes, 'isadmin' => $isadmin]);
                } if ($request['filtro'] == 'C') {
                    $ordenes = DB::table("ordenes as o")
                    ->where("o.estado_del", 0)
                    ->where("o.estado_orden", $condicion_estado, $estado)
                    ->where('o.idlocal',$condicion_local, $idlocal)
                    ->join('clientes as c', 'c.id', '=', 'o.idcliente')
                    ->join('local as l', 'l.id', '=', 'o.idlocal')
                    ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico')
                    ->where(function ($query) use ($request) {
                        if (!empty($request['cedula_nombres'])) {
                            $query->where("c.identificacion", "like", "%" . $request['cedula_nombres'] . "%")
                                  ->orWhere("c.nombres", "like", "%" . $request['cedula_nombres'] . "%");
                        }
                    });
            
                    // Filtrar por rango de fechas si el checkbox de filtro de fecha está activado
                    if (!empty($request['filtro_fecha']) && !empty($request['fecha_desde']) && !empty($request['fecha_hasta'])) {
                        $ordenes->whereBetween("o.fecha_recibe", [$request['fecha_desde'], $request['fecha_hasta']]);
                    }
                
                    $ordenes = $ordenes->select([
                            "o.codigo",
                            "u.name as tecnico",
                            "o.id",
                            "o.fecha_recibe",
                            "o.fecha_asigna",
                            "o.hora_recibe",
                            "o.estado_orden",
                            "c.identificacion",
                            "c.nombres",
                            "l.descripcion as local",
                            "l.direccion as dir_local"
                        ])
                        ->groupBy(
                            "o.id", "o.codigo", "u.name", "o.fecha_recibe",
                            "o.fecha_asigna", "o.hora_recibe", "o.estado_orden",
                            "c.identificacion", "c.nombres", "l.descripcion", "l.direccion"
                        )
                        ->get()
                        ->map(function ($orden) {
                            $orden->id_encrypt = encrypt($orden->id);
                            return $orden;
                        });
                
                    $ordenes = json_decode($ordenes, true);
                    return response()->json(['status' => 'success', 'response' => $ordenes, 'isadmin' => $isadmin]);
                    
                    
                }else {
                    $ordenes = DB::table("ordenes as o")
                        ->where("o.estado_del", 0)
                        ->where("o.estado_orden", $condicion_estado, $estado)
                        ->where('o.idlocal',$condicion_local, $idlocal)
                        ->join('clientes as c', 'c.id', '=', 'o.idcliente')
                        ->join('local as l', 'l.id', '=', 'o.idlocal')
                        ->leftJoin('users as u', 'u.id', '=', 'o.idusuario_tecnico');
                
                    // Filtrar por rango de fechas si el checkbox de filtro de fecha está activado
                    if (!empty($request['filtro_fecha']) && !empty($request['fecha_desde']) && !empty($request['fecha_hasta'])) {
                        $ordenes->whereBetween("o.fecha_recibe", [$request['fecha_desde'], $request['fecha_hasta']]);
                    }
                
                    $ordenes = $ordenes->select([
                            "o.codigo",
                            "u.name as tecnico",
                            "o.id",
                            "o.fecha_recibe",
                            "o.fecha_asigna",
                            "o.hora_recibe",
                            "o.estado_orden",
                            "c.identificacion",
                            "c.nombres",
                            "l.descripcion as local",
                            "l.direccion as dir_local"
                        ])
                        ->groupBy(
                            "o.id", "o.codigo", "u.name", "o.fecha_recibe",
                            "o.fecha_asigna", "o.hora_recibe", "o.estado_orden",
                            "c.identificacion", "c.nombres", "l.descripcion", "l.direccion"
                        )
                        ->get()
                        ->map(function ($orden) {
                            $orden->id_encrypt = encrypt($orden->id);
                            return $orden;
                        });
                
                    $ordenes = json_decode($ordenes, true);
                    return response()->json(['status' => 'success', 'response' => $ordenes, 'isadmin' => $isadmin]);
                }
            
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes, intente nuevamente']);
        }
    }

    public function filtro_fechas(Request $request){
                $local=null;
                $condicion_local='!=';
                $tipo=null;
                $condicion_tipo='!=';
                if($request['local']!='T'){
                    $local=decrypt($request['local']);
                    $condicion_local='=';
                }

                if($request['tipo']!='T'){
                    $tipo=$request['tipo'];
                    $condicion_tipo='=';
                }
                $ordenes = DB::table("ordenes as o")
                ->where("o.estado_del", 0)
                ->where("o.tipo_orden", $condicion_tipo, $tipo)
                ->where("o.idlocal", $condicion_local, $local)
                ->where("o.entregado", 1)
                ->join("clientes as c", "c.id", "=", "o.idcliente")
                ->join("local as l", "l.id", "=", "o.idlocal")
                ->leftJoin("users as u", "u.id", "=", "o.idusuario_tecnico")
                ->leftJoin("ordenes_atencion as oa", function ($join) {
                    $join->on("oa.idorden", "=", "o.id")
                         ->whereColumn("oa.tipo_orden", "=", "o.tipo_orden"); // Se compara con la tabla principal
                })
                ->whereBetween("o.fecha_recibe", [$request["fecha_desde"], $request["fecha_hasta"]])
                ->select([
                    "o.codigo",
                    "u.name as tecnico",
                    "o.id",
                    "o.entregado",
                    "o.fecha",
                    "o.fecha_entrega",
                    "o.estado_orden",
                    "o.modelo",
                    "o.tipo_garantia",
                    "o.tipo_orden",
                    "o.observacion_inicio",
                    "c.identificacion",
                    "c.nombres",
                    "l.descripcion as local",
                    "l.direccion as dir_local",
                    "oa.costo_total",
                    "oa.costo_local as material",
                    "oa.costo_tecnico",
                    "o.transferencia",
                    "o.efectivo",
                    "o.tarjeta_credito",
                    "o.payphone",
                    "o.observacion_entrega",
                    "oa.observacion_diagnostico",
                    "o.observacion_anulacion",
                    "o.imei",
                ])
                ->get();
                
                    $ordenes = json_decode($ordenes, true);

                    return response()->json(['status' => 'success', 'response' => $ordenes]);
    }

    public function filtro_fechas_pdf(Request $request){
        try {
       
            $local=null;
            $condicion_local='!=';
            $tipo=null;
            $condicion_tipo='!=';
            if($request['local']!='T'){
                $local=decrypt($request['local']);
                $condicion_local='=';
            }
    
            if($request['tipo']!='T'){
                $tipo=$request['tipo'];
                $condicion_tipo='=';
            }
            $ordenes = DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.tipo_orden", $condicion_tipo, $tipo)
            ->where("o.idlocal", $condicion_local, $local)
            ->where("o.entregado", 1)
            ->join("clientes as c", "c.id", "=", "o.idcliente")
            ->join("local as l", "l.id", "=", "o.idlocal")
            ->leftJoin("users as u", "u.id", "=", "o.idusuario_tecnico")
            ->leftJoin("ordenes_atencion as oa", function ($join) {
                $join->on("oa.idorden", "=", "o.id")
                    ->whereColumn("oa.tipo_orden", "=", "o.tipo_orden"); // Se compara con la tabla principal
            })
            ->whereBetween("o.fecha_recibe", [$request["fecha_desde"], $request["fecha_hasta"]])
            ->select([
                "o.codigo",
                "u.name as tecnico",
                "o.id",
                "o.entregado",
                "o.fecha",
                "o.fecha_entrega",
                "o.estado_orden",
                "o.modelo",
                "o.tipo_garantia",
                "o.tipo_orden",
                "o.observacion_inicio",
                "c.identificacion",
                "c.nombres",
                "l.descripcion as local",
                "l.direccion as dir_local",
                "oa.costo_total",
                "oa.costo_local as material",
                "oa.costo_tecnico",
                "o.transferencia",
                "o.efectivo",
                "o.tarjeta_credito",
                "o.observacion_entrega",
                "oa.observacion_diagnostico",
                "o.observacion_anulacion",
                "o.imei",
                "o.payphone",
            ])
            ->get();
            
            $ordenes = json_decode($ordenes, true);

            $pdf = PDF::loadView('reportes.porfecha_pdf', compact('ordenes'))->setPaper("A4", "landscape");;

            $fileName = "Reporte_" . $request["fecha_desde"].'-'.$request["fecha_hasta"] . ".xlsx";
            return response($pdf->stream('ordenes.pdf'), 200, [
                'Content-Type' => 'application/pdf',
                'Content-Disposition' => 'attachment; filename="'.$fileName.'"',
            ]);
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes, intente nuevamente']);
        }
    }

    public function filtro_fechas_excel(Request $request){

        $local=null;
        $condicion_local='!=';
        $tipo=null;
        $condicion_tipo='!=';
        if($request['local']!='T'){
            $local=decrypt($request['local']);
            $condicion_local='=';
        }

        if($request['tipo']!='T'){
            $tipo=$request['tipo'];
            $condicion_tipo='=';
        }
        $ordenes = DB::table("ordenes as o")
        ->where("o.estado_del", 0)
        ->where("o.tipo_orden", $condicion_tipo, $tipo)
        ->where("o.idlocal", $condicion_local, $local)
        ->where("o.entregado", 1)
        ->join("clientes as c", "c.id", "=", "o.idcliente")
        ->join("local as l", "l.id", "=", "o.idlocal")
        ->leftJoin("users as u", "u.id", "=", "o.idusuario_tecnico")
        ->leftJoin("ordenes_atencion as oa", function ($join) {
            $join->on("oa.idorden", "=", "o.id")
                 ->whereColumn("oa.tipo_orden", "=", "o.tipo_orden"); // Se compara con la tabla principal
        })
        ->whereBetween("o.fecha_recibe", [$request["fecha_desde"], $request["fecha_hasta"]])
        ->select([
            "o.codigo",
            "u.name as tecnico",
            "o.id",
            "o.entregado",
            "o.fecha",
            "o.fecha_entrega",
            "o.estado_orden",
            "o.modelo",
            "o.tipo_garantia",
            "o.tipo_orden",
            "o.observacion_inicio",
            "c.identificacion",
            "c.nombres",
            "l.descripcion as local",
            "l.direccion as dir_local",
            "oa.costo_total",
            "oa.costo_local as material",
            "oa.costo_tecnico",
            "o.transferencia",
            "o.efectivo",
            "o.tarjeta_credito",
            "o.observacion_entrega",
            "oa.observacion_diagnostico",
            "o.observacion_anulacion",
            "o.imei",
            "o.payphone"
        ])
        ->get();
        
        $ordenes = json_decode($ordenes, true);

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle($request["fecha_desde"].'-'.$request["fecha_hasta"]);
        // Definir el rango de encabezados
        $headerRange = 'A1:U1';

        // Aplicar negrita a los encabezados
        $sheet->getStyle($headerRange)->getFont()->setBold(true);

        // Aplicar color de fondo azul
        $sheet->getStyle($headerRange)->getFill()->setFillType(Fill::FILL_SOLID)
            ->getStartColor()->setARGB('FF0070C0'); // Azul

        // Aplicar color blanco al texto para contraste
        $sheet->getStyle($headerRange)->getFont()->getColor()->setARGB('FFFFFFFF');
        // Encabezados
        $sheet->setCellValue('A1', 'Orden');
        $sheet->setCellValue('B1', 'Local');
        $sheet->setCellValue('C1', 'Cliente');
        $sheet->setCellValue('D1', 'Ingreso');
        $sheet->setCellValue('E1', 'Salida');
        $sheet->setCellValue('F1', 'Modelo');
        $sheet->setCellValue('G1', 'Garantía');
        $sheet->setCellValue('H1', 'Obs. ingreso');
        $sheet->setCellValue('I1', 'Obs. atención');
        $sheet->setCellValue('J1', 'Obs. salida');
        $sheet->setCellValue('K1', 'Obs. anulación');
        $sheet->setCellValue('L1', 'Transferencia');
        $sheet->setCellValue('M1', 'Tarjeta crédito');
        $sheet->setCellValue('N1', 'Payphone');
        $sheet->setCellValue('O1', 'Efectivo');
        $sheet->setCellValue('P1', 'Material');
        $sheet->setCellValue('Q1', 'Reparación');
        $sheet->setCellValue('R1', 'Total');
        $sheet->setCellValue('S1', 'Utilidad');
        $sheet->setCellValue('T1', 'Tipo');
        $sheet->setCellValue('U1', 'Técnico');
        $sheet->setCellValue('V1', 'Estado');
        // Llenar datos
        $row = 2;
        foreach ($ordenes as $orden) {
            if($orden['tipo_orden']=='d'){
                $orden['tipo_orden']='Diagnóstico';
                $orden['costo_total']=0;
                $orden['costo_tecnico']=0;
                $orden['material']=0;
                $orden['efectivo']=0;
                $orden['tarjeta_credito']=0;
                $orden['transferencia']=0;
            }else{
                $orden['tipo_orden']='Reparación';

            }


            if($orden['estado_orden']=='D'){
                $orden['costo_total']=0;
                $orden['costo_tecnico']=0;
                $orden['material']=0;
                $orden['efectivo']=0;
                $orden['tarjeta_credito']=0;
                $orden['transferencia']=0;
                $orden['estado_orden']='Anulada';

            }else{
                $orden['estado_orden']='Entregada';

            }
            if($orden['tipo_garantia']=='NA'){
                $orden['tipo_garantia']='No aplica';
            }
            if($orden['tipo_garantia']=='co'){
                $orden['tipo_garantia']='Compra';
            }
            if($orden['tipo_garantia']=='st'){
                $orden['tipo_garantia']='Servicio técnico';
            }
            $sheet->setCellValue('A' . $row, $orden['codigo']);
            $sheet->setCellValue('B' . $row, $orden['local'].'-'.$orden['dir_local']);
            $sheet->setCellValue('C' . $row, $orden['nombres']);
            $sheet->setCellValue('D' . $row, $orden['fecha']);
            $sheet->setCellValue('E' . $row, $orden['fecha_entrega']);
            $sheet->setCellValue('F' . $row, $orden['modelo']);
            $sheet->setCellValue('G' . $row, $orden['tipo_garantia']);
            $sheet->setCellValue('H' . $row, $orden['observacion_inicio']);
            $sheet->setCellValue('I' . $row, $orden['observacion_diagnostico']);
            $sheet->setCellValue('J' . $row, $orden['observacion_entrega']);
            $sheet->setCellValue('K' . $row, $orden['observacion_anulacion']);
            $sheet->setCellValue('L' . $row, $orden['transferencia']);
            $sheet->setCellValue('M' . $row, $orden['tarjeta_credito']);
            $sheet->setCellValue('N' . $row, $orden['payphone']);
            $sheet->setCellValue('O' . $row, $orden['efectivo']);
            $sheet->setCellValue('P' . $row, $orden['material']);
            $sheet->setCellValue('Q' . $row, $orden['costo_tecnico']);
            $sheet->setCellValue('R' . $row, $orden['costo_total']);
            $sheet->setCellValue('S' . $row, $orden['costo_total']-$orden['material']-$orden['costo_tecnico']);
            $sheet->setCellValue('T' . $row, $orden['tipo_orden']);
            $sheet->setCellValue('U' . $row, $orden['tecnico']);
            $sheet->setCellValue('V' . $row, $orden['estado_orden']);
            // Aplicamos el formato numérico con dos decimales
            $sheet->getStyle('L' . $row . ':R' . $row)
            ->getNumberFormat()
            ->setFormatCode('[$$-409]#,##0.00');
                if($orden['estado_orden']=='Anulada'){
                    $sheet->getStyle('U' . $row)->getFont()->setBold(true)->getColor()->setARGB('FFFF0000');
                }
            $row++;
        }
       // Definir el rango de datos (desde A1 hasta la última fila)
        $lastRow = $sheet->getHighestRow(); // Obtiene la última fila con datos
        $lastColumn = $sheet->getHighestColumn(); // Obtiene la última columna con datos
        $dataRange = 'A1:' . $lastColumn . $lastRow;
        // Obtener la última columna con datos
        $lastColumn = $sheet->getHighestColumn(); 
        $sheet->getStyle('L' . ($lastRow + 1) . ':R' . ($lastRow + 1))
        ->getNumberFormat()
        ->setFormatCode('[$$-409]#,##0.00');

        $sheet->getStyle('L' . ($lastRow + 1) . ':R' . ($lastRow + 1))
        ->getFont()
        ->setBold(true);
        $sheet->setAutoFilter('A1:U1');
        // Suponiendo que $lastRow es la última fila con datos
        $sheet->setCellValue('L' . ($lastRow + 1), '=SUBTOTAL(9, L2:L' . $lastRow . ')');
        $sheet->setCellValue('M' . ($lastRow + 1), '=SUBTOTAL(9, M2:M' . $lastRow . ')'); 
        $sheet->setCellValue('N' . ($lastRow + 1), '=SUBTOTAL(9, N2:N' . $lastRow . ')'); 
        $sheet->setCellValue('O' . ($lastRow + 1), '=SUBTOTAL(9, O2:O' . $lastRow . ')'); 
        $sheet->setCellValue('P' . ($lastRow + 1), '=SUBTOTAL(9, P2:P' . $lastRow . ')'); 
        $sheet->setCellValue('Q' . ($lastRow + 1), '=SUBTOTAL(9, Q2:Q' . $lastRow . ')'); 
        $sheet->setCellValue('R' . ($lastRow + 1), '=SUBTOTAL(9, R2:R' . $lastRow . ')'); 

        // Aplicar autoajuste a todas las columnas con datos
        foreach (range('A', $lastColumn) as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }
        // Aplicar bordes a todo el rango
        $sheet->getStyle($dataRange)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
        // Configurar la descarga
        $fileName = "Reporte_" . $request["fecha_desde"].'-'.$request["fecha_hasta"] . ".xlsx";
        $writer = new Xlsx($spreadsheet);

        $response = new StreamedResponse(function () use ($writer) {
            $writer->save('php://output');
        });

        $response->headers->set('Content-Type', 'application/vnd.ms-excel');
        $response->headers->set('Content-Disposition', 'attachment;filename="' . $fileName . '"');
        $response->headers->set('Cache-Control', 'max-age=0');

        return $response;

    }
    public function index_ordenes_tecnicos(){
        $tecnicos = DB::table("users as u")
        ->where("u.estado_del", 0)
        ->join('usuario_tipousuario as ut', 'ut.idusuario', '=', 'u.id')
        ->join('tipo_usuario as tu', 'tu.id', '=', 'ut.idtipousuario')
        ->where('tu.codigo', 'TE')  // Filtro por tipo de usuario TE
        ->where('u.estado_user',0)
        ->select("u.identificacion", "u.name",'u.id')
        ->get();
        $tecnicos->map(function($tecnicos) {
            $tecnicos->id_encrypt = encrypt($tecnicos->id);  // Encriptar el id usando el accesor
            return $tecnicos;
        });
        return view('reportes.index_orden_tecnicos')->with(['tecnicos'=>$tecnicos]);
    }
    public function ordenes_tecnicos_pdf(Request $request){
        try {
            $idtecnico=decrypt($request['tecnico']);
            $tipo=null;
            $condicion_tipo='!=';
            if($request['tipo']!='T'){
                $tipo=$request['tipo'];
                $condicion_tipo='=';
            }
            $ordenes = DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.tipo_orden", $condicion_tipo, $tipo)
            ->where("o.idusuario_tecnico", $idtecnico)
            ->where("o.entregado", 1)
            ->join("clientes as c", "c.id", "=", "o.idcliente")
            ->join("local as l", "l.id", "=", "o.idlocal")
            ->leftJoin("users as u", "u.id", "=", "o.idusuario_tecnico")
            ->leftJoin("ordenes_atencion as oa", function ($join) {
                $join->on("oa.idorden", "=", "o.id")
                    ->whereColumn("oa.tipo_orden", "=", "o.tipo_orden"); // Se compara con la tabla principal
            })
            ->whereBetween("o.fecha_recibe", [$request["fecha_desde"], $request["fecha_hasta"]])
            ->select([
                "o.codigo",
                "u.name as tecnico",
                "o.id",
                "o.entregado",
                "o.fecha",
                "o.fecha_entrega",
                "o.estado_orden",
                "o.modelo",
                "o.tipo_garantia",
                "o.tipo_orden",
                "o.observacion_inicio",
                "c.identificacion",
                "c.nombres",
                "l.descripcion as local",
                "l.direccion as dir_local",
                "oa.costo_total",
                "oa.costo_local as material",
                "oa.costo_tecnico",
                "o.transferencia",
                "o.efectivo",
                "o.tarjeta_credito",
                "o.observacion_entrega",
                "oa.observacion_diagnostico",
                "o.observacion_anulacion",
                "o.imei",
                "o.payphone",
            ])
            ->get();
            
            $ordenes = json_decode($ordenes, true);
            $pdf = PDF::loadView('reportes.orden_tecnicos_pdf', compact('ordenes'))->setPaper("A4", "landscape");;

            $fileName = "Reporte_" . $request["fecha_desde"].'-'.$request["fecha_hasta"] . ".xlsx";
            return response($pdf->stream('ordenes.pdf'), 200, [
                'Content-Type' => 'application/pdf',
                'Content-Disposition' => 'attachment; filename="'.$fileName.'"',
            ]);
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes, intente nuevamente']);
        }
    }
    public function ordenes_tecnicos(Request $request){
        try {
            $idtecnico=decrypt($request['tecnico']);
            $tipo=null;
            $condicion_tipo='!=';
            if($request['tipo']!='T'){
                $tipo=$request['tipo'];
                $condicion_tipo='=';
            }
            $ordenes = DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.tipo_orden", $condicion_tipo, $tipo)
            ->where("o.idusuario_tecnico", $idtecnico)
            ->where("o.entregado", 1)
            ->join("clientes as c", "c.id", "=", "o.idcliente")
            ->join("local as l", "l.id", "=", "o.idlocal")
            ->leftJoin("users as u", "u.id", "=", "o.idusuario_tecnico")
            ->leftJoin("ordenes_atencion as oa", function ($join) {
                $join->on("oa.idorden", "=", "o.id")
                    ->whereColumn("oa.tipo_orden", "=", "o.tipo_orden"); // Se compara con la tabla principal
            })
            ->whereBetween("o.fecha_recibe", [$request["fecha_desde"], $request["fecha_hasta"]])
            ->select([
                "o.codigo",
                "u.name as tecnico",
                "o.id",
                "o.entregado",
                "o.fecha",
                "o.fecha_entrega",
                "o.estado_orden",
                "o.modelo",
                "o.tipo_garantia",
                "o.tipo_orden",
                "o.observacion_inicio",
                "c.identificacion",
                "c.nombres",
                "l.descripcion as local",
                "l.direccion as dir_local",
                "oa.costo_total",
                "oa.costo_local as material",
                "oa.costo_tecnico",
                "o.transferencia",
                "o.efectivo",
                "o.tarjeta_credito",
                "o.observacion_entrega",
                "oa.observacion_diagnostico",
                "o.observacion_anulacion",
                "o.imei",
                "o.payphone",
            ])
            ->get();
            
            $ordenes = json_decode($ordenes, true);
            return response()->json(['status'=>'success','response'=>$ordenes]);
        } catch (\Throwable $th) {
            Log::error(__CLASS__." => ".__FUNCTION__." =>  Error =>".$th->getMessage());
            return response()->json(['status'=>'error','response'=>'Inconvenientes, intente nuevamente']);
        }
    }

    public function index_varios(){
        $tecnicos = User::with([
            'localesusuario' => function($query) {
                $query->select('id', 'idusuario', 'idlocal', 'estado_del')
                    ->where('estado_del', 0);
            },
            'usuariotipousuario' => function($query) {
                $query->select('id', 'idusuario', 'idtipousuario', 'estado')
                    ->where('estado', 0);
            }
        ])
        ->where('estado_del', 0)
        ->where('estado_user', 0)
        ->whereHas('usuariotipousuario.tipousuario', function($query) {
            $query->where('codigo', 'TE');
        })
        ->count();
        $clientes = DB::table("clientes as c")
        ->where("c.estado_del", 0)
        ->select([
            "c.nombres",
            "c.identificacion",
            "c.correo",
            "c.direccion",
            "c.celular",
            "c.created_at as fecha",
        ])->count();

        $usuarios = User::with([
            'localesusuario' => function($query) {
                $query->select('id', 'idusuario', 'idlocal', 'estado_del')
                    ->where('estado_del', 0);
            },
            'usuariotipousuario' => function($query) {
                $query->select('id', 'idusuario', 'idtipousuario', 'estado')
                    ->where('estado', 0);
            }
        ])
        ->where('estado_del', 0)
        ->where('estado_user',0)
        ->select('id', 'name', 'email', 'celular', 'identificacion','created_at')
        ->count();
        return view('reportes.index_varios',compact('clientes','usuarios','tecnicos'));
    }

    public function clientes(){
        $clientes = DB::table("clientes as c")
        ->where("c.estado_del", 0)
        ->select([
            "c.nombres",
            "c.identificacion",
            "c.correo",
            "c.direccion",
            "c.celular",
            "c.created_at as fecha",
        ])->get();
        $clientes = json_decode($clientes, true);
        $pdf = PDF::loadView('reportes.clientes_pdf', compact('clientes'));
        return $pdf->download('Clientes '.date('d-m-Y').'.pdf');
    }

    public function tecnicos(){
        $tecnicos = User::with([
            'localesusuario' => function($query) {
                $query->select('id', 'idusuario', 'idlocal', 'estado_del')
                    ->where('estado_del', 0);
            },
            'usuariotipousuario' => function($query) {
                $query->select('id', 'idusuario', 'idtipousuario', 'estado')
                    ->where('estado', 0);
            }
        ])
        ->where('estado_del', 0)
        ->where('estado_user', 0)
        ->whereHas('usuariotipousuario.tipousuario', function($query) {
            $query->where('codigo', 'TE');
        })
        ->select('id', 'name', 'email', 'celular', 'identificacion','created_at')
        ->get();
    
        $pdf = PDF::loadView('reportes.tecnicos_pdf', compact('tecnicos'));
        return $pdf->download('Tecnicos '.date('d-m-Y').'.pdf');
    }

    public function usuarios(){
        $usuarios = User::with([
            'localesusuario' => function($query) {
                $query->select('id', 'idusuario', 'idlocal', 'estado_del')
                    ->where('estado_del', 0);
            },
            'usuariotipousuario' => function($query) {
                $query->select('id', 'idusuario', 'idtipousuario', 'estado')
                    ->where('estado', 0);
            }
        ])
        ->where('estado_del', 0)
        ->where('estado_user',0)
        ->select('id', 'name', 'email', 'celular', 'identificacion','created_at')
        ->get();
        $pdf = PDF::loadView('reportes.usuarios_pdf', compact('usuarios'))->setPaper("A4", "landscape");;
        return $pdf->download('Usuarios '.date('d-m-Y').'.pdf');
    }

    public function orden_historial($id){
        $id=decrypt($id);
        $orden=OrdenModel::where('estado_del',0)->where('id',$id)->first();
        $pdf = PDF::loadView('reportes.orden_historial_pdf', compact('orden'));
        return $pdf->stream($orden['codigo'].'.pdf');
    }


    public function clientes_excel(Request $request){

        $clientes = DB::table("clientes as c")
        ->where("c.estado_del", 0)
        ->select([
            "c.nombres",
            "c.identificacion",
            "c.correo",
            "c.direccion",
            "c.celular",
            "c.created_at as fecha",
        ])->get();
        $clientes = json_decode($clientes, true);

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle(date('d-m-Y'));
        // Definir el rango de encabezados
        $headerRange = 'A1:F1';

        // Aplicar negrita a los encabezados
        $sheet->getStyle($headerRange)->getFont()->setBold(true);

        // Aplicar color de fondo azul
        $sheet->getStyle($headerRange)->getFill()->setFillType(Fill::FILL_SOLID)
            ->getStartColor()->setARGB('FF0070C0'); // Azul

        // Aplicar color blanco al texto para contraste
        $sheet->getStyle($headerRange)->getFont()->getColor()->setARGB('FFFFFFFF');
        // Encabezados
        $sheet->setCellValue('A1', 'Identificación');
        $sheet->setCellValue('B1', 'Nombres');
        $sheet->setCellValue('C1', 'Celular');
        $sheet->setCellValue('D1', 'Dirección');
        $sheet->setCellValue('E1', 'Correo');
        $sheet->setCellValue('F1', 'Creado');
        // Llenar datos
        $row = 2;
        foreach ($clientes as $value) {
            $sheet->setCellValue('A' . $row, $value['identificacion']);
            $sheet->setCellValue('B' . $row, $value['nombres']);
            $sheet->setCellValue('C' . $row, $value['celular']);
            $sheet->setCellValue('D' . $row, $value['direccion']);
            $sheet->setCellValue('E' . $row, $value['correo']);
            $sheet->setCellValue('F' . $row, $value['fecha']);
            $row++;
        }
       // Definir el rango de datos (desde A1 hasta la última fila)
        $lastRow = $sheet->getHighestRow(); // Obtiene la última fila con datos
        $lastColumn = $sheet->getHighestColumn(); // Obtiene la última columna con datos
        $dataRange = 'A1:' . $lastColumn . $lastRow;

        $sheet->setAutoFilter('A1:F1');
        // Aplicar autoajuste a todas las columnas con datos
        foreach (range('A', $lastColumn) as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }
        // Aplicar bordes a todo el rango
        $sheet->getStyle($dataRange)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
        // Configurar la descarga
        $fileName = "Clientes_" . date('d-m-Y'). ".xlsx";
        $writer = new Xlsx($spreadsheet);

        $response = new StreamedResponse(function () use ($writer) {
            $writer->save('php://output');
        });

        $response->headers->set('Content-Type', 'application/vnd.ms-excel');
        $response->headers->set('Content-Disposition', 'attachment;filename="' . $fileName . '"');
        $response->headers->set('Cache-Control', 'max-age=0');

        return $response;

    }

    public function tecnicos_excel(Request $request){

        $tecnicos = User::with([
            'localesusuario' => function($query) {
                $query->select('id', 'idusuario', 'idlocal', 'estado_del')
                    ->where('estado_del', 0);
            },
            'usuariotipousuario' => function($query) {
                $query->select('id', 'idusuario', 'idtipousuario', 'estado')
                    ->where('estado', 0);
            }
        ])
        ->where('estado_del', 0)
        ->where('estado_user', 0)
        ->whereHas('usuariotipousuario.tipousuario', function($query) {
            $query->where('codigo', 'TE');
        })
        ->select('id', 'name', 'email', 'celular', 'identificacion','created_at')
        ->get();
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle(date('d-m-Y'));
        // Definir el rango de encabezados
        $headerRange = 'A1:F1';

        // Aplicar negrita a los encabezados
        $sheet->getStyle($headerRange)->getFont()->setBold(true);

        // Aplicar color de fondo azul
        $sheet->getStyle($headerRange)->getFill()->setFillType(Fill::FILL_SOLID)
            ->getStartColor()->setARGB('FF0070C0'); // Azul

        // Aplicar color blanco al texto para contraste
        $sheet->getStyle($headerRange)->getFont()->getColor()->setARGB('FFFFFFFF');
        // Encabezados
        $sheet->setCellValue('A1', 'Identificación');
        $sheet->setCellValue('B1', 'Nombres');
        $sheet->setCellValue('C1', 'Celular');
        $sheet->setCellValue('D1', 'Correo');
        $sheet->setCellValue('E1', 'Local');
        $sheet->setCellValue('F1', 'Creado');
        // Llenar datos
        $row = 2;
        foreach ($tecnicos as $value) {
            $locales='';
            $localesArray = [];
            foreach ($value['localesusuario'] as $value2) {
                $localesArray[] = $value2['local']['descripcion'] . '-' . $value2['local']['direccion'];
            }

            $locales = implode(',', $localesArray);
            $sheet->setCellValue('A' . $row, $value['identificacion']);
            $sheet->setCellValue('B' . $row, $value['name']);
            $sheet->setCellValue('C' . $row, $value['celular']);
            $sheet->setCellValue('D' . $row, $value['email']);
            $sheet->setCellValue('E' . $row, $locales);
            $sheet->setCellValue('F' . $row, $value['created_at']);
            $row++;
        }
       // Definir el rango de datos (desde A1 hasta la última fila)
        $lastRow = $sheet->getHighestRow(); // Obtiene la última fila con datos
        $lastColumn = $sheet->getHighestColumn(); // Obtiene la última columna con datos
        $dataRange = 'A1:' . $lastColumn . $lastRow;

        $sheet->setAutoFilter('A1:F1');
        // Aplicar autoajuste a todas las columnas con datos
        foreach (range('A', $lastColumn) as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }
        // Aplicar bordes a todo el rango
        $sheet->getStyle($dataRange)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
        // Configurar la descarga
        $fileName = "Tecnicos_" . date('d-m-Y'). ".xlsx";
        $writer = new Xlsx($spreadsheet);

        $response = new StreamedResponse(function () use ($writer) {
            $writer->save('php://output');
        });

        $response->headers->set('Content-Type', 'application/vnd.ms-excel');
        $response->headers->set('Content-Disposition', 'attachment;filename="' . $fileName . '"');
        $response->headers->set('Cache-Control', 'max-age=0');

        return $response;

    }

    public function usuarios_excel(Request $request){

        $usuarios = User::with([
            'localesusuario' => function($query) {
                $query->select('id', 'idusuario', 'idlocal', 'estado_del')
                    ->where('estado_del', 0);
            },
            'usuariotipousuario' => function($query) {
                $query->select('id', 'idusuario', 'idtipousuario', 'estado')
                    ->where('estado', 0);
            }
        ])
        ->where('estado_del', 0)
        ->where('estado_user',0)
        ->select('id', 'name', 'email', 'celular', 'identificacion','created_at')
        ->get();
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle(date('d-m-Y'));
        // Definir el rango de encabezados
        $headerRange = 'A1:G1';

        // Aplicar negrita a los encabezados
        $sheet->getStyle($headerRange)->getFont()->setBold(true);

        // Aplicar color de fondo azul
        $sheet->getStyle($headerRange)->getFill()->setFillType(Fill::FILL_SOLID)
            ->getStartColor()->setARGB('FF0070C0'); // Azul

        // Aplicar color blanco al texto para contraste
        $sheet->getStyle($headerRange)->getFont()->getColor()->setARGB('FFFFFFFF');
        // Encabezados
        $sheet->setCellValue('A1', 'Identificación');
        $sheet->setCellValue('B1', 'Nombres');
        $sheet->setCellValue('C1', 'Celular');
        $sheet->setCellValue('D1', 'Correo');
        $sheet->setCellValue('E1', 'Rol');
        $sheet->setCellValue('F1', 'Local');
        $sheet->setCellValue('G1', 'Creado');

        // Llenar datos
        $row = 2;
        foreach ($usuarios as $value) {
            $locales='';
            $localesArray = [];
            foreach ($value['localesusuario'] as $value2) {
                $localesArray[] = $value2['local']['descripcion'] . '-' . $value2['local']['direccion'];
            }

            $locales = implode(',', $localesArray);

            $sheet->setCellValue('A' . $row, $value['identificacion']);
            $sheet->setCellValue('B' . $row, $value['name']);
            $sheet->setCellValue('C' . $row, $value['celular']);
            $sheet->setCellValue('D' . $row, $value['email']);
            $sheet->setCellValue('E' . $row, $value['usuariotipousuario'][0]['tipousuariotodos']['descripcion']);
            $sheet->setCellValue('F' . $row, $locales);
            $sheet->setCellValue('G' . $row, $value['created_at']);
            $row++;
        }
       // Definir el rango de datos (desde A1 hasta la última fila)
        $lastRow = $sheet->getHighestRow(); // Obtiene la última fila con datos
        $lastColumn = $sheet->getHighestColumn(); // Obtiene la última columna con datos
        $dataRange = 'A1:' . $lastColumn . $lastRow;

        $sheet->setAutoFilter('A1:G1');
        // Aplicar autoajuste a todas las columnas con datos
        foreach (range('A', $lastColumn) as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }
        // Aplicar bordes a todo el rango
        $sheet->getStyle($dataRange)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
        // Configurar la descarga
        $fileName = "Usuarios_" . date('d-m-Y'). ".xlsx";
        $writer = new Xlsx($spreadsheet);

        $response = new StreamedResponse(function () use ($writer) {
            $writer->save('php://output');
        });

        $response->headers->set('Content-Type', 'application/vnd.ms-excel');
        $response->headers->set('Content-Disposition', 'attachment;filename="' . $fileName . '"');
        $response->headers->set('Cache-Control', 'max-age=0');

        return $response;

    }



    
}
