<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\OrdenModel;
use DB;
use Carbon\Carbon;
class HomeController extends Controller
{
    public function index(){
        $usuario=auth()->user();
        $idusuario=$usuario->id;
        $tipousuario=tipousuario($idusuario);
        if($tipousuario=='AD'){

            $ordenes_total=DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->get()->count();

            $ordenes_sinasignar=DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.estado_orden",'I')
            ->get()->count();

            $ordenes_asignadas=DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.estado_orden",'A')
            ->get()->count();

            $ordenes_atendidas=DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.estado_orden",'T')
            ->get()->count();

            $ordenes_entregadas=DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.estado_orden",'F')
            ->get()->count();

            $ordenes_anuladas=DB::table("ordenes as o")
            ->where("o.estado_del", 0)
            ->where("o.estado_orden",'D')
            ->get()->count();

            $administradores = DB::table("tipo_usuario as tu")
            ->leftJoin("usuario_tipousuario as ut", "ut.idtipousuario", "=", "tu.id")
            ->leftJoin("users as u", "ut.idusuario", "=", "u.id")
            ->where("tu.codigo",'AD')
            ->groupBy("tu.codigo")
            ->count();

            $tecnicos = DB::table("tipo_usuario as tu")
            ->leftJoin("usuario_tipousuario as ut", "ut.idtipousuario", "=", "tu.id")
            ->leftJoin("users as u", "ut.idusuario", "=", "u.id")
            ->where("tu.codigo",'TE')
            ->groupBy("tu.codigo")
            ->count();

            $estandar = DB::table("tipo_usuario as tu")
            ->leftJoin("usuario_tipousuario as ut", "ut.idtipousuario", "=", "tu.id")
            ->leftJoin("users as u", "ut.idusuario", "=", "u.id")
            ->where("tu.codigo",'ES')
            ->where("u.estado_del",0)
            ->where("u.estado_user",0)
            ->groupBy("tu.codigo")
            ->count();

            $clientes = DB::table("clientes as c")
            ->where("c.estado_del",0)
            ->count();

            $costos_totales = [];

            for ($i = 5; $i >= 0; $i--) {
                $mes = Carbon::now()->subMonths($i); // Obtener el mes correspondiente
            
                $costo_total = DB::table("ordenes_atencion as oa")
                    ->join("ordenes as o", "oa.idorden", "=", "o.id") // Unir con la tabla ordenes
                    ->where("oa.tipo_orden", "r") // Filtrar por tipo_orden 'r'
                    ->where("o.estado_orden", "F") // Filtrar por estado_orden 'F'
                    ->whereYear("o.fecha", $mes->year) // Filtrar por año
                    ->whereMonth("o.fecha", $mes->month) // Filtrar por mes
                    ->sum("oa.costo_total"); // Sumar el costo total del mes
            
                $costos_totales[] = $costo_total; // Agregar al array
            }
            $data=['total'=>$ordenes_total,
            'sinasignar'=>$ordenes_sinasignar,
            'asignadas'=>$ordenes_asignadas,
            'atendidas'=>$ordenes_atendidas,
            'entregadas'=>$ordenes_entregadas,
            'anuladas'=>$ordenes_anuladas,
            'administrador'=>$administradores,
            'estandar'=>$estandar,
            'tecnico'=>$tecnicos,
            'clientes'=>$clientes,
            'ventas'=>$costos_totales,

            ];
            return view('welcomes')->with(['datos_admin'=>$data]);
        } else{
            return view('welcomes');
        }
    }
}
