<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class ValidarRuta
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if(auth()->user()['tipo']!='AD'){
            if (!session()->has('id_local')) {
                return redirect('/local');
            }
        }
            
        // dd('hola');
        if(auth()->guest()){ // si no hay usuarios logueados
            goto ACCEDER;
        }
        $usuario=auth()->user();
        $idusuario=$usuario->id;
        if($usuario['estado_user']==1){
            auth()->logout();
            return redirect('/login')->with(['status'=>'error','mensaje_info' => 'USUARIO SE ENCUENTRA BLOQUEADO']);
        }
        $tipousuario=tipousuario($idusuario);
        if($tipousuario=='AD'){goto ACCEDER;} 
        
        if($tipousuario!='AD'){
            $rutaLlamada = \Request::route()->uri; 
            $metodo = $_SERVER['REQUEST_METHOD'];

            if($metodo!="GET" && $metodo!="get" && $metodo!="Get"){ goto ACCEDER; }
    
            //solo hacemos la validación para las rutas que esten registradas en la tabla "gestion"
            $rutaregistrada = \App\Models\Configuracion\MenuOpcionModel::where('ruta', $rutaLlamada)->first();
            if(is_null($rutaregistrada)){ goto ACCEDER; } //verificar para que no pueda acceder nadie
            if($rutaregistrada['global']==1){ goto ACCEDER; } 
           
            // dd($rutaregistrada);
            //validación de la ruta llamada
            $rutaAsignada = \App\Models\Configuracion\UsuarioOpcionModel::with('menu_opcion')
                ->whereHas('menu_opcion', function($query_gestion) use($rutaLlamada){ 
                    $query_gestion->where('ruta', $rutaLlamada); 
                })
                ->where('user_id',$idusuario)
                ->first();
            if(!is_null($rutaAsignada)){
                goto ACCEDER;
            }
        }else{
            goto  NOACCEDER;
        }
    
        NOACCEDER:
        return redirect('/');

        ACCEDER:
        return $next($request);
    }
}
