<?php

namespace App\Models\Configuracion;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class MenuOpcionModel extends Model implements Auditable
{
    use HasFactory;
    use \OwenIt\Auditing\Auditable;
    protected $table = 'menu_opcion';
    protected $primaryKey  = 'id';
    public $timestamps = false;

    protected $appends = ['idencrypt'];
    public function getIdEncryptAttribute()
    {
        return encrypt($this->attributes['id']);
    }

    public function menu(){
        return $this->belongsTo("App\Models\Configuracion\MenuModel", "menu_id", "id");
    }

    public function usuario_opcion(){
        return $this->hasMany("App\Models\Configuracion\UsuarioOpcionModel", "menu_opcion_id", "id");
    }

}
