<?php

namespace App\Models\Configuracion;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
class UsuarioOpcionModel extends Model implements Auditable
{
    use HasFactory;
    use \OwenIt\Auditing\Auditable;
    protected $table = 'usuario_opcion';
    protected $primaryKey  = 'id';
    public $timestamps = false;

    protected $appends = ['idencrypt'];
    public function getIdEncryptAttribute()
    {
        return encrypt($this->attributes['id']);
    }

    public function menu_opcion(){
        return $this->belongsTo('App\Models\Configuracion\MenuOpcionModel', 'menu_opcion_id', 'id');
    }

}
