<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrdenAccesoriosModel extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    
    protected $table = 'ordenes_accesorios';
    protected $primaryKey  = 'id';
    public $timestamps = true;
    protected $appends = ['id_encrypt'];

    public function getIdEncryptAttribute()
    {
        return encrypt($this->attributes['id']);
    }

    public function accesorios(){
        return $this->belongsTo('App\Models\AccesoriosModel', 'idaccesorios', 'id');
    }
}
