<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrdenAtencionModel extends Model implements Auditable
{
    use HasFactory;
    use \OwenIt\Auditing\Auditable;
    protected $table = 'ordenes_atencion';
    protected $primaryKey  = 'id';
    public $timestamps = true;
    protected $appends = ['id_encrypt'];

    public function getIdEncryptAttribute()
    {
        return encrypt($this->attributes['id']);
    }

    public function useratiende(){
        return $this->belongsTo('App\Models\User', 'user_atiende', 'id')->select('id','name','identificacion');
    }

    public function orden(){
        return $this->belongsTo('App\Models\OrdenModel', 'idorden', 'id');
    }

 
}
