<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrdenImagenesModel extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    
    protected $table = 'ordenes_imagenes';
    protected $primaryKey  = 'id';
    public $timestamps = true;
    protected $appends = ['id_encrypt'];

    public function getIdEncryptAttribute()
    {
        return encrypt($this->attributes['id']);
    }


}
