<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrdenIncidenciasModel extends Model implements Auditable
{
    use HasFactory;
    use \OwenIt\Auditing\Auditable;
    protected $table = 'ordenes_incidencias';
    protected $primaryKey  = 'id';
    public $timestamps = true;
    protected $appends = ['id_encrypt'];

    public function userregistra(){
        return $this->belongsTo('App\Models\User', 'user_registra', 'id');
    }
}
