<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrdenModel extends Model implements Auditable
{
    use HasFactory;
    use \OwenIt\Auditing\Auditable;
    protected $table = 'ordenes';
    protected $primaryKey  = 'id';
    public $timestamps = true;
    protected $appends = ['id_encrypt', 'statusconfirmado'];

    public function getIdEncryptAttribute()
    {
        return encrypt($this->attributes['id']);
    }

    public function local(){
        return $this->belongsTo('App\Models\Parametrizacion\LocalModel', 'idlocal', 'id');
    }
    public function cliente(){
        return $this->belongsTo('App\Models\ClienteModel', 'idcliente', 'id');
    }
    public function userregistra(){
        return $this->belongsTo('App\Models\User', 'user_registra', 'id');
    }

    public function userasigna(){
        return $this->belongsTo('App\Models\User', 'user_asigna', 'id');
    }
    public function ordenaccesorios(){
        return $this->hasMany('App\Models\OrdenAccesoriosModel', 'idorden', 'id');
    }
    public function tecnico(){
        return $this->belongsTo('App\Models\User', 'idusuario_tecnico', 'id');
    }

    public function diagnostico(){
        return $this->hasMany('App\Models\OrdenAtencionModel', 'idorden', 'id');
    }

    public function incidencias(){
        return $this->hasMany('App\Models\OrdenIncidenciasModel', 'idorden', 'id');
    }

    public function imagenes_inicio(){
        return $this->hasMany('App\Models\OrdenImagenesModel', 'idorden', 'id')->where('nivel_orden','I');
    }

    public function imagenes_atencion(){
        return $this->hasMany('App\Models\OrdenImagenesModel', 'idorden', 'id')->where('nivel_orden','A');
    }
    public function imagenes_entrega(){
        return $this->hasMany('App\Models\OrdenImagenesModel', 'idorden', 'id')->where('nivel_orden','T');
    }
    public function userentrega(){
        return $this->belongsTo('App\Models\User', 'user_entrega', 'id');
    }
    public function useranula(){
        return $this->belongsTo('App\Models\User', 'user_anula', 'id');
    }

    public function getStatusConfirmadoAttribute()
    {
        if ($this->attributes['status_confirmado'] == '1') {
            if ($this->attributes['confirmar'] == 'N') {
            return '<span style="color:green;font-weight:bold;">Reparación Aceptada</span>';
            } else {
            return '<span style="color:red;font-weight:bold;">No acepta reparación</span>';
            }
        }
        return '';
    }
        
}
