<?php

namespace App\Models\Parametrizacion\Usuario;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Usuario_tipousuarioModel extends Model
{
    use HasFactory;
    protected $table = 'usuario_tipousuario';
    protected $primaryKey  = 'id';
    public $timestamps = true;
    protected $appends = ['id_encrypt'];

    public function getIdEncryptAttribute()
    {
        return encrypt($this->attributes['id']);
    }

    public function tipousuario(){
        return $this->belongsTo('App\Models\Parametrizacion\Usuario\TipoUsuarioModel', 'idtipousuario', 'id');
    }
    public function tipousuariotodos(){
        return $this->belongsTo('App\Models\Parametrizacion\Usuario\TipoUsuarioModel', 'idtipousuario', 'id');
    }
    public function usuario(){
        return $this->belongsTo('App\Models\User', 'idusuario', 'id')->where('estado_user',0);
    }
}