<?php

namespace App\Models\Parametrizacion;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UsuarioLocalModel extends Model implements Auditable
{
    use HasFactory;
    use \OwenIt\Auditing\Auditable;
    protected $table = 'usuario_local';
    protected $primaryKey  = 'id';
    public $timestamps = true;
    protected $appends = ['id_encrypt'];
    public function getIdEncryptAttribute()
    {
        return encrypt($this->attributes['id']);
    }

    public function local(){
        return $this->belongsTo('App\Models\Parametrizacion\LocalModel', 'idlocal', 'id');
    }
}
