<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected $appends = ['tipo','id_encrypt','identificacion_encrypt'];
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function getIdEncryptAttribute()
    {
        return encrypt($this->attributes['id']);
    }
    public function getIdentificacionEncryptAttribute()
    {
        return encrypt($this->attributes['identificacion']);
    }
    public function getTipoAttribute(){
        return tipousuario($this->attributes['id']);
    }
    public function usuariotipousuario(){
        return $this->hasMany('App\Models\Parametrizacion\Usuario\Usuario_tipousuarioModel', 'idusuario', 'id')->with('tipousuariotodos');
    }

    public function localesusuario(){
        return $this->hasMany('App\Models\Parametrizacion\UsuarioLocalModel', 'idusuario', 'id')->with('local')->where('estado_del',0);
    }
}
