$(document).ready(function(){
    cargar_registros();
});

function cargar_registros(){

    cargando('m','Por favor espere...');
    $.get('/parametrizacion/accesorios/lista',function(data){
        if(data['status']=='error'){
            mensaje_notificacion(data['response'], data['status']);
            cargando();
            return;
        }
        $("#table_accesorios").DataTable().destroy();
        $("#table_accesorios tbody").empty();

        $.each(data['response'],function(i,item){
            $("#body_accesorios").append(`        
                <tr>
                    <td>${item['descripcion']}
                     </td>
                    <td align='center'>
                        <button data-toggle="tooltip" data-placement="right" title="Editar" class="btn btn-warning btn-sm" onclick="edit('${item['id_encrypt']}')">
                            <i class="fa fa-edit"></i> Editar
                        </button>
                        <button data-toggle="tooltip" data-placement="right" title="Eliminar accesorio" class="btn btn-danger btn-sm" onclick="eliminar('${item['id_encrypt']}')">
                            <i class="fa fa-times"></i> Eliminar
                        </button>
                    </td>
                </tr>
            `);

        });
        cargando(); 

        $('[data-toggle="tooltip"]').tooltip(); 
        cargar_estilos_tabla("table_accesorios", "asc");
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al cargar los accesorios','error');
        cargando();
    });

}



$('#form_accesorio').submit(function(e){
    e.preventDefault();
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/parametrizacion/accesorios/store',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }else{
                mensaje_notificacion(data['response'], data['status']);
                cargar_registros();
                cancelar();
            }
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

function edit($id){

    cargando('m','Por favor espere...');
    $.get('/parametrizacion/accesorios/edit/'+$id,function(data){
        if(data['status']=='error'){
            mensaje_notificacion(data['response'],data['status']);
            cargando(); return;
        }
        $('#descripcion').val(data['response']['descripcion'])
        $('#idedit').val(data['response']['id_encrypt']);
     
        $('#btn_footer').html(`
            <button type="submit" class="btn btn-color"> <i class="fa fa-save"></i> Actualizar</button>
            <button type="button" onclick="cancelar()" class="btn btn-danger"> <i class="fa fa-times"></i> Cancelar</button>
        `);
        cargando();

    }).fail(function(){
        mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente','error');
        cargando();
    });
}


function eliminar(id) {
    swal({
        title: "",
        text: "¿Esta seguro que desea eliminar el accesorio ?",
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: "btn-info",
        confirmButtonText: "Si",
        cancelButtonText: "No",
        closeOnConfirm: false,
        closeOnCancel: false
    },
    function(isConfirm) {
        if (isConfirm) { 
            cargando("M", "Eliminando accesorio...");
            $.get('/parametrizacion/accesorios/delete/'+id,function(data){
                if(data['status']=='error'){
                    mensaje_notificacion(data['response'],data['status']);
                    cargando();
                    return;
                }
                mensaje_notificacion(data['response'],'success');
                cargar_registros();
            }).fail(function(){
                mensaje_notificacion('Inconvenientes al procesar solicitud','error');
                cargando();
            });
        }
        sweetAlert.close();   
    }); 
}


function cancelar(){
    $('#idedit').val('');
    $('#descripcion').val('');
    $('#btn_footer').html(`<button type="submit" class="btn btn-color"> <i class="fa fa-save"></i> Registrar</button>`);
}



