
function modal_menu(){
    $("#modal_menu").modal("show");
    limpiar_menu();
}

$("#form_menu").submit(function (e) { 
    e.preventDefault();
    cargando('m','Por favor espere...');

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/parametrizacion/store',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            cargando();
            if(data['status']=='error' || data['status']=='warning'){
                mensaje_notificacion(data['response'], data['status']);
                return;
            }else{
                cargar_tabla_menu();
                limpiar_menu();
                $("#modal_menu").modal("hide");
                mensaje_notificacion(data['response'], data['status']);
            }
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });

});

function editar_menu(idmenu){

    cargando('m','Por favor espere...');
    $.get('/parametrizacion/edit/'+idmenu,function(resultado){
        cargando();
        $("#idmenu").val(resultado.response.idencrypt);
        $("#menu_detalle").val(resultado.response.detalle);
        $("#menu_icono").val(resultado.response.icono);
        $("#menu_orden").val(resultado.response.orden);
        $("#modal_menu").modal("show");
    });

}


function eliminar_menu(idmenu){

    texto = "¿Esta seguro que desea eliminar el menu? las opciones tambien se eliminaran";
    class_bnt = "btn-danger";
    ruta = "/parametrizacion/delete";

    swal({
        title: "",
        text: texto,
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: class_bnt,
        confirmButtonText: "Si",
        cancelButtonText: "No",
        closeOnConfirm: false,
        closeOnCancel: false
    },
    function(isConfirm) {
        if (isConfirm) { 
            cargando("M", "Eliminando...");
            $.get(ruta+'/'+idmenu,function(data){

                cargando();
                mensaje_notificacion(data['response'],data['status']);
                cargar_tabla_menu();
              
            }).fail(function(){
                mensaje_notificacion('Inconvenientes al procesar solicitud','error');
                cargando();
            });
        }
        sweetAlert.close();   // ocultamos la ventana de pregunta
    }); 

}

function limpiar_menu(){
    $("#idmenu").val("");
    $("#menu_detalle").val("");
    $("#menu_icono").val("");
    $("#menu_orden").val("");
}

function cargar_tabla_menu(){

    cargando('m','Por favor espere...');
    $.get('/parametrizacion/get-tabla',function(resultado){
       
        cargando();
        if(resultado.status){
            mensaje_notificacion(resultado['response'], resultado['status']);
        }else{
            $("#body_menu").html(resultado);
        }
        
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al cargar los usuarios','error');
        cargando();
    });

}


// =============================================================================================
// ======================== FUNCIONES PARA GETIO DE LOS MENU OPCIONES ==========================
// =============================================================================================


function modal_menu_opcion(idmenu, menu_detalle){

    $("#modal_menu_opcion").modal("show");
    limpiar_menu_opcion();

    $("#menu_id").val(idmenu);
    $("#menu_text").val(menu_detalle);

}

$("#form_menu_opcion").submit(function (e) { 
    e.preventDefault();
    cargando('m','Por favor espere...');

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/parametrizacion/opcion/store',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            cargando();
            if(data['status']=='error' || data['status']=='warning'){
                mensaje_notificacion(data['response'], data['status']);
                return;
            }else{
                cargar_tabla_menu();
                limpiar_menu_opcion();
                $("#modal_menu_opcion").modal("hide");
                mensaje_notificacion(data['response'], data['status']);
            }
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });

});

function editar_opcion(idopcion){

    cargando('m','Por favor espere...');
    $.get('/parametrizacion/opcion/edit/'+idopcion,function(resultado){
        cargando();
        opcion = resultado.response;

        $("#idmenu_opcion").val(opcion.idencrypt);
        $("#menu_id").val(opcion.menu.idencrypt);
        $("#menu_text").val(opcion.menu.detalle);

        $("#opcion_detalle").val(opcion.detalle);
        $("#opcion_icono").val(opcion.icono);
        $("#opcion_ruta").val(opcion.ruta);
        $("#opcion_orden").val(opcion.orden);

        $("#modal_menu_opcion").modal("show");
    });

}

function eliminar_opcion(idopcion){

    texto = "¿Esta seguro que desea eliminar la opcion?";
    class_bnt = "btn-danger";
    ruta = "/parametrizacion/opcion/delete";

    swal({
        title: "",
        text: texto,
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: class_bnt,
        confirmButtonText: "Si",
        cancelButtonText: "No",
        closeOnConfirm: false,
        closeOnCancel: false
    },
    function(isConfirm) {
        if (isConfirm) { 
            cargando("M", "Eliminando...");
            $.get(ruta+'/'+idopcion,function(data){

                cargando();
                mensaje_notificacion(data['response'],data['status']);
                cargar_tabla_menu();
              
            }).fail(function(){
                mensaje_notificacion('Inconvenientes al procesar solicitud','error');
                cargando();
            });
        }
        sweetAlert.close();   // ocultamos la ventana de pregunta
    }); 

}

function limpiar_menu_opcion(){

    $("#idmenu_opcion").val("");
    $("#menu_id").val("");
    
    $("#menu_text").val("");
    $("#opcion_detalle").val("");
    $("#opcion_icono").val("");
    $("#opcion_ruta").val("");
    $("#opcion_orden").val("");
}