function cargar_usuarios(){

    cargando('m','Por favor espere...');
    $.get('/parametrizacion/usuario/lista',function(resultado){
        cargando(); 
        $("#table_usuarios").DataTable().destroy();
        $("#table_usuarios tbody").empty();

        $.each(resultado['response'],function(i,usuario){
            html_estado = `<span class="text-success"><center><b>Activo</b></center></span>`;
            html_boton_bd = (`<button class="btn btn-danger btn-sm" onclick="bloquear_desbloquear('${usuario['id_encrypt']}')"> <i class="fa fa-user"></i> <i class="fa fa-ban"></i> </button>`);

            if(usuario.estado_user == 1){
                html_estado = `<span class="text-danger"><b><center>Bloqueado</center></b></span>`;
                html_boton_bd = (`<button class="btn btn-success btn-sm" onclick="bloquear_desbloquear('${usuario['id_encrypt']}',1)"> <i class="fa fa-user"></i> <i class="fa fa-refresh"></i> </button>`);
            }
            var tipos='';
            var locales='';
            $.each(usuario['usuariotipousuario'],function(i,itemtipos){
                if(itemtipos['tipousuariotodos']['codigo']!='FP'){
                    tipos=tipos+` <small style="color:orange"><b>${itemtipos['tipousuariotodos']['descripcion']}</b></small>`;
                }
            });
            $.each(usuario['localesusuario'],function(i,itemlocales){
                locales=locales+` <small style="color:black"><li>${itemlocales['local']['descripcion']} - ${itemlocales['local']['direccion']}</li></small>`;
            });
            $("#body_usuarios").append(`        
                <tr>
                    <td>${usuario.identificacion}
                     </td>
                    <td>${usuario.name}
                    <br> ${tipos}</td>
                    <td><small><b><i class='fa fa-envelope'></i> </b>${usuario.email}<br>
                        <b><i  class='fa fa-phone'></i>  </b>${usuario.celular} 
                        </small>
                    </td>
                    <td>${locales}</td>
                    <td>${html_estado}</td>
                    <td>
                        <button data-toggle="tooltip" data-placement="right" title="Editar" class="btn btn-primary btn-sm" onclick="edit('${usuario.id_encrypt}')">
                            <i class="fa fa-user"></i>
                            <i class="fa fa-edit"></i>
                        </button>
                        <button data-toggle="tooltip" data-placement="right" title="Agregar opciones" class="btn btn-success btn-sm" onclick="gestion_opcion('${usuario.id_encrypt}')">
                            <i class="fa fa fa-bars"></i>
                            <i class="fa fa-check-square"></i>
                        </button>
                        <button data-toggle="tooltip" data-placement="right" title="Resetear clave al número de cédula" class="btn btn-warning btn-sm" onclick="resetearclave('${usuario.id_encrypt}')">
                            <i class="fa fa-refresh"></i>
                        </button>
                        ${html_boton_bd}
                    </td>
                </tr>
            `);

        });
        $('[data-toggle="tooltip"]').tooltip(); 
        cargar_estilos_tabla("table_usuarios", "desc");
        
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al cargar los usuarios','error');
        cargando();
    });

}

$(document).ready(function(){
    cargar_usuarios();
});

$('#form_usuario').submit(function(e){
    e.preventDefault();
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/parametrizacion/usuario/store',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error' || data['status']=='warning'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }else{
                mensaje_notificacion(data['response'], data['status']);
                cargar_usuarios();
                cancelar();
            }
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

function edit($id){

    cargando('m','Por favor espere...');
    $.get('/parametrizacion/usuario/edit/'+$id,function(data){
        console.log(data);
        if(data['status']=='error'){
            mensaje_notificacion(data['response'],data['status']);
            cargando(); return;
        }
        $('#cedula').val(data.response.identificacion)
        $('#nombres').val(data['response']['name'])
        $('#celular').val(data['response']['celular'])
        $('#correo').val(data['response']['email'])
        $('#idedit').val(data['response']['id_encrypt']);
        $(`#${data['response']['usuariotipousuario'][0]['tipousuariotodos']['codigo']}`).prop('checked', true);

        const opcionesSeleccionadas = [];
        $.each(data['response']['localesusuario'],function(i,item2){
            opcionesSeleccionadas.push(item2['idlocal']);
        });
        $('#local').val(opcionesSeleccionadas);
        $('#local').trigger('change');

        $('#btn_footer').html(`
            <button type="submit" class="btn btn-color"> <i class="fa fa-save"></i> Actualizar</button>
            <button type="button" onclick="cancelar()" class="btn btn-danger"> <i class="fa fa-times"></i> Cancelar</button>
        `);
        // $("#password").removeAttr("required");
        cargando();

    }).fail(function(){
        mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente','error');
        cargando();
    });
}

function bloquear_desbloquear(id, estado=0) {
    
    texto = "¿Esta seguro que desea bloquear el usuario? la información no se perderá";
    class_bnt = "btn-danger";
    ruta = "/parametrizacion/usuario/bloquear";
    if(estado!=0){ 
        texto = "¿Esta seguro que desea desbloquear el usuario?"; 
        class_bnt = "btn-success";
        ruta = "/parametrizacion/usuario/desbloquear";
    }

    swal({
        title: "",
        text: texto,
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: class_bnt,
        confirmButtonText: "Si",
        cancelButtonText: "No",
        closeOnConfirm: false,
        closeOnCancel: false
    },
    function(isConfirm) {
        if (isConfirm) { 
            if(estado!=0){ 
                cargando("M", "Desbloqueando usuario...");
            }else{
                cargando("M", "Bloqueando usuario...");
            }
            $.get(ruta+'/'+id+'/'+estado,function(data){

                mensaje_notificacion(data['response'],data['status']);
                cargar_usuarios();
                // cargando();
              
            }).fail(function(){
                mensaje_notificacion('Inconvenientes al procesar solicitud','error');
                cargando();
            });
        }
        sweetAlert.close();   // ocultamos la ventana de pregunta
    }); 
}

function resetearclave(id) {
    swal({
        title: "",
        text: "¿Esta seguro que desea resetear la clave del usuario al número de cédula ?",
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: "btn-info",
        confirmButtonText: "Si",
        cancelButtonText: "No",
        closeOnConfirm: false,
        closeOnCancel: false
    },
    function(isConfirm) {
        if (isConfirm) { 
            cargando("M", "Reseteando clave...");
            $.get('/parametrizacion/usuario/resetpassword/'+id,function(data){
                if(data['status']=='failed'){
                    mensaje_notificacion(data['response'],'error');
                    cargando();
                    return;
                }
                mensaje_notificacion(data['response'],'success');
                cargando();
            }).fail(function(){
                mensaje_notificacion('Inconvenientes al procesar solicitud','error');
                cargando();
            });
        }
        sweetAlert.close();   // ocultamos la ventana de pregunta
    }); 
}
$('#cedula').on('input', function() {
    this.value = this.value.replace(/[^0-9]/g,'');
 });

 $('#celular').on('input', function() {
    this.value = this.value.replace(/[^0-9]/g,'');
 });

function cancelar(){
    $('#idedit').val('');
    $('#cedula').val('');
    $('#nombres').val('');
    $('#correo').val('');
    $('#celular').val('');
    $('#ES').prop('checked', true);
    $('#btn_footer').html(`<button type="submit" class="btn btn-color"> <i class="fa fa-save"></i> Registrar</button>`);
    $('#local').val('');
    $('#local').trigger('change');
}

function gestion_opcion(usuario_id){

    cargando('m','Por favor espere...');
    $.get('/parametrizacion/usuario/opciones/'+usuario_id,function(resultado){
        cargando();

        if(resultado.status){
            mensaje_notificacion(resultado['response'], resultado['status']);
        }else{
            $("#tabla_opciones").html(resultado);
            $("#modal_gestion_opcion").modal("show");
        }
        
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente','error');
        cargando();
    });

}

function asignar_quitar_opcion(menu_opcion_id, usuario_id){

    cargando('m','Por favor espere...');
    $.get(`/parametrizacion/usuario/opciones/asignar_quitar/${menu_opcion_id}/${usuario_id}`,function(resultado){
    
        cargando();
        console.log(resultado);
        mensaje_notificacion(resultado['response'],resultado['status']);
    
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente','error');
        cargando();
    });

}


$('#local').on('select2:select', function() {
    var seleccion = $(this).val();
    console.log(seleccion);
    // Si se selecciona "todos", seleccionar todas las opciones
    if (seleccion && seleccion.includes('T')) {
        $('#local option').prop('selected', true);
        $('#local option[value="T"]').prop('selected', false);
        $('#local option[value="T"]').remove();

        $('#local').prepend('<option value="N">No seleccionar</option>');
        $('#local option[value=""]').prop('selected', false);

    } else {
        if (seleccion && seleccion.includes('N')) {
            $('#local option[value="N"]').remove();
            $('#local').val([]);
            $('#local').prepend('<option value="T">Seleccionar todos</option>');

        }
        // Si no se selecciona "todos", deseleccionar la opción "todos" si está seleccionada
        $('#local option[value="T"]').prop('selected', false);
    }
    $('#local').trigger('change');
});


