$(document).ready(function(){
   
    cargar_ordenes();
    
});

function cargar_ordenes(valor='T'){
    cargando('m','Por favor espere...');
    $.get('/orden/lista_incidencias_pendientes/'+valor,function(resultado){
        cargando(); 
        $("#table_ordenes").DataTable().destroy();
        $("#table_ordenes tbody").empty();
        
       
        $.each(resultado['response'],function(i,value){
            var btn_qr=``;
            if(resultado['isadmin']=='S'){
                local=`<td width='15%'>${value['local']} - ${value['dir_local']} <br> <small style='padding-left:10px'><b>${value['tecnico']}</b></small>
                </td>`;
            }else{
                local=``;
            }
            var orden_ingreso='';
            orden_ingreso=`<a target='_blank' href="/orden/reporte/${value['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Orden documento" class="btn btn-primary btn-sm">
                    <i class="fa fa-file"></i>
                    Orden
                </a>`;
            if(value['estado_orden']=='I'){
                estado=`<span class='badge badge-primary'><i class='fa fa-check'></i> Ingresado</span>`;
                
            }
            if(value['estado_orden']=='A'){
                estado=`<span class='badge badge-warning'><i class='fa fa-user'></i> Asignado</span>`;
                
            }
            if(value['estado_orden']=='F'){
                estado=`<span class='badge badge-success'><i class='fa fa-check-circle'></i> Entregado</span>`;
            }
            $("#body_ordenes").append(`        
                <tr>
                    ${local}
                    <td width='15%'>${value['fecha_recibe']} ${value['hora_recibe']}
                     </td>
                    <td width='5%'>${value['codigo']}
                     </td>
                    <td><small><b><i class='fa fa-user'></i> </b>${value['identificacion']}<br>
                        <b><i  class='fa fa-circle'></i>  </b>${value['nombres']}
                        </small>
                    </td>
                    <td align='center'>${estado}
                     <br><small>${value['status_confirmado_ad']}</small>
                     </td>
                    <td  align='center'>
                        <button data-toggle="tooltip" data-placement="right" title="Ver detalles" class="btn btn-info btn-sm" onclick="detalle_orden('${value['id_encrypt']}')">
                            <i class="fa fa-eye"></i>
                            Ver
                        </button>
                        ${orden_ingreso}
                        
                    </td>
                </tr>
            `);

        });
        $('[data-toggle="tooltip"]').tooltip(); 
        if(resultado['isadmin']=='S'){
            cargar_estilos_tabla("table_ordenes", "desc",2);
        }else{
            cargar_estilos_tabla("table_ordenes", "desc",1);

        }
        
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al cargar los usuarios','error');
        cargando();
    });

}

$('#local').on('change', function() {
    // Obtener el valor seleccionado
    var selectedValue = $(this).val();
    
    // Si se selecciona 'T', podrías hacer algo especial
    if (selectedValue == 'T') {
        cargar_ordenes();
    }else{
        cargar_ordenes(selectedValue);
    }

    
});


function detalle_orden(id){
    cargando('m','Cargando...');
    $('#div_patron').show();
    $.get('/orden/detalle/'+id,function(data){
        if(data['status']=='failed'){
            mensaje_notificacion(data['response'],'error');
            cargando();
            return;
        }
        $('#div_asignacion').html(``);
       
        $('#codigo_detalle').html(data['response']['codigo']);
        $('#fecha_detalle').html(`${data['response']['fecha_recibe']} ${data['response']['hora_recibe']}`);
        if(data['response']['estado_orden']=='I'){
            $('#btn_detalle').html(`<button onclick="modal_tecnicos('${data['response']['idlocal_encrypt']}','${data['response']['id_encrypt']}')" id="btn_tecnicos" type="button" class="btn btn-primary"> <i class="fa fa-user"></i> Asignar técnico </button>
            <button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>`);
            
            $('#estado_detalle').html(`<span class='badge badge-primary'><i class='fa fa-check'></i> Ingresada</span>`);
        }
        if(data['response']['estado_orden']=='A'){
            $('#btn_detalle').html(`<button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>
                <button onclick="modal_incidencia('${data['response']['id_encrypt']}')" id="btn_incidencia" type="button" class="btn btn-primary"> <i class="fa fa-bell"></i> Historial incidencias </button>`);
            $('#estado_detalle').html(`<span class='badge badge-warning'><i class='fa fa-circle'></i> Asignado</span>`);
            $('#div_asignacion').html(` <div class="col-md-5">
                <label >Fecha asignación:  </label> <i >${data['response']['fecha_asigna']}</i> 
            </div>
            <div class="col-md-7">
                <label >Técnico asignado:  </label> <i >${data['response']['tecnico']}</i> 
            </div>
           
            `);
        }
        if(data['response']['estado_orden']=='F'){
            $('#btn_detalle').html(`<button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>`);
            $('#estado_detalle').html(`<span class='badge badge-success'><i class='fa fa-check-circle'></i> Entregado</span>`);
        }
        if(data['response']['tipo_orden']=='d'){
            $('#tipod_detalle').html('Diagnóstico');
        }

        if(data['response']['tipo_orden']=='r'){
            $('#tipod_detalle').html('Reparación');
        }

        if(data['response']['tipo_garantia']=='NA'){
            $('#garantia_detalle').html('No aplica');
        }
        if(data['response']['tipo_garantia']=='co'){
            $('#garantia_detalle').html('Compra');
        }
        if(data['response']['tipo_garantia']=='st'){
            $('#garantia_detalle').html('Servicio técnico');
        }

     

        $('#cedula_detalle').html(data['response']['identificacion']);
        $('#nombres_detalle').html(data['response']['nombres']);
        $('#direccion_detalle').html(data['response']['direccion']);
        $('#celular_detalle').html(data['response']['celular']);
        $('#email_detalle').html(data['response']['correo']);
        $('#modelo_detalle').html(data['response']['modelo']);
        $('#imei_detalle').html(data['response']['imei']);
        $('#estadomovil_detalle').html(data['response']['estado_celular']);

        if(data['response']['estado_encendido']=='En'){
            $('#encendido_detalle').html('Si');
        }else{
            $('#encendido_detalle').html('No (No se puede probar periféricos)');
        }
        if(data['response']['tiene_clave']=='S'){
            if(data['response']['pin']==null || data['response']['pin']==''){
                $('#pin_detalle').html('Sin PIN');
            }else{
                $('#pin_detalle').html(data['response']['pin']);
            }
            $('#patron_detalle').html(`<img width='50%' src="${data['response']['patron']}">`);
        }else{
            $('#div_patron').hide();
            $('#pin_detalle').html('Sin clave');
        }
        

        $('#accesorios_detalle').html('');
        if(data['accesorios'].length>0){
            $.each(data['accesorios'], function(i, item) {
                // Verificar si es el último elemento
                var isLast = (i === data['accesorios'].length - 1);
                // Si no es el último, añade la coma, si es el último no la agrega
                $('#accesorios_detalle').append(`${item['accesorios']['descripcion']}${isLast ? '' : ', '}`);
            });
        }else{
            $('#accesorios_detalle').html('Sin accesorios');
        }
        $('#div_imagenes').html('');
        $('#tittle_imagenes').html('');
        if(data['imagenes'].length>0){
            $('#tittle_imagenes').html('<b>Ingreso de orden</b> <hr>');
            $.each(data['imagenes'], function(i, item) {
                $('#div_imagenes').append(` <br> <br>
                                            <div style="text-align: center;">
                                                <p style="margin: 0; font-weight: bold;">${item['descripcion']}</p>
                                                <a href="/imagenesorden/${item['ruta']}"><img width="120px" src="/imagenesorden/${item['ruta'] }" alt="img_orden" style="border: 1px solid #ccc;"></a>
                                                <br><br>
                                            </div> `);
            });
        }
 
        $('#div_imagenes_tecnico').html('');
        $('#tittle_imagenes_tecnico').html('');
        if(data['imagenes_tecnico'].length>0){
            $('#tittle_imagenes_tecnico').html('<hr><b>Diagnóstico o reparación</b> <hr>');
            $.each(data['imagenes_tecnico'], function(i2, item2) {
                $('#div_imagenes_tecnico').append(` <br> <br>
                                            <div style="text-align: center;">
                                                <p style="margin: 0; font-weight: bold;">${item2['descripcion']}</p>
                                                <a href="/imagenesorden/${item2['ruta']}"><img width="120px" src="/imagenesorden/${item2['ruta'] }" alt="img_orden" style="border: 1px solid #ccc;"></a>
                                                <br><br>
                                            </div> `);
            });
        }
        $('#obsgeneral_detalle').html(data['response']['observacion_inicio']);
        $('#obstecnico_detalle').html(data['response']['observacion_para_tecnico']);

       
        
        $('#div_lista').hide();
        $('#div_detalle').show(200);
        
        cargando();
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al obtener registros','error');
        cargando();
    });
}

function regresar(){
    $('#div_lista').show();
    $('#div_detalle').hide(200);
}

function cargar_incidencias(idorden){
    $("#table_historial_incidencias").DataTable().destroy();
    $("#table_historial_incidencias tbody").empty();
    cargando('m','Por favor espere...');
    $.get('/orden/lista_incidencias/'+idorden,function(resultado){
        if(resultado['status']=='error'){
            mensaje_notificacion(resultado['response'],resultado['status']);
            cargando();
            return;
        }
        $.each(resultado['response'],function(i,value){
            notificado='';
            if(value['correo_cliente']=='S' && value['correo_usuario']=='S'){
                notificado='Cliente, usuario y administradores';
            }
            if(value['correo_cliente']=='S' && value['correo_usuario']=='N'){
                notificado='Cliente y administradores';
            }
            if(value['correo_cliente']=='N' && value['correo_usuario']=='S'){
                notificado='Usuario y administradores';
            }
            if(value['correo_cliente']=='N' && value['correo_usuario']=='N'){
                notificado='Administradores';
            }
           
            $("#body_historial_incidencias").append(`        
                <tr>
                    <td align='center' width='1%' >${i+1}
                    </td>
                    <td width='5%'>${value['fecha']}
                    </td>
                    <td width='10%'>${value['usuario']} <br>
                        <small><b>Notificado:</b> ${notificado} </small>
                    </td>
                    <td width='15%'>${value['descripcion']}
                    </td>
                </tr>
            `);

        });
        $('[data-toggle="tooltip"]').tooltip(); 
        cargar_estilos_tabla("table_historial_incidencias", "desc",1);
        cargando();

        $('#modal_incidencia').modal('show');
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al cargar historial','error');
        cargando();
    });
}

function modal_incidencia(idorden){
    $('#idordenincidencia_encrypt').val(idorden);
    $('#descripcion_incidencia').val('');
    $('#correo_usuario').prop('checked',false);
    $('#correo_cliente').prop('checked',false);
    cargar_incidencias(idorden);
}

$('#form_reportar_incidencia').submit(function(e){
    e.preventDefault();
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/reportar_incidencia',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }
            cargar_incidencias(data['idorden']);
            mensaje_notificacion(data['response'], data['status']);
            $('#descripcion_incidencia').val('');
            $('#correo_usuario').prop('checked',false);
            $('#correo_cliente').prop('checked',false);

            cargando();
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});