$('#form_orden').submit(function(e){
    e.preventDefault();
    if($('#accesorios').val()==''){
        mensaje_notificacion('Por favor seleccione los accesorios.', 'error');
        return;
    }
    const canvas = document.getElementById('patternCanvas');
    const ctx = canvas.getContext('2d');

    // Dibujar el patrón sin el botón
    drawPatternWithoutButton();

    // Capturar el contenido del canvas como Base64
    const imageData = canvas.toDataURL('image/png');

    // Crear un campo oculto en el formulario para enviar la imagen
    const inputHidden = document.createElement('input');
    inputHidden.type = 'hidden';
    inputHidden.name = 'canvasImage';
    inputHidden.value = imageData;

    // Añadir el campo al formulario
    this.appendChild(inputHidden);

    // Restaurar el botón y redibujar el canvas
    drawPattern();

    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/generar',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            cargando();

	
            if(data['status']=='error' || data['status']=='warning'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }

            mensaje_notificacion(data['response'], data['status']);
            $('#div_result').show();
            $('#img_qr').html(`<br>
                <b>Orden ${data['result']['codigo']} generada con éxito.<br>
                Puede escanerar el QR para subir las fotos del movil o acceder directamente en el botón cargar imagenes.</b>
                    <br>
                <img src="data:image/png;base64,${data['result']['img']}"><br>
                <a target='_blank' type="button" class="btn btn-warning btn-sm" href="${data['result']['url']}">
                    <i class="fa fa-upload"></i> Cargar imagenes
                </a>
                <a  type="button" class="btn btn-info btn-sm" href="/orden">
                    <i class="fa fa-refresh"></i> Nueva orden
                </a>
                <a target='_blank' href="/orden/reporte/${data['result']['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Imprimir orden" class="btn btn-primary btn-sm">
                    <i class="fa fa-file"></i>
                    Imprimir orden
                </a>
                <br><br>
            `);
            $('#div_form').hide();

            cancelar();
            cargando();

            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

// Esta función se encargará de dibujar el patrón sin el botón, incluyendo la secuencia de círculos seleccionados.
function drawPatternWithoutButton() {
    ctx.clearRect(0, 0, canvas.width, canvas.height);

    // Dibujar círculos
    circles.forEach((circle, index) => {
        ctx.beginPath();
        ctx.arc(circle.x, circle.y, radius, 0, Math.PI * 2);
        ctx.fillStyle = circle.selected ? '#4caf50' : '#ddd';
        ctx.fill();
        ctx.strokeStyle = '#333';
        ctx.stroke();

        // Dibujar números en el centro de cada círculo
        ctx.fillStyle = '#333'; // Color del número
        ctx.font = '16px Arial';
        ctx.textAlign = 'center';
        ctx.textBaseline = 'middle';
        ctx.fillText(index + 1, circle.x, circle.y); // El número del círculo
    });

    // Dibujar líneas entre los círculos seleccionados
    if (selectedCircles.length > 1) {
        ctx.beginPath();
        ctx.moveTo(selectedCircles[0].x, selectedCircles[0].y);
        for (let i = 1; i < selectedCircles.length; i++) {
            ctx.lineTo(selectedCircles[i].x, selectedCircles[i].y);
        }
        ctx.strokeStyle = '#4caf50';
        ctx.lineWidth = 3;
        ctx.stroke();
    }

    // Dibujar la secuencia de números seleccionados
    const sequence = selectedCircles.map(c => circles.indexOf(c) + 1).join('-');
    ctx.fillStyle = '#000'; // Color de la secuencia
    ctx.font = '18px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'top';
    ctx.fillText(sequence, canvas.width / 2, 10); // Coloca la secuencia en la parte superior
}

function modal_clientes(){
    cancelar_cliente();
    $('#modal_clientes').modal('show');
}

$('#form_clientes').submit(function(e){
    e.preventDefault();
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/clientes/registrar',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error' || data['status']=='warning'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }

            mensaje_notificacion(data['response'], data['status']);
            $('#modal_clientes').modal('hide');
            // $('#cedula').val(data['identificacion']);
            buscar_cliente(data['identificacion']);
            cancelar_cliente();
            cargando();

            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

function cancelar_cliente(){
    $('#cedula_clientes').val('');
    $('#nombres_clientes').val('');
    $('#direccion_clientes').val('');
    $('#celular_clientes').val('');
    $('#correo_clientes').val('');


}

function buscar_cliente($cedula){

    cargando('m','Por favor espere...');
    limpiar_form();

    $.get('/clientes/buscar/'+$cedula,function(data){
        console.log(data);
        if(data['status']=='error' || data['status']=='warning'){
            mensaje_notificacion(data['response'],data['status']);
            cargando(); return;
        }
        $('#cedula').val(data['response']['identificacion']);
        $('#nombres').val(data['response']['nombres']);
        $('#celular').val(data['response']['celular']);
        $('#correo').val(data['response']['correo']);
        $('#idcliente_encrypt').val(data['response']['id_encrypt']);
        cargando();

    }).fail(function(){
        mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente','error');
        cargando();
    });
}
function limpiar_form(){
    $('#cedula').val('');
    $('#nombres').val('');
    $('#celular').val('');
    $('#correo').val('');
    $('#idcliente_encrypt').val('');
}

$('#accesorios').on('select2:select', function() {
    var seleccion = $(this).val();
    // Si se selecciona "ninguno", deseleccionar todas las opciones y solo dejar "ninguno"
    if (seleccion && seleccion.includes('Ninguno')) {
        $('#accesorios option').prop('selected', false);
        $('#accesorios option[value="Ninguno"]').prop('selected', true);
        $('#accesorios').val(['Ninguno']); // Solo dejar "Ninguno" como seleccionado
    } else {
        // Si se selecciona una opción diferente a "ninguno", deseleccionar "ninguno"
        $('#accesorios option[value="Ninguno"]').prop('selected', false);
        
        // Si no se selecciona ninguna opción, agregar la opción "ninguno" al principio
        if (seleccion.length === 0) {
            $('#accesorios').prepend('<option value="Ninguno">Ninguno</option>');
        }
    }

    // Después de seleccionar/deseleccionar, disparar el cambio
    $('#accesorios').trigger('change');
});

// Este evento se dispara cuando se está iniciando la selección
$('#accesorios').on('select2:opening', function() {
    // Si "ninguno" no está en la lista de opciones, añadirlo
    if ($('#accesorios option[value="Ninguno"]').length === 0) {
        $('#accesorios').prepend('<option value="Ninguno">Ninguno</option>');
    }
});



$('#cedula').on('input', function() {
    this.value = this.value.replace(/[^0-9]/g,'');
 });

 $('#celular').on('input', function() {
    this.value = this.value.replace(/[^0-9]/g,'');
 });

function cancelar(){
    $('#idcliente_encrypt').val('');
    $('#cedula').val('');
    $('#fecha_recibe').val('');
    $('#hora_recibe').val('');
    $('#modelo').val('');
    $('#imei').val('');
    $('#estado').val('');
    $('#accesorios').val('');
    $('#estado_encendido').val('');
    $('#observacion').val('');
    $('#tipo_orden').val('');
    $('#pin').val('');
    $('#tiene_clave').prop('checked',false);
    $('#canvasImage').val('');
    $('#accesorios').val('');
    $('#accesorios').trigger('change');
}

$('#local').on('select2:select', function() {
    var seleccion = $(this).val();
    console.log(seleccion);
    // Si se selecciona "todos", seleccionar todas las opciones
    if (seleccion && seleccion.includes('T')) {
        $('#local option').prop('selected', true);
        $('#local option[value="T"]').prop('selected', false);
        $('#local option[value="T"]').remove();

        $('#local').prepend('<option value="N">No seleccionar</option>');
        $('#local option[value=""]').prop('selected', false);

    } else {
        if (seleccion && seleccion.includes('N')) {
            $('#local option[value="N"]').remove();
            $('#local').val([]);
            $('#local').prepend('<option value="T">Seleccionar todos</option>');

        }
        // Si no se selecciona "todos", deseleccionar la opción "todos" si está seleccionada
        $('#local option[value="T"]').prop('selected', false);
    }
    $('#local').trigger('change');
});


