$(document).ready(function(){
   
    cargar_ordenes();
    
});

function cargar_ordenes(valor='T'){
    cargando('m','Por favor espere...');
    $.get('/orden/lista_ingresadas/'+valor,function(resultado){
        cargando(); 
        $("#table_ordenes").DataTable().destroy();
        $("#table_ordenes tbody").empty();
        
       
        $.each(resultado['response'],function(i,value){
            var btn_qr=``;
            if(resultado['isadmin']=='S'){
                local=`<td width='15%'>${value['local']} - ${value['dir_local']}
                </td>`;
            }else{
                local=``;
            }
            var orden_ingreso='';
            var fecha_atencion='';
            var observacion_anulacion;
            var obs_confirma='';
            if(value['status_confirmado']==1){
                if(value['confirmar']=='N'){
                    // $()
                }
            }

            if(value['estado_orden']=='I'){
                estado=`<span class='badge badge-primary'><i class='fa fa-check'></i> Ingresado</span>`;
                btn_qr=`<button onclick="modal_qr_imagen('${value['id_encrypt']}','${value['codigo']}')" data-toggle="tooltip" data-placement="right" title="QR imagenes" class="btn btn-success btn-sm">
                            <i class="fa fa-qrcode"></i>
                            Qr
                        </button>`;
                orden_ingreso=`<a target='_blank' href="/orden/reporte/${value['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Orden documento" class="btn btn-primary btn-sm">
                    <i class="fa fa-file"></i>
                    Orden
                </a>`;
            }
            if(value['estado_orden']=='A'){
                estado=`<span class='badge badge-info'><i class='fa fa-user'></i> Asignado</span>`;
                orden_ingreso=`<a target='_blank' href="/orden/reporte/${value['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Orden documento" class="btn btn-primary btn-sm">
                    <i class="fa fa-file"></i>
                    Orden
                </a>`;
                fecha_atencion=`<b></b>`;
            }
            if(value['estado_orden']=='T'){
                estado=`<span class='badge badge-warning'><i class='fa fa-user'></i> Atendido</span>`;
                orden_ingreso=`<a target='_blank' href="/orden/reporte/${value['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Orden documento" class="btn btn-primary btn-sm">
                    <i class="fa fa-file"></i>
                    Orden
                </a>`;
            }
            if(value['estado_orden']=='D'){
                estado=`<span class='badge badge-danger'><i class='fa fa-times'></i> Anulada</span>`;
                orden_ingreso=`<a target='_blank' href="/orden/reporte/${value['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Orden documento" class="btn btn-primary btn-sm">
                    <i class="fa fa-file"></i>
                    Orden
                </a>`;
            }
            if(value['estado_orden']=='F'){
                estado=`<span class='badge badge-success'><i class='fa fa-check-circle'></i> Entregado</span>`;
            }
            var incidencia=``;
            if(value['incidencia']==1){
                incidencia=`<small><b style='color:red'>Reporta incidencia</b></small>`;
            }
            $("#body_ordenes").append(`        
                <tr>
                    ${local}
                    <td width='15%'>${value['fecha_recibe']} ${value['hora_recibe']}<br>
                        ${incidencia}
                     </td>
                    <td width='5%'>${value['codigo']}
                     </td>
                    <td><small><b><i class='fa fa-user'></i> </b>${value['identificacion']}<br>
                        <b><i  class='fa fa-circle'></i>  </b>${value['nombres']}
                        </small>
                    </td>
                    <td align='center'>${estado}
                        <br><small>${value['status_confirmado_ad']}</small>
                    </td>
                    <td  align='center'>
                        <button data-toggle="tooltip" data-placement="right" title="Ver detalles" class="btn btn-info btn-sm" onclick="detalle_orden('${value['id_encrypt']}')">
                            <i class="fa fa-eye"></i>
                            Ver
                        </button>
                        ${btn_qr}
                        ${orden_ingreso}
                        
                    </td>
                </tr>
            `);

        });
        $('[data-toggle="tooltip"]').tooltip(); 
        if(resultado['isadmin']=='S'){
            cargar_estilos_tabla("table_ordenes", "desc",2);
        }else{
            cargar_estilos_tabla("table_ordenes", "desc",1);

        }
        
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al cargar información','error');
        cargando();
    });

}

$('#local').on('change', function() {
    // Obtener el valor seleccionado
    var selectedValue = $(this).val();
    
    // Si se selecciona 'T', podrías hacer algo especial
    if (selectedValue == 'T') {
        cargar_ordenes();
    }else{
        cargar_ordenes(selectedValue);
    }
});

function detalle_orden(id){
    cargando('m','Cargando...');
    $('#div_patron').show();
    $('#div_anulacion').html('');
    $('#div_asignacion').html(``);
    $('#div_cliente_confirmacion').html('');
    $.get('/orden/detalle/'+id,function(data){
        if(data['status']=='failed'){
            mensaje_notificacion(data['response'],'error');
            cargando();
            return;
        }
       
        $('#codigo_detalle').html(data['response']['codigo']);
        $('#fecha_detalle').html(`${data['response']['fecha_recibe']} ${data['response']['hora_recibe']}`);
        if(data['response']['estado_orden']=='I'){
            $('#btn_detalle').html(`<button onclick="modal_tecnicos('${data['response']['idlocal_encrypt']}','${data['response']['id_encrypt']}')" id="btn_tecnicos" type="button" class="btn btn-primary"> <i class="fa fa-user"></i> Asignar técnico </button>
            <button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>`);
            
            $('#estado_detalle').html(`<span class='badge badge-primary'><i class='fa fa-check'></i> Ingresada</span>`);
        }
        if(data['response']['estado_orden']=='A'){
            $('#btn_detalle').html(`<button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>`);
            $('#estado_detalle').html(`<span class='badge badge-warning'><i class='fa fa-user'></i> Asignada</span>`);
            $('#div_asignacion').html(`<div class="col-md-5">
                <label >Técnico asignado: </label> <i> ${data['response']['tecnico']} </i> 
            </div>
            <div class="col-md-6">
                <label >Fecha asignación:  </label> <i >${data['response']['fecha_asigna']}</i> 
            </div>
            `);

            // if(data['response']['tipo_orden']=='d' && data['response']['status_confirmado']==0 ){
            //     $('#div_cliente_confirmacion').html(`<b style='color:red'> En espera de confirmación del cliente para continuar con reparación.</b>`);
            // }else{
                if(data['response']['status_confirmado']==1 ){
                    if(data['response']['confirmar']=='S' ){
                        if(data['response']['user_confirma']==null ){
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> El cliente aceptó la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }else{
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> Se confirma la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }
                    }else{
                        if(data['response']['user_confirma']!=null ){
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> El cliente no aceptó la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }else{
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> No se procede con la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }
                    }
                }
            // }
        }

        if(data['response']['estado_orden']=='T'){
            btn_confirmacion='';
            btn_qr='';
            if(data['response']['tipo_orden']=='d'){
                btn_confirmacion=`<button onclick="modal_confirmar('${data['response']['id_encrypt']}')" id="btn_confirmar_reparacion" type="button" class="btn btn-info"> <i class="fa fa-check"></i> Confirmar reparación </button>`;
            }
            if(data['response']['tipo_orden']=='r'){
                btn_qr=`<button type='button'  onclick="modal_qr_imagen('${data['response']['id_encrypt']}','${data['response']['codigo']}')" data-toggle="tooltip" data-placement="right" title="QR imagenes" class="btn btn-warning">
                            <i class="fa fa-qrcode"></i>
                            Qr imagenes
                        </button>`;
            }
            $('#btn_detalle').html(`<button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>
                <button onclick="detalle_atencion('${data['response']['id_encrypt']}','${data['response']['tipo_orden']}')" id="btn_detalle_atencion" type="button" class="btn btn-success"> <i class="fa fa-eye"></i> Detalle atención </button>
                ${btn_confirmacion}
                <button onclick="modal_entregar('${data['response']['id_encrypt']}','${data['response']['tipo_orden']}')" id="btn_entregar" type="button" class="btn btn-primary"> <i class="fa fa-check-circle"></i> Entregar </button>
                ${btn_qr}`);
            $('#estado_detalle').html(`<span class='badge badge-warning'><i class='fa fa-user'></i> Atendida</span>`);
            $('#div_asignacion').html(`<div class="col-md-5">
                <label >Técnico asignado: </label> <i> ${data['response']['tecnico']} </i> 
            </div>
            <div class="col-md-6">
                <label >Fecha asignación:  </label> <i >${data['response']['fecha_asigna']}</i> 
            </div>
            `);
            
            if(data['response']['tipo_orden']=='d' && data['response']['status_confirmado']==0 ){
                $('#div_cliente_confirmacion').html(`<b style='color:red'> En espera de confirmación del cliente para continuar con reparación.</b>`);
            }else{
                if(data['response']['status_confirmado']==1 ){
                    if(data['response']['confirmar']=='S' ){
                        if(data['response']['user_confirma']==null ){
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> El cliente aceptó la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }else{
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> Se confirma la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }
                    }else{
                        if(data['response']['user_confirma']!=null ){
                            $('#div_cliente_confirmacion').html(`<b style='color:red'> El cliente no aceptó la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }else{
                            $('#div_cliente_confirmacion').html(`<b style='color:red'> No se procede con la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }
                    }
                }
            }
            
        }

        if(data['response']['estado_orden']=='D'){
            $('#btn_detalle').html(`<button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>
                <button onclick="modal_entregar('${data['response']['id_encrypt']}','d')" id="btn_entregar" type="button" class="btn btn-primary"> <i class="fa fa-check-circle"></i> Entregar </button>`);
            $('#estado_detalle').html(`<span class='badge badge-danger'><i class='fa fa-times'></i> Anulada</span>`);
            $('#div_anulacion').html(`
                <div class="col-md-6">
                    <label >Fecha anula:  </label> ${data['response']['fecha_anula']}
                </div>
                <div class="col-md-6">
                    <label >Observación:  </label> ${data['response']['observacion_anulacion']}
                </div>
            `);
        }
        if(data['response']['tipo_orden']=='d'){
            $('#tipod_detalle').html('Diagnóstico');

        }

        if(data['response']['tipo_orden']=='r'){
            $('#tipod_detalle').html('Reparación');
        }

        if(data['response']['tipo_garantia']=='NA'){
            $('#garantia_detalle').html('No aplica');
        }
        if(data['response']['tipo_garantia']=='co'){
            $('#garantia_detalle').html('Equipo vendido');
        }
        if(data['response']['tipo_garantia']=='st'){
            $('#garantia_detalle').html('Servicio técnico');
        }

     

        $('#cedula_detalle').html(data['response']['identificacion']);
        $('#nombres_detalle').html(data['response']['nombres']);
        $('#direccion_detalle').html(data['response']['direccion']);
        $('#celular_detalle').html(data['response']['celular']);
        $('#email_detalle').html(data['response']['correo']);
        $('#modelo_detalle').html(data['response']['modelo']);
        $('#imei_detalle').html(data['response']['imei']);
        $('#estadomovil_detalle').html(data['response']['estado_celular']);

        if(data['response']['estado_encendido']=='En'){
            $('#encendido_detalle').html('Si');
        }else{
            $('#encendido_detalle').html('No (No se puede probar periféricos.)');
        }
        if(data['response']['tiene_clave']=='S'){
            if(data['response']['pin']==null || data['response']['pin']==''){
                $('#pin_detalle').html('Sin PIN');
            }else{
                $('#pin_detalle').html(data['response']['pin']);
            }
            $('#patron_detalle').html(`<img width='50%' src="${data['response']['patron']}">`);
        }else{
            $('#div_patron').hide();
            $('#pin_detalle').html('Sin clave');
        }
        

        $('#accesorios_detalle').html('');
        if(data['accesorios'].length>0){
            $.each(data['accesorios'], function(i, item) {
                // Verificar si es el último elemento
                var isLast = (i === data['accesorios'].length - 1);
                // Si no es el último, añade la coma, si es el último no la agrega
                $('#accesorios_detalle').append(`${item['accesorios']['descripcion']}${isLast ? '' : ', '}`);
            });
        }else{
            $('#accesorios_detalle').html('Sin accesorios');
        }
   
        $('#div_imagenes').html('');
        $('#tittle_imagenes').html('');
        if(data['imagenes'].length>0){
            $('#tittle_imagenes').html('<b>Ingreso de orden</b> <hr>');
            $.each(data['imagenes'], function(i, item) {
                $('#div_imagenes').append(` <br> <br>
                                            <div style="text-align: center;">
                                                <p style="margin: 0; font-weight: bold;">${item['descripcion']}</p>
                                                <a href="/imagenesorden/${item['ruta']}"><img width="120px" src="/imagenesorden/${item['ruta'] }" alt="img_orden" style="border: 1px solid #ccc;"></a>
                                                <br><br>
                                            </div> `);
            });
        }

        $('#div_imagenes_tecnico').html('');
         $('#tittle_imagenes_tecnico').html('');
        if(data['imagenes_tecnico'].length>0){
            $('#tittle_imagenes_tecnico').html('<hr><b>Diagnóstico o reparación</b> <hr>');
            $.each(data['imagenes_tecnico'], function(i2, item2) {
                $('#div_imagenes_tecnico').append(` <br> <br>
                                            <div style="text-align: center;">
                                                <p style="margin: 0; font-weight: bold;">${item2['descripcion']}</p>
                                                <a href="/imagenesorden/${item2['ruta']}"><img width="120px" src="/imagenesorden/${item2['ruta'] }" alt="img_orden" style="border: 1px solid #ccc;"></a>
                                                <br><br>
                                            </div> `);
            });
        }

        $('#div_imagenes_entrega').html('');
        $('#tittle_imagenes_entrega').html('');
        if(data['imagenes_entrega'].length>0){
            $('#tittle_imagenes_entrega').html('<hr><b>Entrega</b> <hr>');
            $.each(data['imagenes_entrega'], function(i3, item3) {
                $('#div_imagenes_entrega').append(` <br> <br>
                                            <div style="text-align: center;">
                                                <p style="margin: 0; font-weight: bold;">${item3['descripcion']}</p>
                                                <a href="/imagenesorden/${item3['ruta']}"><img width="120px" src="/imagenesorden/${item3['ruta'] }" alt="img_orden" style="border: 1px solid #ccc;"></a>
                                                <br><br>
                                            </div> `);
            });
        }
        $('#obsgeneral_detalle').html(data['response']['observacion_inicio']);
        $('#obstecnico_detalle').html(data['response']['observacion_para_tecnico']);

       
        
        $('#div_lista').hide();
        $('#div_detalle').show(200);
        
        cargando();
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al obtener registros','error');
        cargando();
    });
}

function regresar(){
    $('#div_lista').show();
    $('#div_detalle').hide(200);
}

function modal_qr_imagen(id,codigo){
    cargando('m','Cargando...');
    $.get('/orden/qr_imagen/'+id+'/T',function(data){
        if(data['status']=='failed'){           
            mensaje_notificacion(data['response'],'error');
            cargando();
            return;
        }
        $('#title_qr').html(`QR Imagenes orden ${codigo}`);
        $('#div_qr').html(`<br>
            Puede escanerar el QR para subir las fotos del movil o acceder directamente en el botón cargar imagenes.</b><br>
            <img src="data:image/png;base64,${data['response']['img']}"><br>
            <a target='_blank' type="button" class="btn btn-warning btn-sm" href="${data['response']['url']}">
                <i class="fa fa-upload"></i> Cargar imagenes
            </a>
        `);
        $('#modal_qr').modal('show');
        cargando();
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al obtener registros','error');
        cargando();
    });
}

function modal_entregar(id,tipo_orden){
    $('#observacion_entrega').val('');
    $('#trasferencia').val('0.00');
    $('#efectivo').val('0.00');


    if(tipo_orden=='d'){
        $('#div_cobro').hide();
        $('#validar_cobro').val('n');
        $('#mensaje_imagen').html(``);
    }else{
        cargando('m','Cargando...');
        $.get('/orden/detalle_atencion/'+id+'/'+tipo_orden,function(data){
            if(data['status']=='error'){
                mensaje_notificacion(data['response'],'error');
                cargando();
                return;
            }
            $('#total_cobrar').html(`$${data['response']['costo_total']}`);
            $('#total_cobrar_valor').val(data['response']['costo_total']);
            if(data['img_entrega']<=0){
                $('#mensaje_imagen').html(`<b>Debe subir las imagenes de entrega para completar.</b>`);
            }else{
                $('#mensaje_imagen').html(``);
            }
            cargando();
        }).fail(function(){
            mensaje_notificacion('Inconvenientes al obtener registros','error');
            cargando();
        });
        $('#div_cobro').show();
        $('#validar_cobro').val('s');
    }
    $('#idorden_entregar_encrypt').val(id);
    $('#modal_entregar').modal('show');

 
}
function detalle_atencion(id,tipo){
    cargando('m','Cargando...');
    $.get('/orden/detalle_atencion/'+id,function(data){
        if(data['status']=='failed'){
            mensaje_notificacion(data['response'],'error');
            cargando();
            return;
        }
        if(tipo=='d'){
            $('#div_tiempo').show();
        }else{
            $('#div_tiempo').hide();
        }
        $('#div_form_atencion').html('');
        $.each(data['response'],function(i,item){
            tipo='Diagnóstico';
            tiempo='';
            if(item['tipo_orden']=='r'){
                tipo='Reparación';
            }
            if(item['tipo_orden']=='d'){
                tiempo=`<b>Tiempo:</b> ${item['dias']} días ${item['horas']} horas ${item['minutos']} minutos`;
            }
            $('#div_form_atencion').append(`
                <div class="form-group">
                    <div class="row">
                        <div class="col-md-12">
                            <b style='color:blue'>${tipo}</b>
                            <hr>
                            <div style='margin-left:20px'>
                                <b>Fecha atención:</b>  ${item['fecha_atiende']} <br>
                                <b>Observación:</b>  ${item['observacion_diagnostico']} <br>
                                <b>Costo:</b>  $${item['costo_total']} <br>
                                <b>Técnico:</b>  ${item['useratiende']['name']} <br>
                                ${tiempo} 
                                
                            </div>
                        </div>
                    </div>
                </div> <hr>
            `);
        });

        $('#atencion_observacion').html(`<b>Observación: </b> ${data['response']['observacion_diagnostico']}`);
        $('#atencion_tiempo').html(`<b>Tiempo: </b> ${data['response']['dias']} días ${data['response']['horas']} horas ${data['response']['minutos']} minutos`);
        $('#atencion_costo').html(`<b>Costo: </b> ${data['response']['costo_total']}`);
        $('#atencion_fecha').html(`<b>Fecha atención: </b> ${data['response']['fecha_atiende']}`);

        $('#modal_detalle_atencion').modal('show');
        cargando();
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al obtener registros','error');
        cargando();
    });
}
function modal_tecnicos(idlocal,idorden){
    cargando('m','Cargando...');
    $('#tecnicos').html('');
    $.get('/orden/tecnicos/'+idlocal,function(data){
        if(data['status']=='failed'){
            mensaje_notificacion(data['response'],'error');
            cargando();
            return;
        }
        $('#tecnicos').html('<option class="option_tecnicos" value=""></option>');
        $.each(data['response'],function(i,item){
            $('#tecnicos').append(`<option class="option_tecnicos" value="${item['id_encrypt']}">${item['identificacion']} - ${item['name']}</option>`);
        });
        $('#idorden_encrypt').val(idorden);
        $('#modal_tecnicos').modal('show');
        cargando();
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al obtener registros','error');
        cargando();
    });
}

function modal_confirmar(id){
    $('#idordenconfirmar_encrypt').val(id);
    $('descripcion_confirmar').val('');
    $('#modal_confirmar').modal('show');
}


$('#form_asignar_tecnico').submit(function(e){
    e.preventDefault();
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/asignar_tecnico',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }

            mensaje_notificacion(data['response'], data['status']);
            $('#modal_tecnicos').modal('hide');
            regresar();
            cargar_ordenes();
            cargando();
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});


function asignar_tecnico(){
    $('#modal_tecnicos').addClass('disabled_content');
    swal({
        title: "",
        text: "¿Esta seguro que desea asignar el técnico?",
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: "btn-info",
        confirmButtonText: "Si",
        cancelButtonText: "No",
        closeOnConfirm: false,
        closeOnCancel: false
    },
    function(isConfirm) {
        if (isConfirm) { 
            $('#form_asignar_tecnico').submit();

        }
        $('#modal_tecnicos').removeClass('disabled_content');

        sweetAlert.close();   // ocultamos la ventana de pregunta
    }); 
}

$('#trasferencia').on('input', function() {
    // Permitir solo números y un único punto decimal
    this.value = this.value.replace(/[^0-9.]/g, '');  // Elimina todo lo que no sea número o punto

    // Permitir solo un punto decimal
    if ((this.value.match(/\./g) || []).length > 1) {
        this.value = this.value.replace(/\.(?=.*\.)/, '');  // Eliminar puntos adicionales
    }

    // Limitar a dos decimales
    if (this.value.indexOf('.') !== -1) {
        // Si existe un punto, recortar el valor a dos decimales
        this.value = this.value.replace(/(\.\d{2})\d+/, '$1');
    }

    // Si el valor es vacío, dejarlo vacío
    if (this.value === '') {
        this.value = '';
    }
});
$('#trasferencia').on('focus', function() {
    // Al hacer clic en el input o al poner el foco, borrar el valor
    if (this.value === '0.00') {
        this.value = '';
    }
});
$('#trasferencia').on('blur', function() {
    // Si el campo está vacío al salir (blur), volver a poner 0
    if (this.value === '') {
        this.value = '0.00';
    }
});

$('#efectivo').on('input', function() {
    // Permitir solo números y un único punto decimal
    this.value = this.value.replace(/[^0-9.]/g, '');  // Elimina todo lo que no sea número o punto

    // Permitir solo un punto decimal
    if ((this.value.match(/\./g) || []).length > 1) {
        this.value = this.value.replace(/\.(?=.*\.)/, '');  // Eliminar puntos adicionales
    }

    // Limitar a dos decimales
    if (this.value.indexOf('.') !== -1) {
        // Si existe un punto, recortar el valor a dos decimales
        this.value = this.value.replace(/(\.\d{2})\d+/, '$1');
    }

    // Si el valor es vacío, dejarlo vacío
    if (this.value === '') {
        this.value = '';
    }
});
$('#efectivo').on('focus', function() {
    // Al hacer clic en el input o al poner el foco, borrar el valor
    if (this.value === '0.00') {
        this.value = '';
    }
});
$('#efectivo').on('blur', function() {
    // Si el campo está vacío al salir (blur), volver a poner 0
    if (this.value === '') {
        this.value = '0.00';
    }
});

// Lo mismo para tarjeta_credito
$('#tarjeta_credito').on('input', function() {
    this.value = this.value.replace(/[^0-9.]/g, '');
    if ((this.value.match(/\./g) || []).length > 1) {
        this.value = this.value.replace(/\.(?=.*\.)/, '');
    }
    if (this.value.indexOf('.') !== -1) {
        this.value = this.value.replace(/(\.\d{2})\d+/, '$1');
    }
    if (this.value === '') {
        this.value = '';
    }
});
$('#tarjeta_credito').on('focus', function() {
    if (this.value === '0.00') {
        this.value = '';
    }
});
$('#tarjeta_credito').on('blur', function() {
    if (this.value === '') {
        this.value = '0.00';
    }
});

// Lo mismo para payphone
$('#payphone').on('input', function() {
    this.value = this.value.replace(/[^0-9.]/g, '');
    if ((this.value.match(/\./g) || []).length > 1) {
        this.value = this.value.replace(/\.(?=.*\.)/, '');
    }
    if (this.value.indexOf('.') !== -1) {
        this.value = this.value.replace(/(\.\d{2})\d+/, '$1');
    }
    if (this.value === '') {
        this.value = '';
    }
});
$('#payphone').on('focus', function() {
    if (this.value === '0.00') {
        this.value = '';
    }
});
$('#payphone').on('blur', function() {
    if (this.value === '') {
        this.value = '0.00';
    }
});

$('#form_confirmar').submit(function(e){
    e.preventDefault();
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/confirmar',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }

            mensaje_notificacion(data['response'], data['status']);
            $('#modal_confirmar').modal('hide');
            regresar();
            cargar_ordenes();
            cargando();
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

$('#form_entregar_orden').submit(function(e){
    e.preventDefault();
    if($('#validar_cobro').val()=='s'){
        total = 
            parseFloat($('#trasferencia').val()) +
            parseFloat($('#efectivo').val()) +
            parseFloat($('#tarjeta_credito').val()) +
            parseFloat($('#payphone').val());
        if(total.toFixed(2)!=parseFloat($('#total_cobrar_valor').val()).toFixed(2)){
            mensaje_notificacion('Valores no coinciden con el total','warning');
            return;
        }
    }
  
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/entregar',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }

            mensaje_notificacion(data['response'], data['status']);
            $('#modal_entregar').modal('hide');
            regresar();
            cargar_ordenes();
            cargando();
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

