$(document).ready(function(){
   
    cargar_ordenes('T','A');
    
});

function cargar_ordenes(valor='T',estado='A'){
    cargando('m','Por favor espere...');
    $.get('/orden/lista_asignadas/'+valor+'/'+estado,function(resultado){
        cargando(); 
        if(resultado['status']=='error'){
            mensaje_notificacion(resultado['response'],resultado['status']);
            cargando();
            return;
        }
        $("#table_ordenes").DataTable().destroy();
        $("#table_ordenes tbody").empty();
        
       
        $.each(resultado['response'],function(i,value){
            var btn_qr=``;
            if(resultado['isadmin']=='S'){
                local=`<td width='15%'>${value['local']} - ${value['dir_local']} <br> <small style='padding-left:10px'><b>${value['tecnico']}</b></small>
                </td>`;
            }else{
                local=``;
            }
            var orden_ingreso='';
            if(value['estado_orden']=='I'){
                estado=`<span class='badge badge-primary'><i class='fa fa-check'></i> Ingresado</span>`;
                btn_qr=`<button onclick="modal_qr_imagen('${value['id_encrypt']}','${value['codigo']}','A')" data-toggle="tooltip" data-placement="right" title="QR imagenes" class="btn btn-success btn-sm">
                            <i class="fa fa-qrcode"></i>
                            Qr
                        </button>`;
                orden_ingreso=`<a target='_blank' href="/orden/reporte/${value['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Orden documento" class="btn btn-primary btn-sm">
                    <i class="fa fa-file"></i>
                    Orden
                </a>`;
            }
            if(value['estado_orden']=='A'){
                estado=`<span class='badge badge-primary'><i class='fa fa-circle'></i> Pendiente</span>`;
                orden_ingreso=`<a target='_blank' href="/orden/reporte/${value['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Orden documento" class="btn btn-primary btn-sm">
                    <i class="fa fa-file"></i>
                    Orden
                </a>`;
            }
            if(value['estado_orden']=='T'){
                estado=`<span class='badge badge-warning'><i class='fa fa-check-circle'></i> Atendida</span>`;
                orden_ingreso=`<a target='_blank' href="/orden/reporte/${value['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Orden documento" class="btn btn-primary btn-sm">
                <i class="fa fa-file"></i>
                Orden
            </a>`;
            }
            if(value['estado_orden']=='D'){
                estado=`<span class='badge badge-danger'><i class='fa fa-times'></i> Anulada</span>`;
                orden_ingreso=`<a target='_blank' href="/orden/reporte/${value['id_encrypt']}" data-toggle="tooltip" data-placement="right" title="Orden documento" class="btn btn-primary btn-sm">
                    <i class="fa fa-file"></i>
                    Orden
                </a>`;
            }
            var incidencia=``;
            if(value['incidencia']==1){
                incidencia=`<small><b style='color:red'>Reporta incidencia</b></small>`;
            }
            $("#body_ordenes").append(`        
                <tr>
                    ${local}
                    <td width='15%'>${value['fecha_recibe']}<br>
                        ${incidencia}
                     </td>
                    <td width='5%'>${value['codigo']}
                     </td>
                    <td><small><b><i class='fa fa-user'></i> </b>${value['identificacion']}<br>
                        <b><i  class='fa fa-circle'></i>  </b>${value['nombres']}
                        </small>
                    </td>
                    <td align='center'>${estado}
                    <br><small>${value['status_confirmado_ad']}</small>
                    </td>
                    <td  align='center'>
                        <button data-toggle="tooltip" data-placement="right" title="Ver detalles" class="btn btn-info btn-sm" onclick="detalle_orden('${value['id_encrypt']}')">
                            <i class="fa fa-eye"></i>
                            Ver
                        </button>
                        ${btn_qr}
                        ${orden_ingreso}
                        
                    </td>
                </tr>
            `);

        });
        $('[data-toggle="tooltip"]').tooltip(); 
        if(resultado['isadmin']=='S'){
            cargar_estilos_tabla("table_ordenes", "desc",2);
        }else{
            cargar_estilos_tabla("table_ordenes", "desc",1);

        }
        
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al cargar los usuarios','error');
        cargando();
    });

}

$('#local').on('change', function() {
    // Obtener el valor seleccionado
    var selectedValue = $(this).val();
    
    // Si se selecciona 'T', podrías hacer algo especial
    if (selectedValue == 'T') {
        cargar_ordenes('T',$('#estado').val());
    }else{
        cargar_ordenes(selectedValue,$('#estado').val());
    }
});

$('#estado').on('change', function() {
    // Obtener el valor seleccionado
    var selectedValue = $(this).val();
    
    // Si se selecciona 'T', podrías hacer algo especial
    if (selectedValue == 'A') {
        cargar_ordenes($('#local').val(),'A');
    }else{
        cargar_ordenes($('#local').val(),selectedValue);
    }
});

function detalle_orden(id){
    cargando('m','Cargando...');
    $('#div_patron').show();
    $.get('/orden/detalle/'+id,function(data){
        if(data['status']=='failed'){
            mensaje_notificacion(data['response'],'error');
            cargando();
            return;
        }
        $('#div_asignacion').html(``);
       
        $('#codigo_detalle').html(data['response']['codigo']);
        $('#fecha_detalle').html(`${data['response']['fecha_recibe']} ${data['response']['hora_recibe']}`);
        if(data['response']['estado_orden']=='I'){
            $('#btn_detalle').html(`<button onclick="modal_tecnicos('${data['response']['idlocal_encrypt']}','${data['response']['id_encrypt']}')" id="btn_tecnicos" type="button" class="btn btn-primary"> <i class="fa fa-user"></i> Asignar técnico </button>
            <button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>`);
            
            $('#estado_detalle').html(`<span class='badge badge-primary'><i class='fa fa-check'></i> Ingresada</span>`);
        }
        if(data['response']['estado_orden']=='A'){
            $('#btn_detalle').html(`<button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>
                <button onclick="modal_atender('${data['response']['id_encrypt']}','${data['response']['tipo_orden']}','${data['response']['confirmar']}')" id="btn_atender" type="button" class="btn btn-success"> <i class="fa fa-check"></i> Atender </button>
                <button onclick="modal_incidencia('${data['response']['id_encrypt']}')" id="btn_incidencia" type="button" class="btn btn-primary"> <i class="fa fa-bell"></i> Reportar incidencia </button>
                <button type="button" onclick="modal_qr_imagen('${data['response']['id_encrypt']}','${data['response']['codigo']}','A')" class="btn btn-warning"> <i class="fa fa-save"></i> Qr imagenes</button>
                <button onclick="modal_anular('${data['response']['id_encrypt']}')" id="btn_anular" type="button" class="btn btn-danger"> <i class="fa fa-times"></i> Anular</button>`);
            $('#estado_detalle').html(`<span class='badge badge-primary'><i class='fa fa-circle'></i> Pendiente</span>`);
            $('#div_asignacion').html(` <div class="col-md-6">
                <label >Fecha asignación:  </label> <i >${data['response']['fecha_asigna']}</i> 
            </div>
           
            `);
        }
        if(data['response']['estado_orden']=='F'){
            $('#btn_detalle').html(`<button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>`);
            $('#estado_detalle').html(`<span class='badge badge-success'><i class='fa fa-check-circle'></i> Finalizada</span>`);
        }

        if(data['response']['estado_orden']=='T'){
            btn_confirmacion='';
            
            $('#btn_detalle').html(`<button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>
                <button onclick="detalle_atencion('${data['response']['id_encrypt']}','${data['response']['tipo_orden']}')" id="btn_detalle_atencion" type="button" class="btn btn-success"> <i class="fa fa-eye"></i> Detalle atención </button>
                `);
            $('#estado_detalle').html(`<span class='badge badge-warning'><i class='fa fa-user'></i> Atendida</span>`);
            $('#div_asignacion').html(`<div class="col-md-5">
                <label >Técnico asignado: </label> <i> ${data['response']['tecnico']} </i> 
            </div>
            <div class="col-md-6">
                <label >Fecha asignación:  </label> <i >${data['response']['fecha_asigna']}</i> 
            </div>
            `);
           
            if(data['response']['tipo_orden']=='d' && data['response']['status_confirmado']==0 ){
                $('#div_cliente_confirmacion').html(`<b style='color:red'> En espera de confirmación del cliente para continuar con reparación.</b>`);
            }else{
                if(data['response']['status_confirmado']==1 ){
                    if(data['response']['confirmar']=='S' ){
                        if(data['response']['user_confirma']==null ){
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> El cliente aceptó la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }else{
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> Se confirma la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }
                    }else{
                        if(data['response']['user_confirma']!=null ){
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> El cliente no aceptó la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }else{
                            $('#div_cliente_confirmacion').html(`<b style='color:green'> No se procede con la reparación.</b> <br> <b>Observación:</b> ${data['response']['observacion_confirma']}
                                <br> <b>Fecha:</b> ${data['response']['fecha_confirma']}`);
                        }
                    }
                }
            }
            
        }

        if(data['response']['estado_orden']=='D'){
            if(data['response']['entregado']==1){
                $('#estado_detalle').html(`<span class='badge badge-danger'><i class='fa fa-times'></i> Anulada y entregada</span>`);
            }else{
                $('#estado_detalle').html(`<span class='badge badge-danger'><i class='fa fa-times'></i> Anulada sin entregar</span>`);
            }
            $('#btn_detalle').html(`<button onclick="regresar()" id="btn_regresar" type="button" class="btn btn-warning"> <i class="fa fa-arrow-left"></i> Regresar </button>`);
            $('#div_anulacion').html(`
                <div class="col-md-6">
                    <label >Fecha anula:  </label> ${data['response']['fecha_anula']}
                </div>
                <div class="col-md-6">
                    <label >Observación:  </label> ${data['response']['observacion_anulacion']}
                </div>
            `);
        }
        if(data['response']['tipo_orden']=='d'){
            $('#tipod_detalle').html('Diagnóstico');
        }

        if(data['response']['tipo_orden']=='r'){
            $('#tipod_detalle').html('Reparación');
        }

        if(data['response']['tipo_garantia']=='NA'){
            $('#garantia_detalle').html('No aplica');
        }
        if(data['response']['tipo_garantia']=='co'){
            $('#garantia_detalle').html('Compra');
        }
        if(data['response']['tipo_garantia']=='st'){
            $('#garantia_detalle').html('Servicio técnico');
        }

     

        $('#cedula_detalle').html(data['response']['identificacion']);
        $('#nombres_detalle').html(data['response']['nombres']);
        $('#direccion_detalle').html(data['response']['direccion']);
        $('#celular_detalle').html(data['response']['celular']);
        $('#email_detalle').html(data['response']['correo']);
        $('#modelo_detalle').html(data['response']['modelo']);
        $('#imei_detalle').html(data['response']['imei']);
        $('#estadomovil_detalle').html(data['response']['estado_celular']);

        if(data['response']['estado_encendido']=='En'){
            $('#encendido_detalle').html('Si');
        }else{
            $('#encendido_detalle').html('No (No se puede probar periféricos.)');
        }
        if(data['response']['tiene_clave']=='S'){ 
            if(data['response']['pin']==null || data['response']['pin']==''){
                $('#pin_detalle').html('Sin PIN');
            }else{
                $('#pin_detalle').html(data['response']['pin']);
            }
            $('#patron_detalle').html(`<img width='50%' src="${data['response']['patron']}">`);
        }else{
            $('#div_patron').hide();
            $('#pin_detalle').html('Sin clave');
        }
        

        $('#accesorios_detalle').html('');
        if(data['accesorios'].length>0){
            $.each(data['accesorios'], function(i, item) {
                // Verificar si es el último elemento
                var isLast = (i === data['accesorios'].length - 1);
                // Si no es el último, añade la coma, si es el último no la agrega
                $('#accesorios_detalle').append(`${item['accesorios']['descripcion']}${isLast ? '' : ', '}`);
            });
        }else{
            $('#accesorios_detalle').html('Sin accesorios');
        }
        $('#div_imagenes').html('');
        $('#tittle_imagenes').html('');
        if(data['imagenes'].length>0){
            $('#tittle_imagenes').html('<b>Ingreso de orden</b> <hr>');
            $.each(data['imagenes'], function(i, item) {
                $('#div_imagenes').append(` <br> <br>
                                            <div style="text-align: center;">
                                                <p style="margin: 0; font-weight: bold;">${item['descripcion']}</p>
                                                <a href="/imagenesorden/${item['ruta']}"><img width="120px" src="/imagenesorden/${item['ruta'] }" alt="img_orden" style="border: 1px solid #ccc;"></a>
                                                <br><br>
                                            </div> `);
            });
        }
 
        $('#div_imagenes_tecnico').html('');
        $('#tittle_imagenes_tecnico').html('');
        if(data['imagenes_tecnico'].length>0){
            $('#tittle_imagenes_tecnico').html('<hr><b>Diagnóstico o reparación</b> <hr>');
            $.each(data['imagenes_tecnico'], function(i2, item2) {
                $('#div_imagenes_tecnico').append(` <br> <br>
                                            <div style="text-align: center;">
                                                <p style="margin: 0; font-weight: bold;">${item2['descripcion']}</p>
                                                <a href="/imagenesorden/${item2['ruta']}"><img width="120px" src="/imagenesorden/${item2['ruta'] }" alt="img_orden" style="border: 1px solid #ccc;"></a>
                                                <br><br>
                                            </div> `);
            });
        }
        $('#obsgeneral_detalle').html(data['response']['observacion_inicio']);
        $('#obstecnico_detalle').html(data['response']['observacion_para_tecnico']);

       
        
        $('#div_lista').hide();
        $('#div_detalle').show(200);
        
        cargando();
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al obtener registros','error');
        cargando();
    });
}

function regresar(){
    $('#div_lista').show();
    $('#div_detalle').hide(200);
}

function modal_qr_imagen(id,codigo,nivel='I'){
    cargando('m','Cargando...');
    $.get('/orden/qr_imagen/'+id+'/'+nivel,function(data){
        if(data['status']=='failed'){
            mensaje_notificacion(data['response'],'error');
            cargando();
            return;
        }
        $('#title_qr').html(`QR Imagenes orden ${codigo}`);
        $('#div_qr').html(`<br>
            Puede escanerar el QR para subir las fotos del movil o acceder directamente en el botón cargar imagenes.</b><br>
            <img src="data:image/png;base64,${data['response']['img']}"><br>
            <a target='_blank' type="button" class="btn btn-warning btn-sm" href="${data['response']['url']}">
                <i class="fa fa-upload"></i> Cargar imagenes
            </a>
        `);
        $('#modal_qr').modal('show');
        cargando();
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al obtener registros','error');
        cargando();
    });
}
function cargar_incidencias(idorden){
    $("#table_historial_incidencias").DataTable().destroy();
    $("#table_historial_incidencias tbody").empty();
    cargando('m','Por favor espere...');
    $.get('/orden/lista_incidencias/'+idorden,function(resultado){
        if(resultado['status']=='error'){
            mensaje_notificacion(resultado['response'],resultado['status']);
            cargando();
            return;
        }
        $.each(resultado['response'],function(i,value){
                notificado='';
                if(value['correo_cliente']=='S' && value['correo_usuario']=='S'){
                    notificado='Cliente, usuario y administradores';
                }
                if(value['correo_cliente']=='S' && value['correo_usuario']=='N'){
                    notificado='Cliente y administradores';
                }
                if(value['correo_cliente']=='N' && value['correo_usuario']=='S'){
                    notificado='Usuario y administradores';
                }
                if(value['correo_cliente']=='N' && value['correo_usuario']=='N'){
                    notificado='Administradores';
                }
            $("#body_historial_incidencias").append(`        
                <tr>
                    <td align='center' width='1%' >${i+1}
                    </td>
                    <td width='5%'>${value['fecha']}
                    </td>
                    <td width='10%'>${value['usuario']} <br>
                        <small><b>Notificado:</b> ${notificado} </small>
                    </td>
                    <td width='15%'>${value['descripcion']}
                    </td>
                </tr>
            `);

        });
        $('[data-toggle="tooltip"]').tooltip(); 
        cargar_estilos_tabla("table_historial_incidencias", "desc",1);
        cargando();

        $('#modal_incidencia').modal('show');
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al cargar historial','error');
        cargando();
    });
}

function modal_incidencia(idorden){
    $('#idordenincidencia_encrypt').val(idorden);
    $('#descripcion_incidencia').val('');
    $('#correo_usuario').prop('checked',false);
    $('#correo_cliente').prop('checked',false);
    cargar_incidencias(idorden);
}

$('#form_reportar_incidencia').submit(function(e){
    e.preventDefault();
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/reportar_incidencia',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }
            cargar_incidencias(data['idorden']);
            mensaje_notificacion(data['response'], data['status']);
            $('#descripcion_incidencia').val('');
            $('#correo_usuario').prop('checked',false);
            $('#correo_cliente').prop('checked',false);

            cargando();
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});
function modal_atender(id,tipoorden,confirmar){
    $('#idordenatender_encrypt').val(id);
    $('#title_atender').html($('#tipod_detalle').text());
    if(tipoorden=='r'){
        //si es reparacion verificar si tiene algun tipo de diagnostico
        if(confirmar=='S'){
            cargando('m','Cargando...');
            $.get('/orden/detalle_atencion/'+id+'/'+'d',function(data){
                if(data['status']=='failed'){
                    mensaje_notificacion(data['response'],'error');
                    cargando();
                    return;
                }
                $('#costo_tecnico').val(data['response']['costo_tecnico']);
                $('#costo_local').val(data['response']['costo_local']);
                $('#costo_total').val(data['response']['costo_total']);
                $('#diagnostico_atendido').html(`<b>Diagnóstico:</b> ${data['response']['observacion_diagnostico']}<hr>`);

                cargando();
            }).fail(function(){
                mensaje_notificacion('Inconvenientes al obtener registros','error');
                cargando();
            });
        }
        $('#costo_tecnico').val('0.00');
        $('#costo_local').val('0.00');
        $('#costo_total').val('0.00');
        $('#div_tiempo_atencion').hide();
    }else{
        $('#dia_atender').val('0');
        $('#horas_atender').val('0');
        $('#minutos_atender').val('0');
        $('#div_tiempo_atencion').show();
        $('#costo_tecnico').val('0.00');
        $('#costo_local').val('0.00');
        $('#costo_total').val('0.00');
    }
    //limpiar los campos
    $('#observacion_tecnico_atender').val('');
   
    $('#modal_atender').modal('show');

      
}

function modal_anular(id){
    $('#idordenanular_encrypt').val(id);
    $('descripcion_anular').val('');
    $('#modal_anular').modal('show');
}

$('#form_atender').submit(function(e){

    e.preventDefault();
    var costoTecnico = parseFloat($('#costo_tecnico').val());
    var costoLocal = parseFloat($('#costo_local').val());
    if((costoTecnico+costoLocal)>$('#costo_total').val()){
        mensaje_notificacion('El costo total no debe ser inferior a la suma de costo técino y costo de repuesto', 'warning');
        return;

    }
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/atender',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }

            mensaje_notificacion(data['response'], data['status']);
            $('#modal_atender').modal('hide');
            regresar();
            cargar_ordenes();
            cargando();
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

$('#form_anular').submit(function(e){
    e.preventDefault();
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/anular',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }

            mensaje_notificacion(data['response'], data['status']);
            $('#modal_anular').modal('hide');
            regresar();
            cargar_ordenes();
            cargando();
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

$('#dia_atender').on('input', function() {
    // Eliminar caracteres no numéricos
    this.value = this.value.replace(/[^0-9]/g, '');

    // Limitar el valor a un rango entre 1 y 23
    if (this.value !== '' && (parseInt(this.value) < 0 )) {
        this.value = '';  // Si el valor está fuera de rango, lo limpia
    }
    if (this.value === '') {
        this.value = '0';
    }
});
$('#dia_atender').on('focus', function() {
    // Al hacer clic en el input o al poner el foco, borrar el valor
    if (this.value === '0') {
        this.value = '';
    }
});
$('#dia_atender').on('blur', function() {
    // Si el campo está vacío al salir (blur), volver a poner 0
    if (this.value === '') {
        this.value = '0';
    }
});
$('#horas_atender').on('input', function() {
    // Eliminar caracteres no numéricos
    this.value = this.value.replace(/[^0-9]/g, '');

    // Limitar el valor a un rango entre 1 y 23
    if (this.value !== '' && (parseInt(this.value) < 0 || parseInt(this.value) > 23)) {
        this.value = '';  // Si el valor está fuera de rango, lo limpia
    }
    if (this.value === '') {
        this.value = '0';
    }
});
$('#horas_atender').on('focus', function() {
    // Al hacer clic en el input o al poner el foco, borrar el valor
    if (this.value === '0') {
        this.value = '';
    }
});
$('#horas_atender').on('blur', function() {
    // Si el campo está vacío al salir (blur), volver a poner 0
    if (this.value === '') {
        this.value = '0';
    }
});
$('#minutos_atender').on('input', function() {
    // Eliminar caracteres no numéricos
    this.value = this.value.replace(/[^0-9]/g, '');

    // Limitar el valor a un rango entre 1 y 23
    if (this.value !== '' && (parseInt(this.value) < 0 || parseInt(this.value) > 59)) {
        this.value = '';  // Si el valor está fuera de rango, lo limpia
    }
});
$('#minutos_atender').on('focus', function() {
    // Al hacer clic en el input o al poner el foco, borrar el valor
    if (this.value === '0') {
        this.value = '';
    }
});
$('#minutos_atender').on('blur', function() {
    // Si el campo está vacío al salir (blur), volver a poner 0
    if (this.value === '') {
        this.value = '0';
    }
});
$('#costo_tecnico').on('input', function() {
    // Permitir solo números y un único punto decimal
    this.value = this.value.replace(/[^0-9.]/g, '');  // Elimina todo lo que no sea número o punto

    // Permitir solo un punto decimal
    if ((this.value.match(/\./g) || []).length > 1) {
        this.value = this.value.replace(/\.(?=.*\.)/, '');  // Eliminar puntos adicionales
    }

    // Limitar a dos decimales
    if (this.value.indexOf('.') !== -1) {
        // Si existe un punto, recortar el valor a dos decimales
        this.value = this.value.replace(/(\.\d{2})\d+/, '$1');
    }

    // Si el valor es vacío, dejarlo vacío
    if (this.value === '') {
        this.value = '';
    }
});
$('#costo_tecnico').on('focus', function() {
    // Al hacer clic en el input o al poner el foco, borrar el valor
    if (this.value === '0.00') {
        this.value = '';
    }
});
$('#costo_tecnico').on('blur', function() {
    // Si el campo está vacío al salir (blur), volver a poner 0
    if (this.value === '') {
        this.value = '0.00';
    }
});

$('#costo_local').on('input', function() {
    // Permitir solo números y un único punto decimal
    this.value = this.value.replace(/[^0-9.]/g, '');  // Elimina todo lo que no sea número o punto

    // Permitir solo un punto decimal
    if ((this.value.match(/\./g) || []).length > 1) {
        this.value = this.value.replace(/\.(?=.*\.)/, '');  // Eliminar puntos adicionales
    }

    // Limitar a dos decimales
    if (this.value.indexOf('.') !== -1) {
        // Si existe un punto, recortar el valor a dos decimales
        this.value = this.value.replace(/(\.\d{2})\d+/, '$1');
    }

    // Si el valor es vacío, dejarlo vacío
    if (this.value === '') {
        this.value = '';
    }
});
$('#costo_local').on('focus', function() {
    // Al hacer clic en el input o al poner el foco, borrar el valor
    if (this.value === '0.00') {
        this.value = '';
    }
});
$('#costo_local').on('blur', function() {
    // Si el campo está vacío al salir (blur), volver a poner 0
    if (this.value === '') {
        this.value = '0.00';
    }
});

$('#costo_local').on('input', function() {
    // Permitir solo números y un único punto decimal
    this.value = this.value.replace(/[^0-9.]/g, '');  // Elimina todo lo que no sea número o punto

    // Permitir solo un punto decimal
    if ((this.value.match(/\./g) || []).length > 1) {
        this.value = this.value.replace(/\.(?=.*\.)/, '');  // Eliminar puntos adicionales
    }

    // Limitar a dos decimales
    if (this.value.indexOf('.') !== -1) {
        // Si existe un punto, recortar el valor a dos decimales
        this.value = this.value.replace(/(\.\d{2})\d+/, '$1');
    }

    // Si el valor es vacío, dejarlo vacío
    if (this.value === '') {
        this.value = '';
    }
});

$('#costo_total').on('input', function() {
    // Permitir solo números y un único punto decimal
    this.value = this.value.replace(/[^0-9.]/g, '');  // Elimina todo lo que no sea número o punto

    // Permitir solo un punto decimal
    if ((this.value.match(/\./g) || []).length > 1) {
        this.value = this.value.replace(/\.(?=.*\.)/, '');  // Eliminar puntos adicionales
    }

    // Limitar a dos decimales
    if (this.value.indexOf('.') !== -1) {   
        // Si existe un punto, recortar el valor a dos decimales
        this.value = this.value.replace(/(\.\d{2})\d+/, '$1');
    }

    // Si el valor es vacío, dejarlo vacío
    if (this.value === '') {
        this.value = '';
    }
});
$('#costo_total').on('focus', function() {
    // Al hacer clic en el input o al poner el foco, borrar el valor
    if (this.value === '0.00') {
        this.value = '';
    }
});
$('#costo_total').on('blur', function() {
    // Si el campo está vacío al salir (blur), volver a poner 0
    if (this.value === '') {
        this.value = '0.00';
    }
});

function detalle_atencion(id,tipo){
    cargando('m','Cargando...');
    $.get('/orden/detalle_atencion/'+id,function(data){
        if(data['status']=='failed'){
            mensaje_notificacion(data['response'],'error');
            cargando();
            return;
        }
        if(tipo=='d'){
            $('#div_tiempo').show();
        }else{
            $('#div_tiempo').hide();
        }
        $('#div_form_atencion').html('');
        $.each(data['response'],function(i,item){
            tipo='Diagnóstico';
            tiempo='';
            if(item['tipo_orden']=='r'){
                tipo='Reparación';
            }
            if(item['tipo_orden']=='d'){
                tiempo=`<b>Tiempo:</b> ${item['dias']} días ${item['horas']} horas ${item['minutos']} minutos`;
            }
            $('#div_form_atencion').append(`
                <div class="form-group">
                    <div class="row">
                        <div class="col-md-12">
                            <b style='color:blue'>${tipo}</b>
                            <hr>
                            <div style='margin-left:20px'>
                                <b>Fecha atención:</b>  ${item['fecha_atiende']} <br>
                                <b>Observación:</b>  ${item['observacion_diagnostico']} <br>
                                <b>Costo:</b>  $${item['costo_total']} <br>
                                <b>Técnico:</b>  ${item['useratiende']['name']} <br>
                                ${tiempo} 
                                
                            </div>
                        </div>
                    </div>
                </div> <hr>
            `);
        });

        $('#atencion_observacion').html(`<b>Observación: </b> ${data['response']['observacion_diagnostico']}`);
        $('#atencion_tiempo').html(`<b>Tiempo: </b> ${data['response']['dias']} días ${data['response']['horas']} horas ${data['response']['minutos']} minutos`);
        $('#atencion_costo').html(`<b>Costo: </b> ${data['response']['costo_total']}`);
        $('#atencion_fecha').html(`<b>Fecha atención: </b> ${data['response']['fecha_atiende']}`);

        $('#modal_detalle_atencion').modal('show');
        cargando();
    }).fail(function(){
        mensaje_notificacion('Inconvenientes al obtener registros','error');
        cargando();
    });
}

// function actualizarCostoTotal() {
//     // Obtener los valores de los campos
//     var costoTecnico = parseFloat($('#costo_tecnico').val()) || 0; // Usar 0 si no es un número válido
//     var costoLocal = parseFloat($('#costo_local').val()) || 0; // Usar 0 si no es un número válido

//     // Calcular el costo total
//     var costoTotal = costoTecnico + costoLocal;

//     // Mostrar el costo total en el campo correspondiente, con 2 decimales
//     $('#costo_total').val(costoTotal.toFixed(2));
// }
// Escuchar cambios en los campos costo_tecnico y costo_local
// $('#costo_tecnico, #costo_local').on('input', function() {
//     actualizarCostoTotal();
// });
// Inicializar el costo total al cargar la página
// $(document).ready(function() {
//     actualizarCostoTotal();
// });



 