$('#form_orden').submit(function(e){
    e.preventDefault();
    if($('#filtro').val()=='C' && $('#cedula_nombres').val()==''){
        mensaje_notificacion('Por favor ingrese datos del cliente','warning');
        return;
    }
    if($('#filtro').val()=='O' && $('#codigo').val()==''){
        mensaje_notificacion('Por favor ingrese datos de la orden','warning');
        return;
    }
    $('#result').hide();

    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/filtro_grafico',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error' || data['status']=='warning'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }
            $('#ordenes_total').html(data['response']['total']);
            $('#ordenes_sinasignar').html(data['response']['sinasignar']);
            $('#ordenes_asignadas').html(data['response']['asignadas']);
            $('#ordenes_entregadas').html(data['response']['entregadas']);
            $('#ordenes_anuladas').html(data['response']['anuladas']);
            $('#clientes_total').html(data['response']['clientes']);
            $('#ordenes_atendidas').html(data['response']['atendidas']);

            $('#ventas_totales').html(data['response']['costo_total']);
            $('#gastos_tecnicos').html(data['response']['costo_tecnico']);
            $('#gastos_repuestos').html(data['response']['costo_repuesto']);
            $('#ganancia').html(data['response']['ganancia']);

            $('#result').show(200);

            cargando();
            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

function modal_detalle_orden(estado){
    cargando('m','Por favor espere...')
    $("#table_ordenes").DataTable().destroy();
    $("#table_ordenes tbody").empty();
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/orden/filtro_grafico_detalle',
        data: $('#form_orden').serialize() + '&estado=' + encodeURIComponent(estado),
        success: function(data){
            if (data['status'] == 'failed') {
                        mensaje_notificacion(data['response'], 'error');
                        cargando();
                        return;
                    }
                    $.each(data['response'], function (index, value) {
                        $("#body_ordenes").append(`
                                <tr>
                                    <td width='5%'><a target='_blank' href="/orden/indexdetalle/${btoa(value['id'])}">${value['codigo']}</a><br>
                                    </td>
                                    <td width='15%'>${value['tipo_orden_texto']}<br>
                                    </td>
                                </tr>
                            `);
                    });
                    $('#modal_datos').modal('show');
                cargar_estilos_tabla("table_ordenes", "desc",1);
                    cargando();
        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
}





