$(document).ready(function() {
    // Evento de clic para el primer botón
    // $("#btn1").click(function() {
    //     $("#frm_buscar").attr("action", "/reportes/filtrofechas");
    //     $("#frm_buscar").submit(); // Envía el formulario
    // });

    // Evento de clic para el segundo botón
    // $("#btn3").click(function() {
    //     $("#frm_buscar").attr("action", "/reportes/filtrar_report_excel");
    // });
});

$('#form_buscar').submit(function(e){
    e.preventDefault();
    $('#div_tabla_registros').hide();
    cargando('m','Por favor espere...')
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        type: "POST",
        url: '/reportes/filtrofechas',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData:false,
        success: function(data){
            
            if(data['status']=='error' || data['status']=='warning'){
                mensaje_notificacion(data['response'], data['status']);
                cargando();
                return;
            }
            $('#div_tabla_registros').show(200);
            cargar_ordenes(data);
            cargando();

            return;

        },
        error: function(e){
            mensaje_notificacion('Inconvenientes al procesar solicitud intente nuevamente', "error");
            cargando();
            return;
        }
    });
});

function cargar_ordenes(resultado){
        $("#table_ordenes").DataTable().destroy();
        $("#table_ordenes tbody").empty();
        var total=0;
        $.each(resultado['response'],function(i,value){
            var tipo='Reparación';
            var estado='';
            var observacion_anula='';
            var garantia='No aplica';
            if(value['tipo_orden']=='d'){
                tipo='Diagnósito'
                value['material']='0.00';
                value['costo_tecnico']='0.00';
                value['costo_total']='0.00';
                value['efectivo']='0.00';
                value['transferencia']='0.00';
                value['trajeta_credito']='0.00';
            }
            if(value['estado_orden']=='D'){
                estado=`<b style='color:red' >Anulada</b>`;
                value['material']='0.00';
                value['costo_tecnico']='0.00';
                value['costo_total']='0.00';
                value['efectivo']='0.00';
                value['transferencia']='0.00';
                value['trajeta_credito']='0.00';
                observacion_anula=`<b>Anulación:</b> ${value['observacion_anulacion']}`;
                value['observacion_diagnostico']='---';
            };
            if(value['costo_total']==null){
                console.log(value['id']);
            }
            if(value['tipo_garantia']=='co'){
                garantia='Compra';
            };
            if(value['tipo_garantia']=='st'){
                garantia='Servicio técnico';
            };

            
            total=total+parseFloat(value['costo_total'])-parseFloat(value['material'])-parseFloat(value['costo_tecnico']);
            $("#body_ordenes").append(`        
                <tr>
                    <td width='15%'>${value['local']} - ${value['dir_local']}
                    </td>
                    <td width='5%'>${value['codigo']} <br> <small><b>${tipo}</b></small>
                     </td>
                    <td width='15%'> <small><b>Ingresa: </b>${value['fecha']} <br> <b>Entrega: </b>${value['fecha_entrega']} <br> ${estado} </small>  
                     </td>
                
                    <td><small><b><i class='fa fa-user'></i> </b>${value['identificacion']}<br>
                        <b><i  class='fa fa-circle'></i>  </b>${value['nombres']}
                        </small>
                    </td>
                    <td>
                        <small><b>Modelo: </b>${value['modelo']} <br> <b>IMEI: </b>${value['imei']} <br> <b>Garantía: </b> ${garantia} </small>  
                    </td>
                    <td>
                        <small><b>Ingreso: </b>${value['observacion_inicio']} <br> <b>Atención: </b>${value['observacion_diagnostico']}
                        <br> <b>Entrega: </b>${value['observacion_entrega']} <br> ${observacion_anula}
                        
                        </small>  
                    </td>
                    <td>
                        <small><b>Repuestos:</b> ${value['material']} <br> <b>Técnico:</b> ${value['costo_tecnico']} 
                        <br> <b>Total:</b> ${value['costo_total']} 
                        <br> <b>Utilidad:</b> ${parseFloat(value['costo_total']-value['material']-value['costo_tecnico']).toFixed(2)} 
                        </small>  
                    </td>
                    <td>
                        <small><b>Efvo:</b> ${value['efectivo'] ? value['efectivo'] : '0.00'}
                        <br> <b>Trans:</b> ${value['transferencia'] ? value['transferencia'] : '0.00'} 
                        <br> <b>TDC:</b>  ${value['tarjeta_credito'] ? value['tarjeta_credito'] : '0.00'} 
                        <br> <b>Payphone:</b> ${value['payphone'] ? value['payphone'] : '0.00'}  </small>
                    </td>
                    
                </tr>
            `);

        });
        $('#total_utilidad').html(`<b>Total utilidad: ${total.toFixed(2)}</b>`);
        $('[data-toggle="tooltip"]').tooltip(); 
            cargar_estilos_tabla("table_ordenes", "desc",2);
       
}

function generarexcel(){
    var fechaDesde = $("#fecha_desde").val();
    var fechaHasta = $("#fecha_hasta").val();
    var FrmData = {};

    $.each($("#form_buscar").serializeArray(), function(_, field) {
        FrmData[field.name] = field.value;
    });

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    cargando("M", "Generando Excel, espere...");

    $.ajax({
        url: '/reportes/filtrar_report_excel', // Ruta para el Excel
        method: "POST",
        data: FrmData,
        xhrFields: {
            responseType: 'blob' // Recibir el archivo como binario
        },
        success: function(response) {
            cargando();
            // Descargar el Excel
            var blob = new Blob([response], { type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" });
            var link = document.createElement("a");
            var fileName = "Reporte_" + fechaDesde + "_al_" + fechaHasta + ".xlsx";
            link.href = window.URL.createObjectURL(blob);
            link.download = fileName;
            link.click();
        },
        error: function() {
            mensaje_notificacion('Error al generar el Excel, inténtelo más tarde', 'error');
            cargando();
        }
    });

}

function generarpdf(){
    var fechaDesde = $("#fecha_desde").val();
    var fechaHasta = $("#fecha_hasta").val();
    var FrmData = {};
    $.each($("#form_buscar").serializeArray(), function(_, field) {
        FrmData[field.name] = field.value;
    });
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    cargando("M", "Espere...");

    $.ajax({
        url: '/reportes/filtrar_report_pdf',
        method: "POST",
        data: FrmData,
        // type: "json",
        xhrFields: {
            responseType: 'blob' // Recibir el PDF como blob
        },
        success: function (response)
        {
            cargando();
                // Descargar el PDF
                var blob = new Blob([response], { type: "application/pdf" });
                var link = document.createElement("a");
                var fileName = "Reporte_" + fechaDesde + "_al_" + fechaHasta + ".pdf";
                link.href = window.URL.createObjectURL(blob);
                link.download = fileName;
                link.click();
        },error: function(){
            mensaje_notificacion('Error al realizar la solicitud, inténtelo más tarde','error');
            cargando();
        }
    });

}

