@extends('layouts.head')

@section('content')

    <div class="content-wrapper">
        <section class="content">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12">
                        <div class="card card-color row">
                                <div class="card-header" >
                                    <h3 style="color:white" class="card-title"><b>REGISTRO DE USUARIOS DE SISTEMA </b> </h3>
                                </div>
                                <form id="form_usuario"  method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <input type="hidden" id="idedit" name="idedit">
                                    
                                    <div class="card-body">
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label for="cedula">Cédula *</label>
                                                    <input type="number" class="form-control" id="cedula" name="cedula" placeholder="Ingrese cédula" required>
                                                </div>
                                                <div class="col-md-6">
                                                    <label for="nombre">Nombre y apellidos *</label>
                                                    <input type="text" class="form-control" id="nombres" name="nombres" placeholder="Ingrese nombre y apellidos" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label for="celular">Celular</label>
                                                    <input type="text" class="form-control" id="celular" name="celular" placeholder="Celular">
                                                </div>
                                                <div class="col-md-6">
                                                    <label for="correo">Correo *</label>
                                                    <input type="email" class="form-control" id="correo" name="correo" placeholder="ejemplo@gmail.com" required>
                                                </div>                                           
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label for="Local">Locales *</label>
                                                    <select  data-placeholder="Seleccione los locales" multiple name="local[]" id="local" class="form-control chosen-select select">
                                                        @if(isset($locales))
                                                            <option value=""></option>
                                                            <option value="T">Seleccionar todos</option>
                                                            @foreach($locales as $value)
                                                                <option class="optionlocal" value="{{$value['id']}}">{{$value['descripcion']}} - {{$value['direccion']}}</option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                </div>
                                                <div class="col-md-6">
                                                    <label for="rol">Rol</label>
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <input style="cursor:pointer" checked name="rol" id="ES" value="ES" type="radio" required>
                                                            <label style="cursor:pointer" for="ES" class="form-check-label">Estándar</label>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <input style="cursor:pointer" name="rol" id="TE" value="TE" type="radio" required>
                                                            <label style="cursor:pointer" for="TE" class="form-check-label">Técnico</label>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <input style="cursor:pointer" name="rol" id="AD" value="AD" type="radio" required>
                                                            <label style="cursor:pointer" for="AD" class="form-check-label">Administrador</label>
                                                        </div>
                                                    </div>
                                                </div>
                                        </div>
                                    </div>
                                    <div class="card-footer" id="btn_footer">
                                        <button type="submit" class="btn btn-color"> <i class="fa fa-save"></i> Registrar</button>
                                    </div>
                                </form>
                        </div>
                        <hr>
                        
                        <div class="container-fluid">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="table-responsive">
                                                <table id="table_usuarios" class="table table-striped table-bordered dataTable no-footer" style="width:100%">
                                                    <thead>
                                                        <tr align="center"> 
                                                            <th>Cédula</th>
                                                            <th>Nombres</th>
                                                            <th>Contacto</th>
                                                            <th>Locales</th>
                                                            <th>Estado</th>
                                                            <th>Acciones</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="body_usuarios">
                                                        
                                                                                            
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
                <hr>
                
            </div>
        </section>
    </div>

        <!-- Modal Menu -->
        <div class="modal fade" id="modal_gestion_opcion" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" >
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Agregar Opciones al usuario</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-bs-dismiss="modal">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        
                        <div id="tabla_opciones"></div>
    
                    </div>
                </div>
            </div>
        </div>

    <script src="{{asset('js/administracion/registrousuarios.js?v='.rand())}}"></script>

@endsection
