<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta property="og:title" content="CELULAR PLANET"/>
  <meta property="og:description" content="CELULAR PLANET"/>
  <meta property="og:url" content="https://celularplanet.ec/"/> <!-- Reemplaza con la URL real de tu página -->
  <meta name="twitter:card" content="summary_large_image"/>
  <meta name="twitter:title" content="CELULAR PLANET"/>
  <meta name="twitter:description" content="CELULAR PLANET"/>
  <title>CELULAR PLANET</title>

  <meta name="csrf-token" content="{{ csrf_token() }}">
  <link href="{{ asset('fontawesome/font-awesome.css') }}" rel="stylesheet">
  <link rel="stylesheet" href="{{asset('/plantilla/css/adminlte.min.css') }}">
  <link href="{{asset('pnotify/dist/pnotify.css')}}" rel="stylesheet">
  <link href="{{asset('pnotify/dist/pnotify.buttons.css')}}" rel="stylesheet">
  <link href="{{asset('pnotify/dist/pnotify.nonblock.css')}}" rel="stylesheet">
  <link rel="stylesheet" href="{{asset('/plantilla/plugins/select2/css/select2.min.css')}}">
  <link rel="stylesheet" href="{{asset('/plantilla/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')}}">
  <link rel="stylesheet" type="text/css" href="{{asset('DataTables/datatables.min.css')}}"/> 
  <link rel="stylesheet" href="{{asset('sweetalert/sweetalert.css')}}">
  <script src="{{ asset('js/app.js') }}"></script>
  <script src="{{asset('js/jquery.min.js')}}"></script>
</head>
<body >
        <section class="content">
            <div class="container-fluid">
                <div class="row   justify-content-center">
                    <div class="col-md-6">
                        <div class="card card-color row">
                                <div class="card-header" align='center' >
                                <img width="13%" src="/images/logo.png" alt="logo">
                                </div>
                                <div id='div_form'>
                                    <form id="form_imagen_orden" action="/orden/guardar_imagen"  style='font-size:12px'  method="POST" enctype="multipart/form-data">
                                        {{ csrf_field() }}
                                        @if(session()->has('mensaje'))
                                            <script>
                                                $(document).ready(function() {
                                                    mensaje_notificacion('{{session('mensaje')}}','{{session('status')}}');
                                                });
                                            </script>
                                        @endif
                                        <input type="hidden" name='estado_orden' id='estado_orden' value="{{encrypt($data['estado_orden'])}}">
                                        <input type="hidden" name='id_orden' id='id_orden' value="{{encrypt($data['idorden'])}}">
                                        <div class="card-body">
                                            <b>REGISTRO DE IMAGENES ORDEN {{$data['codigo']}} | {{$data['local']}}</b>
                                            <hr>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <p ><b>Cédula:</b> {{$data['identificacion']}}</p>
                                                        <p ><b>Cliente:</b> {{$data['nombres']}}</p>
                                                        <p ><b>Accesorios:</b>
                                                            @if(sizeof($accesorios)>0)
                                                                @foreach($accesorios as $key => $value)
                                                                    {{$value['accesorios']['descripcion']}}
                                                                    @if(!$loop->last) 
                                                                        ,
                                                                    @endif
                                                                @endforeach
                                                            @else
                                                                Sin accesorios
                                                            @endif
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                    <label for="">Descripción:</label>

                                                        <input type="text" class='form-control' placeholder='Ingrese descripción' id='descripcion' name='descripcion' value='Foto' required>                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                    <label >Imagen:</label>
                                                        <input type="file" class="form-control" id="imagen" name="imagen[]" multiple required accept="image/*">
                                                    </div>
                                                </div>
                                            </div>
                                        
                                        </div>
                                        <div class="card-footer" id="btn_footer">
                                            <button type="submit" class="btn btn-primary btn-sm" > <i class="fa fa-save"></i> Guardar imagen</button>
                                        </div>
                                    </form>
                                </div>
                                <div id='div_imagenes' > <br>
                                @if(isset($images))
                                    <div  style="display: flex; flex-wrap: wrap; gap: 10px;"> <!-- Contenedor flexible -->
                                    @foreach($images as $value)
                                        <br> <br>
                                            <div style="text-align: center;"> <!-- Contenedor para cada imagen y descripción -->
                                                <p style="margin: 0; font-weight: bold;">{{ $value['descripcion'] }}</p>
                                                <a href="/imagenesorden/{{ $value['ruta'] }}"><img width="120px" src="/imagenesorden/{{ $value['ruta'] }}" alt="d" style="border: 1px solid #ccc;"></a>
                                                <br><br>
                                            </div> 
                                        @endforeach
                                    </div>
                                @endif
                                </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </section>


    <script>
        $(document).ready(function () {
            const input = $('#descripcion');

            input.val('Foto'); // Valor por defecto

            input.focus(function () {
                if ($(this).val() === 'Foto') {
                    $(this).val('');
                }
            });

            input.blur(function () {
                if ($(this).val().trim() === '') {
                    $(this).val('Foto');
                }
            });
        });
    </script>
    <script src="/plantilla/js/adminlte.js"></script>
    <script src="{{asset('js/gestiones/ordenes/cargar_imagen.js?v='.rand())}}"></script>
</body>
</html>
