@extends('layouts.head')

@section('content')

    <div class="content-wrapper">
        <section class="content" id='div_lista' >
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12">
                        <div class="card card-color ">
                            <div class="card-header" >
                                <h3 style="color:white" class="card-title"><b>Ordenes pendientes</b> @if(auth()->user()['tipo']!='AD') | <small>{{session('descripcion_local')}} @endif</small> </h3>
                            </div>
                            <div class="card-body">
                                @if(auth()->user()['tipo']=='AD')
                                    <div class='row'>
                                        <div class='col-md-6'>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-md-12 d-flex align-items-center">
                                                        <div class='col-md-1'>
                                                            <label for="estado" class="mr-2">Local: </label>
                                                        </div>
                                                        <div class='col-md-6'>
                                                            <select    name="local" id="local" class="form-control chosen-select ">
                                                                @if(isset($locales))
                                                                    <option value='T'>Todos</option>
                                                                    @foreach($locales as $value)
                                                                        <option class="optionlocal" value="{{encrypt($value['id'])}}">{{$value['descripcion']}} - {{$value['direccion']}}</option>
                                                                    @endforeach
                                                                @endif
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                @endif
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="table-responsive">
                                            <table id="table_ordenes" class="table table-striped table-bordered dataTable no-footer" style="width:100%">
                                                <thead>
                                                    <tr align="center"> 
                                                  
                                                        @if(auth()->user()['tipo']=='AD')<th>Local</th>@endif
                                                        <th>Fecha</th>
                                                        <th>Código</th>
                                                        <th>Cliente</th>
                                                        <th>Estado</th>
                                                        <th >Acciones</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="body_ordenes">
                                                    
                                                                                        
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section id="div_detalle" style='display:none' class="content">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12">
                        <div class="card card-color row">
                                <div class="card-header" >
                                    <h3 style="color:white" id="title_head" class="card-title"><b>DETALLES </b> </h3>
                                </div>
                                <form>
                                    <div class="card-body">
                                        <div id="dato_plan">
                                            <div class="form-group">
                                              
                                                <div class="row" style='font-size:12px'>
                                                    <div class="col-md-2">
                                                        <label >Código:  </label> <i id="codigo_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label >Fecha recibe:  </label> <i id="fecha_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label >Estado:  </label> <i id="estado_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label >Tipo diagnóstico:  </label> <i id="tipod_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label >Garantía:  </label> <i id="garantia_detalle"></i> 
                                                    </div>
                                                </div>
                                                <div class="row" id='div_asignacion' style='font-size:12px'>
                                                    
                                                </div>
                                                
                                                <hr>
                                                    <b style='color:blue'>Información cliente</b>
                                                <hr>
                                                <div class="row" style='font-size:12px'>
                                                    <div class="col-md-3">
                                                        <label >Cédula:  </label> <i id="cedula_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-5">
                                                        <label >Nombres:  </label> <i id="nombres_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label >Dirección:  </label> <i id="direccion_detalle"></i> 
                                                    </div>
                                                </div>
                                                <div class="row" style='font-size:12px'>
                                                   
                                                    <div class="col-md-3">
                                                        <label >Celular:  </label> <i id="celular_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-5">
                                                        <label >Email:  </label> <i id="email_detalle"></i> 
                                                    </div>
                                                </div>
                                                <hr>
                                                    <b style='color:blue' >Información del equipo</b>
                                                <hr>
                                                <div class="row" style='font-size:12px'>
                                                    <div class="col-md-3">
                                                        <label >Modelo:  </label> <i id="modelo_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label >IMEI:  </label> <i id="imei_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label >Estado:  </label> <i id="estadomovil_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label >Encendido:  </label> <i id="encendido_detalle"></i> 
                                                    </div>
                                                </div>
                                                <div class="row" style='font-size:12px'>
                                                    <div class="col-md-3">
                                                        <label >Accesorios:  </label> <i id="accesorios_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label >PIN:  </label> <i id="pin_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-3" id='div_patron'>
                                                        <label >Patrón:  </label> <i id="patron_detalle"></i> 
                                                    </div>
                                                    
                                                </div>
                                                <hr>
                                                <div class="row" style='font-size:12px'>
                                                    <div class="col-md-6">
                                                        <label >Observación general:  </label> <i id="obsgeneral_detalle"></i> 
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label >Observación para técnico:  </label> <i id="obstecnico_detalle"></i> 
                                                    </div>
                                                </div>
                                                <hr>
                                                <div class="row" style='font-size:12px'>
                                                    <div class="col-md-12" id='div_cliente_confirmacion'>
                                                    </div>
                                                </div>
                                                <div class="row" id='div_anulacion' style='font-size:12px'>
                                                   
                                                </div>
                                                
                                            </div>
                                        </div>
                                        <hr>
                                       
                                        <div id='btn_detalle'>

                                        </div>
                                        
                                        <hr>
                                        <div class="form-group">
                                            <div class="row" style='font-size:12px'>
                                                <div class="col-md-12">
                                                    <div id='tittle_imagenes'></div>
                                                    <div  id='div_imagenes'  style="display: flex; flex-wrap: wrap; gap: 10px;"></div>
                                                </div>
                                            </div>
                                            <div class="row" style='font-size:12px'>
                                                <div class="col-md-12">
                                                    <div id='tittle_imagenes_tecnico'></div>
                                                    <div id='div_imagenes_tecnico'  style="display: flex; flex-wrap: wrap; gap: 10px;"></div>
                                                </div>
                                            </div>
                                            <div class="row" style='font-size:12px'>
                                                <div class="col-md-12">
                                                    <div id='tittle_imagenes_entrega'></div>
                                                    <div id='div_imagenes_entrega'  style="display: flex; flex-wrap: wrap; gap: 10px;"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Modal qr -->
    <div class="modal fade" id="modal_qr" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" >
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="title_qr">Qr Imagenes</h5>
                    <button type="button" class="close cerrar_modal" >
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="div_qr" align='center'>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal qr -->
    <div class="modal fade" id="modal_tecnicos" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" >
        <div class="modal-dialog modal-dialog modal-dialog-scrollable modal-sg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="title">Asignar técnico</h5>
                    <button type="button" class="close cerrar_modal" >
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="form_asignar_tecnico" style='font-size:12px'  method="POST" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <input type="hidden" name='idorden_encrypt' id='idorden_encrypt'>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-12">
                                        <label for="estado" class="mr-2">Técnico: </label>
                                        <select data-placeholder='Seleccionar técnico'  name="tecnicos" id="tecnicos" class="form-control chosen-select select ">
                                        </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-12">
                                <button type="button" onclick='asignar_tecnico()' class="btn btn-primary"> <i class="fa fa-save"></i> Asignar técnico</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default cerrar_modal"> <i class="fa fa-times"></i> Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal detalle atencion -->
    <div class="modal fade" id="modal_detalle_atencion" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" >
        <div class="modal-dialog modal-dialog modal-dialog-scrollable modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="title_detalle_atencion"><i class='fa fa-file'></i> Detalle atención</h5>
                    <button type="button" class="close cerrar_modal" >
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form  style='font-size:12px'  method="POST" enctype="multipart/form-data" id='div_form_atencion'>
                        
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default cerrar_modal"> <i class="fa fa-times"></i> Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_entregar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" >
        <div class="modal-dialog modal-dialog modal-dialog-scrollable modal-sg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" >Entregar orden</h5>
                    <button type="button" class="close cerrar_modal" >
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="form_entregar_orden" style='font-size:12px'  method="POST" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <input type="hidden" name='idorden_entregar_encrypt' id='idorden_entregar_encrypt'>
                        <input type="hidden" id='total_cobrar_valor' name='total_cobrar_valor'>
                        <input type="hidden" id='validar_cobro' name='validar_cobro'>
                        <p style='color:red;text-align:center' id='mensaje_imagen'></p>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-12">
                                    <label  class="mr-2">Observación (Opcional) </label>
                                    <textarea placeholder='Ingrese observación'  rows='3' name="observacion_entrega" id="observacion_entrega" class='form-control'></textarea>
                                </div>
                            </div>
                        </div>
                        <div id='div_cobro'>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-12" align='center'>
                                        <label  >Total cobrar: </label> <br>
                                        <b id='total_cobrar' style='font-size:20px;color:red'></b>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label>Efectivo: </label>
                                        <input value='0.00' name="efectivo" id="efectivo" class='form-control'></input>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Transferencia: </label>
                                        <input value='0.00' name="trasferencia" id="trasferencia" class='form-control'></input>
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label>Tarjeta de crédito: </label>
                                        <input value='0.00' name="tarjeta_credito" id="tarjeta_credito" class='form-control'></input>
                                    </div>
                                    <div class="col-md-6">
                                        <label>PayPhone: </label>
                                        <input value='0.00' name="payphone" id="payphone" class='form-control'></input>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-12" id='btn_botones_entrega'>
                                <button type="submit"  class="btn btn-primary"> <i class="fa fa-check-circle"></i> Entregar</button>

                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default cerrar_modal"> <i class="fa fa-times"></i> Cerrar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal confirmar reparación -->
    <div class="modal fade" id="modal_confirmar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" >
        <div class="modal-dialog modal-dialog modal-dialog-scrollable modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="title_confirmar"><i class='fa fa-check'></i> Confirmar</h5>
                    <button type="button" class="close cerrar_modal" >
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id='form_confirmar'  style='font-size:12px'  method="POST" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <input type="hidden" name='idordenconfirmar_encrypt' id='idordenconfirmar_encrypt'>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="estado" class="mr-2">Descripción: </label>
                                    <textarea placeholder='Ingrese descripción' required rows='3' name="descripcion_confirmar" id="descripcion_confirmar" class='form-control'></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input style="cursor:pointer" checked name="confirmar" id="si_confirmar" value="S" type="radio" required>
                                            <label style="cursor:pointer;color:green;font-weight:bold" for="si_confirmar" class="form-check-label">Acepta reparación</label>
                                        </div>
                                        <div class="col-md-6">
                                            <input style="cursor:pointer" name="confirmar" id="no_confirmar" value="N" type="radio" required>
                                            <label style="cursor:pointer;color:red;font-weight:bold" for="no_confirmar" class="form-check-label">No acepta reparación</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-12">
                                    <label style="color:blue">Al aceptar la reparación se le asignará automaticamante al técnico que realizó el diagnóstico.</label>
                                </div>
                            </div>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"> <i class="fa fa-save"></i> Guardar</button>
                    <button type="button" class="btn btn-default cerrar_modal"> <i class="fa fa-times"></i> Cerrar</button>
                </div>
                </form>

            </div>
        </div>
    </div>


    <script src="{{asset('js/gestiones/ordenes/ingresadas.js?v='.rand())}}"></script>


@endsection
