<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SISTEMA COACTIVA</title>
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <link rel="icon" href="{{asset('images/logohead.png')}}">
  <link href="{{ asset('fontawesome/font-awesome.css') }}" rel="stylesheet">
  <link rel="stylesheet" href="{{asset('/plantilla/css/adminlte.min.css') }}">
  <link href="{{asset('pnotify/dist/pnotify.css')}}" rel="stylesheet">
  <link href="{{asset('pnotify/dist/pnotify.buttons.css')}}" rel="stylesheet">
  <link href="{{asset('pnotify/dist/pnotify.nonblock.css')}}" rel="stylesheet">
  <link rel="stylesheet" href="{{asset('/plantilla/plugins/select2/css/select2.min.css')}}">
  <link rel="stylesheet" href="{{asset('/plantilla/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')}}">
  <link rel="stylesheet" type="text/css" href="{{asset('DataTables/datatables.min.css')}}"/> 
  <link rel="stylesheet" href="{{asset('sweetalert/sweetalert.css')}}">

  <script src="{{ asset('js/app.js') }}"></script>
  <script src="{{asset('js/jquery.min.js')}}"></script>
  
  <style>

    html {
      font-size: 14px; /* Ajusta el tamaño de letra según tus preferencias */
    }
      .card-color:not(.card-outline)>.card-header {
          background-color: #8b503b;
      }
      .btn-color {
          color: #fff;
          background-color: #8b503b;
          border-color: #8b503b;
          box-shadow: none;
      }
      .div_cargar{
        background-color:rgba(42, 63, 84, 0.5);
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 1050;
        display: none;
        overflow: hidden;
        -webkit-overflow-scrolling: touch;
        outline: 0;
    }
    .page{
        height: 100%;
    }

    .container-1{
        display: table;
        width: 100%;
        height: 100%;
    }

    .container-2{
        display: table-cell;
        vertical-align: middle;
        color: #fff;
    }
    
    .disabled_content{
        display:none !important;
    }

  </style>
</head>
<body class="hold-transition sidebar-mini layout-footer-fixed">
  <div class="wrapper">
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fa fa-bars"></i></a>
        </li>
      </ul>
      <ul class="navbar-nav ml-auto">
        <li class="nav-item">
            <a class="nav-link" data-widget="fullscreen" href="#" role="button">
                <i class="fa fa-expand"></i>
            </a>
        </li>
        <li class="nav-item dropdown">
          @guest
            <a  href="/login" class="nav-link" data-toggle="dropdown" href="#">
              <i class="fa fa-user"></i> Iniciar sesión
            </a>
          @else
            <a id="sesion" onclick="sesion()" class="nav-link" data-toggle="dropdown" href="#">
              <i class="fa fa-user"></i> {{auth()->user()->name}}
            </a>
            <div id="ulsesion" class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
              <div class="dropdown-divider"></div>
              <a  onclick="$('#modalperfil').modal('show');" class="dropdown-item">
                <i class="fa fa-user mr-2"></i>Perfil
              </a>
              <div class="dropdown-divider"></div>
              <a style="cursor:pointer" onclick="$('#modalclave').modal('show');lscampoclave();" class="dropdown-item">
                <i class="fa fa-key mr-2"></i> Cambiar clave
              </a>
              <div class="dropdown-divider"></div>
              <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="dropdown-item">
                <i class="fa fa-sign-out mr-2"></i> Cerrar sesión
              </a>
              <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                  {{ csrf_field() }}
              </form>
            </div>
          @endguest
        </li>
      </ul>
    </nav>
    <script type="text/javascript" src="{{asset('DataTables/datatables.min.js')}}"></script>
    <script>
      var lenguajeTabla = {
        "lengthMenu": "Mostrar _MENU_ registros por pagina",
        "zeroRecords": "No se encontraron resultados en su busqueda",
        "searchPlaceholder": "Buscar registros",
        "info": "Mostrando registros de _START_ al _END_ de un total de  _TOTAL_ registros",
        "infoEmpty": "No existen registros",
        "infoFiltered": "(filtrado de un total de _MAX_ registros)",
        "search": "Buscar:",
        "paginate": {
          "first": "Primero",
          "last": "Último",
          "next": "Siguiente",
          "previous": "Anterior"
        }
      };
      function cargar_estilos_tabla(idtabla,orden="desc",controlar=0,page=5){
        if(controlar==1){
          $(`#${idtabla}`).DataTable({
              order: [[ 0, orden ]],
              "language": lenguajeTabla,
              "lengthMenu": [page, 10, 25, 50, 100],
              "pageLength": page,
              initComplete: function () {
                  // Quitar el autocomplete del campo de búsqueda
                  $('input[type="search"]').attr('autocomplete', 'off');
              }
          });
        }else if(controlar==3){
          $(`#${idtabla}`).DataTable({
              order: [],
              "language": lenguajeTabla,
              "lengthMenu": [page, 10, 25, 50, 100],
              "pageLength": page,
              initComplete: function () {
                  // Quitar el autocomplete del campo de búsqueda
                  $('input[type="search"]').attr('autocomplete', 'off');
              }

          });
        }else{
          $(`#${idtabla}`).DataTable({
              order: [[ 0, orden ],[1, orden]],
              "language": lenguajeTabla,
              "lengthMenu": [page, 10, 25, 50, 100],
              "pageLength": page,
              initComplete: function () {
                  // Quitar el autocomplete del campo de búsqueda
                  $('input[type="search"]').attr('autocomplete', 'off');
              }
          });
        }
      
      }
    </script>
    <main class="py-4">
        @yield('content')
    </main>
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
      <a href="/" class="brand-link">
        <img src="/images/logohead.png" alt="Logo" class="brand-image img-circle elevation-1" style="opacity: .8">
        <span class="brand-text font-weight-light"><b style="font-size:10px">SISTEMA COACTIVA</b></span>
      </a>
      <div class="sidebar">
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
          <div class="image">
            <img src="/plantilla/img/user2-160x160.jpg" class="img-circle elevation-2" alt="User Image">
          </div>
          <div class="info">
            <a href="#" class="d-block">Bienvenido
              @if(Auth::user())
                Administrador
              @endif
            </a>
          </div>
        </div>
        <nav class="mt-2" id="navmenu">
          <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
            @if(Auth::user())
            <!-- Opciones de administrador -->
            <?php
              $menus=\App\Models\Administracion\Roles\MenuModel::with('gestion')->where('estado',0)->get();
              foreach ($menus as $key => $value) {
                  echo "<li class='nav-item' id='nav_{$value['id']}'>
                    <a id='menu_{$value['id']}' href='#' class='nav-link'>
                      <i class='nav-icon {$value['icono']}'></i>
                      <p>{$value['descripcion']}
                        <i class='fa fa-angle-left right'></i>
                      </p>
                  </a>";
                $gestiones='';
                foreach ($value['gestion'] as $key2 => $valuegestion) {
                  echo "<ul style='margin-left:10px' class='nav nav-treeview'>
                    <li class='nav-item'>
                      <a id='opcion_{$valuegestion['id']}' href='{$valuegestion['url']}' class='nav-link'>
                        <i class='{$valuegestion['icono']} nav-icon'></i>
                        <p>{$valuegestion['descripcion']}</p>
                      </a>
                    </li>
                  </ul>";
                }
              }
              ?>
            @else
            <?php
              $roles=auth()->user()['roles'];
              foreach ($roles as $key => $value) {
                $menu=$value['rol']['gestion'][0]['gestion']['menu'];
                  echo "<li class='nav-item' id='nav_{$menu['id']}'>
                    <a id='menu_{$menu['id']}' href='#' class='nav-link'>
                      <i class='nav-icon {$menu['icono']}'></i>
                      <p>{$menu['descripcion']}
                        <i class='fa fa-angle-left right'></i>
                      </p>
                  </a>";
                $gestiones='';
                foreach ($value['rol']['gestion'] as $key2 => $valuegestion) {
                  echo "<ul style='margin-left:10px' class='nav nav-treeview'>
                    <li class='nav-item'>
                      <a id='opcion_{$valuegestion['gestion']['id']}' href='{$valuegestion['gestion']['url']}' class='nav-link'>
                        <i class='{$valuegestion['gestion']['icono']} nav-icon'></i>
                        <p>{$valuegestion['gestion']['descripcion']}</p>
                      </a>
                    </li>
                  </ul>";
                }
              }
            ?>
            @endif
          </ul>
        </nav>
      </div>
    </aside>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    <footer class="main-footer">
      <b>SISTEMA ADMINISTRATIVO Y COACTIVA</b>
      <div class="float-right d-none d-sm-inline-block">
        <b>Version</b> 1.0
      </div>
    </footer>
  </div>

  <div class="modal fade" id="modalperfil">
        <div class="modal-dialog modal-sm">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Información</h5>
              <button onclick="cerrarmodal()" type="button" class="close" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-md-12">
                  <div class="card card-primary card-outline">
                    <div class="card-body box-profile">
                      <div class="text-center">
                        <img class="profile-user-img img-fluid img-circle"
                            src="/plantilla/img/user2-160x160.jpg"
                            alt="User profile picture">
                      </div>
                      <h3 class="profile-username text-center">{{auth()->user()->name}}</h3>
                      <p class="text-muted text-center">{{auth()->user()->cedula}}</p>
                      <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                          <b>Email</b> <a class="float-right">{{auth()->user()->email}}</a>
                        </li>
                        <li class="list-group-item">
                          <b>Dirección</b> <a class="float-right">{{auth()->user()->direccion}}</a>
                        </li>
                        <li class="list-group-item">
                          <b>Rol de sistema</b> <a class="float-right">
                            @if(Auth::user())
                              Administrador
                            @else
                              Usuario estandar
                            @endif
                          </a>
                        </li>
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" onclick="cerrarmodal()">Cerrar</button>
            </div>
          </div>
        </div>
  </div>

  <div class="modal fade" id="modalclave">
        <div class="modal-dialog modal-lx">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Información</h5>
              <button onclick="cerrarmodalclave()" type="button" class="close" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-md-12">
                  <div class="card card-primary card-outline">
                    <div class="card-body box-profile">
                      <div class="text-center">
                        <img class="profile-user-img img-fluid img-circle"
                            src="/plantilla/img/user2-160x160.jpg"
                            alt="User profile picture">
                      </div>
                      <h3 class="profile-username text-center">{{auth()->user()->name}}</h3>
                      <p class="text-muted text-center">{{auth()->user()->cedula}}</p>
                      <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                          <b>Clave anterior</b> <a class="float-right"><input type="password" id="claveact" name="claveact" placeholder="Ingrese clave anterior"  type="text" class="form-control"></a>
                        </li>
                        <li class="list-group-item">
                          <b>Nueva clave</b> <a class="float-right"><input type="password" id="nuevaclaveact" name="nuevaclaveact" placeholder="Ingrese nueva clave"  type="text" class="form-control"></a>
                        </li>
                        <li class="list-group-item">
                          <b>Confirmar clave</b> <a class="float-right"><input type="password" id="confirmarclaveact" name="confirmarclaveact" placeholder="Confirmar clave"  type="text" class="form-control"></a>

                        </li>
                      </ul>
                      <a  onclick="cambiarclave()" class="btn btn-primary btn-block"><b>Cambiar clave</b></a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" onclick="cerrarmodalclave()">Cerrar</button>
            </div>
          </div>
        </div>
  </div>
  <script src="/plantilla/js/adminlte.js"></script>
  <script src="{{asset('/plantilla/plugins/select2/js/select2.full.min.js')}}"></script>
  <script src="{{asset('pnotify/dist/pnotify.js')}}"></script>
  <script src="{{asset('pnotify/dist/pnotify.buttons.js')}}"></script>
  <script src="{{asset('sweetalert/sweetalert.js')}}"></script>
  <script src="{{ asset('/plantilla/plugins/select2/js/i18n/es.js') }}"></script>

  <script>
    function lscampoclave(){
      $('#claveact').val('');
      $('#nuevaclaveact').val('');
      $('#confirmarclaveact').val('');
    }
    function cambiarclave(){
        if($('#claveact').val()=='' ||  $('#nuevaclaveact').val()=='' || $('#confirmarclaveact').val()==''){
          mensaje_notificacion('Debe ingresar todos los campos','warning');
          return;
        }
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        cargando("m","Actualizando...");
        $.ajax({
            url: '/administracion/updatepassword',
            type: 'PUT',
            data: {claveact:$('#claveact').val(),
            nuevaclaveact:$('#nuevaclaveact').val(),
            confirmarclaveact:$('#confirmarclaveact').val()},
          
            success: function(data) {
                if(data['status']=='failed'){
                    mensaje_notificacion(data['response'],'error');
                    cargando();
                    return;
                }
                mensaje_notificacion(data['response'],'success');
                $('#modalclave').modal('hide');
                cargando();
            },
            error: function (data) {
                mensaje_notificacion('Inconvenientes al procesar solicitud','error');
                cargando();
                return;
            },
        });

    }
    function cerrarmodal(){
        $('#modalperfil').modal('hide');
    }
    function cerrarmodalclave(){
        $('#modalclave').modal('hide');
    }
    // FUNCION PARA MOSTRAR UNA ALERTA DE PNotify PERSONALIZADA
    function mensaje_notificacion(texto, tipo){
        PNotify.removeAll()
        new PNotify({
            title: '<i class="fa fa-info-circle"></i> Información <a style="cursor:pointer" onclick="remove()"><b style="padding-left:90px">x</b></a>',
            text: texto,
            type: tipo,
            hide: true,
            delay: 7000,
            styling: 'bootstrap3',
            addclass: '',
            icono:'info'
        });
    }
    function remove(){
        PNotify.removeAll()
    }
    function cargando(estado){
        mostrar_carga(estado,'');
    }
    function cargando(estado, mensaje){
        mostrar_carga(estado, mensaje);
    }
    function mostrar_carga(estado, mensaje){
        if(estado=='M' || estado=='m'){
            $('#modal_cargando_title').html(mensaje);
            $('#modal_cargando').show();
            $('body').css('overflow', 'hidden');
        }else{
            $('#modal_cargando_title').html('Cargando');
            $('#modal_cargando').hide();
            $('body').css('overflow', '');
        }
    }
  </script>
  <div id="modal_cargando" class="page div_cargar">
      <div class="container-1">
          <div class="container-2">
              <center><h1 id="modal_cargando_title">Cargando</h1></center>
              <div align="center"  id="loader"><img width="5%" src="/images/cargando.gif" alt=""></div>			
          </div>
      </div>
  </div>
  <script>
    $(function () {
      //Initialize Select2 Elements
      $('.select').select2({
        theme: 'bootstrap4'
      })
    });
  </script>

  <script>
    function sesion(){
      if($('#ulsesion').hasClass('show')){
        $('#ulsesion').removeClass('show')
      }else{
        $('#ulsesion').addClass('show')
      }
    }
    $(document).click(function() {
      var obj = $("#ulsesion");
      var obj2 = $("#sesion");

      if ((!obj.is(event.target) && !obj.has(event.target).length) && (!obj2.is(event.target) && !obj2.has(event.target).length)) {
        $('#ulsesion').removeClass('show')

      }
    });
    $(document).on('click', '.cerrar_modal', function () {
        $('.modal').modal('hide');
        setTimeout(function() {
          document.body.style.overflow = 'scroll';
          // Otras operaciones que desees realizar después de cierto tiempo
      }, 400);
    });
  </script>
  @php 
    $rutaactual=\Request::route()->uri;
    $rutaactual2= $rutaactual;
  @endphp
  <script>
    $(document).ready(function(){
    var ruta= $('#navmenu').find('a');
    var rutaactual=@php echo 'href="'.'/'.$rutaactual2.'"'; @endphp; 
        $.each(ruta,function(i,item){
          if(rutaactual==item.getAttribute('href')){
            var id=item.getAttribute('id');
            $(`#${id}`).addClass('active');
            var submenu=($(`#${id}`).parent().parent().parent().find('a'))
            var idparents=(submenu[0].getAttribute('id'));
            // $(`#${idparents}`).addClass('active');
            var abuelo=$(`#${id}`).parent().parent().parent();
            $(`#${abuelo[0].getAttribute('id')}`).addClass('active');
            $(`#${abuelo[0].getAttribute('id')}`).addClass('menu-is-opening menu-open');

          }
        });
    });
  </script>

<!-- <script type="text/javascript" src="/js/accesibilidad.min.js"></script> -->
</body>
</html>
