<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta property="og:title" content="CELULAR PLANET"/>
  <meta property="og:description" content="CELULAR PLANET"/>
  <meta property="og:url" content="https://celularplanet.ec/"/> <!-- Reemplaza con la URL real de tu página -->
  <meta name="twitter:card" content="summary_large_image"/>
  <meta name="twitter:title" content="CELULAR PLANET"/>
  <meta name="twitter:description" content="CELULAR PLANET"/>
  <title>CELULAR PLANET</title>

  <meta name="csrf-token" content="{{ csrf_token() }}">
  <link href="{{ asset('fontawesome/font-awesome.css') }}" rel="stylesheet">
  <link rel="stylesheet" href="{{asset('/plantilla/css/adminlte.min.css') }}">
  <link href="{{asset('pnotify/dist/pnotify.css')}}" rel="stylesheet">
  <link href="{{asset('pnotify/dist/pnotify.buttons.css')}}" rel="stylesheet">
  <link href="{{asset('pnotify/dist/pnotify.nonblock.css')}}" rel="stylesheet">
  <link rel="stylesheet" href="{{asset('/plantilla/plugins/select2/css/select2.min.css')}}">
  <link rel="stylesheet" href="{{asset('/plantilla/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')}}">
  <link rel="stylesheet" type="text/css" href="{{asset('DataTables/datatables.min.css')}}"/> 
  <link rel="stylesheet" href="{{asset('sweetalert/sweetalert.css')}}">
  <script src="{{ asset('js/app.js') }}"></script>
  <script src="{{asset('js/jquery.min.js')}}"></script>
  <style>
    html {
  font-size: 14px; /* Ajusta el tamaño de letra según tus preferencias */
}
      .card-color:not(.card-outline)>.card-header {
          background-color:rgb(0, 0, 0);
      }
      .btn-color {
          color: #fff;
          background-color: #0068d1;
          border-color: #0068d1;
          box-shadow: none;
      }
      .div_cargar{
        background-color:rgba(42, 63, 84, 0.5);
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 1050;
        display: none;
        overflow: hidden;
        -webkit-overflow-scrolling: touch;
        outline: 0;
    }
    .page{
        height: 100%;
    }

    .container-1{
        display: table;
        width: 100%;
        height: 100%;
    }

    .container-2{
        display: table-cell;
        vertical-align: middle;
        color: #fff;
    }
    .disabled_content{
        display:none !important;
    }

  </style>
</head>
<body class="hold-transition sidebar-mini layout-footer-fixed">
<div class="wrapper">
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fa fa-bars"></i></a>
      </li>
    </ul>
    <ul class="navbar-nav ml-auto">
      <li class="nav-item">
          <a class="nav-link" data-widget="fullscreen" href="#" role="button">
              <i class="fa fa-expand"></i>
          </a>
      </li>
      @if(auth()->user()['tipo']!='AD')
        @if(sizeof(auth()->user()['localesusuario'])>1)
          <li class="nav-item">
              <a id="local_perfil" onclick="cambio_local()" class="nav-link" data-toggle="dropdown" href="#">
                  <i class="fa fa-home"></i> {{session('descripcion_local')}}
              </a>
              <div id="ul_local" class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                @foreach(auth()->user()['localesusuario'] as $value)
                  <div class="dropdown-divider"></div>
                  @if(decrypt(session('id_local'))!=$value['local']['id'])
                    <a onclick="cambiar_local('{{encrypt($value['local']['id'])}}','{{$value['local']['descripcion']}}')" style='cursor:pointer' class="dropdown-item">
                      <i class="fa fa-home mr-2"></i>{{$value['local']['descripcion']}} - {{$value['local']['direccion']}}
                    </a>
                  @endif

                @endforeach
          </li>
        @endif
      @endif
      <li class="nav-item dropdown">
        @guest
          <a  href="/login" class="nav-link" >
            <i class="fa fa-user"></i> Iniciar sesión
          </a>
        @else
          
          <a id="sesion" onclick="sesion()" class="nav-link" data-toggle="dropdown" href="#">
            <i class="fa fa-user"></i> {{auth()->user()->name}}
          </a>
          <div id="ulsesion" class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
            <div class="dropdown-divider"></div>
            <a  onclick="$('#modalperfil').modal('show');" class="dropdown-item">
              <i class="fa fa-user mr-2"></i>Perfil
            </a>
            <div class="dropdown-divider"></div>
            <a style="cursor:pointer" onclick="$('#modalclave').modal('show');lscampoclave();" class="dropdown-item">
              <i class="fa fa-key mr-2"></i> Cambiar clave
            </a>
            <div class="dropdown-divider"></div>
            <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="dropdown-item">
              <i class="fa fa-sign-out mr-2"></i> Cerrar sesión
            </a>
            <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                {{ csrf_field() }}
            </form>
          </div>
        @endguest
      </li>
    </ul>
  </nav>
  <script type="text/javascript" src="{{asset('DataTables/datatables.min.js')}}"></script>
  <script>
    var lenguajeTabla = {
      "lengthMenu": "Mostrar _MENU_ registros por pagina",
      "zeroRecords": "No se encontraron resultados en su busqueda",
      "searchPlaceholder": "Buscar registros",
      "info": "Mostrando registros de _START_ al _END_ de un total de  _TOTAL_ registros",
      "infoEmpty": "No existen registros",
      "infoFiltered": "(filtrado de un total de _MAX_ registros)",
      "search": "Buscar:",
      "paginate": {
        "first": "Primero",
        "last": "Último",
        "next": "Siguiente",
        "previous": "Anterior"
      }
    };
    //nombre de la tabla,orden asc o desc,columna a ordenar,paginacion
    function cargar_estilos_tabla(idtabla,orden="desc",columna=0,page=5){
      // if(controlar==1){
    $(`#${idtabla}`).DataTable({
    order: [[ columna, orden ]],
    lengthMenu: [[ 5, 10, 25, 50, 100, -1 ], [ "5", "10", "25", "50", "100", "Todos" ]],
    language: lenguajeTabla,
    pageLength: page,
    initComplete: function () {
        const input = $(`#${idtabla}_filter input`);

        // Solución completa para evitar que se autocomplete con correos/contraseñas:
        input.attr({
            type: 'text',
            autocomplete: 'new-password', // más efectivo que 'off' en algunos navegadores
            name: 'buscar_' + idtabla,    // nombre neutro para evitar asociaciones con login
            id: 'buscar_' + idtabla
        });

        // Campo oculto para "engañar" el autocompletado
        $('<input type="text" style="display:none" name="fakeuser">').insertBefore(input);
        $('<input type="password" style="display:none" name="fakepass">').insertBefore(input);
    }
});
      // }else if(controlar==3){
      //   $(`#${idtabla}`).DataTable({
      //     "lengthMenu": [5, 10, 25, 50, 100],
      //       order: [],
      //       "language": lenguajeTabla,
      //       pageLength: 5

      //   });
      // }else{
      //   $(`#${idtabla}`).DataTable({
      //       "lengthMenu": [5, 10, 25, 50, 100],
      //       order: [[ 0, orden ],[1, orden]],
      //       "language": lenguajeTabla,
      //       pageLength: 5
      //   });
      // }
     
    }
  </script>
    @if(session()->has('status'))
        <script>
            $(document).ready(function() {
                mensaje_notificacion('{{session('mensaje_info')}}','{{session('status')}}');
            });
        </script>
    @endif
  <main class="py-4">
      @yield('content')
  </main>
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="/" class="brand-link">
      <img src="/images/logo2.jpg" alt="Logo" class="brand-image img-circle elevation-1" style="opacity: .8">
      <span class="brand-text font-weight-light"><b>CELULAR PLANET</b></span>
    </a>
    <div class="sidebar">
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="image">
          <img 
            src="/plantilla/img/avatar5.png"
          class="img-circle elevation-2" alt="User Image">
        </div>
        <div class="info">
          <a href="#" class="d-block">
            @if(auth()->user()['tipo']!='AD')
              <small>{{session('descripcion_local')}}</small>
            @else
              <small>Administrador</small>
            @endif
          </a>
        </div>
      </div>

      @php
          $lista_opcion = cargar_menu_opciones();
         // $lista_opcion=[];
          $menu = 0;
      @endphp

      <nav class="mt-2" id="navmenu">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          
          @foreach ($lista_opcion as $i => $item)

            @if($menu != $item->menu_id)
            @php $menu = $item->menu_id @endphp
            <li class="nav-item" id="menuopciones_{{$item->menu_id}}">
              <a id="head_{{$item->menu_id}}" href="#" class="nav-link">
                <i class="nav-icon {{ $item->menu_icono }}"></i>
                <p>
                  {{ $item->menu_detalle }}
                  <i class="fa fa-angle-left right"></i>
                </p>
              </a>
              <ul class="nav nav-treeview">
            @endif

                <li class="nav-item">
                  <a id="detalle_{{$item->menu_opcion_id}}" style="margin-left:10px; width: auto;" href="{{ asset($item->menu_opcion_ruta) }}" class="nav-link">
                    <i class="{{ $item->menu_opcion_icono }} nav-icon"></i>
                    <p>{{ $item->menu_opcion_detalle }}</p>
                  </a>
                </li>
            
            @if($i == sizeof($lista_opcion)-1) <!-- estamos en el ultimo -->
              </ul>
            </li>
            @elseif($lista_opcion[$i+1]->menu_id != $menu) <!-- aun no es el ultimo pero el siguiente menu es diferente-->
              </ul>
            </li>
            @endif

          @endforeach 
  
        </ul>
      </nav>
    </div>
  </aside>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  <footer class="main-footer">
    <strong>Copyright &copy; 2025 <a href="/">CELULAR PLANET</a>.</strong>
    Todos los derechos reservados.
    <div class="float-right d-none d-sm-inline-block">
      <b>Version</b> 1.0
    </div>
  </footer>
</div>
@if(isset(auth()->user()->name))
  <div class="modal fade" id="modalperfil">
        <div class="modal-dialog modal-lx">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Perfil de usuario</h5>
              <button onclick="cerrarmodal()" type="button" class="close" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-md-12">
                  <div class="card card-primary card-outline">
                    <div class="card-body box-profile">
                      <div class="text-center">
                        <img class="profile-user-img img-fluid img-circle" src="/plantilla/img/avatar5.png"
                            alt="User profile picture">
                      </div>
                      <h3 class="profile-username text-center">{{auth()->user()->name}}</h3>
                      <p class="text-muted text-center">{{auth()->user()->identificacion}}</p>
                      <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                          <b>Correo</b> <a class="float-right">{{auth()->user()->email}}</a>
                        </li>
                        <li class="list-group-item">
                          <b>Celular</b> <a class="float-right">{{auth()->user()->celular}}</a>
                        </li>
                        <li class="list-group-item">
                          <b>Rol</b> <a class="float-right">
                            
                          @if(auth()->user()->tipo=='AD')
                            Administrador
                          @endif
                          @if(auth()->user()->tipo=='ES')
                            Usuario estandar
                          @endif
                          @if(auth()->user()->tipo=='TE')
                            Técnico
                          @endif</a>
                        </li>
                        @if(auth()->user()['tipo']!='AD')
                          <li class="list-group-item">
                              <b>Local</b> <a class="float-right">
                              {{session('descripcion_local')}} </a>
                          </li>
                        @endif


                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" onclick="cerrarmodal()">Cerrar</button>
            </div>
          </div>
        </div>
  </div>

  <div class="modal fade" id="modalclave">
        <div class="modal-dialog modal-lx">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Actualización de clave</h5>
              <button onclick="cerrarmodalclave()" type="button" class="close" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-md-12">
                  <div class="card card-primary card-outline">
                    <div class="card-body box-profile">
                      <div class="text-center">
                        <img class="profile-user-img img-fluid img-circle"
                              src="/plantilla/img/avatar5.png"
                            alt="User profile picture">
                      </div>
                      <h3 class="profile-username text-center">{{auth()->user()->name}}</h3>
                      <p class="text-muted text-center">{{auth()->user()->identificacion}}</p>
                      <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                          <b>Clave anterior</b> <a class="float-right"><input type="password" id="claveact" name="claveact" placeholder="Ingrese clave anterior"  type="text" class="form-control"></a>
                        </li>
                        <li class="list-group-item">
                          <b>Nueva clave</b> <a class="float-right"><input type="password" id="nuevaclaveact" name="nuevaclaveact" placeholder="Ingrese nueva clave"  type="text" class="form-control"></a>
                        </li>
                        <li class="list-group-item">
                          <b>Confirmar clave</b> <a class="float-right"><input type="password" id="confirmarclaveact" name="confirmarclaveact" placeholder="Confirmar clave"  type="text" class="form-control"></a>

                        </li>
                      </ul>
                      <a type='button'  onclick="cambiarclave()" class="btn btn-primary btn-block"><b>Cambiar clave</b></a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" onclick="cerrarmodalclave()">Cerrar</button>
            </div>
          </div>
        </div>
  </div>
@endif


<script src="/plantilla/js/adminlte.js"></script>
<script src="{{asset('/plantilla/plugins/select2/js/select2.full.min.js')}}"></script>
<script src="{{asset('pnotify/dist/pnotify.js')}}"></script>
<script src="{{asset('pnotify/dist/pnotify.buttons.js')}}"></script>
<script src="{{asset('sweetalert/sweetalert.js')}}"></script>
  <script>
    function lscampoclave(){
      $('#claveact').val('');
      $('#nuevaclaveact').val('');
      $('#confirmarclaveact').val('');
    }
    function cambiarclave(){
        if($('#claveact').val()=='' ||  $('#nuevaclaveact').val()=='' || $('#confirmarclaveact').val()==''){
          mensaje_notificacion('Debe ingresar todos los campos','warning');
          return;
        }
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        cargando("m","Actualizando...");
        $.ajax({
            url: '/usuario/updatepassword',
            type: 'PUT',
            data: {claveact:$('#claveact').val(),
            nuevaclaveact:$('#nuevaclaveact').val(),
            confirmarclaveact:$('#confirmarclaveact').val()},
          
            success: function(data) {
                if(data['status']=='failed'){
                    mensaje_notificacion(data['response'],'error');
                    cargando();
                    return;
                }
                mensaje_notificacion(data['response'],'success');
                $('#modalclave').modal('hide');
                cargando();
            },
            error: function (data) {
                mensaje_notificacion('Inconvenientes al procesar solicitud','error');
                cargando();
                return;
            },
        });

    }
    function cerrarmodal(){
        $('#modalperfil').modal('hide');
        setTimeout(function() {
                document.body.style.overflow = 'scroll';
            }, 400);
    }
    function cerrarmodalclave(){
        $('#modalclave').modal('hide');
        setTimeout(function() {
                document.body.style.overflow = 'scroll';
            }, 400);
    }
    // FUNCION PARA MOSTRAR UNA ALERTA DE PNotify PERSONALIZADA
    function mensaje_notificacion(texto, tipo){
        PNotify.removeAll()
        new PNotify({
            title: '<i class="fa fa-info-circle"></i> Información <a style="cursor:pointer" onclick="remove()"><b style="padding-left:90px">x</b></a>',
            text: texto,
            type: tipo,
            hide: true,
            delay: 7000,
            styling: 'bootstrap3',
            addclass: '',
            icono:'info'
        });
    }
    function remove(){
        PNotify.removeAll()
    }
    function cargando(estado){
        mostrar_carga(estado,'');
    }
    function cargando(estado, mensaje){
        mostrar_carga(estado, mensaje);
    }
    function mostrar_carga(estado, mensaje){
        if(estado=='M' || estado=='m'){
            $('#modal_cargando_title').html(mensaje);
            $('#modal_cargando').show();
            $('body').css('overflow', 'hidden');
        }else{
            $('#modal_cargando_title').html('Cargando');
            $('#modal_cargando').hide();
            $('body').css('overflow', '');
        }
    }
    $(document).on('click', '.cerrar_modal', function () {
        $('.modal').modal('hide');
        setTimeout(function() {
          document.body.style.overflow = 'scroll';
          // Otras operaciones que desees realizar después de cierto tiempo
      }, 400);
    });
  </script>
  <div id="modal_cargando" class="page div_cargar">
      <div class="container-1">
          <div class="container-2">
              <center><h1 id="modal_cargando_title">Cargando</h1></center>
              <div align="center"  id="loader"><img width="5%" src="/images/cargando.gif" alt=""></div>			
          </div>
      </div>
  </div>
  <script>
    $(function () {
      //Initialize Select2 Elements
      $('.select').select2({
        theme: 'bootstrap4'
      })
    });
  </script>

  <script>


    function cambiar_local(idlocal,descripcion_local){
        titulo='¿Está seguro que desea cambiar al local '+descripcion_local+'?';
        swal({
          title: "",
          text: titulo,
          type: "warning",
          showCancelButton: true,
          confirmButtonClass: "btn-info",
          confirmButtonText: "Si",
          cancelButtonText: "No",
          closeOnConfirm: false,
          closeOnCancel: false
      },
      function(isConfirm) {
          if (isConfirm) { 
              cargando("M", "Cambiando de local...");
              $.get('/usuario/cambiar_local/'+idlocal,function(data){
                  if(data['status']=='error'){
                      mensaje_notificacion(data['response'],data['status']);
                      cargando();
                      return;
                  }
                  window.location.href = "/";
              }).fail(function(){
                  mensaje_notificacion('Inconvenientes intente nuevamente','error');
                  cargando();
              });
          }
          sweetAlert.close();   
      }); 

    }






    function sesion(){
      if($('#ulsesion').hasClass('show')){
        $('#ulsesion').removeClass('show')
      }else{
        $('#ulsesion').addClass('show')
      }
    }
    $(document).click(function(event) {
      var obj = $("#ulsesion");
      var obj2 = $("#sesion");
      if ((!obj.is(event.target) && !obj.has(event.target).length) && (!obj2.is(event.target) && !obj2.has(event.target).length)) {
        $('#ulsesion').removeClass('show')
      }
      
    });

    function cambio_local(){
      if($('#ul_local').hasClass('show')){
        $('#ul_local').removeClass('show')
      }else{
        $('#ul_local').addClass('show')
      }
    }
    $(document).click(function(event) {
      var obj = $("#ul_local");
      var obj2 = $("#local_perfil");
      if ((!obj.is(event.target) && !obj.has(event.target).length) && (!obj2.is(event.target) && !obj2.has(event.target).length)) {
        $('#ul_local').removeClass('show')
      }
      
    });

  </script>
  @php 
    $rutaactual=\Request::fullUrl();
    $rutaactual2= $rutaactual;
  @endphp
  <script>
     $(document).on('click', '.cerrar_modal', function () {
        $('.modal').modal('hide');
        setTimeout(function() {
          document.body.style.overflow = 'scroll';
          // Otras operaciones que desees realizar después de cierto tiempo
      }, 400);
    });
    $(document).ready(function(){
    var ruta= $('#navmenu').find('a');
    var rutaactual3='@php echo $rutaactual; @endphp'; 
        $.each(ruta,function(i,item){

          if(rutaactual3==item.getAttribute('href')){
            var id=item.getAttribute('id');
            $(`#${id}`).addClass('active');
            var submenu=($(`#${id}`).parent().parent().parent().find('a'))
            var idparents=(submenu[0].getAttribute('id'));
            $(`#${idparents}`).addClass('active');
            var abuelo=$(`#${id}`).parent().parent().parent();
            $(`#${abuelo[0].getAttribute('id')}`).addClass('active');
            $(`#${abuelo[0].getAttribute('id')}`).addClass('menu-is-opening menu-open');
            return false;
          }
        });
    });

    // $(document).ready(function () {
    //     var w_a = $(`#navmenu a[href*="${window.location.href}"]`);
    //     if($(w_a).length==1){
    //         $(w_a).addClass("active");
    //         var arbol_padre = $(w_a).parents(".nav-treeview");
    //         if($(arbol_padre).length==1){
    //             $(arbol_padre).siblings('a.nav-link').addClass("active");
    //             setTimeout(() => {
    //                 $(arbol_padre).siblings('a.nav-link').click();
    //             }, 200);
    //         }
    //     }
    // });

  </script>
</body>
</html>
