<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="{{ asset('fontawesome/font-awesome.css') }}" rel="stylesheet">
    <link href="{{asset('pnotify/dist/pnotify.css')}}" rel="stylesheet">
    <link href="{{asset('pnotify/dist/pnotify.buttons.css')}}" rel="stylesheet">
    <link href="{{asset('pnotify/dist/pnotify.nonblock.css')}}" rel="stylesheet">
    <title>Confirmación de Reparación</title>

    <style>
        .div_cargar{
            background-color:rgba(42, 63, 84, 0.5);
            position: fixed;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            z-index: 1050;
            display: none;
            overflow: hidden;
            -webkit-overflow-scrolling: touch;
            outline: 0;
        }
        .page{
            height: 100%;
        }
        .container-1{
            display: table;
            width: 100%;
            height: 100%;
        }
        .container-2{
            display: table-cell;
            vertical-align: middle;
            color: #fff;
        }
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 600px;
            text-align: center;
        }
        .logo {
            width: 50%;
            height: auto;
            margin-bottom: 10px;
        }
        .details {
            text-align: left;
            background: #f9f9f9;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
        }
        textarea {
            width: 100%;
            height: 80px;
            margin-top: 10px;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
            resize: none;
        }
        .buttons {
            margin-top: 15px;
            display: flex;
            justify-content: space-between;
        }
        button {
            padding: 10px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            width: 45%;
        }
        .confirm {
            background-color: #4CAF50;
            color: white;
        }
        .reject {
            background-color: #d9534f;
            color: white;
        }
    </style>

    <script src="{{asset('js/jquery.min.js')}}"></script>
    <script src="{{asset('pnotify/dist/pnotify.js')}}"></script>
    <script src="{{asset('pnotify/dist/pnotify.buttons.js')}}"></script>
    <script>
        function enviarRespuesta(respuesta) {
            cargando("M", "Por favor espere...");
            var FrmData = {
                descripcion_confirmar: $("#observacion").val(),
                respuesta: respuesta,
                idordenconfirmar_encrypt: $('#idordenconfirmar_encrypt').val()
            } 
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });  

            $.ajax({
                url: '/orden/confirmar', 
                method: "POST", 
                        data: FrmData,
                        type: "json",             
                complete: function (request)   
                {
                    var retorno = request.responseJSON;
                    if(retorno['status']=='error'){
                        mensaje_notificacion(retorno['response'],'error');
                        cargando();
                        return;
                    }
                    window.location.href = '/orden/confirmar_orden/' + retorno['id'];
                },error: function(){
                    mensaje_notificacion('Inconveniente, Inténtelo más tarde','error');
                    cargando();
                }
            });
        }
        function mensaje_notificacion(texto, tipo){
            PNotify.removeAll()
            new PNotify({
                title: '<i class="fa fa-info-circle"></i> Información <a style="cursor:pointer" onclick="remove()"><b style="padding-left:90px">x</b></a>',
                text: texto,
                type: tipo,
                hide: true,
                delay: 7000,
                styling: 'bootstrap3',
                addclass: '',
                icono:'info'
            });
        }
        function remove(){
            PNotify.removeAll()
        }
        function cargando(estado){
            mostrar_carga(estado,'');
        }
        function cargando(estado, mensaje){
            mostrar_carga(estado, mensaje);
        }
        function mostrar_carga(estado, mensaje){
            if(estado=='M' || estado=='m'){
                $('#modal_cargando_title').html(mensaje);
                $('#modal_cargando').show();
                $('body').css('overflow', 'hidden');
            }else{
                $('#modal_cargando_title').html('Cargando');
                $('#modal_cargando').hide();
                $('body').css('overflow', '');
            }
        }
    </script>
</head>
<body>
    <div class="container">
        <img src="/images/logo.png" alt="Logo" class="logo">
        <div class="details">
            <p><b>Cliente:</b> {{$orden['cliente']['nombres']}}</p>
            <p><b>Orden:</b> {{$orden['codigo']}}</p>
            <p><b>Modelo celular:</b> {{$orden['modelo']}}</p>
            <p style='color:blue'><strong>Detalles del diagnóstico</strong></p>
            <p>{{$diagnostico['observacion_diagnostico']}}</p>
            <p><b>Costo:</b> ${{$diagnostico['costo_total']}}</p>
            <p><b>Tiempo:</b> {{$diagnostico['dias']}} días {{$diagnostico['horas']}} horas {{$diagnostico['minutos']}} minutos</p>
        </div>
        <p>¿Desea confirmar la reparación?</p>
        <form onsubmit="event.preventDefault();" method="POST" enctype="multipart/form-data">
            {{ csrf_field() }}
            <input type="hidden" id='idordenconfirmar_encrypt' value="{{$orden['idencrypt']}}">
            <textarea id="observacion" required placeholder="Añadir observación..."></textarea>
            <div class="buttons">
                <button type="button" class="confirm" onclick="enviarRespuesta('S')">Confirmar reparación</button>
                <button type="button" class="reject" onclick="enviarRespuesta('N')">No reparar</button>
            </div>
        </form>
        <br>
        <div class="form-group">
            <div class="row" style='font-size:12px'>
                <div class="col-md-12">
                    <div></div>
                    <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                        <br> <br>
                        @if(isset($imagenes))
                            @foreach($imagenes as $item)
                                <div style="text-align: center;">
                                    <a href="/imagenesorden/{{$item['ruta']}}"><img width="120px" src="/imagenesorden/{{$item['ruta']}}" alt="img_orden" style="border: 1px solid #ccc;"></a>
                                    <br><br>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="modal_cargando" class="page div_cargar">
      <div class="container-1">
          <div class="container-2">
              <center><h1 id="modal_cargando_title">Cargando</h1></center>
              <div align="center"  id="loader"><img width="5%" src="/images/cargando.gif" alt=""></div>			
          </div>
      </div>
  </div>
</div>

</body>
</html>
