@extends('layouts.head')

@section('content')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/echarts/dist/echarts.min.js"></script>
              <link rel="stylesheet" type="text/css" href="{{asset('DataTables/datatables.min.css')}}"/> 
            <style>
                .chart-container {
                    width: 100%;
                    max-width: 620px;
                    height: auto;
                    aspect-ratio: 3 / 2;
                    margin: auto;
                    padding: 10px;
                    border: 2px solid #000;
                    border-radius: 10px;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                #donut-chart {
                    width: 100%;
                    height: 100%;
                }
                #donut-chart-clientes {
                    width: 100%;
                    height: 100%;
                }
                .icon i {
                        font-size: 50px !important;
                        transform: scale(0.9); /* Reduce el tamaño */
                    }

                    #bar-chart-clientes {
                        width: 100%;
                        height: 100%;
                    }
            </style>
            <div class="content-wrapper">
                <section class="content" id='div_lista'>
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card card-color">
                                    <div class="card-header">
                                        <h3 style="color:white" class="card-title">
                                            <b>INFORMACIÓN
                                                @if(auth()->user()['tipo']!='AD') 
                                                    | <small>{{session('descripcion_local')}}</small> 
                                                @endif
                                            </b>
                                        </h3>
                                    </div>
                                    <div id='div_form'>
                                        <form id="form_orden" style='font-size:12px' method="POST" enctype="multipart/form-data">
                                            {{ csrf_field() }}
                                            <div class="card-body">
                                                <div class="form-group row">
                                                    <label for="local" class="col-md-2 col-form-label">Local:</label>
                                                    <div class="col-md-6">
                                                        <select name="local" id="local" class="form-control chosen-select">
                                                        <option class="optionlocal" value="T">Todos</option>
                                                            @if(isset($locales))
                                                                @foreach($locales as $value)
                                                                    <option class="optionlocal" value="{{encrypt($value['id'])}}">
                                                                        {{$value['descripcion']}} - {{$value['direccion']}}
                                                                    </option>
                                                                @endforeach
                                                            @endif
                                                        </select>
                                                    </div>
                                                </div>
                                                <hr>
                                                <div class="form-group row" id='div_fecha' >
                                                    <label class="col-md-2 col-form-label">Desde:</label>
                                                    <div class="col-md-4">
                                                        <input type="date" value="<?php echo date('Y-m-d', strtotime('-3 months')); ?>"  class="form-control" id="fecha_desde" name="fecha_desde">
                                                    </div>
                                                    <label class="col-md-2 col-form-label">Hasta:</label>
                                                    <div class="col-md-4">
                                                        <input type="date" value="<?php echo date('Y-m-d'); ?>"  class="form-control" id="fecha_hasta" name="fecha_hasta">
                                                    </div>
                                                </div>
                                                <hr>
                                            </div>
                                            
                                            <div class="card-footer text-center">
                                                <button type="submit" class="btn btn-color">
                                                    <i class="fa fa-search"></i> Buscar
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                
                                </div>
                                <div style='display:none' id='result'>

                                    <div class="row">
                                        <!-- Primer columna -->
                                        <div class="col-lg-3 col-6">
                                            <div class="small-box bg-default">
                                                <!-- Contenido interno -->
                                                <div class="inner">
                                                    <h4 id='ordenes_total'></h4>
                                                    <p>Total de ordenes</p>
                                                </div>
                                                <!-- Icono -->
                                                <div class="icon">
                                                    <i class="fa fa-address-card-o"></i>
                                                </div>
                                                <!-- Enlace de pie de caja -->
                                            </div>
                                        </div>

                                        <!-- Segunda columna -->
                                        <div class="col-lg-3 col-6">
                                            <div class="small-box bg-primary" onclick="modal_detalle_orden('I')" style='cursor:pointer;'>
                                                <div class="inner">
                                                    <h4 id='ordenes_sinasignar'></h4>
                                                    <p>Ordenes sin asignar</p>
                                                </div>
                                                <div class="icon">
                                                    <i class="fa fa-address-card-o"></i>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Tercera columna -->
                                        <div class="col-lg-3 col-6">
                                            <div class="small-box bg-info" onclick="modal_detalle_orden('A')" style='cursor:pointer;'>
                                                <div class="inner">
                                                    <h4 id='ordenes_asignadas'></h4>
                                                    <p>Ordenes asignadas</p>
                                                </div>
                                                <div class="icon">
                                                    <i class="fa fa-address-card-o"></i>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-6">
                                            <div class="small-box bg-warning" onclick="modal_detalle_orden('T')" style='cursor:pointer;'>
                                                <div class="inner">
                                                    <h4 id='ordenes_atendidas'></h4>
                                                    <p>Ordenes atendidas</p>
                                                </div>
                                                <div class="icon">
                                                    <i class="fa fa-address-card-o"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <!-- Primer columna -->
                                        <div class="col-lg-3 col-6">
                                            <div class="small-box bg-success" onclick="modal_detalle_orden('F')" style='cursor:pointer;'>
                                                <!-- Contenido interno -->
                                                <div class="inner">
                                                    <h4 id='ordenes_entregadas'></h4>
                                                    <p>Ordenes entregadas</p>
                                                </div>
                                                <!-- Icono -->
                                                <div class="icon">
                                                    <i class="fa fa-address-card-o" ></i>
                                                </div>
                                                <!-- Enlace de pie de caja -->
                                            </div>
                                        </div>

                                        <!-- Segunda columna -->
                                        <div class="col-lg-3 col-6">
                                            <div class="small-box bg-danger" onclick="modal_detalle_orden('D')" style='cursor:pointer;'>
                                                <div class="inner">
                                                    <h4 id='ordenes_anuladas'></h4>
                                                    <p>Ordenes anuladas</p>
                                                </div>
                                                <div class="icon">
                                                    <i class="fa fa-address-card-o"></i>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-6">
                                            <div class="small-box bg-dark">
                                                <div class="inner">
                                                    <h4 id='clientes_total'></h4>
                                                    <p>Clientes</p>
                                                </div>
                                                <div class="icon">
                                                    <i class="fa fa-users"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row dark-mode" style='background-color::black !mportant'>
                                        <div class="col-sm-3 col-6">
                                            <div class="description-block border-right">
                                            <span class="description-percentage text-success"><i class="fa fa-shopping-cart"></i></span>
                                            <h5 class="description-header" id='ventas_totales'></h5>
                                            <span class="description-text">Ventas totales</span>
                                            </div>
                                            <!-- /.description-block -->
                                        </div>
                                        <!-- /.col -->
                                        <div class="col-sm-3 col-6">
                                            <div class="description-block border-right">
                                            <span class="description-percentage text-warning"><i class="fa fa-users"></i></span>
                                            <h5 class="description-header" id='gastos_tecnicos'></h5>
                                            <span class="description-text">Gastos en técnicos</span>
                                            </div>
                                            <!-- /.description-block -->
                                        </div>
                                        <!-- /.col -->
                                        <div class="col-sm-3 col-6">
                                            <div class="description-block border-right">
                                            <span class="description-percentage text-success"><i class="fa fa-cogs"></i> </span>
                                            <h5 class="description-header" id='gastos_repuestos'></h5>
                                            <span class="description-text">Gastos en repuestos</span>
                                            </div>
                                            <!-- /.description-block -->
                                        </div>
                                        <!-- /.col -->
                                        <div class="col-sm-3 col-6">
                                            <div class="description-block">
                                            <span class="description-percentage text-danger"><i class="fa fa-money"></i> </span>
                                            <h5 class="description-header" id='ganancia'></h5>
                                            <span class="description-text">Ganancia</span>
                                            </div>
                                            <!-- /.description-block -->
                                        </div>
                                    </div>
                            </div>
                                
                            </div>
                        </div>
                    </div>
                </section>
        <div class="modal fade" id="modal_datos" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" >
            <div class="modal-dialog modal-dialog modal-dialog-scrollable modal-xs">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="title_atender"><i class='fa fa-file'></i> Información</h5>
                        <button type="button" class="close cerrar_modal" >
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table id="table_ordenes" class="table table-striped table-bordered dataTable no-footer" style="width:100%">
                                        <thead>
                                            <tr align="center"> 
                                                <th>Código</th>
                                                <th>Tipo</th>
                                            </tr>
                                        </thead>
                                        <tbody id="body_ordenes">
                                            
                                                                                
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default cerrar_modal"> <i class="fa fa-times"></i> Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
</div>
</div>
<script type="text/javascript" src="{{asset('DataTables/datatables.min.js')}}"></script>
<script src="{{asset('js/reportes/graficos.js?v='.rand())}}"></script>
@endsection
