<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Orden</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap">
    <style type="text/css">
        body {
            font-family: 'Roboto', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #ffffff;
            color: #333;
        }

        @page {
            margin-top: 2em;
            margin-left: 2em;
            margin-right: 2em;
            margin-bottom: 2em;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background-color: #006f6b;
            color: white;
            height: 100px;
            text-align: center;
            line-height: 100px;
            font-size: 24px;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        }

        header img {
            height: 50px;
            margin-top: 10px;
        }

        p {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            color: #005f5f;
            margin-top: 20px;
        }

        .table-header {
            background-color: #e1f2f1;
            color: #333;
            text-align: center;
            font-size: 12px;
            font-weight: bold;
            padding: 6px;
        }

        .table-content {
            width: 100%;
            font-size: 12px;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .table-content td {
            padding: 4px;
            text-align: left;
        }

        .table-content td b {
            font-weight: bold;
        }

        .table-content tr:last-child td {
            border-bottom: none;
        }

        .table-footer {
            margin-top: 20px;
            font-size: 11px;
            color: #666;
        }

        .table-footer th,
        .table-footer td {
            padding: 8px;
            text-align: left;
        }

        .table-footer th {
            background-color: #f4f7fc;
            font-weight: bold;
        }

        .table-footer tr:nth-child(even) {
            background-color: #fafafa;
        }

        .table-footer tr:hover {
            background-color: #e1f2f1;
        }

        .text-center {
            text-align: center;
        }
    </style>
</head>
<body>
    <header>
        <table class="table-content">
            <tr class="table-header">
                <td colspan="4" style="background-color: #006f6b; border: 0;">
                    <img src="images/logo.png" alt="Logo">
                </td>
            </tr>
        </table>
    </header>

    <p>ORDEN {{$orden['codigo']}}</p>

    <table class="table-content">
        <tr>
            <td><b>Fecha solicitud:</b></td>
            <td>{{$orden['fecha']}}</td>
            <td><b>Tipo:</b></td>
            <td> @if($orden['tipo_orden']=='d') Diagnóstico @else Reparación @endif</td>
        </tr>
       
        <tr>
            <td><b>Garantía:</b></td>
            <td> 
                @if($orden['tipo_garantia']=='NA') No aplica @endif
                @if($orden['tipo_garantia']=='co') Compra @endif
                @if($orden['tipo_garantia']=='st') Servicio técnico @endif
            </td>
            <td><b>Recibe:</b></td>
            <td> {{$orden['userregistra']['name']}}</td>
        </tr>
        <tr>
            <td><b>Observación:</b></td>
            <td>{{$orden['observacion_inicio']}}</td>
            <td><b>Local:</b></td>
            <td>{{$orden['local']['descripcion']}} - {{$orden['local']['direccion']}} </td>
        </tr>
        <tr>
            <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Datos del Cliente</b></td>
        </tr>
        <tr>
            <td><b>Identificación:</b></td>
            <td>{{$orden['cliente']['identificacion']}}</td>
            <td><b>Cliente:</b></td>
            <td>{{$orden['cliente']['nombres']}}</td>
        </tr>
        <tr>
            <td><b>Dirección:</b></td>
            <td>{{$orden['cliente']['direccion']}}</td>
            <td><b>Celular:</b></td>
            <td>{{$orden['cliente']['celular']}}</td>
        </tr>
        <tr>
            <td><b>Correo:</b></td>
            <td>{{$orden['cliente']['correo']}}</td>
        </tr>

        <tr>
            <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Datos del Móvil</b></td>
        </tr>
        <tr>
            <td><b>Modelo:</b></td>
            <td>{{$orden['modelo']}}</td>
            <td><b>IMEI:</b></td>
            <td>{{$orden['imei']}}</td>
        </tr>
        <tr>
            <td><b>Estado:</b></td>
            <td>{{$orden['estado_celular']}}</td>
            <td><b>Encendido:</b></td>
            <td>@if($orden['estado_encendido']=='En') Sí @else No (<b>No se puede comprobar periféricos</b>) @endif</td>
        </tr>
        
        <tr>
            <td><b>Accesorios:</b></td>
            <td colspan='3'>
                @if(sizeof($orden['ordenaccesorios'])>0)
                    @foreach($orden['ordenaccesorios'] as $key => $value)
                        {{$value['accesorios']['descripcion']}}
                        @if(!$loop->last) , @endif
                    @endforeach
                @else
                    Sin accesorios
                @endif
            </td>
           
        </tr>
        <tr>
            <td ><b>PIN:</b></td>
            <td >
                {{$orden['pin']}}
            </td>
            <td><b>Patrón:</b></td>
            <td><img width="30%" src="{{$orden['patron']}}"></td>
        </tr>
        <tr>
            <td colspan="4">
                <br> <br>
                <div style="text-align: left;">
                    @foreach($orden['imagenes_inicio'] as $value)
                        <img width="100px" src="imagenesorden/{{$value['ruta']}}" alt="img_orden" style="border: 1px solid #ccc;">
                    @endforeach
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Datos asignación</b></td>
        </tr>
        <tr>
            <td><b>Fecha:</b></td>
            <td>{{$orden['fecha_asigna']}}</td>
            <td><b>Usuario asigna:</b></td>
            <td>{{$orden['userasigna']['name']}}</td>
        </tr>
        <tr>
            <td><b>Técnico asignado:</b></td>
            <td>{{$orden['tecnico']['name']}}</td>
            <td><b>Observación para técnico:</b></td>
            <td>{{$orden['observacion_para_tecnico']}}</td>
        </tr>
        @if(sizeof($orden['diagnostico'])>0)
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Datos diagnóstico | reparación</b></td>
            </tr>
            @foreach($orden['diagnostico'] as $value)
                <tr >
                    <td style='padding-left:20px' ><b>@if($value['tipo_orden']=='d') Diagnóstico @endif @if($value['tipo_orden']=='r') Reparación @endif  </b></td>
                    <td style='padding-left:20px' colspan='3'>{{$value['observacion_diagnostico']}}</td>
                </tr>
                <tr>
                @if($value['tipo_orden']=='d') 
                    <td style='padding-left:40px'><b>Tiempo:</b></td>
                    <td style='padding-left:40px'>{{$value['dias']}} días {{$value['horas']}} horas {{$value['minutos']}} minutos  </td>
                @endif
                    <td style='padding-left:40px'><b>Costo total:</b></td>
                    <td style='padding-left:40px'>${{$value['costo_total']}}  </td>
                </tr>
                <tr>
                    <td style='padding-left:40px'><b>Costo material:</b></td>
                    <td style='padding-left:40px'>${{$value['costo_local']}}  </td>
                    <td style='padding-left:40px'><b>Costo técnico:</b></td>
                    <td style='padding-left:40px'>${{$value['costo_tecnico']}}  </td>
                </tr>
                <tr>
                    <td style='padding-left:40px'><b>Fecha:</b></td>
                    <td style='padding-left:40px'>{{$value['fecha_atiende']}}  </td>
                    <td style='padding-left:40px'><b>Usuario atiende:</b></td>
                    <td style='padding-left:40px'>{{$value['useratiende']['name']}}  </td>
                </tr>
                
            @endforeach
            @if(sizeof($orden['diagnostico'])>1)
                <tr>
                    <td colspan="4" style='font-weight:bold;color:blue'>
                        @if($orden['status_confirmado']==1)
                            @if($orden['user_confirma']==null)
                                El cliente confirmó la reparación el {{$orden['fecha_confirma']}} con la siguiente observación: {{$orden['observacion_confirma']}}
                            @else
                                Se confirmó la reparación el {{$orden['fecha_confirma']}} @if($orden['observacion_confirma']!=null) con la siguiente observación {{$orden['observacion_confirma']}}@endif
                            @endif
                        @endif
                    </td>
                </tr>
            @endif
            <tr>
                <td colspan="4">
                    <br> <br>
                    <div style="text-align: left;">
                        @foreach($orden['imagenes_atencion'] as $value)
                            <img width="100px" src="imagenesorden/{{$value['ruta']}}" alt="img_orden" style="border: 1px solid #ccc;">
                        @endforeach
                    </div>
                </td>
            </tr>
        @endif
        @if(sizeof($orden['incidencias'])>0)
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Historial de incidencias</b></td>
            </tr>
            <tr>
                <td colspan="4" style="font-size: 13px; ">
                    <table class="table-footer" width="100%" style="margin-top: 20px;">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Usuario</th>
                                <th>Descripción </th>
                                <th>Notificación</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orden['incidencias'] as $key => $valor)
                                @php 
                                $notificado=""; 
                                if($valor['correo_cliente']=='S' && $valor['correo_usuario']=='S'){
                                    $notificado='Cliente, usuario y administradores';
                                }
                                if($valor['correo_cliente']=='S' && $valor['correo_usuario']=='N'){
                                    $notificado='Cliente y administradores';
                                }
                                if($valor['correo_cliente']=='N' && $valor['correo_usuario']=='S'){
                                    $notificado='Usuario y administradores';
                                }
                                if($valor['correo_cliente']=='N' && $valor['correo_usuario']=='N'){
                                    $notificado='Administradores';
                                }
                                @endphp
                                <tr>
                                    <td>{{$valor['created_at']}}</td>
                                    <td>{{$valor['userregistra']['name']}}</td>
                                    <td><small>{{$valor['descripcion']}}</small></td>
                                    <td>{{$notificado}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                </td>
            </tr>
        @endif
        @if($orden['estado_orden']=='D')
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Información de anulación</b></td>
            </tr>
            <tr>
                <td><b>Fecha:</b></td>
                <td>{{$orden['fecha_anula']}}</td>
                <td><b>Usuario:</b></td>
                <td>{{$orden['useranula']['name']}}</td>
            </tr>
            <tr>
                <td><b>Observación:</b></td>
                <td colspan='3'>{{$orden['observacion_anulacion']}}</td>
            </tr>
        @endif

        @if($orden['entregado']==1)
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Información de entrega</b></td>
            </tr>
            <tr>
                <td><b>Fecha:</b></td>
                <td>{{$orden['fecha_entrega']}}</td>
                <td><b>Usuario:</b></td>
                <td>{{$orden['userentrega']['name']}}</td>
            </tr>
            <tr>
                <td><b>Observación:</b></td>
                <td colspan='3'>{{$orden['observacion_entrega']}}</td>
            </tr>
            <tr>
                <td><b>Transferencia:</b></td>
                <td>${{$orden['transferencia']}}</td>
                <td><b>Efectivo:</b></td>
                <td>${{$orden['efectivo']}}</td>
            </tr>
            <tr>
                <td colspan="4">
                    <br> <br>
                    <div style="text-align: left;">
                        @foreach($orden['imagenes_entrega'] as $value)
                            <img width="100px" src="imagenesorden/{{$value['ruta']}}" alt="img_orden" style="border: 1px solid #ccc;">
                        @endforeach
                    </div>
                </td>
            </tr>
        @else
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Información de entrega</b></td>
            </tr>
            <tr>
                <td colspan="4" ><b>Disposito no se encuentra entregado</b></td>
            </tr>
        @endif
       
    </table>

    

</body>
</html>
