<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte por fecha</title>
    <link rel="stylesheet" type="text/css" href="css/estiloReporte.css">
    <style type="text/css">
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            /* background-color: #f4f7fc; */
        }

        @page {
            margin-top: 2em;
            margin-left: 2em;
            margin-right: 2em;
            margin-bottom: 2em;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background-color: #005F73;
            color: white;
            height: 80px;
            text-align: center;
            line-height: 80px;
            font-size: 24px;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        }

        header img {
            height: 50px;
            margin-top: 10px;
        }

        .table-header {
            background-color: #f0f4f8;
            text-align: center;
            font-size: 11px;
            font-weight: bold;
            padding: 4px;
        }

        .table-content {
            border-collapse: collapse;
            width: 100%;
            font-size: 8.5px;
        }

        .table-content td {
            padding: 1px;
            border-bottom: 1px solid #e0e0e0;
            vertical-align: top;
        }

        .table-content td b {
            font-weight: bold;
        }

        .table-content tr:last-child td {
            border-bottom: none;
        }

   
     
      
        /* Ajuste para las tablas dentro de las órdenes */
        .table-content {
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <header>
        <table class="table-content" >
            <tr class="table-header">
                <td style=' background-color:rgb(72, 188, 205); border:0px' colspan="4"><img style=' height: 40px;
                    margin-top: 10px;' src="images/logo.png" alt="Logo">
                </td>
            </tr>
        </table>
    </header>
    <p style='font-size:14px' align='center'><b>REPORTE DESDE 2025-03-12 HASTA 2025-03-32</b></p>
    <table class="ltable" border="0" width="100%"  style="font-size: 9px; padding-top: 10px">
                <thead style="font-size: 11px !important; background-color: #D3D3D3 ">
                    <tr style="font-size: 11px !important; background-color: #D3D3D3 "> 
                        <th style="border: 0px; width: 20px; text-align: center;">#</th>
                        <th style="border: 0px; width: 70px; text-align: center;">Local</th>
                        <th style="border: 0px;width: 50px; text-align: center;">Orden</th> 
                        <th style="border: 0px;width: 70px; text-align: center;">Cliente</th> 
                        <th style="border: 0px;width: 50px; text-align: center;">Ingreso
                        <th style="border: 0px; width: 50px; text-align: center;">Salida</th>    
                        <th style="border: 0px; text-align: center; width: 50px">Modelo</th>  
                        <th style="border: 0px; text-align: center; width: 70px">Observación</th>  
                        <th style="border: 0px;width: 30px; text-align: center;">Garantía</th> 
                        <th style="border: 0px;width: 30px; text-align: center;">Tipo</th>   
                        <th style="border: 0px;width: 70px; text-align: center;">Técnico</th>  
                        <th style="border: 0px;width: 70px; text-align: center;">Estado</th>   
                        <th style="border: 0px;width: 30px; text-align: center;">Material</th>   
                        <th style="border: 0px;width:30px; text-align: center;">Reparación</th>   
                        <th style="border: 0px;width: 30px; text-align: center;">Total</th>   
                        <th style="border: 0px;width: 30px; text-align: center;">Utilidad</th>   
                      

                    </tr>
                </thead>
                <tbody >
                    @if(isset($ordenes))
                        @php
                            $total_costo_tecnico = 0;
                            $total_costo_total = 0;
                            $total_material = 0;
                            $total_utilidad = 0;
                        @endphp
                        @foreach($ordenes as $key=>$valor)
                        @php
                            if ($valor['tipo_orden'] == 'd') {
                                $valor['tipo_orden'] = 'Diagnóstico';
                                $valor['costo_total'] = 0;
                                $valor['costo_tecnico'] = 0;
                                $valor['material'] = 0;
                                $valor['efectivo'] = 0;
                                $valor['tarjeta_credito'] = 0;
                                $valor['transferencia'] = 0;
                                $valor['payphone'] = 0;
                            } else {
                                $valor['tipo_orden'] = 'Reparación';
                            }

                            if ($valor['estado_orden'] == 'D') {
                                $valor['costo_total'] = 0;
                                $valor['costo_tecnico'] = 0;
                                $valor['material'] = 0;
                                $valor['efectivo'] = 0;
                                $valor['tarjeta_credito'] = 0;
                                $valor['transferencia'] = 0;
                                $valor['estado_orden'] = 'Anulada';
                                $valor['payphone'] = 0;
                            } else {
                                $valor['estado_orden'] = 'Entregada';
                            }

                            if ($valor['tipo_garantia'] == 'NA') {
                                $valor['tipo_garantia'] = 'No aplica';
                            } elseif ($valor['tipo_garantia'] == 'co') {
                                $valor['tipo_garantia'] = 'Compra';
                            } elseif ($valor['tipo_garantia'] == 'st') {
                                $valor['tipo_garantia'] = 'Servicio técnico';
                            }
                            $utilidad = $valor['costo_total'] - $valor['material'] - $valor['costo_tecnico'];
                            $total_costo_tecnico += $valor['costo_tecnico'];
                            $total_costo_total += $valor['costo_total'];
                            $total_material += $valor['material'];
                            $total_utilidad += $utilidad;
                        @endphp
                            
                            <tr>
                                <td style="border: 0px; border-bottom: 1px solid;"><b>{{$key+1}}</b></td>
                                <td style="border: 0px; border-bottom: 1px solid; ">
                                    {{$valor['local']}} - {{$valor['dir_local']}}
                                </td>
                                <td style="border: 0px; border-bottom: 1px solid;">
                                    {{$valor['codigo']}}
                                </td>
                                <td style="border: 0px; border-bottom: 1px solid;">
                                   <small> {{$valor['identificacion']}} |  {{$valor['nombres']}}</small>
                                </td>
                                <td style="border: 0px; border-bottom: 1px solid;">
                                    {{$valor['fecha']}}
                                </td>
                                <td style="border: 0px;border-bottom: 1px solid;">
                                    {{$valor['fecha_entrega']}} 
                                </td>
                                <td style="border: 0px;border-bottom: 1px solid;">
                                    {{$valor['modelo']}} 
                                </td>
                                <td style="border: 0px;border-bottom: 1px solid;">
                                    {{$valor['observacion_inicio']}} 
                                </td>
                                <td style="border: 0px;border-bottom: 1px solid;">
                                    {{$valor['tipo_garantia']}} 
                                </td>
                                <td style="border: 0px;border-bottom: 1px solid;">
                                    {{$valor['tipo_orden']}} 
                                </td>
                                <td style="border: 0px;border-bottom: 1px solid;text-align: left">
                                    {{$valor['tecnico']}} 
                                </td>
                                <td style="border: 0px;border-bottom: 1px solid;text-align: center">
                                    @if($valor['estado_orden']=='Anulada')
                                        <b style='color:red; font-weight:bold'>{{$valor['estado_orden']}} </b>
                                    @else
                                        {{$valor['estado_orden']}}
                                    @endif
                                </td>
                                <td style="border: 0px;border-bottom: 1px solid;text-align: right">
                                    ${{ number_format($valor['material'], 2) }}
                                </td>
                                <td style="border: 0px; border-bottom: 1px solid; text-align: right">
                                    ${{ number_format($valor['costo_tecnico'], 2) }}
                                </td>
                                <td style="border: 0px; border-bottom: 1px solid; text-align: right">
                                    ${{ number_format($valor['costo_total'], 2) }}
                                </td>
                                <td style="border: 0px; border-bottom: 1px solid; text-align: right">
                                    ${{ number_format($valor['costo_total'] - $valor['material'] - $valor['costo_tecnico'], 2) }}
                                </td>
                               
                            </tr>
                        @endforeach
                    @endif
                </tbody>
                <tfoot style="font-size: 10px;">    
                            <tr class="text-right" style="font-weight: bold;">
                                <td style='border: 0px;' colspan="12"align="right"> TOTAL: </td>
                                <td style="border: 0px;text-align: right; font-weight: bold;">${{ number_format($total_material, 2) }}</td>
                                <td style="border: 0px;text-align: right; font-weight: bold;">${{ number_format($total_costo_tecnico, 2) }}</td>
                                <td style="border: 0px;text-align: right; font-weight: bold;">${{ number_format($total_costo_total, 2) }}</td>
                                <td style="border: 0px;text-align: right; font-weight: bold;">${{ number_format($total_utilidad, 2) }}</td>

                            </tr>
                </tfoot>
            </table>
</body>
</body>
</html>