@extends('layouts.head')

@section('content')
  <link rel="stylesheet" type="text/css" href="{{asset('DataTables/datatables.min.css')}}"/> 
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
        @if(isset($datos_admin))
            <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/echarts/dist/echarts.min.js"></script>
            <style>
                .chart-container {
                    width: 100%;
                    max-width: 620px;
                    height: auto;
                    aspect-ratio: 3 / 2;
                    margin: auto;
                    padding: 10px;
                    border: 2px solid #000;
                    border-radius: 10px;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                #donut-chart {
                    width: 100%;
                    height: 100%;
                }
                #donut-chart-clientes {
                    width: 100%;
                    height: 100%;
                }
                .icon i {
                        font-size: 50px !important;
                        transform: scale(0.9); /* Reduce el tamaño */
                    }

                    #bar-chart-clientes {
                        width: 100%;
                        height: 100%;
                    }
            </style>
                <div class="row ">
                    <div class="col-md-12 col-xs-12">
                        <div class="card" style="margin-top:30px">
                            <div class="card-header">
                                <center><img src="/images/logo.png" width="15%" alt="logo_institucional"></center>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    
                    <!-- Primer columna -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-default">
                            <!-- Contenido interno -->
                            <div class="inner">
                                <h4>{{$datos_admin['total']}}</h4>
                                <p>Total de ordenes</p>
                            </div>
                            <!-- Icono -->
                            <div class="icon">
                                <i class="fa fa-address-card-o"></i>
                            </div>
                            <!-- Enlace de pie de caja -->
                        </div>
                    </div>

                    <!-- Segunda columna -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-primary" onclick="modal_datos('I')" style="cursor:pointer;">
                            <div class="inner">
                                <h4>{{$datos_admin['sinasignar']}}<sup style="font-size: 20px"></sup></h4>
                                <p>Ordenes sin asignar</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-address-card-o"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Tercera columna -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-info" onclick="modal_datos('A')" style="cursor:pointer;">
                            <div class="inner">
                                <h4>{{$datos_admin['asignadas']}}</h4>
                                <p>Ordenes asignadas</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-address-card-o"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-warning" onclick="modal_datos('T')" style="cursor:pointer;">
                            <div class="inner">
                                <h4>{{$datos_admin['atendidas']}}</h4>
                                <p>Ordenes atendidas</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-address-card-o"></i>
                            </div>
                        </div>
                    </div>

                
                </div>
                <div class="row">
                    <!-- Primer columna -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-success" onclick="modal_datos('F')" style="cursor:pointer;">
                            <!-- Contenido interno -->
                            <div class="inner">
                                <h4>{{$datos_admin['entregadas']}}</h4>
                                <p>Ordenes entregadas</p>
                            </div>
                            <!-- Icono -->
                            <div class="icon">
                                <i class="fa fa-address-card-o" ></i>
                            </div>
                            <!-- Enlace de pie de caja -->
                        </div>
                    </div>

                    <!-- Segunda columna -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-danger" onclick="modal_datos('D')" style="cursor:pointer;">
                            <div class="inner">
                                <h4>{{$datos_admin['anuladas']}}</h4>
                                <p>Ordenes anuladas</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-address-card-o"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-dark">
                            <div class="inner">
                                <h4>{{$datos_admin['clientes']}}</h4>
                                <p>Clientes</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-users"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- Primer columna -->
                    <div class="col-lg-6 col-12">
                        <div style=' height: 300px !important;' class="chart-container">
                            <div id="donut-chart"></div>
                        </div>
                    </div>
                    <div   class="col-lg-6 col-12">
                        <div style=' height: 300px !important;' class="chart-container">
                            <div  id="bar-chart-clientes" ></div>
                        </div>
                    </div>
                </div>
            @else
            <div class="row ">
                    <div class="col-md-12 col-xs-12">
                        <div class="card" style="margin-top:30px">
                            <div class="card-header">
                                <center><img src="/images/logo.png" width="15%" alt="logo_institucional"></center>
                            </div>
                            <div class="card-body" align="center">
                                <h4>BIENVENIDOS </h4>
                            </div>
                        </div>
                    </div>
                </div>
               
            @endif
        </div>
    </section>
<div class="modal fade" id="modal_datos" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" >
        <div class="modal-dialog modal-dialog modal-dialog-scrollable modal-xs">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="title_atender"><i class='fa fa-file'></i> Información</h5>
                    <button type="button" class="close cerrar_modal" >
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table id="table_ordenes" class="table table-striped table-bordered dataTable no-footer" style="width:100%">
                                    <thead>
                                        <tr align="center"> 
                                            <th>Código</th>
                                            <th>Tipo</th>
                                        </tr>
                                    </thead>
                                    <tbody id="body_ordenes">
                                        
                                                                            
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default cerrar_modal"> <i class="fa fa-times"></i> Cerrar</button>
                </div>
            </div>
        </div>
    </div>
</div>
@if(isset($datos_admin))
<script type="text/javascript" src="{{asset('DataTables/datatables.min.js')}}"></script>
        <script>
            $(document).ready(function () {
                // Donut Chart
                var chart = echarts.init(document.getElementById('donut-chart'));
                var option = {
                    title: {
                        text: 'Usuarios',
                        left: 'center'
                    },
                    tooltip: {
                        trigger: 'item',
                        formatter: '{b}: {c} ({d}%)'
                    },
                    legend: {
                        orient: 'vertical',
                        left: 'left'
                    },
                    series: [
                        {
                            name: 'Datos',
                            type: 'pie',
                            radius: ['40%', '70%'],
                            avoidLabelOverlap: false,
                            label: {
                                show: false,
                                position: 'center'
                            },
                            emphasis: {
                                label: {
                                    show: true,
                                    fontSize: '10',
                                    fontWeight: 'bold'
                                }
                            },
                            labelLine: {
                                show: false
                            },
                            data: [
                                { value: {{$datos_admin['estandar']}}, name: 'Estandar' },
                                { value: {{$datos_admin['tecnico']}}, name: 'Técnicos' },
                                { value: {{$datos_admin['administrador']}}, name: 'Administradores' },
                            ]
                        }
                    ]
                };
                chart.setOption(option);
                window.addEventListener('resize', function () {
                    chart.resize();
                });

                // Bar Chart Clientes
                var chart2 = echarts.init(document.getElementById('bar-chart-clientes'));
                function getLast6Months() {
                    var months = [];
                    var date = new Date();
                    var monthNames = ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'];
                    for (var i = 5; i >= 0; i--) {
                        var prevMonth = new Date(date.getFullYear(), date.getMonth() - i, 1);
                        var monthYear = monthNames[prevMonth.getMonth()] + ' ' + prevMonth.getFullYear();
                        months.push(monthYear);
                    }
                    return months;
                }
                var ventas = [
                    {{$datos_admin['ventas'][0]}}, 
                    {{$datos_admin['ventas'][1]}}, 
                    {{$datos_admin['ventas'][2]}}, 
                    {{$datos_admin['ventas'][3]}}, 
                    {{$datos_admin['ventas'][4]}}, 
                    {{$datos_admin['ventas'][5]}}
                ];
                ventas = ventas.map(value => parseFloat(value).toFixed(2));
                var option2 = {
                    title: {
                        text: 'Total Ventas (Últimos 6 meses)',
                        left: 'center'
                    },
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {
                            type: 'shadow'
                        },
                        formatter: function (params) {
                            let result = params[0].axisValue + '<br/>';
                            params.forEach(item => {
                                result += item.marker + ' ' + item.seriesName + ': $' + parseFloat(item.value).toFixed(2) + '<br/>';
                            });
                            return result;
                        }
                    },
                    xAxis: {
                        type: 'category',
                        data: getLast6Months()
                    },
                    yAxis: {
                        type: 'value',
                        axisLabel: {
                            formatter: '${value}'
                        }
                    },
                    series: [
                        {
                            name: 'Ventas',
                            type: 'bar',
                            data: ventas,
                            itemStyle: {
                                color: '#0096d2'
                            },
                            label: {
                                show: true,
                                position: 'top',
                                formatter: '${c}'
                            }
                        }
                    ]
                };
                chart2.setOption(option2);
                window.addEventListener('resize', function () {
                    chart2.resize();
                });

                // Modal Datos
            
                
            });

            function modal_datos(status) {
                cargando('M', 'Por favor espere...');

                $("#table_ordenes").DataTable().destroy();
                $("#table_ordenes tbody").empty();
                $.get('/orden/statusorden/' + status, function (data) {
                    if (data['status'] == 'failed') {
                        mensaje_notificacion(data['response'], 'error');
                        cargando();
                        return;
                    }
                    $.each(data['response'], function (index, value) {
                        $("#body_ordenes").append(`
                                <tr>
                                    <td width='5%'><a target='_blank' href="/orden/indexdetalle/${btoa(value['id'])}">${value['codigo']}</a><br>
                                    </td>
                                    <td width='15%'>${value['tipo_orden_texto']}<br>
                                    </td>
                                </tr>
                            `);
                    });
                    $('#modal_datos').modal('show');
                cargar_estilos_tabla("table_ordenes", "desc",1);
                    cargando();
                }).fail(function () {
                    mensaje_notificacion('Inconvenientes al obtener registros', 'error');
                    cargando();
                });
            }
        </script>


    @endif
@endsection
