<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/',[App\Http\Controllers\HomeController::class, 'index'])->middleware(['auth', 'verified','validar_ruta']);;


Route::get('/local', function () {
    return view('auth.local_user');
})->middleware(['auth', 'verified']);

Route::post('/login_local',[App\Http\Controllers\Auth\RegistroUsuarioController::class, 'login_local']);


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware(['auth','admin'])->prefix('parametrizacion')->group(function(){
    Route::get('menu', [App\Http\Controllers\Administracion\GestionMenuController::class, 'menu_index']);
    Route::get('get-tabla', [App\Http\Controllers\Administracion\GestionMenuController::class, 'menu_get_tabla']);
    Route::post('store',[App\Http\Controllers\Administracion\GestionMenuController::class, 'menu_store']);
    Route::get('edit/{idmenu}', [App\Http\Controllers\Administracion\GestionMenuController::class, 'menu_edit']);
    Route::get('delete/{idmenu}', [App\Http\Controllers\Administracion\GestionMenuController::class, 'menu_delete']);

    Route::post('opcion/store',[App\Http\Controllers\Administracion\GestionMenuController::class, 'opcion_store']);
    Route::get('opcion/edit/{idmenu}', [App\Http\Controllers\Administracion\GestionMenuController::class, 'opcion_edit']);
    Route::get('opcion/delete/{idmenu}', [App\Http\Controllers\Administracion\GestionMenuController::class, 'opcion_delete']);

    Route::get('usuario/lista', [App\Http\Controllers\Auth\RegistroUsuarioController::class, 'usuario_lista']);
    Route::get('usuario', [App\Http\Controllers\Auth\RegistroUsuarioController::class, 'usuario_index']);
    Route::post('usuario/store', [App\Http\Controllers\Auth\RegistroUsuarioController::class, 'usuario_store']);
    Route::get('usuario/edit/{id}', [App\Http\Controllers\Auth\RegistroUsuarioController::class, 'usuario_edit']);
    Route::get('usuario/bloquear/{id}/{estado}', [App\Http\Controllers\Auth\RegistroUsuarioController::class, 'usuario_bloquear_desbloquear']);
    Route::get('usuario/desbloquear/{id}/{estado}', [App\Http\Controllers\Auth\RegistroUsuarioController::class, 'usuario_bloquear_desbloquear']);
    Route::get('usuario/resetpassword/{id}', [App\Http\Controllers\Auth\RegistroUsuarioController::class, 'resetearclave']);
    Route::get('usuario/opciones/{usuario_id}',[App\Http\Controllers\Administracion\GestionMenuController::class, 'usuario_opciones']);
    Route::get('usuario/opciones/asignar_quitar/{menu_opcion_id}/{usuario_id}',[App\Http\Controllers\Administracion\GestionMenuController::class, 'asignar_quitar']);

    Route::get('local', [App\Http\Controllers\Administracion\LocalesController::class, 'index']);
    Route::post('local/store',[App\Http\Controllers\Administracion\LocalesController::class, 'local_guardar']);
    Route::get('local/edit/{id}', [App\Http\Controllers\Administracion\LocalesController::class, 'local_editar']);
    Route::get('local/delete/{id}', [App\Http\Controllers\Administracion\LocalesController::class, 'local_eliminar']);
    Route::get('local/lista', [App\Http\Controllers\Administracion\LocalesController::class, 'local_lista']);

    Route::get('accesorios', [App\Http\Controllers\Administracion\AccesoriosController::class, 'index']);
    Route::post('accesorios/store',[App\Http\Controllers\Administracion\AccesoriosController::class, 'accesorio_guardar']);
    Route::get('accesorios/edit/{id}', [App\Http\Controllers\Administracion\AccesoriosController::class, 'accesorio_editar']);
    Route::get('accesorios/delete/{id}', [App\Http\Controllers\Administracion\AccesoriosController::class, 'accesorio_eliminar']);
    Route::get('accesorios/lista', [App\Http\Controllers\Administracion\AccesoriosController::class, 'accesorio_lista']);


    Route::get('parametros', [App\Http\Controllers\Administracion\ParametrosController::class, 'index']);
    Route::post('parametros/store',[App\Http\Controllers\Administracion\ParametrosController::class, 'parametros_guardar']);
    Route::get('parametros/edit/{id}', [App\Http\Controllers\Administracion\ParametrosController::class, 'parametros_editar']);
    Route::get('parametros/delete/{id}', [App\Http\Controllers\Administracion\ParametrosController::class, 'parametros_eliminar']);
    Route::get('parametros/lista', [App\Http\Controllers\Administracion\ParametrosController::class, 'parametros_lista']);

    Route::get('clientes', [App\Http\Controllers\Gestiones\ClienteController::class, 'index']);
    Route::get('clientes/edit/{id}', [App\Http\Controllers\Gestiones\ClienteController::class, 'cliente_editar']);
    Route::get('clientes/delete/{id}', [App\Http\Controllers\Gestiones\ClienteController::class, 'cliente_eliminar']);
    Route::get('clientes/lista', [App\Http\Controllers\Gestiones\ClienteController::class, 'cliente_lista']);

});

Route::PUT('usuario/updatepassword', [App\Http\Controllers\Auth\RegistroUsuarioController::class, 'cambiarclave'])->middleware(['auth']);

Route::middleware(['auth','validar_ruta'])->prefix('orden')->group(function () {
    Route::get('/', [App\Http\Controllers\Gestiones\OrdenController::class, 'index_orden']);
    Route::post('generar',[App\Http\Controllers\Gestiones\OrdenController::class, 'generar_orden']);
    Route::get('/ingresadas', [App\Http\Controllers\Gestiones\OrdenController::class, 'index_orden_ingresadas']);
    Route::get('/lista_ingresadas/{idlocal?}', [App\Http\Controllers\Gestiones\OrdenController::class, 'lista_ingresadas']);
    Route::get('/detalle/{id}', [App\Http\Controllers\Gestiones\OrdenController::class, 'detalle_orden']);
    Route::get('/qr_imagen/{id}/{nivel?}', [App\Http\Controllers\Gestiones\OrdenController::class, 'qr_imagen']);
    Route::get('/tecnicos/{idlocal}', [App\Http\Controllers\Gestiones\OrdenController::class, 'lista_tecnicos']);
    Route::POST('/asignar_tecnico', [App\Http\Controllers\Gestiones\OrdenController::class, 'asignar_tecnico']);
    Route::get('/reporte/{id}', [App\Http\Controllers\Gestiones\OrdenController::class, 'orden_reporte']);
    Route::get('/descargar/{id}', [App\Http\Controllers\Gestiones\OrdenController::class, 'descargar_orden_reporte']);

    Route::get('/asignadas', [App\Http\Controllers\Gestiones\OrdenController::class, 'index_asignadas']);
    Route::get('/lista_asignadas/{idlocal?}/{estado?}', [App\Http\Controllers\Gestiones\OrdenController::class, 'lista_asignadas']);

    Route::get('/lista_incidencias/{id}', [App\Http\Controllers\Gestiones\OrdenController::class, 'lista_incidencias']);

    Route::POST('/reportar_incidencia', [App\Http\Controllers\Gestiones\OrdenController::class, 'reportar_incidencia']);
    Route::get('/incidencias', [App\Http\Controllers\Gestiones\OrdenController::class, 'index_incidencias']);
    Route::get('/lista_incidencias_pendientes/{idlocal?}', [App\Http\Controllers\Gestiones\OrdenController::class, 'lista_incidencias_pendientes']);
    Route::POST('/atender', [App\Http\Controllers\Gestiones\OrdenController::class, 'store_atencion']);
    Route::get('/detalle_atencion/{id}/{tipo?}', [App\Http\Controllers\Gestiones\OrdenController::class, 'detalle_atencion']);
    Route::POST('/anular', [App\Http\Controllers\Gestiones\OrdenController::class, 'anular_orden']);
    Route::POST('/entregar', [App\Http\Controllers\Gestiones\OrdenController::class, 'entregar_orden']);
    Route::get('/buscar', [App\Http\Controllers\Gestiones\OrdenController::class, 'index_buscar']);
    Route::POST('/buscar', [App\Http\Controllers\Gestiones\OrdenController::class, 'filtro_buscar']);
    Route::POST('/filtro_grafico', [App\Http\Controllers\Gestiones\ReportesController::class, 'filtro_grafico']);
    Route::get('/graficos', [App\Http\Controllers\Gestiones\ReportesController::class, 'index_graficos']);


    Route::get('/ajuste_precios', [App\Http\Controllers\Gestiones\OrdenController::class, 'index_cambio_valores']);
    Route::POST('/buscar_entregadas', [App\Http\Controllers\Gestiones\OrdenController::class, 'buscar_entregadas']);
    Route::get('/detalle_costos/{id}', [App\Http\Controllers\Gestiones\OrdenController::class, 'detalle_costos']);
    Route::POST('/actualizar_costos', [App\Http\Controllers\Gestiones\OrdenController::class, 'actualizar_costos']);
    Route::get('/statusorden/{estado}', [App\Http\Controllers\Gestiones\OrdenController::class, 'ordenes_status']);

    Route::get('/indexdetalle/{id}', [App\Http\Controllers\Gestiones\OrdenController::class, 'detalle_orden_index']);
    Route::POST('/filtro_grafico_detalle', [App\Http\Controllers\Gestiones\OrdenController::class, 'filtro_grafico_detalle']);
    
    
    
});

Route::get('orden/imagi/{id}/{nivel?}', [App\Http\Controllers\Gestiones\OrdenController::class, 'cargar_imagen']);
Route::POST('orden/guardar_imagen', [App\Http\Controllers\Gestiones\OrdenController::class, 'guardar_imagen']);
Route::get('/orden/confirmar_orden/{id}', [App\Http\Controllers\Gestiones\OrdenController::class, 'confirmar_orden_link']);
Route::POST('/orden/confirmar', [App\Http\Controllers\Gestiones\OrdenController::class, 'confirmar_orden']);

Route::middleware(['auth','validar_ruta'])->prefix('clientes')->group(function () {
    Route::post('registrar',[App\Http\Controllers\Gestiones\ClienteController::class, 'store_cliente']);
    Route::get('buscar/{cedula}',[App\Http\Controllers\Gestiones\ClienteController::class, 'search_cliente']);

});

Route::middleware(['auth','validar_ruta'])->prefix('usuario')->group(function () {
    Route::get('cambiar_local/{idlocal}',[App\Http\Controllers\Administracion\LocalesController::class, 'cambiar_local']);

});

Route::middleware(['auth','validar_ruta'])->prefix('reportes')->group(function () {
    Route::get('porfecha',[App\Http\Controllers\Gestiones\ReportesController::class, 'index_reporte_fecha']);
    Route::post('filtrofechas',[App\Http\Controllers\Gestiones\ReportesController::class, 'filtro_fechas']);
    Route::post('filtrar_report_pdf',[App\Http\Controllers\Gestiones\ReportesController::class, 'filtro_fechas_pdf']);
    Route::post('filtrar_report_excel',[App\Http\Controllers\Gestiones\ReportesController::class, 'filtro_fechas_excel']);
    Route::get('filtrar_report_pdf2',[App\Http\Controllers\Gestiones\ReportesController::class, 'filtro_fechas_pdf']);
    Route::get('portecnicos',[App\Http\Controllers\Gestiones\ReportesController::class, 'index_ordenes_tecnicos']);
    Route::post('ordenes_tecnicos_pdf',[App\Http\Controllers\Gestiones\ReportesController::class, 'ordenes_tecnicos_pdf']);
    Route::post('ordenes_tecnicos',[App\Http\Controllers\Gestiones\ReportesController::class, 'ordenes_tecnicos']);
    Route::get('varios',[App\Http\Controllers\Gestiones\ReportesController::class, 'index_varios']);
    Route::get('clientes',[App\Http\Controllers\Gestiones\ReportesController::class, 'clientes']);
    Route::get('clientes_excel',[App\Http\Controllers\Gestiones\ReportesController::class, 'clientes_excel']);
    Route::get('tecnicos_excel',[App\Http\Controllers\Gestiones\ReportesController::class, 'tecnicos_excel']);
    Route::get('usuarios_excel',[App\Http\Controllers\Gestiones\ReportesController::class, 'usuarios_excel']);

    Route::get('tecnicos',[App\Http\Controllers\Gestiones\ReportesController::class, 'tecnicos']);
    Route::get('usuarios',[App\Http\Controllers\Gestiones\ReportesController::class, 'usuarios']);
    Route::get('orden_historial/{id}',[App\Http\Controllers\Gestiones\ReportesController::class, 'orden_historial']);
});



require __DIR__.'/auth.php';
