<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta property="og:title" content="CELULAR PLANET"/>
  <meta property="og:description" content="CELULAR PLANET"/>
  <meta property="og:url" content="https://celularplanet.ec/"/> <!-- Reemplaza con la URL real de tu página -->
  <meta name="twitter:card" content="summary_large_image"/>
  <meta name="twitter:title" content="CELULAR PLANET"/>
  <meta name="twitter:description" content="CELULAR PLANET"/>
  <title>CELULAR PLANET</title>

  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <link href="<?php echo e(asset('fontawesome/font-awesome.css')); ?>" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo e(asset('/plantilla/css/adminlte.min.css')); ?>">
  <link href="<?php echo e(asset('pnotify/dist/pnotify.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('pnotify/dist/pnotify.buttons.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('pnotify/dist/pnotify.nonblock.css')); ?>" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo e(asset('/plantilla/plugins/select2/css/select2.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('/plantilla/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
  <link rel="stylesheet" type="text/css" href="<?php echo e(asset('DataTables/datatables.min.css')); ?>"/> 
  <link rel="stylesheet" href="<?php echo e(asset('sweetalert/sweetalert.css')); ?>">
  <script src="<?php echo e(asset('js/app.js')); ?>"></script>
  <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
</head>
<body >
        <section class="content">
            <div class="container-fluid">
                <div class="row   justify-content-center">
                    <div class="col-md-6">
                        <div class="card card-color row">
                                <div class="card-header" align='center' >
                                <img width="13%" src="/images/logo.png" alt="logo">
                                </div>
                                <div id='div_form'>
                                    <form id="form_imagen_orden" action="/orden/guardar_imagen"  style='font-size:12px'  method="POST" enctype="multipart/form-data">
                                        <?php echo e(csrf_field()); ?>

                                        <?php if(session()->has('mensaje')): ?>
                                            <script>
                                                $(document).ready(function() {
                                                    mensaje_notificacion('<?php echo e(session('mensaje')); ?>','<?php echo e(session('status')); ?>');
                                                });
                                            </script>
                                        <?php endif; ?>
                                        <input type="hidden" name='estado_orden' id='estado_orden' value="<?php echo e(encrypt($data['estado_orden'])); ?>">
                                        <input type="hidden" name='id_orden' id='id_orden' value="<?php echo e(encrypt($data['idorden'])); ?>">
                                        <div class="card-body">
                                            <b>REGISTRO DE IMAGENES ORDEN <?php echo e($data['codigo']); ?> | <?php echo e($data['local']); ?></b>
                                            <hr>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <p ><b>Cédula:</b> <?php echo e($data['identificacion']); ?></p>
                                                        <p ><b>Cliente:</b> <?php echo e($data['nombres']); ?></p>
                                                        <p ><b>Accesorios:</b>
                                                            <?php $__currentLoopData = $accesorios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php echo e($value['accesorios']['descripcion']); ?>

                                                                <?php if(!$loop->last): ?> 
                                                                    ,
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                    <label for="">Descripción:</label>

                                                        <input type="text" class='form-control' placeholder='Ingrese descripción' id='descripcion' name='descripcion' required>                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                    <label >Imagen:</label>
                                                        <input type="file" class='form-control' id='imagen' name='imagen' required>                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        
                                        </div>
                                        <div class="card-footer" id="btn_footer">
                                            <button type="submit" class="btn btn-primary btn-sm"> <i class="fa fa-save"></i> Guardar imagen</button>
                                        </div>
                                    </form>
                                </div>
                                <div id='div_imagenes' > <br>
                                <?php if(isset($images)): ?>
                                    <div  style="display: flex; flex-wrap: wrap; gap: 10px;"> <!-- Contenedor flexible -->
                                    <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <br> <br>
                                            <div style="text-align: center;"> <!-- Contenedor para cada imagen y descripción -->
                                                <p style="margin: 0; font-weight: bold;"><?php echo e($value['descripcion']); ?></p>
                                                <a href="/imagenesorden/<?php echo e($value['ruta']); ?>"><img width="120px" src="/imagenesorden/<?php echo e($value['ruta']); ?>" alt="d" style="border: 1px solid #ccc;"></a>
                                                <br><br>
                                            </div> 
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>
                                </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </section>

    <!-- Modal clientes -->
    <div class="modal fade" id="modal_clientes" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" >
        <div class="modal-dialog  modal-dialog-scrollable modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class='fa fa-user'></i> Registro de clientes</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-bs-dismiss="modal">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="form_clientes" style='font-size:12px'  method="POST" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <div class="card-body">
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="cedula">Cédula *</label>
                                        <input type="text" class="form-control" id="cedula_clientes" name="cedula_clientes" placeholder="Ingrese cédula" required>
                                    </div>
                                    
                                    <div class="col-md-8">
                                        <label for="nombre">Nombre y apellidos *</label>
                                        <input  type="text" class="form-control" id="nombres_clientes" name="nombres_clientes" placeholder="Ingrese nombre y apellidos" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="celular_clientes">Celular</label>
                                        <input type="text" class="form-control" id="celular_clientes" name="celular_clientes" placeholder="Ingrese celular" >
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <label for="correo_clientes">Correo</label>
                                        <input  type="text" class="form-control" id="correo_clientes" name="correo_clientes" placeholder="Ingrese correo" >
                                    </div>
                                    <div class="col-md-4">
                                        <label for="direccion_clientes">Dirección</label>
                                        <input  type="text" class="form-control" id="direccion_clientes" name="direccion_clientes" placeholder="Ingrese direccion" >
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-12" >
                                        <label ></label>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-save"></i> Registrar cliente</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default cerrar_modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
    <script src="/plantilla/js/adminlte.js"></script>
    <script src="<?php echo e(asset('js/gestiones/ordenes/cargar_imagen.js?v='.rand())); ?>"></script>
</body>
</html>
<?php /**PATH C:\laragon\www\PROYECTOS\Ordenes\resources\views/gestiones/ordenes/imagen_qr.blade.php ENDPATH**/ ?>