<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de tecnicos</title>
    <link rel="stylesheet" type="text/css" href="css/estiloReporte.css">
    <style type="text/css">
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            /* background-color: #f4f7fc; */
        }

        @page {
            margin-top: 2em;
            margin-left: 2em;
            margin-right: 2em;
            margin-bottom: 2em;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background-color: #005F73;
            color: white;
            height: 80px;
            text-align: center;
            line-height: 80px;
            font-size: 24px;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        }

        header img {
            height: 50px;
            margin-top: 10px;
        }

        .table-header {
            background-color: #f0f4f8;
            text-align: center;
            font-size: 11px;
            font-weight: bold;
            padding: 4px;
        }

        .table-content {
            border-collapse: collapse;
            width: 100%;
            font-size: 8.5px;
        }

        .table-content td {
            padding: 1px;
            border-bottom: 1px solid #e0e0e0;
            vertical-align: top;
        }

        .table-content td b {
            font-weight: bold;
        }

        .table-content tr:last-child td {
            border-bottom: none;
        }
        /* Ajuste para las tablas dentro de las órdenes */
        .table-content {
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <header>
        <table class="table-content" >
            <tr class="table-header">
                <td style=' background-color:rgb(72, 188, 205); border:0px' colspan="4"><img style=' height: 40px;
                    margin-top: 10px;' src="images/logo.png" alt="Logo">
                </td>
            </tr>
        </table>
    </header>
    <p style='font-size:14px' align='center'><b>REPORTE DE TÉCNICOS</b></p>
    <p style='font-size:12px'><b>Fecha emisión: </b> <?php echo e(date('d-m-Y H:i:s')); ?>  </p>
    <table class="ltable" border="0" width="100%"  style="font-size: 9px; padding-top: 10px">
                <thead style="font-size: 11px !important; background-color: #D3D3D3 ">
                    <tr style="font-size: 11px !important; background-color: #D3D3D3 "> 
                        <th style="border: 0px; width: 10px; text-align: center;">#</th>
                        <th style="border: 0px; width: 10px; text-align: left;">Identificación</th>
                        <th style="border: 0px;width: 140px; text-align: cenleftter;">Nombres</th> 
                        <th style="border: 0px;width: 50px; text-align: left;">Celular</th> 
                        <th style="border: 0px; width: 50px; text-align: left;">Correo</th>    
                        <th style="border: 0px; width: 80px; text-align: left;">Local</th>    
                        <th style="border: 0px; width: 80px; text-align: left;">Creado</th>    

                    </tr>
                </thead>
                <tbody >
                    <?php if(isset($tecnicos)): ?>
                        <?php $__currentLoopData = $tecnicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$valor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td style="border: 0px; border-bottom: 1px solid;text-align:center "><b><?php echo e($key+1); ?></b></td>
                                <td style="border: 0px; border-bottom: 1px solid;">
                                    <?php echo e($valor['identificacion']); ?>

                                </td>
                                <td style="border: 0px; border-bottom: 1px solid;">
                                    <?php echo e($valor['name']); ?>

                                </td>
                                <td style="border: 0px; border-bottom: 1px solid;">
                                   <small> <?php echo e($valor['celular']); ?></small>
                                </td>
                                <td style="border: 0px; border-bottom: 1px solid;">
                                    <?php echo e($valor['email']); ?>

                                </td>
                                <td style="border: 0px;border-bottom: 1px solid;">
                                    <?php $__currentLoopData = $valor['localesusuario']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($value['local']['descripcion']); ?> - <?php echo e($value['local']['direccion']); ?> </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td style="border: 0px; border-bottom: 1px solid;">
                                    <?php echo e($valor['created_at']); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
</body>
</body>
</html><?php /**PATH C:\laragon\www\PROYECTOS\SoporteCelular\resources\views/reportes/tecnicos_pdf.blade.php ENDPATH**/ ?>