<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Orden</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap">
    <style type="text/css">
        body {
            font-family: 'Roboto', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #ffffff;
            color: #333;
        }

        @page {
            margin-top: 2em;
            margin-left: 2em;
            margin-right: 2em;
            margin-bottom: 2em;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background-color: #006f6b;
            color: white;
            height: 100px;
            text-align: center;
            line-height: 100px;
            font-size: 24px;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        }

        header img {
            height: 50px;
            margin-top: 10px;
        }

        p {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            color: #005f5f;
            margin-top: 20px;
        }

        .table-header {
            background-color: #e1f2f1;
            color: #333;
            text-align: center;
            font-size: 12px;
            font-weight: bold;
            padding: 6px;
        }

        .table-content {
            width: 100%;
            font-size: 12px;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .table-content td {
            padding: 4px;
            text-align: left;
        }

        .table-content td b {
            font-weight: bold;
        }

        .table-content tr:last-child td {
            border-bottom: none;
        }

        .table-footer {
            margin-top: 20px;
            font-size: 11px;
            color: #666;
        }

        .table-footer th,
        .table-footer td {
            padding: 8px;
            text-align: left;
        }

        .table-footer th {
            background-color: #f4f7fc;
            font-weight: bold;
        }

        .table-footer tr:nth-child(even) {
            background-color: #fafafa;
        }

        .table-footer tr:hover {
            background-color: #e1f2f1;
        }

        .text-center {
            text-align: center;
        }
    </style>
</head>
<body>
    <header>
        <table class="table-content">
            <tr class="table-header">
                <td colspan="4" style="background-color: #006f6b; border: 0;">
                    <img src="images/logo.png" alt="Logo">
                </td>
            </tr>
        </table>
    </header>

    <p>ORDEN <?php echo e($orden['codigo']); ?></p>

    <table class="table-content">
        <tr>
            <td><b>Fecha solicitud:</b></td>
            <td><?php echo e($orden['fecha']); ?></td>
            <td><b>Tipo:</b></td>
            <td> <?php if($orden['tipo_orden']=='d'): ?> Diagnóstico <?php else: ?> Reparación <?php endif; ?></td>
        </tr>
       
        <tr>
            <td><b>Garantía:</b></td>
            <td> 
                <?php if($orden['tipo_garantia']=='NA'): ?> No aplica <?php endif; ?>
                <?php if($orden['tipo_garantia']=='co'): ?> Compra <?php endif; ?>
                <?php if($orden['tipo_garantia']=='st'): ?> Servicio técnico <?php endif; ?>
            </td>
            <td><b>Recibe:</b></td>
            <td> <?php echo e($orden['userregistra']['name']); ?></td>
        </tr>
        <tr>
            <td><b>Observación:</b></td>
            <td><?php echo e($orden['observacion_inicio']); ?></td>
            <td><b>Local:</b></td>
            <td><?php echo e($orden['local']['descripcion']); ?> - <?php echo e($orden['local']['direccion']); ?> </td>
        </tr>
        <tr>
            <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Datos del Cliente</b></td>
        </tr>
        <tr>
            <td><b>Identificación:</b></td>
            <td><?php echo e($orden['cliente']['identificacion']); ?></td>
            <td><b>Cliente:</b></td>
            <td><?php echo e($orden['cliente']['nombres']); ?></td>
        </tr>
        <tr>
            <td><b>Dirección:</b></td>
            <td><?php echo e($orden['cliente']['direccion']); ?></td>
            <td><b>Celular:</b></td>
            <td><?php echo e($orden['cliente']['celular']); ?></td>
        </tr>
        <tr>
            <td><b>Correo:</b></td>
            <td><?php echo e($orden['cliente']['correo']); ?></td>
        </tr>

        <tr>
            <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Datos del Móvil</b></td>
        </tr>
        <tr>
            <td><b>Modelo:</b></td>
            <td><?php echo e($orden['modelo']); ?></td>
            <td><b>IMEI:</b></td>
            <td><?php echo e($orden['imei']); ?></td>
        </tr>
        <tr>
            <td><b>Estado:</b></td>
            <td><?php echo e($orden['estado_celular']); ?></td>
            <td><b>Encendido:</b></td>
            <td><?php if($orden['estado_encendido']=='En'): ?> Sí <?php else: ?> No (<b>No se puede comprobar periféricos</b>) <?php endif; ?></td>
        </tr>
        
        <tr>
            <td><b>Accesorios:</b></td>
            <td colspan='3'>
                <?php if(sizeof($orden['ordenaccesorios'])>0): ?>
                    <?php $__currentLoopData = $orden['ordenaccesorios']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($value['accesorios']['descripcion']); ?>

                        <?php if(!$loop->last): ?> , <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    Sin accesorios
                <?php endif; ?>
            </td>
           
        </tr>
        <tr>
            <td ><b>PIN:</b></td>
            <td >
                <?php echo e($orden['pin']); ?>

            </td>
            <td><b>Patrón:</b></td>
            <td><img width="30%" src="<?php echo e($orden['patron']); ?>"></td>
        </tr>
        <tr>
            <td colspan="4">
                <br> <br>
                <div style="text-align: left;">
                    <?php $__currentLoopData = $orden['imagenes_inicio']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <img width="100px" src="imagenesorden/<?php echo e($value['ruta']); ?>" alt="img_orden" style="border: 1px solid #ccc;">
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Datos asignación</b></td>
        </tr>
        <tr>
            <td><b>Fecha:</b></td>
            <td><?php echo e($orden['fecha_asigna']); ?></td>
            <td><b>Usuario asigna:</b></td>
            <td><?php echo e($orden['userasigna']['name']); ?></td>
        </tr>
        <tr>
            <td><b>Técnico asignado:</b></td>
            <td><?php echo e($orden['tecnico']['name']); ?></td>
            <td><b>Observación para técnico:</b></td>
            <td><?php echo e($orden['observacion_para_tecnico']); ?></td>
        </tr>
        <?php if(sizeof($orden['diagnostico'])>0): ?>
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Datos diagnóstico | reparación</b></td>
            </tr>
            <?php $__currentLoopData = $orden['diagnostico']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr >
                    <td style='padding-left:20px' ><b><?php if($value['tipo_orden']=='d'): ?> Diagnóstico <?php endif; ?> <?php if($value['tipo_orden']=='r'): ?> Reparación <?php endif; ?>  </b></td>
                    <td style='padding-left:20px' colspan='3'><?php echo e($value['observacion_diagnostico']); ?></td>
                </tr>
                <tr>
                <?php if($value['tipo_orden']=='d'): ?> 
                    <td style='padding-left:40px'><b>Tiempo:</b></td>
                    <td style='padding-left:40px'><?php echo e($value['dias']); ?> días <?php echo e($value['horas']); ?> horas <?php echo e($value['minutos']); ?> minutos  </td>
                <?php endif; ?>
                    <td style='padding-left:40px'><b>Costo total:</b></td>
                    <td style='padding-left:40px'>$<?php echo e($value['costo_total']); ?>  </td>
                </tr>
                <tr>
                    <td style='padding-left:40px'><b>Costo material:</b></td>
                    <td style='padding-left:40px'>$<?php echo e($value['costo_local']); ?>  </td>
                    <td style='padding-left:40px'><b>Costo técnico:</b></td>
                    <td style='padding-left:40px'>$<?php echo e($value['costo_tecnico']); ?>  </td>
                </tr>
                <tr>
                    <td style='padding-left:40px'><b>Fecha:</b></td>
                    <td style='padding-left:40px'><?php echo e($value['fecha_atiende']); ?>  </td>
                    <td style='padding-left:40px'><b>Usuario atiende:</b></td>
                    <td style='padding-left:40px'><?php echo e($value['useratiende']['name']); ?>  </td>
                </tr>
                
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if(sizeof($orden['diagnostico'])>1): ?>
                <tr>
                    <td colspan="4" style='font-weight:bold;color:blue'>
                        <?php if($orden['status_confirmado']==1): ?>
                            <?php if($orden['user_confirma']==null): ?>
                                El cliente confirmó la reparación el <?php echo e($orden['fecha_confirma']); ?> con la siguiente observación: <?php echo e($orden['observacion_confirma']); ?>

                            <?php else: ?>
                                Se confirmó la reparación el <?php echo e($orden['fecha_confirma']); ?> <?php if($orden['observacion_confirma']!=null): ?> con la siguiente observación <?php echo e($orden['observacion_confirma']); ?><?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endif; ?>
            <tr>
                <td colspan="4">
                    <br> <br>
                    <div style="text-align: left;">
                        <?php $__currentLoopData = $orden['imagenes_atencion']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <img width="100px" src="imagenesorden/<?php echo e($value['ruta']); ?>" alt="img_orden" style="border: 1px solid #ccc;">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </td>
            </tr>
        <?php endif; ?>
        <?php if(sizeof($orden['incidencias'])>0): ?>
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Historial de incidencias</b></td>
            </tr>
            <tr>
                <td colspan="4" style="font-size: 13px; ">
                    <table class="table-footer" width="100%" style="margin-top: 20px;">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Usuario</th>
                                <th>Descripción </th>
                                <th>Notificación</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orden['incidencias']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $valor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php 
                                $notificado=""; 
                                if($valor['correo_cliente']=='S' && $valor['correo_usuario']=='S'){
                                    $notificado='Cliente, usuario y administradores';
                                }
                                if($valor['correo_cliente']=='S' && $valor['correo_usuario']=='N'){
                                    $notificado='Cliente y administradores';
                                }
                                if($valor['correo_cliente']=='N' && $valor['correo_usuario']=='S'){
                                    $notificado='Usuario y administradores';
                                }
                                if($valor['correo_cliente']=='N' && $valor['correo_usuario']=='N'){
                                    $notificado='Administradores';
                                }
                                ?>
                                <tr>
                                    <td><?php echo e($valor['created_at']); ?></td>
                                    <td><?php echo e($valor['userregistra']['name']); ?></td>
                                    <td><small><?php echo e($valor['descripcion']); ?></small></td>
                                    <td><?php echo e($notificado); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </td>
            </tr>
        <?php endif; ?>
        <?php if($orden['estado_orden']=='D'): ?>
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Información de anulación</b></td>
            </tr>
            <tr>
                <td><b>Fecha:</b></td>
                <td><?php echo e($orden['fecha_anula']); ?></td>
                <td><b>Usuario:</b></td>
                <td><?php echo e($orden['useranula']['name']); ?></td>
            </tr>
            <tr>
                <td><b>Observación:</b></td>
                <td colspan='3'><?php echo e($orden['observacion_anulacion']); ?></td>
            </tr>
        <?php endif; ?>

        <?php if($orden['entregado']==1): ?>
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Información de entrega</b></td>
            </tr>
            <tr>
                <td><b>Fecha:</b></td>
                <td><?php echo e($orden['fecha_entrega']); ?></td>
                <td><b>Usuario:</b></td>
                <td><?php echo e($orden['userentrega']['name']); ?></td>
            </tr>
            <tr>
                <td><b>Observación:</b></td>
                <td colspan='3'><?php echo e($orden['observacion_entrega']); ?></td>
            </tr>
            <tr>
                <td><b>Transferencia:</b></td>
                <td>$<?php echo e($orden['transferencia']); ?></td>
                <td><b>Efectivo:</b></td>
                <td>$<?php echo e($orden['efectivo']); ?></td>
            </tr>
            <tr>
                <td colspan="4">
                    <br> <br>
                    <div style="text-align: left;">
                        <?php $__currentLoopData = $orden['imagenes_entrega']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <img width="100px" src="imagenesorden/<?php echo e($value['ruta']); ?>" alt="img_orden" style="border: 1px solid #ccc;">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </td>
            </tr>
        <?php else: ?>
            <tr>
                <td colspan="4" style="font-size: 13px; background-color: #f0f4f7;"><b>Información de entrega</b></td>
            </tr>
            <tr>
                <td colspan="4" ><b>Disposito no se encuentra entregado</b></td>
            </tr>
        <?php endif; ?>
       
    </table>

    

</body>
</html>
<?php /**PATH C:\laragon\www\PROYECTOS\SoporteCelular\resources\views/reportes/orden_historial_pdf.blade.php ENDPATH**/ ?>