<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orden de Trabajo</title>
    <link rel="stylesheet" type="text/css" href="css/estiloReporte.css">
    <style type="text/css">
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            /* background-color: #f4f7fc; */
        }

        @page {
            margin-top: 2em;
            margin-left: 2em;
            margin-right: 2em;
            margin-bottom: 2em;
            size: A4;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background-color: #005F73;
            color: white;
            height: 80px;
            text-align: center;
            line-height: 80px;
            font-size: 24px;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        }

        header img {
            height: 50px;
            margin-top: 10px;
        }

        .container {
            width: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .order {
            width: 100%;
            height: 50%;
            padding: 4px;
            box-sizing: border-box;
            /* overflow: hidden; */
        }

        .table-header {
            background-color: #f0f4f8;
            text-align: center;
            font-size: 11px;
            font-weight: bold;
            padding: 4px;
        }

        .table-content {
            border-collapse: collapse;
            width: 100%;
            font-size: 8.5px;
        }

        .table-content td {
            padding: 1px;
            border-bottom: 1px solid #e0e0e0;
            vertical-align: top;
        }

        .table-content td b {
            font-weight: bold;
        }

        .table-content tr:last-child td {
            border-bottom: none;
        }

        /* .highlight {
            background-color: #f9f9f9;
            font-weight: bold;
        } */

        .footer {
            margin-top: 20px;
            font-size: 10px;
            text-align: center;
            color: #888;
        }

        .note {
            font-size: 12px;
            color: #444;
            margin-top: 10px;
        }

        .patron-img {
            display: block;
            margin-left: auto;
            margin-right: auto;
            width: 20%;
        }

        .order-container {
            width: 100%;
            height: 100%;
            overflow: auto;
        }

        .note-container {
            margin-top: 10px;
            font-size: 12px;
            color: #444;
        }

        /* Ajuste para las tablas dentro de las órdenes */
        .table-content {
            margin-bottom: 10px;
        }
    </style>
</head>
<body>

    <div class="container">
        <!-- Orden de Trabajo 1 (Parte superior) -->
        <div class="order">
            <!-- <header>
                <img src="images/logo.png" alt="Logo">
            </header> -->
            <table class="table-content" >
				<tr class="table-header">
                    <td style="<?php if($data['tipo_orden']=='d'): ?> background-color:pink; <?php else: ?> background-color:rgb(71, 93, 255); <?php endif; ?> " colspan="4"><img style=' height: 30px;
            			margin-top: 10px;' src="images/logo.png" alt="Logo">
					</td>
                </tr>
                <tr class="table-header">
                    <td colspan="4">ORDEN DE TRABAJO #<?php echo e($data['codigo']); ?></td>
                </tr>
                <tr>
                    <td colspan="4" class="highlight">
                        <b>Fecha y hora recibe:</b> <?php echo e(date('d-m-Y',strtotime($data['fecha_recibe']))); ?> <?php echo e($data['hora_recibe']); ?>

                    </td>
                </tr>
                <tr>
                    <td><b>Cliente:</b> <?php echo e($data['cliente']['nombres']); ?></td>
                    <td><b>Celular:</b> <?php echo e($data['cliente']['celular']); ?></td>
                    <td><b>Cédula:</b> <?php echo e($data['cliente']['identificacion']); ?></td>
                    <td><b>Recibe:</b> <?php echo e($data['userregistra']['name']); ?></td>
                </tr>
                <tr>
                    <td><b>Tipo:</b> 
                        <?php if($data['tipo_orden']=='d'): ?> Diagnóstico <?php else: ?> Reparación <?php endif; ?>
                    </td>
                    <td colspan='3'><b>Garantía:</b> 
                        <?php if($data['tipo_garantia']=='NA'): ?> No aplica <?php endif; ?>
                        <?php if($data['tipo_garantia']=='co'): ?> Compra <?php endif; ?>
                        <?php if($data['tipo_garantia']=='st'): ?> Servicio técnico <?php endif; ?>
                    </td>
                </tr>
                <tr class="table-header">
                    <td colspan="4">INFORMACIÓN DEL EQUIPO</td>
                </tr>
                <tr>
                    <td><b>Modelo:</b> <?php echo e($data['modelo']); ?></td>
                    <td><b>ESN o IMEI:</b> <?php echo e($data['imei']); ?></td>
                    <td colspan="2"><b>Accesorios:</b>
                        <?php if(sizeof($data['ordenaccesorios'])>0): ?>
                            <?php $__currentLoopData = $data['ordenaccesorios']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($value['accesorios']['descripcion']); ?>

                                <?php if(!$loop->last): ?> , <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            Sin accesorios
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><b>Estado:</b> <?php echo e($data['estado_celular']); ?></td>
                    <td>Tiene clave:</b> <?php if($data['tiene_clave']=='S'): ?> Si <?php else: ?> No  <?php endif; ?></td>
                    <td colspan="2"><b>Encendido:</b> <?php if($data['estado_encendido']=='en'): ?> Si <?php else: ?> No (<b>No se puede comprobar periféricos</b>) <?php endif; ?></td>
                </tr>
                <tr>
                    <td colspan="1"><b>Pin:</b> <?php echo e($data['pin']); ?></td>
                    <td colspan="1" style="border-right: solid 0px" ><b>Patrón:</b> </td>

                    <td colspan="2" style="border-left: solid 0px" > <img width="20%" src="<?php echo e($data['patron']); ?>"></td>
                </tr>
                <tr>
                    <td colspan="4"><b>Observación:</b> <?php echo e($data['observacion_inicio']); ?></td>
                </tr>
				<tr>
                    <td colspan="4" style="text-align:justify;border-bottom: solid 1px">
                        <b>Notas:</b> <br>
                        <?php $__currentLoopData = $notas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li style="margin-left:20px"><?php echo e($value['valor']); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
                <tr>
                    <td colspan="4" style="text-align:justify;border: solid 0px;border-left: solid 1px;border-right: solid 1px">
                    <b>CLIENTE:</b>
                    <?php $__currentLoopData = $aceptacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li style="margin-left:20px"><?php echo e($value2['valor']); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="text-align:center;border: solid 0px;border-left: solid 1px;border-bottom: solid 1px">
                        <br><br><br><br>
                        <?php echo e($data['cliente']['nombres']); ?> <br><b>Firma del cliente </b>
                    </td>
                    <td colspan="2" style="text-align:center;border: solid 0px;border-right: solid 1px;border-bottom: solid 1px">
                        <br><br><br><br>
                        _______________________ <br><b>Firma autorizada </b>
                    </td>
                </tr>
            </table>

			<table class="table-content" >
				<tr class="table-header">
                    <td style="<?php if($data['tipo_orden']=='d'): ?> background-color:pink; <?php else: ?> background-color:rgb(71, 93, 255); <?php endif; ?> " colspan="4"><img style=' height: 30px;
            			margin-top: 10px;' src="images/logo.png" alt="Logo">
					</td>
                </tr>
                <tr class="table-header">
                    <td colspan="4">ORDEN DE TRABAJO #<?php echo e($data['codigo']); ?></td>
                </tr>
                <tr>
                    <td colspan="4" class="highlight">
                        <b>Fecha y hora recibe:</b> <?php echo e(date('d-m-Y',strtotime($data['fecha_recibe']))); ?> <?php echo e($data['hora_recibe']); ?>

                    </td>
                </tr>
                <tr>
                    <td><b>Cliente:</b> <?php echo e($data['cliente']['nombres']); ?></td>
                    <td><b>Celular:</b> <?php echo e($data['cliente']['celular']); ?></td>
                    <td><b>Cédula:</b> <?php echo e($data['cliente']['identificacion']); ?></td>
                    <td><b>Recibe:</b> <?php echo e($data['userregistra']['name']); ?></td>
                </tr>
                <tr>
                    <td><b>Tipo:</b> 
                        <?php if($data['tipo_orden']=='d'): ?> Diagnóstico <?php else: ?> Reparación <?php endif; ?>
                    </td>
                    <td colspan="3"><b>Garantía:</b> 
                        <?php if($data['tipo_garantia']=='NA'): ?> No aplica <?php endif; ?>
                        <?php if($data['tipo_garantia']=='co'): ?> Compra <?php endif; ?>
                        <?php if($data['tipo_garantia']=='st'): ?> Servicio técnico <?php endif; ?>
                    </td>
                </tr>
                <tr class="table-header">
                    <td colspan="4">INFORMACIÓN DEL EQUIPO</td>
                </tr>
                <tr>
                    <td><b>Modelo:</b> <?php echo e($data['modelo']); ?></td>
                    <td><b>ESN o IMEI:</b> <?php echo e($data['imei']); ?></td>
                    <td colspan="2"><b>Accesorios:</b>
                        <?php if(sizeof($data['ordenaccesorios'])>0): ?>
                            <?php $__currentLoopData = $data['ordenaccesorios']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($value['accesorios']['descripcion']); ?>

                                <?php if(!$loop->last): ?> , <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            Sin accesorios
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><b>Estado:</b> <?php echo e($data['estado_celular']); ?></td>
                    <td>Tiene clave:</b> <?php if($data['tiene_clave']=='S'): ?> Si <?php else: ?> No  <?php endif; ?></td>
                    <td colspan="2"><b>Encendido:</b> <?php if($data['estado_encendido']=='en'): ?> Si <?php else: ?> No (<b>No se puede comprobar periféricos</b>) <?php endif; ?></td>
                </tr>
                <tr>
                    <td colspan="1"><b>Pin:</b> <?php echo e($data['pin']); ?></td>
                    <td colspan="1" style="border-right: solid 0px" ><b>Patrón:</b> </td>

                    <td colspan="2" style="border-left: solid 0px" > <img width="20%" src="<?php echo e($data['patron']); ?>"></td>
                </tr>
                <tr>
                    <td colspan="4"><b>Observación:</b> <?php echo e($data['observacion_inicio']); ?></td>
                </tr>
				<tr>
                    <td colspan="4" style="text-align:justify;border-bottom: solid 1px">
                        <b>Notas:</b> <br>
                        <?php $__currentLoopData = $notas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li style="margin-left:20px"><?php echo e($value['valor']); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
                <tr>
                    <td colspan="4" style="text-align:justify;border: solid 0px;border-left: solid 1px;border-right: solid 1px">
                    <b>CLIENTE:</b>
                    <?php $__currentLoopData = $aceptacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li style="margin-left:20px"><?php echo e($value2['valor']); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="text-align:center;border: solid 0px;border-left: solid 1px;border-bottom: solid 1px">
                        <br><br><br><br>
                        <?php echo e($data['cliente']['nombres']); ?> <br><b>Firma del cliente </b>
                    </td>
                    <td colspan="2" style="text-align:center;border: solid 0px;border-right: solid 1px;border-bottom: solid 1px">
                        <br><br><br><br>
                        _______________________ <br><b>Firma autorizada </b>
                    </td>
                </tr>
            </table>

          
        </div>
       
    </div>

</body>
</html>
<?php /**PATH C:\laragon\www\PROYECTOS\SoporteCelular\resources\views/gestiones/ordenes/reporte.blade.php ENDPATH**/ ?>