<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="<?php echo e(asset('images/logohead.png')); ?>">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>

    <title>SISTEMA</title>

    <!-- Scripts -->
    <!-- <script src="<?php echo e(asset('js/app.js')); ?>" defer></script> -->
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('fontawesome/font-awesome.css')); ?>" rel="stylesheet">

    
    <!-- PNotify -->
    <link href="<?php echo e(asset('pnotify/dist/pnotify.css')); ?>" rel="stylesheet">
      <link href="<?php echo e(asset('pnotify/dist/pnotify.buttons.css')); ?>" rel="stylesheet">
      <link href="<?php echo e(asset('pnotify/dist/pnotify.nonblock.css')); ?>" rel="stylesheet">

      <!-- Librerias para Sweet Alert -->
      <link rel="stylesheet" href="<?php echo e(asset('sweetalert/sweetalert.css')); ?>">
    <style>
        .div_cargar{
            background-color:rgba(42, 63, 84, 0.5);
            position: fixed;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            z-index: 1050;
            display: none;
            overflow: hidden;
            -webkit-overflow-scrolling: touch;
            outline: 0;
        }
        .page{
            height: 100%;
        }

        .container-1{
            display: table;
            width: 100%;
            height: 100%;
        }

        .container-2{
            display: table-cell;
            vertical-align: middle;
            color: #fff;
        }
        .full-page-background-1{
            background-image:url("/images/fondo.jpg");
            position: absolute;
            z-index: 1;
            height: 100%;
            width: 100%;
            display: block;
            top: 0;
            left: 0;
            background-size: cover;
            background-position: center center;
        }
        .full-page-background-2{
            background-color: rgba(9, 43, 95, 0.658);
            position: absolute;
            z-index: 1;
            height: 100%;
            width: 100%;
            display: block;
            top: 0;
            left: 0;
            background-size: cover;
            background-position: center center;
        }
    </style>
    
</head>
<body>
<div class="full-page-background-1">
    <div class="full-page-background-2">
        <div id="app">
    
            <main class="py-4">
                <div class="container" style="padding-top:80px">
                    <div class="row justify-content-center">
                        <div class="col-md-4">
                            <div class="card">
                                <div align="center" style="background-color:white" class="card-header"><img width="80%" src="/images/logo.png" alt=""></div>

                                <div class="card-body">
                                    <form method="POST" action="<?php echo e(route('login')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="row mb-3" style="padding-top:20px; padding-left:40px;padding-right:40px">
                                            <?php if(session()->has('status')): ?>
                                                <script>
                                                    $(document).ready(function() {
                                                        mensaje_notificacion('<?php echo e(session('mensaje_info')); ?>','<?php echo e(session('status')); ?>');
                                                    });
                                                </script>
                                            <?php endif; ?>
                                        
                                        <label for="email" class="col-md-12 col-form-label "><b>Email</b></label>

                                            <div  class="col-md-12">
                                                <input id="email" placeholder="Ingrese email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus>

                                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="row mb-3" style="padding-left:40px;padding-right:40px">
                                            <label for="password" class="col-md-12 col-form-label "><b>Contraseña</b></label>

                                            <div class="col-md-12">
                                                <input id="password" type="password" placeholder="Ingrese contraseña" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" required autocomplete="current-password">

                                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="row mb-3" style="padding-left:40px;padding-right:40px">
                                            <label for="password" class="col-md-12 col-form-label "></label>
                                            <div class="col-md-12" align='center'>
                                                <button type="submit" class="btn btn-primary">
                                                <i class="fa fa-sign-in"></i>  Iniciar sesión
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
            <!-- PNotify -->
            <script src="<?php echo e(asset('pnotify/dist/pnotify.js')); ?>"></script>
            <script src="<?php echo e(asset('pnotify/dist/pnotify.buttons.js')); ?>"></script>
            <!-- Librerias para Sweet Alert -->
            <script src="<?php echo e(asset('sweetalert/sweetalert.js')); ?>"></script>
            <script>
                // FUNCION PARA MOSTRAR UNA ALERTA DE PNotify PERSONALIZADA
                function mensaje_notificacion(texto, tipo){
                    PNotify.removeAll()
                    new PNotify({
                        title: '<i class="fa fa-info-circle"></i> Información <a style="cursor:pointer" onclick="remove()"><b style="padding-left:120px">x</b></a>',
                        text: texto,
                        type: tipo,
                        hide: true,
                        delay: 7000,
                        styling: 'bootstrap3',
                        addclass: '',
                        icono:'info'
                    });
                }
                function remove(){
                    PNotify.removeAll()
                }
                function cargando(estado){
                    mostrar_carga(estado,'');
                }

                function cargando(estado, mensaje){
                    mostrar_carga(estado, mensaje);
                }

                function mostrar_carga(estado, mensaje){
                    //estado --> M:mostrar, otra letra: Ocultamos la ventana
                    // mensaje --> el texto que se carga al mostrar la ventana de carga
                    if(estado=='M' || estado=='m'){
                        $('#modal_cargando_title').html(mensaje);
                        $('#modal_cargando').show();
                        $('body').css('overflow', 'hidden');
                    }else{
                        $('#modal_cargando_title').html('Cargando');
                        $('#modal_cargando').hide();
                        $('body').css('overflow', '');
                    }
                }
            </script>

        </div>
    </div>
</div>
    <div id="modal_cargando" class="page div_cargar">
	<div class="container-1">
		<div class="container-2">
			<center><h1 id="modal_cargando_title">Cargando</h1></center>
			<div align="center"  id="loader"><img src="/images/cargando.gif" alt=""></div>			
		</div>
	</div>
</div>
</body>
</html>



<?php /**PATH C:\laragon\www\PROYECTOS\Ordenes\resources\views/auth/login.blade.php ENDPATH**/ ?>